/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.kafka.oauth.server.authorizer;

import java.util.Locale;

public class ResourceSpec {
    private String clusterName;
    private boolean clusterStartsWith;
    private ResourceType resourceType;
    private String resourceName;
    private boolean resourceStartsWith;

    public String getClusterName() {
        return this.clusterName;
    }

    public boolean isClusterStartsWith() {
        return this.clusterStartsWith;
    }

    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public boolean isResourceStartsWith() {
        return this.resourceStartsWith;
    }

    public boolean match(String cluster, String type, String name) {
        if (this.clusterName != null) {
            if (cluster == null) {
                throw new IllegalArgumentException("cluster == null");
            }
            if (this.clusterStartsWith ? !cluster.startsWith(this.clusterName) : !cluster.equals(this.clusterName)) {
                return false;
            }
        }
        if (type == null) {
            throw new IllegalArgumentException("type == null");
        }
        if (this.resourceType == null || !type.equals(this.resourceType.name())) {
            return false;
        }
        if (name == null) {
            throw new IllegalArgumentException("name == null");
        }
        if (this.resourceStartsWith) {
            return name.startsWith(this.resourceName);
        }
        return name.equals(this.resourceName);
    }

    public static ResourceSpec of(String name) {
        String[] parts;
        ResourceSpec spec = new ResourceSpec();
        for (String part : parts = name.split(",")) {
            String[] subSpec = part.split(":");
            if (subSpec.length != 2) {
                throw new IllegalArgumentException("Failed to parse Resource: " + name + " - part doesn't follow TYPE:NAME pattern: " + part);
            }
            String type = subSpec[0].toLowerCase(Locale.US);
            String pat = subSpec[1];
            if (type.equals("kafka-cluster")) {
                if (spec.clusterName != null) {
                    throw new IllegalArgumentException("Failed to parse Resource: " + name + " - cluster part specified multiple times");
                }
                if (pat.endsWith("*")) {
                    spec.clusterName = pat.substring(0, pat.length() - 1);
                    spec.clusterStartsWith = true;
                    continue;
                }
                spec.clusterName = pat;
                continue;
            }
            if (spec.resourceName != null) {
                throw new IllegalArgumentException("Failed to parse Resource: " + name + " - resource part specified multiple times");
            }
            switch (type) {
                case "topic": {
                    spec.resourceType = ResourceType.TOPIC;
                    break;
                }
                case "group": {
                    spec.resourceType = ResourceType.GROUP;
                    break;
                }
                case "cluster": {
                    spec.resourceType = ResourceType.CLUSTER;
                    break;
                }
                case "transactionalid": {
                    spec.resourceType = ResourceType.TRANSACTIONAL_ID;
                    break;
                }
                case "delegationtoken": {
                    spec.resourceType = ResourceType.DELEGATION_TOKEN;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Failed to parse Resource: " + name + " - unsupported segment type: " + subSpec[0]);
                }
            }
            if (pat.endsWith("*")) {
                spec.resourceName = pat.substring(0, pat.length() - 1);
                spec.resourceStartsWith = true;
                continue;
            }
            spec.resourceName = pat;
        }
        return spec;
    }

    public String toString() {
        return (this.clusterName != null ? "kafka-cluster:" + this.clusterName + (this.clusterStartsWith ? "*" : "") + "," : "") + (this.resourceName != null ? (Object)((Object)this.resourceType) + ":" + this.resourceName + (this.resourceStartsWith ? "*" : ":") : "");
    }

    public static enum ResourceType {
        TOPIC,
        GROUP,
        CLUSTER,
        TRANSACTIONAL_ID,
        DELEGATION_TOKEN;

    }
}

