/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.kafka.oauth.server.authorizer;

import java.util.EnumSet;
import java.util.List;
import java.util.Locale;

public class ScopesSpec {
    private final EnumSet<AuthzScope> granted;

    private ScopesSpec(EnumSet<AuthzScope> grants) {
        this.granted = grants;
    }

    static ScopesSpec of(List<AuthzScope> scopes) {
        return new ScopesSpec(EnumSet.copyOf(scopes));
    }

    public boolean isGranted(String operation) {
        AuthzScope scope = AuthzScope.valueOf(operation);
        return this.granted.contains((Object)scope);
    }

    public String toString() {
        return String.valueOf(this.granted);
    }

    public static enum AuthzScope {
        CREATE,
        READ,
        WRITE,
        DELETE,
        ALTER,
        DESCRIBE,
        ALTER_CONFIGS,
        DESCRIBE_CONFIGS,
        CLUSTER_ACTION,
        IDEMPOTENT_WRITE;


        public static AuthzScope of(String grantValue) {
            String value;
            switch (value = grantValue.toUpperCase(Locale.ROOT)) {
                case "ALTERCONFIGS": {
                    return ALTER_CONFIGS;
                }
                case "DESCRIBECONFIGS": {
                    return DESCRIBE_CONFIGS;
                }
                case "CLUSTERACTION": {
                    return CLUSTER_ACTION;
                }
                case "IDEMPOTENTWRITE": {
                    return IDEMPOTENT_WRITE;
                }
            }
            return AuthzScope.valueOf(value);
        }
    }
}

