/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.kafka.oauth.server.authorizer;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;

class Semaphores<T> {
    private final ConcurrentHashMap<String, Semaphore<T>> futures = new ConcurrentHashMap();

    Semaphores() {
    }

    SemaphoreResult<T> acquireSemaphore(String key) {
        Semaphore semaphore = this.futures.computeIfAbsent(key, v -> new Semaphore());
        return new SemaphoreResult(semaphore);
    }

    void releaseSemaphore(String key) {
        this.futures.remove(key);
    }

    static class SemaphoreResult<T> {
        private final boolean acquired;
        private final CompletableFuture<T> future;

        private SemaphoreResult(Semaphore<T> semaphore) {
            this.acquired = ((Semaphore)semaphore).tryAcquire();
            this.future = ((Semaphore)semaphore).future;
        }

        boolean acquired() {
            return this.acquired;
        }

        CompletableFuture<T> future() {
            return this.future;
        }
    }

    static class Semaphore<T> {
        private final CompletableFuture<T> future = new CompletableFuture();
        private final AtomicBoolean acquired = new AtomicBoolean(true);

        private Semaphore() {
        }

        private boolean tryAcquire() {
            return this.acquired.getAndSet(false);
        }
    }
}

