/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.kafka.oauth.server.authorizer;

import java.util.Objects;

public class UserSpec {
    private final String type;
    private final String name;

    private UserSpec(String type, String name) {
        this.type = type;
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public static UserSpec of(String principal) {
        int pos = principal.indexOf(58);
        if (pos <= 0) {
            throw new IllegalArgumentException("Invalid user specification: " + principal);
        }
        return new UserSpec(principal.substring(0, pos), principal.substring(pos + 1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserSpec userSpec = (UserSpec)o;
        return this.type.equals(userSpec.type) && this.name.equals(userSpec.name);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.name);
    }

    public String toString() {
        return super.toString() + " " + this.type + ":" + this.name;
    }
}

