/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.kafka.oauth.server.plain;

import io.strimzi.kafka.oauth.common.BearerTokenWithPayload;
import io.strimzi.kafka.oauth.common.HttpException;
import io.strimzi.kafka.oauth.common.MetricsHandler;
import io.strimzi.kafka.oauth.common.OAuthAuthenticator;
import io.strimzi.kafka.oauth.common.PrincipalExtractor;
import io.strimzi.kafka.oauth.metrics.SensorKeyProducer;
import io.strimzi.kafka.oauth.server.JaasServerOauthValidatorCallbackHandler;
import io.strimzi.kafka.oauth.server.OAuthKafkaPrincipal;
import io.strimzi.kafka.oauth.server.OAuthSaslAuthenticationException;
import io.strimzi.kafka.oauth.server.ServerConfig;
import io.strimzi.kafka.oauth.server.plain.metrics.PlainHttpSensorKeyProducer;
import io.strimzi.kafka.oauth.services.OAuthMetrics;
import io.strimzi.kafka.oauth.services.Services;
import io.strimzi.kafka.oauth.validator.ValidationException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.kafka.common.errors.SaslAuthenticationException;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerValidatorCallback;
import org.apache.kafka.common.security.plain.PlainAuthenticateCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaasServerOauthOverPlainValidatorCallbackHandler
extends JaasServerOauthValidatorCallbackHandler {
    private static final Logger log = LoggerFactory.getLogger(JaasServerOauthOverPlainValidatorCallbackHandler.class);
    private URI tokenEndpointUri;
    private String scope;
    private String audience;
    private OAuthMetrics metrics;
    private boolean enableMetrics;
    private SensorKeyProducer authHttpSensorKeyProducer;
    private final MetricsHandler authMetrics = new PlainMetricsHandler();

    public void configure(Map<String, ?> configs, String saslMechanism, List<AppConfigurationEntry> jaasConfigEntries) {
        if (!"PLAIN".equals(saslMechanism)) {
            throw new IllegalArgumentException(String.format("Unexpected SASL mechanism: %s", saslMechanism));
        }
        ServerConfig config = this.parseJaasConfig(jaasConfigEntries);
        String tokenEndpoint = config.getValue("oauth.token.endpoint.uri");
        if (tokenEndpoint != null) {
            try {
                this.tokenEndpointUri = new URI(tokenEndpoint);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Invalid tokenEndpointUri: " + tokenEndpoint, e);
            }
        }
        this.scope = config.getValue("oauth.scope");
        this.audience = config.getValue("oauth.audience");
        super.delegatedConfigure(configs, "PLAIN", jaasConfigEntries);
        String configId = this.getConfigId();
        this.configureMetrics(config);
        this.authHttpSensorKeyProducer = this.tokenEndpointUri != null ? new PlainHttpSensorKeyProducer(configId, this.tokenEndpointUri) : null;
        log.debug("Configured OAuth over PLAIN:\n    configId: " + configId + "\n    tokenEndpointUri: " + this.tokenEndpointUri + "\n    scope: " + this.scope + "\n    audience: " + this.audience + "\n    enableMetrics: " + this.enableMetrics);
        if (tokenEndpoint == null) {
            log.debug("Token endpoint uri is not configured ('{}') - 'password' parameter of SASL/PLAIN will automatically be treated as an access token (no '$accessToken:' prefix needed)", (Object)"oauth.token.endpoint.uri");
        }
    }

    private void configureMetrics(ServerConfig config) {
        this.enableMetrics = config.getValueAsBoolean("oauth.enable.metrics", false);
        if (this.enableMetrics) {
            this.metrics = Services.getInstance().getMetrics();
        }
    }

    public void close() {
        super.close();
    }

    public void handle(Callback[] callbacks) {
        String username = null;
        String password = null;
        PlainAuthenticateCallback cb = null;
        try {
            for (Callback callback : callbacks) {
                if (callback instanceof NameCallback) {
                    username = ((NameCallback)callback).getDefaultName();
                    continue;
                }
                if (callback instanceof PlainAuthenticateCallback) {
                    password = String.valueOf(((PlainAuthenticateCallback)callback).password());
                    cb = (PlainAuthenticateCallback)callback;
                    continue;
                }
                throw new UnsupportedCallbackException(callback);
            }
            this.handleCallback(cb, username, password);
        }
        catch (OAuthSaslAuthenticationException e) {
            throw e;
        }
        catch (UnsupportedCallbackException e) {
            this.handleErrorWithLogger(log, "Authentication failed due to misconfiguration", e);
        }
        catch (SaslAuthenticationException e) {
            this.handleErrorWithLogger(log, e.getMessage(), e);
        }
        catch (HttpException e) {
            this.handleErrorWithLogger(log, "Authentication failed: Invalid clientId or secret", e);
        }
        catch (Throwable e) {
            this.handleErrorWithLogger(log, "Authentication failed for username: [" + username + "]", e);
        }
    }

    private void handleCallback(PlainAuthenticateCallback callback, String username, String password) throws UnsupportedCallbackException, IOException {
        if (callback == null) {
            throw new IllegalArgumentException("callback == null");
        }
        if (username == null) {
            throw new IllegalArgumentException("username == null");
        }
        this.authenticate(username, password);
        callback.authenticated(true);
    }

    private void authenticate(String username, String password) throws UnsupportedCallbackException, IOException {
        long requestStartTime = System.currentTimeMillis();
        try {
            String accessToken;
            String accessTokenPrefix = "$accessToken:";
            boolean checkUsernameMatch = false;
            if (password != null && password.startsWith("$accessToken:")) {
                accessToken = password.substring("$accessToken:".length());
                checkUsernameMatch = true;
            } else if (password != null && this.tokenEndpointUri == null) {
                accessToken = password;
                checkUsernameMatch = true;
            } else if (this.tokenEndpointUri != null) {
                accessToken = OAuthAuthenticator.loginWithClientSecret((URI)this.tokenEndpointUri, (SSLSocketFactory)this.getSocketFactory(), (HostnameVerifier)this.getVerifier(), (String)username, (String)password, (boolean)this.isJwt(), (PrincipalExtractor)this.getPrincipalExtractor(), (String)this.scope, (String)this.audience, (int)this.getConnectTimeout(), (int)this.getReadTimeout(), (MetricsHandler)this.authMetrics).token();
            } else {
                throw new ValidationException("Empty password where access token was expected");
            }
            OAuthBearerValidatorCallback[] callbacks = new OAuthBearerValidatorCallback[]{new OAuthBearerValidatorCallback(accessToken)};
            super.delegatedHandle((Callback[])callbacks);
            OAuthBearerToken token = callbacks[0].token();
            if (token == null) {
                throw new ValidationException("Authentication with OAuth token has failed (no token returned)");
            }
            if (checkUsernameMatch && !username.equals(token.principalName())) {
                throw new SaslAuthenticationException("Username doesn't match the token");
            }
            OAuthKafkaPrincipal kafkaPrincipal = new OAuthKafkaPrincipal("User", token.principalName(), (BearerTokenWithPayload)token);
            Services.getInstance().getCredentials().storeCredentials(username, (KafkaPrincipal)kafkaPrincipal);
            this.addSuccessTime(requestStartTime);
        }
        catch (Throwable e) {
            this.addErrorTime(e, requestStartTime);
            throw e;
        }
    }

    private void addSuccessTime(long startTimeMs) {
        if (this.enableMetrics) {
            this.metrics.addTime(this.validationSensorKeyProducer.successKey(), System.currentTimeMillis() - startTimeMs);
        }
    }

    private void addErrorTime(Throwable e, long startTimeMs) {
        if (this.enableMetrics) {
            this.metrics.addTime(this.validationSensorKeyProducer.errorKey(e), System.currentTimeMillis() - startTimeMs);
        }
    }

    class PlainMetricsHandler
    implements MetricsHandler {
        PlainMetricsHandler() {
        }

        public void addSuccessRequestTime(long millis) {
            if (JaasServerOauthOverPlainValidatorCallbackHandler.this.enableMetrics) {
                JaasServerOauthOverPlainValidatorCallbackHandler.this.metrics.addTime(JaasServerOauthOverPlainValidatorCallbackHandler.this.authHttpSensorKeyProducer.successKey(), millis);
            }
        }

        public void addErrorRequestTime(Throwable e, long millis) {
            if (JaasServerOauthOverPlainValidatorCallbackHandler.this.enableMetrics) {
                JaasServerOauthOverPlainValidatorCallbackHandler.this.metrics.addTime(JaasServerOauthOverPlainValidatorCallbackHandler.this.authHttpSensorKeyProducer.errorKey(e), millis);
            }
        }
    }
}

