/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.kafka.oauth.server.plain;

import io.strimzi.kafka.oauth.common.BearerTokenWithPayload;
import io.strimzi.kafka.oauth.common.LogUtil;
import io.strimzi.kafka.oauth.common.OAuthAuthenticator;
import io.strimzi.kafka.oauth.common.PrincipalExtractor;
import io.strimzi.kafka.oauth.server.JaasServerOauthValidatorCallbackHandler;
import io.strimzi.kafka.oauth.server.OAuthKafkaPrincipal;
import io.strimzi.kafka.oauth.server.ServerConfig;
import io.strimzi.kafka.oauth.services.Services;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.kafka.common.errors.SaslAuthenticationException;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerValidatorCallback;
import org.apache.kafka.common.security.plain.PlainAuthenticateCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaasServerOauthOverPlainValidatorCallbackHandler
extends JaasServerOauthValidatorCallbackHandler {
    private static final Logger log = LoggerFactory.getLogger(JaasServerOauthOverPlainValidatorCallbackHandler.class);
    private URI tokenEndpointUri;

    public void configure(Map<String, ?> configs, String saslMechanism, List<AppConfigurationEntry> jaasConfigEntries) {
        if (!"PLAIN".equals(saslMechanism)) {
            throw new IllegalArgumentException(String.format("Unexpected SASL mechanism: %s", saslMechanism));
        }
        ServerConfig config = this.parseJaasConfig(jaasConfigEntries);
        String tokenEndpoint = config.getValue("oauth.token.endpoint.uri");
        if (tokenEndpoint != null) {
            try {
                this.tokenEndpointUri = new URI(tokenEndpoint);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Invalid tokenEndpointUri: " + tokenEndpoint, e);
            }
        }
        super.configure(configs, "OAUTHBEARER", jaasConfigEntries);
        log.debug("Configured OAuth over PLAIN:\n    tokenEndpointUri: " + this.tokenEndpointUri);
        if (tokenEndpoint == null) {
            log.debug("tokenEndpointUri is not configured - client_credentials will not be available, password parameter of SASL/PLAIN will automatically be treated as an access token (no '$accessToken:' prefix needed)");
        }
    }

    public void close() {
        super.close();
    }

    public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
        String username = null;
        String password = null;
        PlainAuthenticateCallback cb = null;
        try {
            for (Callback callback : callbacks) {
                if (callback instanceof NameCallback) {
                    username = ((NameCallback)callback).getDefaultName();
                    continue;
                }
                if (callback instanceof PlainAuthenticateCallback) {
                    password = String.valueOf(((PlainAuthenticateCallback)callback).password());
                    cb = (PlainAuthenticateCallback)callback;
                    continue;
                }
                throw new UnsupportedCallbackException(callback);
            }
            this.handleCallback(cb, username, password);
        }
        catch (UnsupportedCallbackException e) {
            log.error("Authentication failed due to misconfigured CallbackHandler: ", (Throwable)e);
            throw e;
        }
        catch (SaslAuthenticationException e) {
            if (log.isDebugEnabled()) {
                log.debug("Authentication failed for username: [" + username + "]: ", (Throwable)e);
            }
            throw e;
        }
        catch (Throwable e) {
            if (log.isDebugEnabled()) {
                log.debug("Authentication failed for username: [" + username + "]: ", e);
            }
            throw new SaslAuthenticationException("Authentication failed for username: [" + username + "] " + LogUtil.getAllCauseMessages((Throwable)e), e);
        }
    }

    private void handleCallback(PlainAuthenticateCallback callback, String username, String password) {
        if (callback == null) {
            throw new IllegalArgumentException("callback == null");
        }
        if (username == null) {
            throw new IllegalArgumentException("username == null");
        }
        try {
            this.authenticate(username, password);
            callback.authenticated(true);
        }
        catch (SaslAuthenticationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SaslAuthenticationException("Authentication failed: " + LogUtil.getAllCauseMessages((Throwable)e), (Throwable)e);
        }
    }

    private void authenticate(String username, String password) throws UnsupportedCallbackException, IOException {
        String accessToken;
        String accessTokenPrefix = "$accessToken:";
        boolean checkUsernameMatch = false;
        if (password != null && password.startsWith("$accessToken:")) {
            accessToken = password.substring("$accessToken:".length());
            checkUsernameMatch = true;
        } else if (password != null && this.tokenEndpointUri == null) {
            accessToken = password;
            checkUsernameMatch = true;
        } else {
            accessToken = OAuthAuthenticator.loginWithClientSecret((URI)this.tokenEndpointUri, (SSLSocketFactory)this.getSocketFactory(), (HostnameVerifier)this.getVerifier(), (String)username, (String)password, (boolean)this.isJwt(), (PrincipalExtractor)this.getPrincipalExtractor(), null).token();
        }
        OAuthBearerValidatorCallback[] callbacks = new OAuthBearerValidatorCallback[]{new OAuthBearerValidatorCallback(accessToken)};
        super.handle((Callback[])callbacks);
        OAuthBearerToken token = callbacks[0].token();
        if (token == null) {
            throw new RuntimeException("Authentication with OAuth token has failed (no token returned)");
        }
        if (checkUsernameMatch && !username.equals(token.principalName())) {
            throw new SaslAuthenticationException("Username doesn't match the token");
        }
        OAuthKafkaPrincipal kafkaPrincipal = new OAuthKafkaPrincipal("User", token.principalName(), (BearerTokenWithPayload)token);
        Services.getInstance().getCredentials().storeCredentials(username, (KafkaPrincipal)kafkaPrincipal);
    }
}

