/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.kafka.oauth.server;

import io.strimzi.kafka.oauth.common.Config;
import io.strimzi.kafka.oauth.common.ConfigUtil;
import io.strimzi.kafka.oauth.common.JSONUtil;
import io.strimzi.kafka.oauth.common.LogUtil;
import io.strimzi.kafka.oauth.common.TokenInfo;
import io.strimzi.kafka.oauth.server.ServerConfig;
import io.strimzi.kafka.oauth.validator.JWTSignatureValidator;
import io.strimzi.kafka.oauth.validator.OAuthIntrospectionValidator;
import io.strimzi.kafka.oauth.validator.TokenValidationException;
import io.strimzi.kafka.oauth.validator.TokenValidator;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.security.auth.AuthenticateCallbackHandler;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerValidatorCallback;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.jose.jws.JWSInputException;
import org.keycloak.representations.AccessToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaasServerOauthValidatorCallbackHandler
implements AuthenticateCallbackHandler {
    private static final Logger log = LoggerFactory.getLogger(JaasServerOauthValidatorCallbackHandler.class);
    private TokenValidator validator;
    private ServerConfig config;
    private String usernameClaim;

    public void configure(Map<String, ?> configs, String saslMechanism, List<AppConfigurationEntry> jaasConfigEntries) {
        if (!"OAUTHBEARER".equals(saslMechanism)) {
            throw new IllegalArgumentException(String.format("Unexpected SASL mechanism: %s", saslMechanism));
        }
        if (jaasConfigEntries.size() != 1) {
            throw new IllegalArgumentException("Exactly one jaasConfigEntry expected (size: " + jaasConfigEntries.size());
        }
        Iterator<AppConfigurationEntry> iterator = jaasConfigEntries.iterator();
        if (iterator.hasNext()) {
            AppConfigurationEntry e = iterator.next();
            Properties p = new Properties();
            p.putAll(e.getOptions());
            this.config = new ServerConfig(p);
        }
        this.validateConfig();
        SSLSocketFactory socketFactory = ConfigUtil.createSSLFactory((Config)this.config);
        HostnameVerifier verifier = ConfigUtil.createHostnameVerifier((Config)this.config);
        String jwksUri = this.config.getValue("oauth.jwks.endpoint.uri");
        this.validator = jwksUri != null ? new JWTSignatureValidator(this.config.getValue("oauth.jwks.endpoint.uri"), socketFactory, verifier, this.config.getValue("oauth.valid.issuer.uri"), this.config.getValueAsInt("oauth.jwks.refresh.seconds", 300), this.config.getValueAsInt("oauth.jwks.expiry.seconds", 360), true, null) : new OAuthIntrospectionValidator(this.config.getValue("oauth.introspection.endpoint.uri"), socketFactory, verifier, this.config.getValue("oauth.valid.issuer.uri"), this.config.getValue("oauth.client.id"), this.config.getValue("oauth.client.secret"), true, null);
        this.usernameClaim = this.config.getValue("oauth.username.claim", "sub");
        if ("sub".equals(this.usernameClaim)) {
            this.usernameClaim = null;
        }
    }

    private void validateConfig() {
        String introspectUri;
        String jwksUri = this.config.getValue("oauth.jwks.endpoint.uri");
        if (jwksUri == null == ((introspectUri = this.config.getValue("oauth.introspection.endpoint.uri")) == null)) {
            throw new RuntimeException("OAuth validator configuration error - one of the two should be specified: OAUTH_JWKS_ENDPOINT_URI (for fast local signature validation) or OAUTH_INTROSPECTION_ENDPOINT_URI (for using authorization server during validation)");
        }
    }

    public void close() {
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (Callback callback : callbacks) {
            if (!(callback instanceof OAuthBearerValidatorCallback)) {
                throw new UnsupportedCallbackException(callback);
            }
            this.handleCallback((OAuthBearerValidatorCallback)callback);
        }
    }

    private void handleCallback(OAuthBearerValidatorCallback callback) throws IOException {
        if (callback.tokenValue() == null) {
            throw new IllegalArgumentException("Callback has null token value!");
        }
        String token = callback.tokenValue();
        this.debugLogToken(token);
        try {
            final TokenInfo ti = this.validateToken(token);
            callback.token(new OAuthBearerToken(){

                public String value() {
                    return ti.token();
                }

                public Set<String> scope() {
                    return ti.scope();
                }

                public long lifetimeMs() {
                    return ti.expiresAtMs();
                }

                public String principalName() {
                    if (JaasServerOauthValidatorCallbackHandler.this.usernameClaim != null) {
                        if (ti.payload() != null) {
                            return JSONUtil.getClaimFromJWT((String)JaasServerOauthValidatorCallbackHandler.this.usernameClaim, (Object)ti.payload());
                        }
                        throw new IllegalStateException("Username claim extraction not supported by validator: " + JaasServerOauthValidatorCallbackHandler.this.validator.getClass());
                    }
                    return ti.subject();
                }

                public Long startTimeMs() {
                    return ti.issuedAtMs();
                }
            });
        }
        catch (TokenValidationException e) {
            if (log.isDebugEnabled()) {
                log.debug("Validation failed for token: " + LogUtil.mask((String)token), (Throwable)e);
            }
            callback.error(e.status(), null, null);
        }
        catch (RuntimeException e) {
            throw new AuthenticationException("Validation failed due to runtime exception:", (Throwable)e);
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected failure during signature check:", e);
        }
    }

    private TokenInfo validateToken(String token) {
        return this.validator.validate(token);
    }

    private void debugLogToken(String token) {
        JWSInput parser;
        if (!log.isDebugEnabled()) {
            return;
        }
        try {
            parser = new JWSInput(token);
            log.debug("Token: {}", (Object)parser.readContentAsString());
        }
        catch (JWSInputException e) {
            log.debug("Token doesn't seem to be JWT token: " + token, (Throwable)e);
            return;
        }
        try {
            AccessToken t = (AccessToken)parser.readJsonContent(AccessToken.class);
            log.debug("Access token expires at (UTC): " + LocalDateTime.ofEpochSecond(t.getExpiration(), 0, ZoneOffset.UTC).format(DateTimeFormatter.ISO_DATE_TIME));
        }
        catch (JWSInputException e) {
            log.debug("[IGNORED] Failed to parse JWT token's payload", (Throwable)e);
        }
    }
}

