/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.kafka.oauth.server;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.strimzi.kafka.oauth.common.BearerTokenWithPayload;
import io.strimzi.kafka.oauth.common.LogUtil;
import java.util.Collections;
import java.util.Set;
import org.apache.kafka.common.security.auth.KafkaPrincipal;

@SuppressFBWarnings(value={"EQ_DOESNT_OVERRIDE_EQUALS"})
public final class OAuthKafkaPrincipal
extends KafkaPrincipal {
    private final BearerTokenWithPayload jwt;
    private final Set<String> groups;

    public OAuthKafkaPrincipal(String principalType, String name) {
        this(principalType, name, (Set<String>)null);
    }

    public OAuthKafkaPrincipal(String principalType, String name, Set<String> groups) {
        super(principalType, name);
        this.jwt = null;
        this.groups = groups == null ? null : Collections.unmodifiableSet(groups);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public OAuthKafkaPrincipal(String principalType, String name, BearerTokenWithPayload jwt) {
        super(principalType, name);
        this.jwt = jwt;
        Set parsedGroups = jwt.getGroups();
        this.groups = parsedGroups == null ? null : Collections.unmodifiableSet(parsedGroups);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public BearerTokenWithPayload getJwt() {
        return this.jwt;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public Set<String> getGroups() {
        return this.groups;
    }

    public String toString() {
        return "OAuthKafkaPrincipal(" + super.toString() + ", groups: " + this.groups + ", session: " + (this.jwt != null ? Integer.valueOf(this.jwt.getSessionId()) : "") + ", token: " + (this.jwt != null ? LogUtil.mask((String)this.jwt.value()) : "") + ")";
    }
}

