/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.kafka.oauth.server;

import io.strimzi.kafka.oauth.common.BearerTokenWithPayload;
import io.strimzi.kafka.oauth.server.OAuthKafkaPrincipal;
import io.strimzi.kafka.oauth.services.Principals;
import io.strimzi.kafka.oauth.services.Services;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.security.sasl.SaslServer;
import org.apache.kafka.common.Configurable;
import org.apache.kafka.common.security.auth.AuthenticationContext;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SaslAuthenticationContext;
import org.apache.kafka.common.security.authenticator.DefaultKafkaPrincipalBuilder;
import org.apache.kafka.common.security.oauthbearer.internals.OAuthBearerSaslServer;
import org.apache.kafka.common.security.plain.internals.PlainSaslServer;

public class OAuthKafkaPrincipalBuilder
extends DefaultKafkaPrincipalBuilder
implements Configurable {
    private static final SetAccessibleAction SET_PRINCIPAL_MAPPER = SetAccessibleAction.newInstance();

    public OAuthKafkaPrincipalBuilder() {
        super(null, null);
    }

    public void configure(Map<String, ?> configs) {
        Object sslPrincipalMappingRules = configs.get("ssl.principal.mapping.rules");
        try {
            Object sslPrincipalMapper;
            Class<?> clazz = Class.forName("org.apache.kafka.common.security.ssl.SslPrincipalMapper");
            try {
                Method m = clazz.getMethod("fromRules", List.class);
                if (sslPrincipalMappingRules == null) {
                    sslPrincipalMappingRules = Collections.singletonList("DEFAULT");
                }
                sslPrincipalMapper = m.invoke(null, sslPrincipalMappingRules);
            }
            catch (NoSuchMethodException ex) {
                Method m = clazz.getMethod("fromRules", String.class);
                if (sslPrincipalMappingRules == null) {
                    sslPrincipalMappingRules = "DEFAULT";
                }
                sslPrincipalMapper = m.invoke(null, sslPrincipalMappingRules);
            }
            SET_PRINCIPAL_MAPPER.invoke(this, sslPrincipalMapper);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | RuntimeException | InvocationTargetException e) {
            throw new IllegalStateException("Failed to initialize OAuthKafkaPrincipalBuilder", e);
        }
    }

    public KafkaPrincipal build(AuthenticationContext context) {
        if (context instanceof SaslAuthenticationContext) {
            SaslServer saslServer = ((SaslAuthenticationContext)context).server();
            if (saslServer instanceof OAuthBearerSaslServer) {
                OAuthBearerSaslServer server = (OAuthBearerSaslServer)saslServer;
                if ("OAUTHBEARER".equals(server.getMechanismName())) {
                    BearerTokenWithPayload token = (BearerTokenWithPayload)server.getNegotiatedProperty("OAUTHBEARER.token");
                    Services.getInstance().getSessions().put(token);
                    return new OAuthKafkaPrincipal("User", server.getAuthorizationID(), token);
                }
            } else if (saslServer instanceof PlainSaslServer) {
                PlainSaslServer server = (PlainSaslServer)saslServer;
                Principals principals = Services.getInstance().getPrincipals();
                OAuthKafkaPrincipal principal = (OAuthKafkaPrincipal)principals.getPrincipal(saslServer);
                if (principal != null) {
                    return principal;
                }
                principal = (OAuthKafkaPrincipal)Services.getInstance().getCredentials().takeCredentials(server.getAuthorizationID());
                if (principal != null) {
                    principals.putPrincipal(saslServer, (KafkaPrincipal)principal);
                    return principal;
                }
            }
        }
        return super.build(context);
    }

    private static class SetAccessibleAction
    implements PrivilegedAction<Void> {
        private final Field field;

        SetAccessibleAction(Field field) {
            this.field = field;
        }

        @Override
        public Void run() {
            this.field.setAccessible(true);
            return null;
        }

        void invoke(DefaultKafkaPrincipalBuilder target, Object value) throws IllegalAccessException {
            AccessController.doPrivileged(this);
            this.field.set(target, value);
        }

        static SetAccessibleAction newInstance() {
            try {
                return new SetAccessibleAction(DefaultKafkaPrincipalBuilder.class.getDeclaredField("sslPrincipalMapper"));
            }
            catch (NoSuchFieldException e) {
                throw new IllegalStateException("Failed to install OAuthKafkaPrincipalBuilder. This Kafka version does not seem to be supported", e);
            }
        }
    }
}

