/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.kafka.oauth.server;

import io.strimzi.kafka.oauth.common.BearerTokenWithPayload;
import io.strimzi.kafka.oauth.common.Config;
import io.strimzi.kafka.oauth.common.ConfigException;
import io.strimzi.kafka.oauth.common.LogUtil;
import io.strimzi.kafka.oauth.common.TimeUtil;
import io.strimzi.kafka.oauth.server.OAuthKafkaPrincipal;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.server.authorizer.AclCreateResult;
import org.apache.kafka.server.authorizer.AclDeleteResult;
import org.apache.kafka.server.authorizer.Action;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.authorizer.AuthorizationResult;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthSessionAuthorizer
implements Authorizer {
    static final Logger log = LoggerFactory.getLogger(OAuthSessionAuthorizer.class);
    static final Logger GRANT_LOG = LoggerFactory.getLogger((String)(OAuthSessionAuthorizer.class.getName() + ".grant"));
    static final Logger DENY_LOG = LoggerFactory.getLogger((String)(OAuthSessionAuthorizer.class.getName() + ".deny"));
    private Authorizer delegate;

    public void configure(Map<String, ?> configs) {
        String className = (String)configs.get("strimzi.authorizer.delegate.class.name");
        if (className != null) {
            try {
                Class<?> delegateClass = Thread.currentThread().getContextClassLoader().loadClass(className);
                if (!Authorizer.class.isAssignableFrom(delegateClass)) {
                    throw new IllegalArgumentException("The class specified by strimzi.authorizer.delegate.class.name is not an instance of org.apache.kafka.server.authorizer.Authorizer");
                }
                this.delegate = (Authorizer)delegateClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                this.delegate.configure(configs);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new ConfigException("Failed to instantiate and configure the delegate authorizer: " + className, (Throwable)e);
            }
        } else {
            boolean isGrantByDefault;
            String grantByDefault = (String)configs.get("strimzi.authorizer.grant.when.no.delegate");
            boolean bl = isGrantByDefault = grantByDefault != null && Config.isTrue((String)grantByDefault);
            if (!isGrantByDefault) {
                throw new ConfigException("When no 'strimzi.authorizer.delegate.class.name' is specified, 'strimzi.authorizer.grant.when.no.delegate=true' has to be specified");
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Configured OAuthSessionAuthorizer:\n    strimzi.authorizer.delegate.class.name: " + className);
        }
    }

    public List<AuthorizationResult> authorize(AuthorizableRequestContext requestContext, List<Action> actions) {
        KafkaPrincipal principal = requestContext.principal();
        if (!(principal instanceof OAuthKafkaPrincipal)) {
            if (this.delegate != null) {
                return this.delegate.authorize(requestContext, actions);
            }
            if (GRANT_LOG.isDebugEnabled()) {
                GRANT_LOG.debug("Authorization GRANTED - no access token: " + principal + ", actions: " + actions);
            }
            return Collections.nCopies(actions.size(), AuthorizationResult.ALLOWED);
        }
        BearerTokenWithPayload token = ((OAuthKafkaPrincipal)principal).getJwt();
        if (this.denyIfTokenInvalid(token)) {
            return Collections.nCopies(actions.size(), AuthorizationResult.DENIED);
        }
        if (this.delegate == null) {
            if (GRANT_LOG.isDebugEnabled()) {
                GRANT_LOG.debug("Authorization GRANTED - access token still valid: " + principal + ", actions: " + actions + ", token: " + LogUtil.mask((String)token.value()));
            }
            return Collections.nCopies(actions.size(), AuthorizationResult.ALLOWED);
        }
        return this.delegate.authorize(requestContext, actions);
    }

    private boolean denyIfTokenInvalid(BearerTokenWithPayload token) {
        if (token.lifetimeMs() <= System.currentTimeMillis()) {
            if (DENY_LOG.isDebugEnabled()) {
                DENY_LOG.debug("Authorization DENIED due to token expiry - The token expired at: " + token.lifetimeMs() + " (" + TimeUtil.formatIsoDateTimeUTC((long)token.lifetimeMs()) + " UTC), for token: " + LogUtil.mask((String)token.value()));
            }
            return true;
        }
        return false;
    }

    public void close() throws IOException {
        this.delegate.close();
    }

    public Map<Endpoint, ? extends CompletionStage<Void>> start(AuthorizerServerInfo serverInfo) {
        return this.delegate.start(serverInfo);
    }

    public List<? extends CompletionStage<AclCreateResult>> createAcls(AuthorizableRequestContext requestContext, List<AclBinding> aclBindings) {
        return this.delegate.createAcls(requestContext, aclBindings);
    }

    public List<? extends CompletionStage<AclDeleteResult>> deleteAcls(AuthorizableRequestContext requestContext, List<AclBindingFilter> aclBindingFilters) {
        return this.delegate.deleteAcls(requestContext, aclBindingFilters);
    }

    public Iterable<AclBinding> acls(AclBindingFilter filter) {
        return this.delegate.acls(filter);
    }
}

