/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.kafka.oauth.server;

import io.strimzi.kafka.oauth.common.Config;
import io.strimzi.kafka.oauth.common.ConfigException;
import io.strimzi.kafka.oauth.common.ConfigUtil;
import io.strimzi.kafka.oauth.common.DeprecationUtil;
import io.strimzi.kafka.oauth.common.IOUtil;
import io.strimzi.kafka.oauth.common.LogUtil;
import io.strimzi.kafka.oauth.common.PrincipalExtractor;
import io.strimzi.kafka.oauth.common.TokenInfo;
import io.strimzi.kafka.oauth.common.TokenIntrospection;
import io.strimzi.kafka.oauth.metrics.IntrospectValidationSensorKeyProducer;
import io.strimzi.kafka.oauth.metrics.JwksValidationSensorKeyProducer;
import io.strimzi.kafka.oauth.metrics.SensorKeyProducer;
import io.strimzi.kafka.oauth.server.BearerTokenWithJsonPayload;
import io.strimzi.kafka.oauth.server.OAuthSaslAuthenticationException;
import io.strimzi.kafka.oauth.server.ServerConfig;
import io.strimzi.kafka.oauth.services.ConfigurationKey;
import io.strimzi.kafka.oauth.services.OAuthMetrics;
import io.strimzi.kafka.oauth.services.Services;
import io.strimzi.kafka.oauth.services.ValidatorKey;
import io.strimzi.kafka.oauth.validator.JWTSignatureValidator;
import io.strimzi.kafka.oauth.validator.OAuthIntrospectionValidator;
import io.strimzi.kafka.oauth.validator.TokenValidationException;
import io.strimzi.kafka.oauth.validator.TokenValidator;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Supplier;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.kafka.common.errors.SaslAuthenticationException;
import org.apache.kafka.common.security.auth.AuthenticateCallbackHandler;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerValidatorCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaasServerOauthValidatorCallbackHandler
implements AuthenticateCallbackHandler {
    private static final Logger log = LoggerFactory.getLogger(JaasServerOauthValidatorCallbackHandler.class);
    private TokenValidator validator;
    private ServerConfig config;
    private boolean isJwt;
    private SSLSocketFactory socketFactory;
    private HostnameVerifier verifier;
    private PrincipalExtractor principalExtractor;
    private int connectTimeout;
    private int readTimeout;
    private int retries;
    private long retryPauseMillis;
    private boolean enableMetrics;
    private OAuthMetrics metrics;
    protected SensorKeyProducer validationSensorKeyProducer;

    public void configure(Map<String, ?> configs, String saslMechanism, List<AppConfigurationEntry> jaasConfigEntries) {
        if (!"OAUTHBEARER".equals(saslMechanism)) {
            throw new IllegalArgumentException(String.format("Unexpected SASL mechanism: %s", saslMechanism));
        }
        this.delegatedConfigure(configs, saslMechanism, jaasConfigEntries);
    }

    public void delegatedConfigure(Map<String, ?> configs, String saslMechanism, List<AppConfigurationEntry> jaasConfigEntries) {
        this.parseJaasConfig(jaasConfigEntries);
        this.isJwt = DeprecationUtil.isAccessTokenJwt((Config)this.config, (Logger)log, (String)"OAuth validator configuration error: ");
        this.validateConfig();
        this.socketFactory = ConfigUtil.createSSLFactory((Config)this.config);
        this.verifier = ConfigUtil.createHostnameVerifier((Config)this.config);
        String jwksUri = this.config.getValue("oauth.jwks.endpoint.uri");
        String validIssuerUri = this.config.getValue("oauth.valid.issuer.uri");
        this.validateIssuerUri(validIssuerUri);
        this.checkDeprecatedConfig();
        boolean checkTokenType = JaasServerOauthValidatorCallbackHandler.isCheckAccessTokenType(this.config);
        boolean checkAudience = this.config.getValueAsBoolean("oauth.check.audience", false);
        String usernameClaim = this.config.getValue("oauth.username.claim");
        String fallbackUsernameClaim = this.config.getValue("oauth.fallback.username.claim");
        String fallbackUsernamePrefix = this.config.getValue("oauth.fallback.username.prefix");
        this.validateFallbackUsernameParameters(usernameClaim, fallbackUsernameClaim, fallbackUsernamePrefix);
        this.principalExtractor = new PrincipalExtractor(usernameClaim, fallbackUsernameClaim, fallbackUsernamePrefix);
        String clientId = this.config.getValue("oauth.client.id");
        String clientSecret = this.config.getValue("oauth.client.secret");
        if (checkAudience && clientId == null) {
            throw new ConfigException("OAuth validator configuration error: 'oauth.client.id' must be set when 'oauth.check.audience' is 'true'");
        }
        String audience = checkAudience ? clientId : null;
        String customClaimCheck = this.config.getValue("oauth.custom.claim.check");
        String groupQuery = this.config.getValue("oauth.groups.claim");
        String groupDelimiter = this.config.getValue("oauth.groups.claim.delimiter");
        String sslTruststore = this.config.getValue("oauth.ssl.truststore.location");
        String sslPassword = this.config.getValue("oauth.ssl.truststore.password");
        String sslType = this.config.getValue("oauth.ssl.truststore.type");
        String sslRnd = this.config.getValue("oauth.ssl.secure.random.implementation");
        this.connectTimeout = ConfigUtil.getConnectTimeout((Config)this.config);
        this.readTimeout = ConfigUtil.getReadTimeout((Config)this.config);
        this.configureHttpRetries(this.config);
        String configId = this.config.getValue("oauth.config.id");
        this.configureMetrics(configs);
        if (jwksUri != null) {
            String effectiveConfigId = this.setupJWKSValidator(configId, jwksUri, validIssuerUri, checkTokenType, usernameClaim, fallbackUsernameClaim, fallbackUsernamePrefix, groupQuery, groupDelimiter, audience, customClaimCheck, sslTruststore, sslPassword, sslType, sslRnd);
            URI jwksEndpointUri = this.config.getValueAsURI("oauth.jwks.endpoint.uri");
            this.validationSensorKeyProducer = new JwksValidationSensorKeyProducer(effectiveConfigId, saslMechanism, jwksEndpointUri);
        } else {
            String effectiveConfigId = this.setupIntrospectionValidator(configId, validIssuerUri, usernameClaim, fallbackUsernameClaim, fallbackUsernamePrefix, groupQuery, groupDelimiter, clientId, clientSecret, audience, customClaimCheck, sslTruststore, sslPassword, sslType, sslRnd);
            URI introspectionUri = this.config.getValueAsURI("oauth.introspection.endpoint.uri");
            this.validationSensorKeyProducer = new IntrospectValidationSensorKeyProducer(effectiveConfigId, saslMechanism, introspectionUri);
        }
    }

    private void configureMetrics(Map<String, ?> configs) {
        if (!Services.isAvailable()) {
            Services.configure(configs);
        }
        this.enableMetrics = this.config.getValueAsBoolean("oauth.enable.metrics", false);
        if (this.enableMetrics) {
            this.metrics = Services.getInstance().getMetrics();
        }
    }

    private String setupIntrospectionValidator(String configId, String validIssuerUri, String usernameClaim, String fallbackUsernameClaim, String fallbackUsernamePrefix, String groupQuery, String groupDelimiter, String clientId, String clientSecret, String audience, String customClaimCheck, String sslTruststore, String sslPassword, String sslType, String sslRnd) {
        String introspectionEndpoint = this.config.getValue("oauth.introspection.endpoint.uri");
        String userInfoEndpoint = this.config.getValue("oauth.userinfo.endpoint.uri");
        String validTokenType = this.config.getValue("oauth.valid.token.type");
        ValidatorKey.IntrospectionValidatorKey vkey = new ValidatorKey.IntrospectionValidatorKey(validIssuerUri, audience, customClaimCheck, usernameClaim, fallbackUsernameClaim, fallbackUsernamePrefix, groupQuery, groupDelimiter, sslTruststore, sslPassword, sslType, sslRnd, this.verifier != null, introspectionEndpoint, userInfoEndpoint, validTokenType, clientId, clientSecret, this.connectTimeout, this.readTimeout, this.enableMetrics, this.retries, this.retryPauseMillis);
        String effectiveConfigId = configId != null ? configId : vkey.getConfigIdHash();
        Supplier<TokenValidator> factory = () -> new OAuthIntrospectionValidator(effectiveConfigId, introspectionEndpoint, this.socketFactory, this.verifier, this.principalExtractor, groupQuery, groupDelimiter, validIssuerUri, userInfoEndpoint, validTokenType, clientId, clientSecret, audience, customClaimCheck, this.connectTimeout, this.readTimeout, this.enableMetrics, this.retries, this.retryPauseMillis);
        ConfigurationKey confKey = configId != null ? new ConfigurationKey(configId, (ValidatorKey)vkey) : new ConfigurationKey(vkey.getConfigIdHash(), (ValidatorKey)vkey);
        this.validator = Services.getInstance().getValidators().get(confKey, factory);
        return effectiveConfigId;
    }

    private String setupJWKSValidator(String configId, String jwksUri, String validIssuerUri, boolean checkTokenType, String usernameClaim, String fallbackUsernameClaim, String fallbackUsernamePrefix, String groupQuery, String groupDelimiter, String audience, String customClaimCheck, String sslTruststore, String sslPassword, String sslType, String sslRnd) {
        int jwksRefreshSeconds = this.config.getValueAsInt("oauth.jwks.refresh.seconds", 300);
        int jwksExpirySeconds = this.config.getValueAsInt("oauth.jwks.expiry.seconds", 360);
        int jwksMinPauseSeconds = this.config.getValueAsInt("oauth.jwks.refresh.min.pause.seconds", 1);
        boolean failFast = this.config.getValueAsBoolean("oauth.fail.fast", true);
        boolean jwksIgnoreKeyUse = this.config.getValueAsBoolean("oauth.jwks.ignore.key.use", false);
        ValidatorKey.JwtValidatorKey vkey = new ValidatorKey.JwtValidatorKey(validIssuerUri, audience, customClaimCheck, usernameClaim, fallbackUsernameClaim, fallbackUsernamePrefix, groupQuery, groupDelimiter, sslTruststore, sslPassword, sslType, sslRnd, this.verifier != null, jwksUri, jwksRefreshSeconds, jwksExpirySeconds, jwksMinPauseSeconds, jwksIgnoreKeyUse, checkTokenType, this.connectTimeout, this.readTimeout, this.enableMetrics, failFast);
        String effectiveConfigId = configId != null ? configId : vkey.getConfigIdHash();
        Supplier<TokenValidator> factory = () -> new JWTSignatureValidator(effectiveConfigId, jwksUri, this.socketFactory, this.verifier, this.principalExtractor, groupQuery, groupDelimiter, validIssuerUri, jwksRefreshSeconds, jwksMinPauseSeconds, jwksExpirySeconds, jwksIgnoreKeyUse, checkTokenType, audience, customClaimCheck, this.connectTimeout, this.readTimeout, this.enableMetrics, failFast);
        ConfigurationKey confKey = configId != null ? new ConfigurationKey(configId, (ValidatorKey)vkey) : new ConfigurationKey(vkey.getConfigIdHash(), (ValidatorKey)vkey);
        this.validator = Services.getInstance().getValidators().get(confKey, factory);
        return effectiveConfigId;
    }

    private void checkDeprecatedConfig() {
        if (this.config.getValue("oauth.crypto.provider.bouncycastle") != null) {
            log.warn("The 'oauth.crypto.provider.bouncycastle' option has been deprecated. ECDSA is automatically available without the need for BouncyCastle JCE provider.");
        }
        if (this.config.getValue("oauth.crypto.provider.bouncycastle.position") != null) {
            log.warn("The 'oauth.crypto.provider.bouncycastle.position' option has been deprecated. ECDSA is automatically available without the need for BouncyCastle JCE provider.");
        }
    }

    protected ServerConfig parseJaasConfig(List<AppConfigurationEntry> jaasConfigEntries) {
        if (this.config != null) {
            return this.config;
        }
        if (jaasConfigEntries.size() != 1) {
            throw new IllegalArgumentException("Exactly one jaasConfigEntry expected (size: " + jaasConfigEntries.size());
        }
        AppConfigurationEntry e = jaasConfigEntries.get(0);
        Properties p = new Properties();
        p.putAll(e.getOptions());
        this.config = new ServerConfig(p);
        return this.config;
    }

    private static boolean isCheckAccessTokenType(Config config) {
        String legacy = config.getValue("oauth.validation.skip.type.check");
        if (legacy != null) {
            log.warn("Config option '{}' is deprecated. Use '{}' (with reverse meaning) instead.", (Object)"oauth.validation.skip.type.check", (Object)"oauth.check.access.token.type");
            if (config.getValue("oauth.check.access.token.type") != null) {
                throw new ConfigException("OAuth validator configuration error: can't use both 'oauth.check.access.token.type' and 'oauth.validation.skip.type.check'");
            }
        }
        return legacy != null ? !Config.isTrue((String)legacy) : config.getValueAsBoolean("oauth.check.access.token.type", true);
    }

    private void validateConfig() {
        String jwksUri = this.config.getValue("oauth.jwks.endpoint.uri");
        String introspectUri = this.config.getValue("oauth.introspection.endpoint.uri");
        if (jwksUri == null && introspectUri == null) {
            throw new ConfigException("OAuth validator configuration error: either 'oauth.jwks.endpoint.uri' (for fast local signature validation) or 'oauth.introspection.endpoint.uri' (for using authorization server during validation) should be specified!");
        }
        if (jwksUri != null && introspectUri != null) {
            throw new ConfigException("OAuth validator configuration error: only one of 'oauth.jwks.endpoint.uri' (for fast local signature validation) and 'oauth.introspection.endpoint.uri' (for using authorization server during validation) can be specified!");
        }
        if (jwksUri != null && !this.isJwt) {
            throw new ConfigException("OAuth validator configuration error: 'oauth.jwks.endpoint.uri' (for fast local signature validation) is not compatible with 'oauth.access.token.is.jwt' set to 'false'");
        }
    }

    private void validateIssuerUri(String validIssuerUri) {
        if (validIssuerUri == null && this.config.getValueAsBoolean("oauth.check.issuer", true)) {
            throw new ConfigException("OAuth validator configuration error: 'oauth.valid.issuer.uri' must be set or 'oauth.check.issuer' has to be set to 'false'");
        }
    }

    private void validateFallbackUsernameParameters(String usernameClaim, String fallbackUsernameClaim, String fallbackUsernamePrefix) {
        if (fallbackUsernameClaim != null && usernameClaim == null) {
            throw new ConfigException("OAuth validator configuration error: 'oauth.username.claim' must be set when 'oauth.fallback.username.claim' is set");
        }
        if (fallbackUsernamePrefix != null && fallbackUsernameClaim == null) {
            throw new ConfigException("OAuth validator configuration error: 'oauth.fallback.username.claim' must be set when 'oauth.fallback.username.prefix' is set");
        }
    }

    private void configureHttpRetries(ServerConfig config) {
        this.retries = config.getValueAsInt("oauth.http.retries", 0);
        if (this.retries < 0) {
            throw new ConfigException("The configured value of 'oauth.http.retries' has to be greater or equal to zero");
        }
        this.retryPauseMillis = config.getValueAsLong("oauth.http.retry.pause.millis", 0L);
        if (this.retries > 0) {
            if (this.retryPauseMillis < 0L) {
                this.retryPauseMillis = 0L;
                log.warn("The configured value of 'oauth.http.retry.pause.millis' is less than zero and will be ignored");
            }
            if (this.retryPauseMillis <= 0L) {
                log.warn("No pause between http retries configured. Consider setting 'oauth.http.retry.pause.millis' to greater than zero to avoid flooding the authorization server with requests.");
            }
        }
    }

    public void close() {
    }

    public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
        long requestStartTime = System.currentTimeMillis();
        try {
            this.delegatedHandle(callbacks);
            this.addValidationMetricSuccessTime(requestStartTime);
        }
        catch (UnsupportedCallbackException e) {
            throw e;
        }
        catch (Throwable t) {
            this.addValidationMetricErrorTime(t, requestStartTime);
            throw t;
        }
    }

    public void delegatedHandle(Callback[] callbacks) throws UnsupportedCallbackException {
        for (Callback callback : callbacks) {
            if (!(callback instanceof OAuthBearerValidatorCallback)) {
                throw new UnsupportedCallbackException(callback);
            }
            this.handleCallback((OAuthBearerValidatorCallback)callback);
        }
    }

    private void handleCallback(OAuthBearerValidatorCallback callback) {
        if (callback.tokenValue() == null) {
            throw new IllegalArgumentException("Callback has null token value!");
        }
        String token = callback.tokenValue();
        try {
            this.debugLogToken(token);
            TokenInfo ti = this.validateToken(token);
            callback.token((OAuthBearerToken)new BearerTokenWithJsonPayload(ti));
            if (log.isDebugEnabled()) {
                log.debug("Set validated token on callback: " + callback.token());
            }
        }
        catch (TokenValidationException e) {
            this.handleError("Token validation failed for token: " + LogUtil.mask((String)token), e);
        }
        catch (RuntimeException e) {
            this.handleError("Runtime failure during token validation", e);
        }
        catch (Throwable e) {
            this.handleError("Unexpected failure during token validation", e);
        }
    }

    private void handleError(String message, Throwable e) {
        this.handleErrorWithLogger(log, message, e);
    }

    protected void handleErrorWithLogger(Logger logger, String message, Throwable e) {
        String errId = IOUtil.randomHexString();
        String msg = message + " (ErrId: " + errId + ")";
        if (e instanceof TokenValidationException || e instanceof SaslAuthenticationException) {
            if (logger.isDebugEnabled()) {
                logger.debug(msg, e);
            }
            message = e.getMessage();
            e = e.getCause() != null ? e.getCause() : e;
        } else if (e instanceof RuntimeException) {
            if (logger.isDebugEnabled()) {
                logger.debug(msg, e);
            }
        } else {
            logger.error(msg, e);
        }
        throw new OAuthSaslAuthenticationException(message, errId, e);
    }

    private TokenInfo validateToken(String token) {
        TokenInfo result = this.validator.validate(token);
        if (log.isDebugEnabled()) {
            log.debug("User validated (Principal:{})", (Object)(result == null ? "null" : result.principal()));
        }
        return result;
    }

    private void debugLogToken(String token) {
        if (!log.isDebugEnabled() || !this.isJwt) {
            return;
        }
        TokenIntrospection.debugLogJWT((Logger)log, (String)token);
    }

    public boolean isJwt() {
        return this.isJwt;
    }

    public SSLSocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    public HostnameVerifier getVerifier() {
        return this.verifier;
    }

    public PrincipalExtractor getPrincipalExtractor() {
        return this.principalExtractor;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    protected String getConfigId() {
        if (this.validator == null) {
            throw new IllegalStateException("This method can only be invoked after the validator was configured");
        }
        return this.validator.getValidatorId();
    }

    protected int getRetries() {
        return this.retries;
    }

    protected long getRetryPauseMillis() {
        return this.retryPauseMillis;
    }

    private void addValidationMetricSuccessTime(long startTimeMs) {
        if (this.enableMetrics) {
            this.metrics.addTime(this.validationSensorKeyProducer.successKey(), System.currentTimeMillis() - startTimeMs);
        }
    }

    private void addValidationMetricErrorTime(Throwable e, long startTimeMs) {
        if (this.enableMetrics) {
            this.metrics.addTime(this.validationSensorKeyProducer.errorKey(e), System.currentTimeMillis() - startTimeMs);
        }
    }
}

