/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.kafka.oauth.server;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.strimzi.kafka.oauth.common.BearerTokenWithPayload;
import io.strimzi.kafka.oauth.common.JSONUtil;
import io.strimzi.kafka.oauth.common.TimeUtil;
import io.strimzi.kafka.oauth.common.TokenInfo;
import java.io.IOException;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BearerTokenWithJsonPayload
implements BearerTokenWithPayload {
    private static final Logger log = LoggerFactory.getLogger(BearerTokenWithJsonPayload.class);
    private final TokenInfo ti;
    private volatile JsonNode payload;
    private int sessionId = System.identityHashCode(this);

    BearerTokenWithJsonPayload(TokenInfo ti) {
        if (ti == null) {
            throw new IllegalArgumentException("TokenInfo == null");
        }
        this.ti = ti;
    }

    public JsonNode getPayload() {
        return this.payload;
    }

    public void setPayload(JsonNode value) {
        this.payload = value;
    }

    public Set<String> getGroups() {
        return this.ti.groups();
    }

    public ObjectNode getClaimsJSON() {
        return this.ti.payload();
    }

    public String value() {
        return this.ti.token();
    }

    public Set<String> scope() {
        return this.ti.scope();
    }

    public long lifetimeMs() {
        return this.ti.expiresAtMs();
    }

    public String principalName() {
        return this.ti.principal();
    }

    public Long startTimeMs() {
        return this.ti.issuedAtMs();
    }

    public int getSessionId() {
        return this.sessionId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BearerTokenWithJsonPayload that = (BearerTokenWithJsonPayload)o;
        return Objects.equals(this.ti, that.ti);
    }

    public int hashCode() {
        return Objects.hash(this.ti);
    }

    public String toString() {
        return "BearerTokenWithPayloadImpl (principalName: " + this.ti.principal() + ", groups: " + this.ti.groups() + ", lifetimeMs: " + this.ti.expiresAtMs() + " [" + TimeUtil.formatIsoDateTimeUTC((long)this.ti.expiresAtMs()) + " UTC], startTimeMs: " + this.ti.issuedAtMs() + " [" + TimeUtil.formatIsoDateTimeUTC((long)this.ti.issuedAtMs()) + " UTC], scope: " + this.ti.scope() + ", payload: " + this.ti.payload() + ", sessionId: " + this.sessionId + ")";
    }

    static class Serde {
        private static final String TOKEN = "t";
        private static final String SCOPES = "sc";
        private static final String GROUPS = "g";
        private static final String PRINCIPAL = "n";
        private static final String START_TIME = "st";
        private static final String EXPIRY_TIME = "e";
        private static final String TOKEN_CLAIMS = "j";
        private static final String EXTRA_PAYLOAD = "p";
        private static final String SESSION_ID = "si";

        Serde() {
        }

        public byte[] serialize(BearerTokenWithJsonPayload token) throws IOException {
            ObjectNode object = JSONUtil.newObjectNode();
            object.put(PRINCIPAL, token.principalName());
            JSONUtil.setArrayOfStringsIfNotNull((JsonNode)object, (String)GROUPS, token.getGroups());
            JSONUtil.setArrayOfStringsIfNotNull((JsonNode)object, (String)SCOPES, token.scope());
            object.put(TOKEN, token.value());
            object.put(START_TIME, token.startTimeMs());
            object.put(EXPIRY_TIME, token.lifetimeMs());
            object.set(TOKEN_CLAIMS, (JsonNode)token.getClaimsJSON());
            object.set(EXTRA_PAYLOAD, token.getPayload());
            if (token.getPayload() == null) {
                this.logTrace("Serialising a token without an extra payload: " + token, new Object[0]);
            } else {
                this.logTrace("Serialising a token with an extra payload: " + token, new Object[0]);
            }
            object.put(SESSION_ID, token.sessionId);
            this.logTrace("Serialising a token: {}", token);
            return JSONUtil.MAPPER.writeValueAsBytes((Object)object);
        }

        public BearerTokenWithJsonPayload deserialize(byte[] bytes) throws IOException {
            ObjectNode object = (ObjectNode)JSONUtil.MAPPER.readValue(bytes, ObjectNode.class);
            JsonNode groups = object.get(GROUPS);
            JsonNode scopes = object.get(SCOPES);
            JsonNode json = object.get(TOKEN_CLAIMS);
            JsonNode payload = object.get(EXTRA_PAYLOAD);
            int sessionId = object.get(SESSION_ID).asInt();
            BearerTokenWithJsonPayload result = new BearerTokenWithJsonPayload(new TokenInfo(object.get(TOKEN).asText(), scopes != null && scopes.isArray() ? new HashSet(JSONUtil.asListOfString((JsonNode)scopes, (String)",")) : null, object.get(PRINCIPAL).asText(), groups != null && groups.isArray() ? new HashSet(JSONUtil.asListOfString((JsonNode)groups, (String)",")) : null, object.get(START_TIME).asLong(), object.get(EXPIRY_TIME).asLong(), json.isNull() ? null : json));
            result.sessionId = sessionId;
            result.setPayload(payload);
            this.logTrace("Deserialised a token: {}", result);
            return result;
        }

        private void logTrace(String message, Object ... args) {
            if (log.isTraceEnabled()) {
                log.trace(message, args);
            }
        }
    }
}

