/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.kafka.oauth.server;

import io.strimzi.kafka.oauth.common.BearerTokenWithPayload;
import io.strimzi.kafka.oauth.server.OAuthKafkaPrincipal;
import io.strimzi.kafka.oauth.services.Services;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.Configurable;
import org.apache.kafka.common.security.auth.AuthenticationContext;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SaslAuthenticationContext;
import org.apache.kafka.common.security.authenticator.DefaultKafkaPrincipalBuilder;
import org.apache.kafka.common.security.oauthbearer.internals.OAuthBearerSaslServer;

public class OAuthKafkaPrincipalBuilder
extends DefaultKafkaPrincipalBuilder
implements Configurable {
    private static final SetAccessibleAction SET_PRINCIPAL_MAPPER = SetAccessibleAction.newInstance();

    public OAuthKafkaPrincipalBuilder() {
        super(null, null);
    }

    public void configure(Map<String, ?> configs) {
        Object sslPrincipalMappingRules = configs.get("ssl.principal.mapping.rules");
        try {
            Object sslPrincipalMapper;
            Class<?> clazz = Class.forName("org.apache.kafka.common.security.ssl.SslPrincipalMapper");
            try {
                Method m = clazz.getMethod("fromRules", List.class);
                if (sslPrincipalMappingRules == null) {
                    sslPrincipalMappingRules = Collections.singletonList("DEFAULT");
                }
                sslPrincipalMapper = m.invoke(null, sslPrincipalMappingRules);
            }
            catch (NoSuchMethodException ex) {
                Method m = clazz.getMethod("fromRules", String.class);
                if (sslPrincipalMappingRules == null) {
                    sslPrincipalMappingRules = "DEFAULT";
                }
                sslPrincipalMapper = m.invoke(null, sslPrincipalMappingRules);
            }
            SET_PRINCIPAL_MAPPER.invoke(this, sslPrincipalMapper);
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Failed to initialize OAuthKafkaPrincipalBuilder", e);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Failed to initialize OAuthKafkaPrincipalBuilder", e);
        }
    }

    public KafkaPrincipal build(AuthenticationContext context) {
        OAuthBearerSaslServer server;
        if (context instanceof SaslAuthenticationContext && "OAUTHBEARER".equals((server = (OAuthBearerSaslServer)((SaslAuthenticationContext)context).server()).getMechanismName())) {
            BearerTokenWithPayload token = (BearerTokenWithPayload)server.getNegotiatedProperty("OAUTHBEARER.token");
            Services.getInstance().getSessions().put(token);
            OAuthKafkaPrincipal kafkaPrincipal = new OAuthKafkaPrincipal("User", server.getAuthorizationID(), token);
            return kafkaPrincipal;
        }
        return super.build(context);
    }

    private static class SetAccessibleAction
    implements PrivilegedAction<Void> {
        private Field field;

        SetAccessibleAction(Field field) {
            this.field = field;
        }

        @Override
        public Void run() {
            this.field.setAccessible(true);
            return null;
        }

        void invoke(DefaultKafkaPrincipalBuilder target, Object value) throws IllegalAccessException {
            AccessController.doPrivileged(this);
            this.field.set(target, value);
        }

        static SetAccessibleAction newInstance() {
            try {
                return new SetAccessibleAction(DefaultKafkaPrincipalBuilder.class.getDeclaredField("sslPrincipalMapper"));
            }
            catch (NoSuchFieldException e) {
                throw new IllegalStateException("Failed to install OAuthKafkaPrincipalBuilder. This Kafka version does not seem to be supported", e);
            }
        }
    }
}

