/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.kafka.oauth.server;

import io.strimzi.kafka.oauth.common.BearerTokenWithPayload;
import io.strimzi.kafka.oauth.common.Config;
import io.strimzi.kafka.oauth.common.ConfigUtil;
import io.strimzi.kafka.oauth.common.DeprecationUtil;
import io.strimzi.kafka.oauth.common.IOUtil;
import io.strimzi.kafka.oauth.common.LogUtil;
import io.strimzi.kafka.oauth.common.PrincipalExtractor;
import io.strimzi.kafka.oauth.common.TimeUtil;
import io.strimzi.kafka.oauth.common.TokenInfo;
import io.strimzi.kafka.oauth.common.TokenIntrospection;
import io.strimzi.kafka.oauth.server.OAuthSaslAuthenticationException;
import io.strimzi.kafka.oauth.server.ServerConfig;
import io.strimzi.kafka.oauth.services.Services;
import io.strimzi.kafka.oauth.services.ValidatorKey;
import io.strimzi.kafka.oauth.validator.JWTSignatureValidator;
import io.strimzi.kafka.oauth.validator.OAuthIntrospectionValidator;
import io.strimzi.kafka.oauth.validator.TokenValidationException;
import io.strimzi.kafka.oauth.validator.TokenValidator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.function.Supplier;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.kafka.common.errors.SaslAuthenticationException;
import org.apache.kafka.common.security.auth.AuthenticateCallbackHandler;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerValidatorCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaasServerOauthValidatorCallbackHandler
implements AuthenticateCallbackHandler {
    private static final Logger log = LoggerFactory.getLogger(JaasServerOauthValidatorCallbackHandler.class);
    private TokenValidator validator;
    private ServerConfig config;
    private boolean isJwt;
    private SSLSocketFactory socketFactory;
    private HostnameVerifier verifier;
    private PrincipalExtractor principalExtractor;

    public void configure(Map<String, ?> configs, String saslMechanism, List<AppConfigurationEntry> jaasConfigEntries) {
        Supplier<TokenValidator> factory;
        ValidatorKey.IntrospectionValidatorKey vkey;
        if (!"OAUTHBEARER".equals(saslMechanism)) {
            throw new IllegalArgumentException(String.format("Unexpected SASL mechanism: %s", saslMechanism));
        }
        this.parseJaasConfig(jaasConfigEntries);
        this.isJwt = DeprecationUtil.isAccessTokenJwt((Config)this.config, (Logger)log, (String)"OAuth validator configuration error: ");
        this.validateConfig();
        this.socketFactory = ConfigUtil.createSSLFactory((Config)this.config);
        this.verifier = ConfigUtil.createHostnameVerifier((Config)this.config);
        String jwksUri = this.config.getValue("oauth.jwks.endpoint.uri");
        String validIssuerUri = this.config.getValue("oauth.valid.issuer.uri");
        this.validateIssuerUri(validIssuerUri);
        if (this.config.getValue("oauth.crypto.provider.bouncycastle") != null) {
            log.warn("The OAUTH_CRYPTO_PROVIDER_BOUNCYCASTLE option has been deprecated. ECDSA is automatically available without the need for BouncyCastle JCE provider.");
        }
        if (this.config.getValue("oauth.crypto.provider.bouncycastle.position") != null) {
            log.warn("The OAUTH_CRYPTO_PROVIDER_BOUNCYCASTLE_POSITION option has been deprecated. ECDSA is automatically available without the need for BouncyCastle JCE provider.");
        }
        boolean checkTokenType = JaasServerOauthValidatorCallbackHandler.isCheckAccessTokenType(this.config);
        boolean checkAudience = this.config.getValueAsBoolean("oauth.check.audience", false);
        String usernameClaim = this.config.getValue("oauth.username.claim");
        String fallbackUsernameClaim = this.config.getValue("oauth.fallback.username.claim");
        String fallbackUsernamePrefix = this.config.getValue("oauth.fallback.username.prefix");
        this.validateFallbackUsernameParameters(usernameClaim, fallbackUsernameClaim, fallbackUsernamePrefix);
        this.principalExtractor = new PrincipalExtractor(usernameClaim, fallbackUsernameClaim, fallbackUsernamePrefix);
        String clientId = this.config.getValue("oauth.client.id");
        String clientSecret = this.config.getValue("oauth.client.secret");
        if (checkAudience && clientId == null) {
            throw new RuntimeException("Oauth validator configuration error: OAUTH_CLIENT_ID must be set when OAUTH_CHECK_AUDIENCE is 'true'");
        }
        String audience = checkAudience ? clientId : null;
        String customClaimCheck = this.config.getValue("oauth.custom.claim.check");
        if (!Services.isAvailable()) {
            Services.configure(configs);
        }
        String sslTruststore = this.config.getValue("oauth.ssl.truststore.location");
        String sslPassword = this.config.getValue("oauth.ssl.truststore.password");
        String sslType = this.config.getValue("oauth.ssl.truststore.type");
        String sslRnd = this.config.getValue("oauth.ssl.secure.random.implementation");
        if (jwksUri != null) {
            int jwksRefreshSeconds = this.config.getValueAsInt("oauth.jwks.refresh.seconds", 300);
            int jwksExpirySeconds = this.config.getValueAsInt("oauth.jwks.expiry.seconds", 360);
            int jwksMinPauseSeconds = this.config.getValueAsInt("oauth.jwks.refresh.min.pause.seconds", 1);
            vkey = new ValidatorKey.JwtValidatorKey(validIssuerUri, audience, customClaimCheck, usernameClaim, fallbackUsernameClaim, fallbackUsernamePrefix, sslTruststore, sslPassword, sslType, sslRnd, this.verifier != null, jwksUri, jwksRefreshSeconds, jwksExpirySeconds, jwksMinPauseSeconds, checkTokenType);
            factory = () -> new JWTSignatureValidator(jwksUri, this.socketFactory, this.verifier, this.principalExtractor, validIssuerUri, jwksRefreshSeconds, jwksMinPauseSeconds, jwksExpirySeconds, checkTokenType, audience, customClaimCheck);
        } else {
            String introspectionEndpoint = this.config.getValue("oauth.introspection.endpoint.uri");
            String userInfoEndpoint = this.config.getValue("oauth.userinfo.endpoint.uri");
            String validTokenType = this.config.getValue("oauth.valid.token.type");
            vkey = new ValidatorKey.IntrospectionValidatorKey(validIssuerUri, audience, customClaimCheck, usernameClaim, fallbackUsernameClaim, fallbackUsernamePrefix, sslTruststore, sslPassword, sslType, sslRnd, this.verifier != null, introspectionEndpoint, userInfoEndpoint, validTokenType, clientId, clientSecret);
            factory = () -> new OAuthIntrospectionValidator(introspectionEndpoint, this.socketFactory, this.verifier, this.principalExtractor, validIssuerUri, userInfoEndpoint, validTokenType, clientId, clientSecret, audience, customClaimCheck);
        }
        this.validator = Services.getInstance().getValidators().get((ValidatorKey)vkey, factory);
    }

    protected ServerConfig parseJaasConfig(List<AppConfigurationEntry> jaasConfigEntries) {
        if (this.config != null) {
            return this.config;
        }
        if (jaasConfigEntries.size() != 1) {
            throw new IllegalArgumentException("Exactly one jaasConfigEntry expected (size: " + jaasConfigEntries.size());
        }
        AppConfigurationEntry e = jaasConfigEntries.get(0);
        Properties p = new Properties();
        p.putAll(e.getOptions());
        this.config = new ServerConfig(p);
        return this.config;
    }

    private static boolean isCheckAccessTokenType(Config config) {
        String legacy = config.getValue("oauth.validation.skip.type.check");
        if (legacy != null) {
            log.warn("OAUTH_VALIDATION_SKIP_TYPE_CHECK is deprecated. Use OAUTH_CHECK_ACCESS_TOKEN_TYPE (with reverse meaning) instead.");
            if (config.getValue("oauth.check.access.token.type") != null) {
                throw new RuntimeException("OAuth validator configuration error: can't use both OAUTH_CHECK_ACCESS_TOKEN_TYPE and OAUTH_VALIDATION_SKIP_TYPE_CHECK");
            }
        }
        return legacy != null ? !Config.isTrue((String)legacy) : config.getValueAsBoolean("oauth.check.access.token.type", true);
    }

    private void validateConfig() {
        String jwksUri = this.config.getValue("oauth.jwks.endpoint.uri");
        String introspectUri = this.config.getValue("oauth.introspection.endpoint.uri");
        if (jwksUri == null && introspectUri == null) {
            throw new RuntimeException("OAuth validator configuration error: either OAUTH_JWKS_ENDPOINT_URI (for fast local signature validation) or OAUTH_INTROSPECTION_ENDPOINT_URI (for using authorization server during validation) should be specified!");
        }
        if (jwksUri != null && introspectUri != null) {
            throw new RuntimeException("OAuth validator configuration error: only one of OAUTH_JWKS_ENDPOINT_URI (for fast local signature validation) and OAUTH_INTROSPECTION_ENDPOINT_URI (for using authorization server during validation) can be specified!");
        }
        if (jwksUri != null && !this.isJwt) {
            throw new RuntimeException("OAuth validator configuration error: OAUTH_JWKS_ENDPOINT_URI (for fast local signature validation) is not compatible with OAUTH_ACCESS_TOKEN_IS_JWT=false");
        }
    }

    private void validateIssuerUri(String validIssuerUri) {
        if (validIssuerUri == null && this.config.getValueAsBoolean("oauth.check.issuer", true)) {
            throw new RuntimeException("OAuth validator configuration error: OAUTH_VALID_ISSUER_URI must be set or OAUTH_CHECK_ISSUER has to be set to 'false'");
        }
    }

    private void validateFallbackUsernameParameters(String usernameClaim, String fallbackUsernameClaim, String fallbackUsernamePrefix) {
        if (fallbackUsernameClaim != null && usernameClaim == null) {
            throw new RuntimeException("OAuth validator configuration error: OAUTH_USERNAME_CLAIM must be set when OAUTH_FALLBACK_USERNAME_CLAIM is set");
        }
        if (fallbackUsernamePrefix != null && fallbackUsernameClaim == null) {
            throw new RuntimeException("OAuth validator configuration error: OAUTH_FALLBACK_USERNAME_CLAIM must be set when OAUTH_FALLBACK_USERNAME_PREFIX is set");
        }
    }

    public void close() {
    }

    public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
        for (Callback callback : callbacks) {
            if (!(callback instanceof OAuthBearerValidatorCallback)) {
                throw new UnsupportedCallbackException(callback);
            }
            this.handleCallback((OAuthBearerValidatorCallback)callback);
        }
    }

    private void handleCallback(OAuthBearerValidatorCallback callback) {
        if (callback.tokenValue() == null) {
            throw new IllegalArgumentException("Callback has null token value!");
        }
        String token = callback.tokenValue();
        this.debugLogToken(token);
        try {
            TokenInfo ti = this.validateToken(token);
            callback.token((OAuthBearerToken)new BearerTokenWithPayloadImpl(ti));
            if (log.isDebugEnabled()) {
                log.debug("Set validated token on callback: " + callback.token());
            }
        }
        catch (TokenValidationException e) {
            this.handleError("Token validation failed for token: " + LogUtil.mask((String)token), e);
        }
        catch (RuntimeException e) {
            this.handleError("Runtime failure during token validation", e);
        }
        catch (Throwable e) {
            this.handleError("Unexpected failure during token validation", e);
        }
    }

    private void handleError(String message, Throwable e) {
        this.handleErrorWithLogger(log, message, e);
    }

    protected void handleErrorWithLogger(Logger logger, String message, Throwable e) {
        String errId = IOUtil.randomHexString();
        String msg = message + " (ErrId: " + errId + ")";
        if (e instanceof TokenValidationException || e instanceof SaslAuthenticationException) {
            if (logger.isDebugEnabled()) {
                logger.debug(msg, e);
            }
            message = e.getMessage();
            e = e.getCause() != null ? e.getCause() : e;
        } else if (e instanceof RuntimeException) {
            if (logger.isDebugEnabled()) {
                logger.debug(msg, e);
            }
        } else {
            logger.error(msg, e);
        }
        throw new OAuthSaslAuthenticationException(message, errId, e);
    }

    private TokenInfo validateToken(String token) {
        TokenInfo result = this.validator.validate(token);
        if (log.isDebugEnabled()) {
            log.debug("User validated (Principal:{})", (Object)(result == null ? "null" : result.principal()));
        }
        return result;
    }

    private void debugLogToken(String token) {
        if (!log.isDebugEnabled() || !this.isJwt) {
            return;
        }
        TokenIntrospection.debugLogJWT((Logger)log, (String)token);
    }

    public boolean isJwt() {
        return this.isJwt;
    }

    public SSLSocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    public HostnameVerifier getVerifier() {
        return this.verifier;
    }

    public PrincipalExtractor getPrincipalExtractor() {
        return this.principalExtractor;
    }

    static class BearerTokenWithPayloadImpl
    implements BearerTokenWithPayload {
        private final TokenInfo ti;
        private Object payload;

        BearerTokenWithPayloadImpl(TokenInfo ti) {
            if (ti == null) {
                throw new IllegalArgumentException("TokenInfo == null");
            }
            this.ti = ti;
        }

        public Object getPayload() {
            return this.payload;
        }

        public void setPayload(Object value) {
            this.payload = value;
        }

        public String value() {
            return this.ti.token();
        }

        public Set<String> scope() {
            return this.ti.scope();
        }

        public long lifetimeMs() {
            return this.ti.expiresAtMs();
        }

        public String principalName() {
            return this.ti.principal();
        }

        public Long startTimeMs() {
            return this.ti.issuedAtMs();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BearerTokenWithPayloadImpl that = (BearerTokenWithPayloadImpl)o;
            return Objects.equals(this.ti, that.ti);
        }

        public int hashCode() {
            return Objects.hash(this.ti);
        }

        public String toString() {
            return "BearerTokenWithPayloadImpl (principalName: " + this.ti.principal() + ", lifetimeMs: " + this.ti.expiresAtMs() + " [" + TimeUtil.formatIsoDateTimeUTC((long)this.ti.expiresAtMs()) + " UTC], startTimeMs: " + this.ti.issuedAtMs() + " [" + TimeUtil.formatIsoDateTimeUTC((long)this.ti.issuedAtMs()) + " UTC], scope: " + this.ti.scope() + ")";
        }
    }
}

