/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.kafka.oauth.server;

import io.strimzi.kafka.oauth.common.BearerTokenWithPayload;
import io.strimzi.kafka.oauth.common.Config;
import io.strimzi.kafka.oauth.common.LogUtil;
import io.strimzi.kafka.oauth.common.TimeUtil;
import io.strimzi.kafka.oauth.server.OAuthKafkaPrincipal;
import kafka.network.RequestChannel;
import kafka.security.auth.Acl;
import kafka.security.auth.Authorizer;
import kafka.security.auth.Operation;
import kafka.security.auth.Resource;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;

public class OAuthSessionAuthorizer
implements Authorizer {
    static final Logger log = LoggerFactory.getLogger(OAuthSessionAuthorizer.class);
    static final Logger GRANT_LOG = LoggerFactory.getLogger((String)(OAuthSessionAuthorizer.class.getName() + ".grant"));
    static final Logger DENY_LOG = LoggerFactory.getLogger((String)(OAuthSessionAuthorizer.class.getName() + ".deny"));
    private Authorizer delegate;

    public void configure(java.util.Map<String, ?> configs) {
        String className = (String)configs.get("strimzi.authorizer.delegate.class.name");
        if (className != null) {
            try {
                Class<?> delegateClass = Thread.currentThread().getContextClassLoader().loadClass(className);
                if (!Authorizer.class.isAssignableFrom(delegateClass)) {
                    throw new IllegalArgumentException("The class specified by strimzi.authorizer.delegate.class.name is not an instance of kafka.security.auth.Authorizer");
                }
                this.delegate = (Authorizer)delegateClass.newInstance();
                this.delegate.configure(configs);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new RuntimeException("Failed to instantiate and configure the delegate authorizer: " + className, e);
            }
        } else {
            boolean isGrantByDefault;
            String grantByDefault = (String)configs.get("strimzi.authorizer.grant.when.no.delegate");
            boolean bl = isGrantByDefault = grantByDefault != null && Config.isTrue((String)grantByDefault);
            if (!isGrantByDefault) {
                throw new RuntimeException("When no 'strimzi.authorizer.delegate.class.name' is specified, 'strimzi.authorizer.grant.when.no.delegate=true' has to be specified");
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Configured OAuthSessionAuthorizer:\n    strimzi.authorizer.delegate.class.name: " + className);
        }
    }

    public boolean authorize(RequestChannel.Session session, Operation operation, Resource resource) {
        KafkaPrincipal principal = session.principal();
        if (!(principal instanceof OAuthKafkaPrincipal)) {
            if (this.delegate != null) {
                return this.delegate.authorize(session, operation, resource);
            }
            if (GRANT_LOG.isDebugEnabled()) {
                GRANT_LOG.debug("Authorization GRANTED - no access token: " + session.principal() + ", operation: " + operation + ", resource: " + resource);
            }
            return true;
        }
        BearerTokenWithPayload token = ((OAuthKafkaPrincipal)principal).getJwt();
        if (this.denyIfTokenInvalid(token)) {
            return false;
        }
        if (this.delegate == null) {
            if (GRANT_LOG.isDebugEnabled()) {
                GRANT_LOG.debug("Authorization GRANTED - access token still valid: " + session.principal() + ", operation: " + operation + ", resource: " + resource + ", token: " + LogUtil.mask((String)token.value()));
            }
            return true;
        }
        return this.delegate.authorize(session, operation, resource);
    }

    private boolean denyIfTokenInvalid(BearerTokenWithPayload token) {
        if (token.lifetimeMs() <= System.currentTimeMillis()) {
            if (DENY_LOG.isDebugEnabled()) {
                DENY_LOG.debug("Authorization DENIED due to token expiry - The token expired at: " + token.lifetimeMs() + " (" + TimeUtil.formatIsoDateTimeUTC((long)token.lifetimeMs()) + " UTC), for token: " + LogUtil.mask((String)token.value()));
            }
            return true;
        }
        return false;
    }

    public void addAcls(Set<Acl> acls, Resource resource) {
        this.delegate.addAcls(acls, resource);
    }

    public boolean removeAcls(Set<Acl> acls, Resource resource) {
        return this.delegate.removeAcls(acls, resource);
    }

    public boolean removeAcls(Resource resource) {
        return this.delegate.removeAcls(resource);
    }

    public Set<Acl> getAcls(Resource resource) {
        return this.delegate.getAcls(resource);
    }

    public Map<Resource, Set<Acl>> getAcls(KafkaPrincipal principal) {
        return this.delegate.getAcls(principal);
    }

    public Map<Resource, Set<Acl>> getAcls() {
        return this.delegate.getAcls();
    }

    public void close() {
        this.delegate.close();
    }
}

