/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.test.container;

import io.strimzi.test.container.UnknownKafkaVersionException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.testcontainers.shaded.com.fasterxml.jackson.databind.ObjectMapper;

class KafkaVersionService {
    private static final Logger LOGGER = LoggerFactory.getLogger(KafkaVersionService.class);
    private static final Pattern KAFKA_VERSION_PATTERN = Pattern.compile(".*-kafka-(\\d+\\.\\d+\\.\\d+)$");
    private final List<KafkaVersion> logicalKafkaVersionEntities = new ArrayList<KafkaVersion>();

    private KafkaVersionService() {
        this.resolveAndParse();
    }

    public static KafkaVersionService getInstance() {
        return InstanceHolder.INSTANCE;
    }

    protected static String strimziTestContainerImageName(String kafkaVersion) {
        String imageName;
        Object strimziCustomImageName = System.getProperties().get("strimzi.test-container.kafka.custom.image");
        if (strimziCustomImageName != null && !strimziCustomImageName.toString().isEmpty()) {
            String customImage = strimziCustomImageName.toString();
            LOGGER.info("Using custom image: {}", (Object)customImage);
            imageName = customImage;
        } else if (kafkaVersion == null || kafkaVersion.isEmpty()) {
            imageName = KafkaVersionService.getInstance().latestRelease().getImage();
            kafkaVersion = KafkaVersionService.getInstance().latestRelease().getVersion();
            LOGGER.info("No Kafka version specified. Using latest release: {}", (Object)kafkaVersion);
        } else {
            for (KafkaVersion kv : KafkaVersionService.getInstance().logicalKafkaVersionEntities) {
                if (!kv.getVersion().equals(kafkaVersion)) continue;
                return kv.getImage();
            }
            throw new UnknownKafkaVersionException("Doesn't know the specified Kafka version: " + kafkaVersion + ". The supported Kafka versions are: " + KafkaVersionService.getInstance().logicalKafkaVersionEntities.stream().map(KafkaVersion::getVersion).collect(Collectors.toList()));
        }
        return imageName;
    }

    public KafkaVersion latestRelease() {
        if (this.logicalKafkaVersionEntities.isEmpty()) {
            throw new IllegalStateException("Wrong json schema! It must have at least one release");
        }
        KafkaVersion latestRelease = this.logicalKafkaVersionEntities.get(0);
        for (int i = 1; i < this.logicalKafkaVersionEntities.size(); ++i) {
            if (latestRelease.compareTo(this.logicalKafkaVersionEntities.get(i)) >= 0) continue;
            latestRelease = this.logicalKafkaVersionEntities.get(i);
        }
        LOGGER.info("Latest release of Kafka is:{}", (Object)latestRelease.toString());
        return latestRelease;
    }

    public KafkaVersion previousMinor() {
        if (this.logicalKafkaVersionEntities.isEmpty()) {
            throw new IllegalStateException("Wrong json schema! It must have at least one release");
        }
        this.logicalKafkaVersionEntities.sort(KafkaVersion::compareTo);
        KafkaVersion previousMinorRelease = this.logicalKafkaVersionEntities.get(this.logicalKafkaVersionEntities.size() - 2);
        LOGGER.info("Previous minor release of Kafka is:{}", (Object)previousMinorRelease);
        return previousMinorRelease;
    }

    private void resolveAndParse() {
        try {
            JsonNode rootNode = (JsonNode)new ObjectMapper().readValue(KafkaVersionService.class.getResourceAsStream("/kafka_versions.json"), JsonNode.class);
            Iterator iter = rootNode.get("kafkaVersions").fields();
            while (iter.hasNext()) {
                Map.Entry fields = (Map.Entry)iter.next();
                KafkaVersion logicalKafkaVersion = new KafkaVersion((String)fields.getKey(), ((JsonNode)fields.getValue()).asText());
                this.logicalKafkaVersionEntities.add(logicalKafkaVersion);
            }
        }
        catch (IOException e) {
            LOGGER.error("Error occurred during instantiation of JsonReader!", (Throwable)e);
        }
    }

    public String toString() {
        return "KafkaVersionService{logicalKafkaVersionEntities=" + this.logicalKafkaVersionEntities + "}";
    }

    private static class InstanceHolder {
        public static final KafkaVersionService INSTANCE = new KafkaVersionService();

        private InstanceHolder() {
        }
    }

    static class KafkaVersion
    implements Comparable<KafkaVersion> {
        private final String version;
        private final String image;

        public KafkaVersion(String version, String image) {
            this.version = version;
            this.image = image;
        }

        @Override
        public int compareTo(KafkaVersion o) {
            return KafkaVersion.compareVersions(this.version, o.version);
        }

        public static int compareVersions(String version1, String version2) {
            String[] components = version1.split("\\.");
            String[] otherComponents = version2.split("\\.");
            for (int i = 0; i < Math.min(components.length, otherComponents.length); ++i) {
                int y;
                int x = Integer.parseInt(components[i]);
                if (x < (y = Integer.parseInt(otherComponents[i]))) {
                    return -1;
                }
                if (x <= y) continue;
                return 1;
            }
            return components.length - otherComponents.length;
        }

        public static String extractVersionFromImageName(String imageName) {
            Matcher matcher = KAFKA_VERSION_PATTERN.matcher(imageName);
            if (matcher.find()) {
                return matcher.group(1);
            }
            throw new IllegalArgumentException("Cannot extract Kafka version from image name: " + imageName);
        }

        public String getVersion() {
            return this.version;
        }

        public String getImage() {
            return this.image;
        }

        public String toString() {
            return "LogicalKafkaVersionEntity{version='" + this.version + "', image='" + this.image + "'}";
        }
    }
}

