/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.test.container;

import io.strimzi.test.container.WaitException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.net.ServerSocket;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.images.builder.Transferable;
import org.testcontainers.utility.MountableFile;

class Utils {
    private static final Logger LOGGER = LoggerFactory.getLogger(Utils.class);

    Utils() {
    }

    static long waitFor(String description, Duration pollInterval, Duration timeout, BooleanSupplier ready) {
        LOGGER.debug("Waiting for {}", (Object)description);
        long deadline = System.currentTimeMillis() + timeout.toMillis();
        String exceptionMessage = null;
        int exceptionCount = 0;
        StringWriter stackTraceError = new StringWriter();
        while (true) {
            boolean result;
            try {
                result = ready.getAsBoolean();
            }
            catch (Exception e) {
                exceptionMessage = e.getMessage();
                if (++exceptionCount == 1 && exceptionMessage != null) {
                    LOGGER.error("Exception waiting for {}, {}", (Object)description, (Object)exceptionMessage);
                    e.printStackTrace(new PrintWriter(stackTraceError));
                }
                result = false;
            }
            long timeLeft = deadline - System.currentTimeMillis();
            if (result) {
                return timeLeft;
            }
            if (timeLeft <= 0L) {
                if (exceptionCount > 1) {
                    LOGGER.error("Exception waiting for {}, {}", (Object)description, (Object)exceptionMessage);
                    if (!stackTraceError.toString().isEmpty()) {
                        LOGGER.error(stackTraceError.toString());
                    }
                }
                WaitException waitException = new WaitException("Timeout after " + timeout.toMillis() + " ms waiting for " + description);
                waitException.addSuppressed(waitException);
                throw waitException;
            }
            long sleepTime = Math.min(pollInterval.toMillis(), timeLeft);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("{} not satisfied, will try again in {} ms ({}ms till timeout)", new Object[]{description, sleepTime, timeLeft});
            }
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException e) {
                return deadline - System.currentTimeMillis();
            }
        }
    }

    static Optional<Transferable> asTransferableBytes(MountableFile file) {
        if (file != null) {
            byte[] data;
            try {
                data = Files.readAllBytes(Path.of(file.getFilesystemPath(), new String[0]));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            return Optional.of(Transferable.of((byte[])data));
        }
        return Optional.empty();
    }

    public static int getFreePort() {
        int n;
        ServerSocket serverSocket = new ServerSocket(0);
        try {
            n = serverSocket.getLocalPort();
        }
        catch (Throwable throwable) {
            try {
                try {
                    serverSocket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to find free port", e);
            }
        }
        serverSocket.close();
        return n;
    }
}

