/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.test.container;

import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.model.ContainerNetwork;
import eu.rekawek.toxiproxy.Proxy;
import eu.rekawek.toxiproxy.ToxiproxyClient;
import io.strimzi.test.container.AuthenticationType;
import io.strimzi.test.container.DoNotMutate;
import io.strimzi.test.container.KafkaContainer;
import io.strimzi.test.container.KafkaVersionService;
import io.strimzi.test.container.UnsupportedKraftKafkaVersionException;
import io.strimzi.test.container.Utils;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.lang.invoke.CallSite;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.ToxiproxyContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.images.builder.Transferable;
import org.testcontainers.utility.MountableFile;

public class StrimziKafkaContainer
extends GenericContainer<StrimziKafkaContainer>
implements KafkaContainer {
    private static final Logger LOGGER = LoggerFactory.getLogger(StrimziKafkaContainer.class);
    public static final String STARTER_SCRIPT = "/testcontainers_start.sh";
    public static final int KAFKA_PORT = 9092;
    protected static final String NETWORK_ALIAS_PREFIX = "broker-";
    protected static final int INTER_BROKER_LISTENER_PORT = 9091;
    private final CompletableFuture<String> imageNameProvider;
    private final boolean enableBrokerContainerSlf4jLogging = Boolean.parseBoolean(System.getenv().getOrDefault("STRIMZI_TEST_CONTAINER_LOGGING_ENABLED", "false"));
    private int kafkaExposedPort;
    private int internalZookeeperExposedPort;
    private Map<String, String> kafkaConfigurationMap;
    private String externalZookeeperConnect;
    private int brokerId;
    private Integer nodeId;
    private String kafkaVersion;
    private boolean useKraft;
    private Function<StrimziKafkaContainer, String> bootstrapServersProvider = c -> String.format("PLAINTEXT://%s:%s", this.getHost(), this.kafkaExposedPort);
    private String clusterId;
    private MountableFile serverPropertiesFile;
    private ToxiproxyContainer proxyContainer;
    private ToxiproxyClient toxiproxyClient;
    private Proxy proxy;
    protected Set<String> listenerNames = new HashSet<String>();
    private boolean oauthEnabled;
    private String realm;
    private String clientId;
    private String clientSecret;
    private String oauthUri;
    private String usernameClaim;
    private String saslUsername;
    private String saslPassword;
    private AuthenticationType authenticationType = AuthenticationType.NONE;

    public StrimziKafkaContainer() {
        this(new CompletableFuture<String>());
    }

    public StrimziKafkaContainer(String dockerImageName) {
        this(CompletableFuture.completedFuture(dockerImageName));
    }

    private StrimziKafkaContainer(CompletableFuture<String> imageName) {
        super(imageName);
        this.imageNameProvider = imageName;
        super.setNetwork(Network.SHARED);
        super.setExposedPorts(Collections.singletonList(9092));
        super.addEnv("LOG_DIR", "/tmp");
    }

    @DoNotMutate
    protected void doStart() {
        if (this.proxyContainer != null && !this.proxyContainer.isRunning()) {
            this.proxyContainer.start();
            if (this.toxiproxyClient == null) {
                this.toxiproxyClient = new ToxiproxyClient(this.proxyContainer.getHost(), this.proxyContainer.getControlPort());
            }
        }
        if (!this.imageNameProvider.isDone()) {
            this.imageNameProvider.complete(KafkaVersionService.strimziTestContainerImageName(this.kafkaVersion));
        }
        try {
            if (this.useKraft && (this.kafkaVersion != null && this.kafkaVersion.startsWith("2.") || this.imageNameProvider.get().contains("2.8.2"))) {
                throw new UnsupportedKraftKafkaVersionException("Specified Kafka version " + this.kafkaVersion + " is not supported in KRaft mode.");
            }
        }
        catch (InterruptedException | ExecutionException e) {
            LOGGER.error("Error occurred during retrieving of image name provider", (Throwable)e);
            throw new RuntimeException(e);
        }
        if (!this.hasKraftOrExternalZooKeeperConfigured()) {
            super.addExposedPort(Integer.valueOf(2181));
        }
        super.withNetworkAliases(new String[]{NETWORK_ALIAS_PREFIX + this.brokerId});
        if (this.isOAuthEnabled()) {
            this.addEnv("OAUTH_JWKS_ENDPOINT_URI", this.oauthUri + "/realms/" + this.realm + "/protocol/openid-connect/certs");
            this.addEnv("OAUTH_VALID_ISSUER_URI", this.oauthUri + "/realms/" + this.realm);
            this.addEnv("OAUTH_CLIENT_ID", this.clientId);
            this.addEnv("OAUTH_CLIENT_SECRET", this.clientSecret);
            this.addEnv("OAUTH_TOKEN_ENDPOINT_URI", this.oauthUri + "/realms/" + this.realm + "/protocol/openid-connect/token");
            this.addEnv("OAUTH_USERNAME_CLAIM", this.usernameClaim);
        }
        if (this.enableBrokerContainerSlf4jLogging) {
            this.withLogConsumer((Consumer)new Slf4jLogConsumer(LoggerFactory.getLogger((String)("StrimziKafkaContainer-" + this.brokerId))));
        }
        super.setCommand(new String[]{"sh", "-c", this.runStarterScript()});
        super.doStart();
    }

    @DoNotMutate
    public void stop() {
        if (this.proxyContainer != null && this.proxyContainer.isRunning()) {
            this.proxyContainer.stop();
        }
        super.stop();
    }

    protected String runStarterScript() {
        return "while [ ! -x /testcontainers_start.sh ]; do sleep 0.1; done; /testcontainers_start.sh";
    }

    @DoNotMutate
    public StrimziKafkaContainer waitForRunning() {
        if (this.useKraft) {
            super.waitingFor((WaitStrategy)Wait.forLogMessage((String)".*Transitioning from RECOVERY to RUNNING.*", (int)1));
        } else {
            super.waitingFor((WaitStrategy)Wait.forLogMessage((String)".*Recorded new.*controller, from now on will use [node|broker].*", (int)1));
        }
        return this;
    }

    @DoNotMutate
    protected void containerIsStarting(InspectContainerResponse containerInfo, boolean reused) {
        super.containerIsStarting(containerInfo, reused);
        this.kafkaExposedPort = this.getMappedPort(9092);
        if (!this.hasKraftOrExternalZooKeeperConfigured()) {
            this.internalZookeeperExposedPort = this.getMappedPort(2181);
        }
        LOGGER.info("Mapped port: {}", (Object)this.kafkaExposedPort);
        if (this.nodeId == null) {
            LOGGER.warn("Node ID is not set. Using broker ID {} as the default node ID.", (Object)this.brokerId);
            this.nodeId = this.brokerId;
        }
        String[] listenersConfig = this.buildListenersConfig(containerInfo);
        Properties defaultServerProperties = this.buildDefaultServerProperties(listenersConfig[0], listenersConfig[1]);
        String serverPropertiesWithOverride = this.overrideProperties(defaultServerProperties, this.kafkaConfigurationMap);
        if (this.useKraft) {
            this.copyFileToContainer(Transferable.of((byte[])serverPropertiesWithOverride.getBytes(StandardCharsets.UTF_8)), "/opt/kafka/config/kraft/server.properties");
        } else {
            this.copyFileToContainer(Transferable.of((byte[])serverPropertiesWithOverride.getBytes(StandardCharsets.UTF_8)), "/opt/kafka/config/server.properties");
        }
        Object command = "#!/bin/bash \n";
        if (!this.useKraft) {
            if (this.externalZookeeperConnect != null) {
                this.withEnv("KAFKA_ZOOKEEPER_CONNECT", this.externalZookeeperConnect);
            } else {
                command = (String)command + "bin/zookeeper-server-start.sh config/zookeeper.properties &\n";
            }
            command = (String)command + "bin/kafka-server-start.sh config/server.properties";
        } else {
            if (this.clusterId == null) {
                this.clusterId = this.randomUuid();
                LOGGER.info("New `cluster.id` has been generated: {}", (Object)this.clusterId);
            }
            command = (String)command + "bin/kafka-storage.sh format -t=\"" + this.clusterId + "\" -c /opt/kafka/config/kraft/server.properties \n";
            command = (String)command + "bin/kafka-server-start.sh /opt/kafka/config/kraft/server.properties \n";
        }
        Utils.asTransferableBytes(this.serverPropertiesFile).ifPresent(properties -> this.copyFileToContainer((Transferable)properties, this.useKraft ? "/opt/kafka/config/kraft/server.properties" : "/opt/kafka/config/server.properties"));
        LOGGER.info("Copying command to 'STARTER_SCRIPT' script.");
        this.copyFileToContainer(Transferable.of((byte[])((String)command).getBytes(StandardCharsets.UTF_8), (int)700), STARTER_SCRIPT);
    }

    @Override
    @DoNotMutate
    public boolean hasKraftOrExternalZooKeeperConfigured() {
        return this.useKraft || this.externalZookeeperConnect != null;
    }

    protected String extractListenerName(String bootstrapServers) {
        String[] strings = bootstrapServers.split(":");
        if (strings.length < 3) {
            throw new IllegalArgumentException("The configured boostrap servers '" + bootstrapServers + "' must be prefixed with a listener name.");
        }
        return strings[0];
    }

    protected String[] buildListenersConfig(InspectContainerResponse containerInfo) {
        String bootstrapServers = this.getBootstrapServers();
        String bsListenerName = this.extractListenerName(bootstrapServers);
        Collection networks = containerInfo.getNetworkSettings().getNetworks().values();
        ArrayList<CallSite> advertisedListenersNames = new ArrayList<CallSite>();
        StringBuilder kafkaListeners = new StringBuilder();
        StringBuilder advertisedListeners = new StringBuilder();
        advertisedListeners.append(bootstrapServers);
        kafkaListeners.append(bsListenerName).append(":").append("//").append("0.0.0.0").append(":").append(9092).append(",");
        this.listenerNames.add(bsListenerName);
        int listenerNumber = 1;
        int portNumber = 9091;
        for (ContainerNetwork containerNetwork : networks) {
            String advertisedName = "BROKER" + listenerNumber;
            advertisedListeners.append(",").append(advertisedName).append("://").append(containerNetwork.getIpAddress()).append(":").append(portNumber);
            advertisedListenersNames.add((CallSite)((Object)advertisedName));
            ++listenerNumber;
            --portNumber;
        }
        portNumber = 9091;
        for (String string : advertisedListenersNames) {
            kafkaListeners.append(string).append("://0.0.0.0:").append(portNumber).append(",");
            this.listenerNames.add(string);
            --portNumber;
        }
        if (this.useKraft) {
            String controllerListenerName = "CONTROLLER";
            int n = 9094;
            kafkaListeners.append("CONTROLLER").append("://0.0.0.0:").append(9094);
            try {
                if (this.kafkaVersion != null && KafkaVersionService.KafkaVersion.compareVersions(this.kafkaVersion, "3.9.0") >= 0 || KafkaVersionService.KafkaVersion.compareVersions(KafkaVersionService.KafkaVersion.extractVersionFromImageName(this.imageNameProvider.get()), "3.9.0") >= 0) {
                    advertisedListeners.append(",").append("CONTROLLER").append("://").append(NETWORK_ALIAS_PREFIX + this.brokerId).append(":").append(9094);
                }
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
            this.listenerNames.add("CONTROLLER");
        }
        LOGGER.info("This is all advertised listeners for Kafka {}", (Object)advertisedListeners);
        return new String[]{kafkaListeners.toString(), advertisedListeners.toString()};
    }

    @DoNotMutate
    private String randomUuid() {
        UUID metadataTopicIdInternal = new UUID(0L, 1L);
        UUID zeroIdImpactInternal = new UUID(0L, 0L);
        UUID uuid = UUID.randomUUID();
        while (uuid.equals(metadataTopicIdInternal) || uuid.equals(zeroIdImpactInternal)) {
            uuid = UUID.randomUUID();
        }
        ByteBuffer uuidBytes = ByteBuffer.wrap(new byte[16]);
        uuidBytes.putLong(uuid.getMostSignificantBits());
        uuidBytes.putLong(uuid.getLeastSignificantBits());
        byte[] uuidBytesArray = uuidBytes.array();
        return Base64.getUrlEncoder().withoutPadding().encodeToString(uuidBytesArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Properties buildDefaultServerProperties(String listeners, String advertisedListeners) {
        Properties properties = new Properties();
        properties.setProperty("listeners", listeners);
        properties.setProperty("inter.broker.listener.name", "BROKER1");
        properties.setProperty("broker.id", String.valueOf(this.brokerId));
        properties.setProperty("advertised.listeners", advertisedListeners);
        properties.setProperty("listener.security.protocol.map", this.configureListenerSecurityProtocolMap("PLAINTEXT"));
        properties.setProperty("num.network.threads", "3");
        properties.setProperty("num.io.threads", "8");
        properties.setProperty("socket.send.buffer.bytes", "102400");
        properties.setProperty("socket.receive.buffer.bytes", "102400");
        properties.setProperty("socket.request.max.bytes", "104857600");
        properties.setProperty("log.dirs", "/tmp/default-log-dir");
        properties.setProperty("num.partitions", "1");
        properties.setProperty("num.recovery.threads.per.data.dir", "1");
        properties.setProperty("offsets.topic.replication.factor", "1");
        properties.setProperty("transaction.state.log.replication.factor", "1");
        properties.setProperty("transaction.state.log.min.isr", "1");
        properties.setProperty("log.retention.hours", "168");
        properties.setProperty("log.retention.check.interval.ms", "300000");
        if (this.useKraft) {
            properties.setProperty("process.roles", "broker,controller");
            properties.setProperty("node.id", String.valueOf(this.nodeId));
            properties.setProperty("controller.quorum.voters", String.format("%d@broker-" + this.nodeId + ":9094", this.nodeId));
            properties.setProperty("controller.listener.names", "CONTROLLER");
            if (this.authenticationType == AuthenticationType.NONE) return properties;
            switch (this.authenticationType) {
                case OAUTH_OVER_PLAIN: {
                    if (!this.isOAuthEnabled()) throw new IllegalStateException("OAuth2 is not enabled: " + this.oauthEnabled);
                    this.configureOAuthOverPlain(properties);
                    return properties;
                }
                case OAUTH_BEARER: {
                    if (!this.isOAuthEnabled()) throw new IllegalStateException("OAuth2 is not enabled: " + this.oauthEnabled);
                    this.configureOAuthBearer(properties);
                    return properties;
                }
                default: {
                    throw new IllegalStateException("Unsupported authentication type: " + String.valueOf((Object)this.authenticationType));
                }
            }
        }
        if (this.externalZookeeperConnect != null) {
            LOGGER.info("Using external ZooKeeper 'zookeeper.connect={}'.", (Object)this.externalZookeeperConnect);
            properties.put("zookeeper.connect", this.externalZookeeperConnect);
            return properties;
        } else {
            LOGGER.info("Using internal ZooKeeper 'zookeeper.connect={}.'", (Object)"localhost:2181");
            properties.put("zookeeper.connect", "localhost:2181");
        }
        return properties;
    }

    protected void configureOAuthOverPlain(Properties properties) {
        properties.setProperty("sasl.enabled.mechanisms", "PLAIN");
        properties.setProperty("sasl.mechanism.inter.broker.protocol", "PLAIN");
        properties.setProperty("listener.security.protocol.map", this.configureListenerSecurityProtocolMap("SASL_PLAINTEXT"));
        properties.setProperty("sasl.mechanism.controller.protocol", "PLAIN");
        properties.setProperty("principal.builder.class", "io.strimzi.kafka.oauth.server.OAuthKafkaPrincipalBuilder");
        String jaasConfig = String.format("org.apache.kafka.common.security.plain.PlainLoginModule required username=\"%s\" password=\"%s\";", this.saslUsername, this.saslPassword);
        String callbackHandler = "io.strimzi.kafka.oauth.server.plain.JaasServerOauthOverPlainValidatorCallbackHandler";
        for (String listenerName : this.listenerNames) {
            properties.setProperty("listener.name." + listenerName.toLowerCase(Locale.ROOT) + ".plain.sasl.jaas.config", jaasConfig);
            properties.setProperty("listener.name." + listenerName.toLowerCase(Locale.ROOT) + ".plain.sasl.server.callback.handler.class", "io.strimzi.kafka.oauth.server.plain.JaasServerOauthOverPlainValidatorCallbackHandler");
        }
    }

    protected void configureOAuthBearer(Properties properties) {
        properties.setProperty("sasl.enabled.mechanisms", "OAUTHBEARER");
        properties.setProperty("sasl.mechanism.inter.broker.protocol", "OAUTHBEARER");
        properties.setProperty("listener.security.protocol.map", this.configureListenerSecurityProtocolMap("SASL_PLAINTEXT"));
        properties.setProperty("sasl.mechanism.controller.protocol", "OAUTHBEARER");
        properties.setProperty("principal.builder.class", "io.strimzi.kafka.oauth.server.OAuthKafkaPrincipalBuilder");
        String jaasConfig = "org.apache.kafka.common.security.oauthbearer.OAuthBearerLoginModule required ;";
        String serverCallbackHandler = "io.strimzi.kafka.oauth.server.JaasServerOauthValidatorCallbackHandler";
        String clientSideCallbackHandler = "io.strimzi.kafka.oauth.client.JaasClientOauthLoginCallbackHandler";
        for (String listenerName : this.listenerNames) {
            properties.setProperty("listener.name." + listenerName.toLowerCase(Locale.ROOT) + ".oauthbearer.sasl.jaas.config", "org.apache.kafka.common.security.oauthbearer.OAuthBearerLoginModule required ;");
            properties.setProperty("listener.name." + listenerName.toLowerCase(Locale.ROOT) + ".oauthbearer.sasl.server.callback.handler.class", "io.strimzi.kafka.oauth.server.JaasServerOauthValidatorCallbackHandler");
            properties.setProperty("listener.name." + listenerName.toLowerCase(Locale.ROOT) + ".oauthbearer.sasl.login.callback.handler.class", "io.strimzi.kafka.oauth.client.JaasClientOauthLoginCallbackHandler");
        }
    }

    protected String configureListenerSecurityProtocolMap(String securityProtocol) {
        return this.listenerNames.stream().map(listenerName -> listenerName + ":" + securityProtocol).collect(Collectors.joining(","));
    }

    protected String overrideProperties(Properties defaultProperties, Map<String, String> overrides) {
        if (overrides != null && !overrides.isEmpty()) {
            overrides.forEach(defaultProperties::setProperty);
        }
        StringWriter writer = new StringWriter();
        try {
            defaultProperties.store(writer, null);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to store Kafka server properties", e);
        }
        return writer.toString();
    }

    @Override
    public String getInternalZooKeeperConnect() {
        if (this.hasKraftOrExternalZooKeeperConfigured()) {
            throw new IllegalStateException("Connect string is not available when using KRaft or external ZooKeeper");
        }
        return this.getHost() + ":" + this.internalZookeeperExposedPort;
    }

    @Override
    @DoNotMutate
    public String getBootstrapServers() {
        if (this.proxyContainer != null) {
            return String.format("PLAINTEXT://%s", this.getProxy().getListen());
        }
        return this.bootstrapServersProvider.apply(this);
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public StrimziKafkaContainer withKafkaConfigurationMap(Map<String, String> kafkaConfigurationMap) {
        this.kafkaConfigurationMap = kafkaConfigurationMap;
        return this;
    }

    public StrimziKafkaContainer withExternalZookeeperConnect(String externalZookeeperConnect) {
        if (this.useKraft) {
            throw new IllegalStateException("Cannot configure an external Zookeeper and use Kraft at the same time");
        }
        this.externalZookeeperConnect = externalZookeeperConnect;
        return (StrimziKafkaContainer)this.self();
    }

    public StrimziKafkaContainer withBrokerId(int brokerId) {
        if (this.useKraft && this.brokerId != this.nodeId) {
            throw new IllegalStateException("`broker.id` and `node.id` must have same value!");
        }
        this.brokerId = brokerId;
        return (StrimziKafkaContainer)this.self();
    }

    public StrimziKafkaContainer withNodeId(int nodeId) {
        this.nodeId = nodeId;
        return (StrimziKafkaContainer)this.self();
    }

    public StrimziKafkaContainer withKafkaVersion(String kafkaVersion) {
        this.kafkaVersion = kafkaVersion;
        return (StrimziKafkaContainer)this.self();
    }

    public StrimziKafkaContainer withKraft() {
        this.useKraft = true;
        return (StrimziKafkaContainer)this.self();
    }

    public StrimziKafkaContainer withPort(int fixedPort) {
        if (fixedPort <= 0) {
            throw new IllegalArgumentException("The fixed Kafka port must be greater than 0");
        }
        this.addFixedExposedPort(fixedPort, 9092);
        return (StrimziKafkaContainer)this.self();
    }

    public StrimziKafkaContainer withServerProperties(MountableFile serverPropertiesFile) {
        this.serverPropertiesFile = serverPropertiesFile;
        return (StrimziKafkaContainer)this.self();
    }

    public StrimziKafkaContainer withBootstrapServers(Function<StrimziKafkaContainer, String> provider) {
        this.bootstrapServersProvider = provider;
        return (StrimziKafkaContainer)this.self();
    }

    public StrimziKafkaContainer withProxyContainer(ToxiproxyContainer proxyContainer) {
        if (proxyContainer != null) {
            this.proxyContainer = proxyContainer;
            proxyContainer.setNetwork(Network.SHARED);
            proxyContainer.setNetworkAliases(Collections.singletonList("toxiproxy"));
        }
        return (StrimziKafkaContainer)this.self();
    }

    public StrimziKafkaContainer withOAuthConfig(String realm, String clientId, String clientSecret, String oauthUri, String usernameClaim) {
        this.oauthEnabled = true;
        this.realm = realm;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.oauthUri = oauthUri;
        this.usernameClaim = usernameClaim;
        return (StrimziKafkaContainer)this.self();
    }

    public StrimziKafkaContainer withAuthenticationType(AuthenticationType authType) {
        if (authType != null) {
            this.authenticationType = authType;
        }
        return (StrimziKafkaContainer)this.self();
    }

    public StrimziKafkaContainer withSaslUsername(String saslUsername) {
        if (saslUsername == null || saslUsername.trim().isEmpty()) {
            throw new IllegalArgumentException("SASL username cannot be null or empty.");
        }
        this.saslUsername = saslUsername;
        return (StrimziKafkaContainer)this.self();
    }

    public StrimziKafkaContainer withSaslPassword(String saslPassword) {
        if (saslPassword == null || saslPassword.trim().isEmpty()) {
            throw new IllegalArgumentException("SASL password cannot be null or empty.");
        }
        this.saslPassword = saslPassword;
        return (StrimziKafkaContainer)this.self();
    }

    protected StrimziKafkaContainer withClusterId(String clusterId) {
        this.clusterId = clusterId;
        return (StrimziKafkaContainer)this.self();
    }

    public StrimziKafkaContainer withKafkaLog(Level level) {
        String log4jConfig = "log4j.rootLogger=" + level.name() + ", stdout\nlog4j.appender.stdout=org.apache.log4j.ConsoleAppender\nlog4j.appender.stdout.layout=org.apache.log4j.PatternLayout\nlog4j.appender.stdout.layout.ConversionPattern=[%d] %p %m (%c)%n\n";
        this.withCopyToContainer(Transferable.of((byte[])log4jConfig.getBytes(StandardCharsets.UTF_8)), "/opt/kafka/config/log4j.properties");
        return (StrimziKafkaContainer)this.self();
    }

    public synchronized Proxy getProxy() {
        if (this.proxyContainer == null) {
            throw new IllegalStateException("The proxy container has not been configured");
        }
        if (this.proxy == null) {
            if (this.toxiproxyClient == null) {
                this.toxiproxyClient = new ToxiproxyClient(this.proxyContainer.getHost(), this.proxyContainer.getControlPort());
            }
            try {
                int listenPort = 8666 + this.brokerId;
                this.proxy = this.toxiproxyClient.createProxy("kafka" + this.brokerId, "0.0.0.0:" + listenPort, "toxiproxy:" + Utils.getFreePort());
            }
            catch (IOException e) {
                LOGGER.error("Error happened during creation of the Proxy: {}", (Object)e.getMessage());
                throw new RuntimeException(e);
            }
        }
        return this.proxy;
    }

    String getKafkaVersion() {
        return this.kafkaVersion;
    }

    int getBrokerId() {
        return this.brokerId;
    }

    public boolean isOAuthEnabled() {
        return this.oauthEnabled;
    }

    public String getSaslUsername() {
        return this.saslUsername;
    }

    public String getSaslPassword() {
        return this.saslPassword;
    }

    public String getRealm() {
        return this.realm;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getOauthUri() {
        return this.oauthUri;
    }

    public String getUsernameClaim() {
        return this.usernameClaim;
    }

    public AuthenticationType getAuthenticationType() {
        return this.authenticationType;
    }
}

