/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.test.container;

import com.github.dockerjava.api.command.InspectContainerResponse;
import com.groupcdg.pitest.annotations.DoNotMutate;
import io.strimzi.test.container.StrimziKafkaCluster;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.images.builder.Transferable;

class StrimziConnectContainer
extends GenericContainer<StrimziConnectContainer> {
    private static final String STARTER_SCRIPT = "/start_connect.sh";
    private static final String CONFIG_FILE = "/opt/kafka/config/connect.properties";
    private final StrimziKafkaCluster kafkaCluster;
    private final Properties configs;

    public StrimziConnectContainer(String imageName, StrimziKafkaCluster kafkaCluster, Properties configs) {
        super(imageName);
        this.kafkaCluster = kafkaCluster;
        this.configs = configs;
    }

    @DoNotMutate
    protected void doStart() {
        super.setNetwork(this.kafkaCluster.getNetwork());
        super.setCommand(new String[]{"sh", "-c", "while [ ! -x /start_connect.sh ]; do sleep 0.1; done; /start_connect.sh"});
        super.doStart();
    }

    @DoNotMutate
    protected void containerIsStarting(InspectContainerResponse containerInfo, boolean reused) {
        super.containerIsStarting(containerInfo, reused);
        StringWriter writer = new StringWriter();
        try {
            this.configs.store(writer, null);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to build configuration file", e);
        }
        this.copyFileToContainer(Transferable.of((byte[])writer.toString().getBytes(StandardCharsets.UTF_8)), CONFIG_FILE);
        String command = "/opt/kafka/bin/connect-distributed.sh /opt/kafka/config/connect.properties";
        this.copyFileToContainer(Transferable.of((byte[])"/opt/kafka/bin/connect-distributed.sh /opt/kafka/config/connect.properties".getBytes(StandardCharsets.UTF_8), (int)700), STARTER_SCRIPT);
    }

    @DoNotMutate
    public StrimziConnectContainer waitForRunning() {
        super.waitingFor((WaitStrategy)Wait.forLogMessage((String)".*Finished starting connectors and tasks.*", (int)1));
        return this;
    }

    Properties getConfigs() {
        return this.configs;
    }
}

