/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.test.container;

import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.model.ContainerNetwork;
import eu.rekawek.toxiproxy.Proxy;
import eu.rekawek.toxiproxy.ToxiproxyClient;
import io.strimzi.test.container.AuthenticationType;
import io.strimzi.test.container.DoNotMutate;
import io.strimzi.test.container.KafkaContainer;
import io.strimzi.test.container.KafkaNodeRole;
import io.strimzi.test.container.KafkaVersionService;
import io.strimzi.test.container.Utils;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.lang.invoke.CallSite;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.ToxiproxyContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.images.builder.Transferable;
import org.testcontainers.utility.MountableFile;

@Deprecated
public class StrimziKafkaContainer
extends GenericContainer<StrimziKafkaContainer>
implements KafkaContainer {
    private static final Logger LOGGER = LoggerFactory.getLogger(StrimziKafkaContainer.class);
    public static final String STARTER_SCRIPT = "/testcontainers_start.sh";
    public static final int KAFKA_PORT = 9092;
    public static final int CONTROLLER_PORT = 9094;
    protected static final String NETWORK_ALIAS_PREFIX = "broker-";
    protected static final int INTER_BROKER_LISTENER_PORT = 9091;
    private final CompletableFuture<String> imageNameProvider;
    private final boolean enableBrokerContainerSlf4jLogging = Boolean.parseBoolean(System.getenv().getOrDefault("STRIMZI_TEST_CONTAINER_LOGGING_ENABLED", "false"));
    private int kafkaExposedPort;
    private int controllerExposedPort;
    private Map<String, String> kafkaConfigurationMap;
    private int brokerId;
    private Integer nodeId;
    private String kafkaVersion;
    private Function<StrimziKafkaContainer, String> bootstrapServersProvider = c -> String.format("PLAINTEXT://%s:%s", this.getHost(), this.kafkaExposedPort);
    private String clusterId;
    private MountableFile serverPropertiesFile;
    private KafkaNodeRole nodeRole = KafkaNodeRole.COMBINED;
    private ToxiproxyContainer proxyContainer;
    private ToxiproxyClient toxiproxyClient;
    private Proxy proxy;
    protected Set<String> listenerNames = new HashSet<String>();
    private boolean oauthEnabled;
    private String realm;
    private String clientId;
    private String clientSecret;
    private String oauthUri;
    private String usernameClaim;
    private String saslUsername;
    private String saslPassword;
    private AuthenticationType authenticationType = AuthenticationType.NONE;
    private String logFilePath;

    public StrimziKafkaContainer() {
        this(new CompletableFuture<String>());
    }

    public StrimziKafkaContainer(String dockerImageName) {
        this(CompletableFuture.completedFuture(dockerImageName));
    }

    private StrimziKafkaContainer(CompletableFuture<String> imageName) {
        super(imageName);
        this.imageNameProvider = imageName;
        super.setNetwork(Network.SHARED);
        super.addEnv("LOG_DIR", "/tmp");
    }

    @DoNotMutate
    protected void doStart() {
        if (this.proxyContainer != null && !this.proxyContainer.isRunning()) {
            this.proxyContainer.start();
            if (this.toxiproxyClient == null) {
                this.toxiproxyClient = new ToxiproxyClient(this.proxyContainer.getHost(), this.proxyContainer.getControlPort());
            }
        }
        if (!this.imageNameProvider.isDone()) {
            this.imageNameProvider.complete(KafkaVersionService.strimziTestContainerImageName(this.kafkaVersion));
        }
        super.setExposedPorts(this.determineExposedPorts());
        super.withNetworkAliases(new String[]{NETWORK_ALIAS_PREFIX + this.brokerId});
        this.setupOAuthConfiguration();
        if (this.enableBrokerContainerSlf4jLogging) {
            this.withLogConsumer((Consumer)new Slf4jLogConsumer(LoggerFactory.getLogger((String)("StrimziKafkaContainer-" + this.brokerId))));
        }
        super.setCommand(new String[]{"sh", "-c", this.runStarterScript()});
        super.doStart();
    }

    @DoNotMutate
    private List<Integer> determineExposedPorts() {
        ArrayList<Integer> portsToExpose = new ArrayList<Integer>();
        if (this.nodeRole == KafkaNodeRole.CONTROLLER) {
            portsToExpose.add(9094);
        } else if (this.nodeRole == KafkaNodeRole.BROKER) {
            portsToExpose.add(9092);
        } else {
            portsToExpose.add(9092);
            portsToExpose.add(9094);
        }
        portsToExpose.addAll(super.getExposedPorts());
        return portsToExpose;
    }

    @DoNotMutate
    private void setupOAuthConfiguration() {
        if (this.isOAuthEnabled()) {
            this.addEnv("OAUTH_JWKS_ENDPOINT_URI", this.oauthUri + "/realms/" + this.realm + "/protocol/openid-connect/certs");
            this.addEnv("OAUTH_VALID_ISSUER_URI", this.oauthUri + "/realms/" + this.realm);
            this.addEnv("OAUTH_CLIENT_ID", this.clientId);
            this.addEnv("OAUTH_CLIENT_SECRET", this.clientSecret);
            this.addEnv("OAUTH_TOKEN_ENDPOINT_URI", this.oauthUri + "/realms/" + this.realm + "/protocol/openid-connect/token");
            this.addEnv("OAUTH_USERNAME_CLAIM", this.usernameClaim);
        }
    }

    @DoNotMutate
    public void stop() {
        if (this.logFilePath != null) {
            this.collectLogs();
        }
        if (this.proxyContainer != null && this.proxyContainer.isRunning()) {
            this.proxyContainer.stop();
        }
        super.stop();
    }

    @DoNotMutate
    private void collectLogs() {
        try {
            Object finalLogPath = this.logFilePath;
            if (this.logFilePath.endsWith("/")) {
                String fileName;
                switch (this.nodeRole) {
                    case CONTROLLER: {
                        fileName = "kafka-controller-" + this.nodeId + ".log";
                        break;
                    }
                    case BROKER: {
                        fileName = "kafka-broker-" + this.brokerId + ".log";
                        break;
                    }
                    default: {
                        fileName = "kafka-container-" + this.brokerId + ".log";
                    }
                }
                finalLogPath = this.logFilePath + fileName;
            }
            LOGGER.info("Collecting logs to file: {}", finalLogPath);
            String logs = this.getLogs();
            Path logPath = Paths.get((String)finalLogPath, new String[0]);
            if (logPath.getParent() != null) {
                Files.createDirectories(logPath.getParent(), new FileAttribute[0]);
            }
            this.writeDataToFile((String)finalLogPath, logs);
            LOGGER.info("Successfully collected logs to: {}", (Object)logPath.toAbsolutePath());
        }
        catch (IOException e) {
            LOGGER.error("Failed to collect logs to file: {}", (Object)this.logFilePath, (Object)e);
            throw new RuntimeException("Failed to collect logs to file: " + this.logFilePath, e);
        }
    }

    @DoNotMutate
    private void writeDataToFile(String fullFilePath, String data) {
        if (data != null && !data.isEmpty()) {
            try {
                Files.writeString(Paths.get(fullFilePath, new String[0]), (CharSequence)data, StandardCharsets.UTF_8, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("Failed to write to the %s file due to: %s", fullFilePath, e.getMessage()));
            }
        }
    }

    protected String runStarterScript() {
        return "while [ ! -x /testcontainers_start.sh ]; do sleep 0.1; done; /testcontainers_start.sh";
    }

    @DoNotMutate
    public StrimziKafkaContainer waitForRunning() {
        if (this.nodeRole == KafkaNodeRole.CONTROLLER) {
            super.waitingFor((WaitStrategy)Wait.forLogMessage((String)".*Kafka Server started.*", (int)1));
        } else {
            super.waitingFor((WaitStrategy)Wait.forLogMessage((String)".*Transitioning from RECOVERY to RUNNING.*", (int)1));
        }
        return this;
    }

    @DoNotMutate
    protected void containerIsStarting(InspectContainerResponse containerInfo, boolean reused) {
        super.containerIsStarting(containerInfo, reused);
        if (this.nodeRole.isBroker()) {
            this.kafkaExposedPort = this.getMappedPort(9092);
            LOGGER.info("Mapped Kafka port: {}", (Object)this.kafkaExposedPort);
        }
        if (this.nodeRole.isController()) {
            this.controllerExposedPort = this.getMappedPort(9094);
            LOGGER.info("Mapped controller port: {}", (Object)this.controllerExposedPort);
        }
        if (this.nodeId == null) {
            LOGGER.warn("Node ID is not set. Using broker ID {} as the default node ID.", (Object)this.brokerId);
            this.nodeId = this.brokerId;
        }
        if (this.brokerId != this.nodeId) {
            throw new IllegalStateException("`broker.id` and `node.id` must have the same value!");
        }
        String[] listenersConfig = this.buildListenersConfig(containerInfo);
        Properties defaultServerProperties = this.buildDefaultServerProperties(listenersConfig[0], listenersConfig[1]);
        String serverPropertiesWithOverride = this.overrideProperties(defaultServerProperties, this.kafkaConfigurationMap);
        this.copyFileToContainer(Transferable.of((byte[])serverPropertiesWithOverride.getBytes(StandardCharsets.UTF_8)), "/opt/kafka/config/kraft/server.properties");
        Object command = "#!/bin/bash \n";
        if (this.clusterId == null) {
            this.clusterId = this.randomUuid();
            LOGGER.info("New `cluster.id` has been generated: {}", (Object)this.clusterId);
        }
        command = (String)command + "bin/kafka-storage.sh format -t=\"" + this.clusterId + "\" -c /opt/kafka/config/kraft/server.properties \n";
        command = (String)command + "bin/kafka-server-start.sh /opt/kafka/config/kraft/server.properties \n";
        Utils.asTransferableBytes(this.serverPropertiesFile).ifPresent(properties -> this.copyFileToContainer((Transferable)properties, "/opt/kafka/config/kraft/server.properties"));
        LOGGER.info("Copying command to 'STARTER_SCRIPT' script.");
        this.copyFileToContainer(Transferable.of((byte[])((String)command).getBytes(StandardCharsets.UTF_8), (int)700), STARTER_SCRIPT);
    }

    protected String extractListenerName(String bootstrapServers) {
        String[] strings = bootstrapServers.split(":");
        if (strings.length < 3) {
            throw new IllegalArgumentException("The configured boostrap servers '" + bootstrapServers + "' must be prefixed with a listener name.");
        }
        return strings[0];
    }

    protected String[] buildListenersConfig(InspectContainerResponse containerInfo) {
        Collection networks = containerInfo.getNetworkSettings().getNetworks().values();
        ArrayList<CallSite> advertisedListenersNames = new ArrayList<CallSite>();
        StringBuilder kafkaListeners = new StringBuilder();
        StringBuilder advertisedListeners = new StringBuilder();
        String bsListenerName = null;
        String bootstrapServers = null;
        if (this.nodeRole.isBroker()) {
            bootstrapServers = this.getBootstrapServers();
            bsListenerName = this.extractListenerName(bootstrapServers);
        }
        if (this.nodeRole.isBroker() && bsListenerName != null) {
            advertisedListeners.append(bootstrapServers);
            kafkaListeners.append(bsListenerName).append(":").append("//").append("0.0.0.0").append(":").append(9092).append(",");
            this.listenerNames.add(bsListenerName);
        }
        int listenerNumber = 1;
        int portNumber = 9091;
        if (this.nodeRole.isBroker()) {
            for (ContainerNetwork containerNetwork : networks) {
                String advertisedName = "BROKER" + listenerNumber;
                advertisedListeners.append(",").append(advertisedName).append("://").append(containerNetwork.getIpAddress()).append(":").append(portNumber);
                advertisedListenersNames.add((CallSite)((Object)advertisedName));
                ++listenerNumber;
                --portNumber;
            }
        }
        portNumber = 9091;
        if (this.nodeRole.isBroker()) {
            for (String string : advertisedListenersNames) {
                kafkaListeners.append(string).append("://0.0.0.0:").append(portNumber).append(",");
                this.listenerNames.add(string);
                --portNumber;
            }
        }
        if (this.nodeRole.isController()) {
            advertisedListeners.append(",");
            advertisedListeners.append(this.getBootstrapControllers());
            String controllerListenerName = "CONTROLLER";
            kafkaListeners.append("CONTROLLER").append("://0.0.0.0:").append(9094);
            this.listenerNames.add("CONTROLLER");
        }
        LOGGER.info("This is all advertised listeners for Kafka {}", (Object)advertisedListeners);
        return new String[]{kafkaListeners.toString(), advertisedListeners.toString()};
    }

    @DoNotMutate
    private String randomUuid() {
        UUID metadataTopicIdInternal = new UUID(0L, 1L);
        UUID zeroIdImpactInternal = new UUID(0L, 0L);
        UUID uuid = UUID.randomUUID();
        while (uuid.equals(metadataTopicIdInternal) || uuid.equals(zeroIdImpactInternal)) {
            uuid = UUID.randomUUID();
        }
        ByteBuffer uuidBytes = ByteBuffer.wrap(new byte[16]);
        uuidBytes.putLong(uuid.getMostSignificantBits());
        uuidBytes.putLong(uuid.getLeastSignificantBits());
        byte[] uuidBytesArray = uuidBytes.array();
        return Base64.getUrlEncoder().withoutPadding().encodeToString(uuidBytesArray);
    }

    protected Properties buildDefaultServerProperties(String listeners, String advertisedListeners) {
        Properties properties = new Properties();
        properties.setProperty("listeners", listeners);
        if (this.nodeRole.isBroker()) {
            properties.setProperty("inter.broker.listener.name", "BROKER1");
            properties.setProperty("advertised.listeners", advertisedListeners);
        } else {
            this.extractControllerListener(properties, advertisedListeners);
        }
        String securityProtocolMap = this.configureListenerSecurityProtocolMap("PLAINTEXT");
        securityProtocolMap = this.ensureControllerMapping(securityProtocolMap, "PLAINTEXT");
        properties.setProperty("listener.security.protocol.map", securityProtocolMap);
        this.setCommonServerProperties(properties);
        this.setKRaftProperties(properties);
        this.configureAuthentication(properties);
        return properties;
    }

    void extractControllerListener(Properties properties, String advertisedListeners) {
        if (advertisedListeners != null && advertisedListeners.contains("CONTROLLER://")) {
            String[] parts;
            for (String part : parts = advertisedListeners.split(",")) {
                if (!part.trim().startsWith("CONTROLLER://")) continue;
                properties.setProperty("advertised.listeners", part.trim());
                break;
            }
        }
    }

    private void setCommonServerProperties(Properties properties) {
        properties.setProperty("num.network.threads", "3");
        properties.setProperty("num.io.threads", "8");
        properties.setProperty("socket.send.buffer.bytes", "102400");
        properties.setProperty("socket.receive.buffer.bytes", "102400");
        properties.setProperty("socket.request.max.bytes", "104857600");
        properties.setProperty("log.dirs", "/tmp/default-log-dir");
        properties.setProperty("num.partitions", "1");
        properties.setProperty("num.recovery.threads.per.data.dir", "1");
        properties.setProperty("offsets.topic.replication.factor", "1");
        properties.setProperty("transaction.state.log.replication.factor", "1");
        properties.setProperty("transaction.state.log.min.isr", "1");
        properties.setProperty("log.retention.hours", "168");
        properties.setProperty("log.retention.check.interval.ms", "300000");
    }

    private void setKRaftProperties(Properties properties) {
        properties.setProperty("process.roles", this.nodeRole.getProcessRoles());
        properties.setProperty("node.id", String.valueOf(this.nodeId));
        properties.setProperty("controller.listener.names", "CONTROLLER");
        if (!(this.kafkaConfigurationMap != null && this.kafkaConfigurationMap.containsKey("controller.quorum.voters") || this.nodeRole != KafkaNodeRole.COMBINED)) {
            properties.setProperty("controller.quorum.voters", String.format("%d@%s%d:%d", this.nodeId, NETWORK_ALIAS_PREFIX, this.brokerId, 9094));
        }
        if (this.nodeRole.isBroker()) {
            properties.setProperty("broker.id", String.valueOf(this.nodeId));
        }
    }

    private void configureAuthentication(Properties properties) {
        if (this.authenticationType != AuthenticationType.NONE) {
            switch (this.authenticationType) {
                case OAUTH_OVER_PLAIN: {
                    this.validateOAuthAndConfigure(properties, this::configureOAuthOverPlain);
                    break;
                }
                case OAUTH_BEARER: {
                    this.validateOAuthAndConfigure(properties, this::configureOAuthBearer);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported authentication type: " + String.valueOf((Object)this.authenticationType));
                }
            }
        }
    }

    private void validateOAuthAndConfigure(Properties properties, Consumer<Properties> configurer) {
        if (!this.isOAuthEnabled()) {
            throw new IllegalStateException("OAuth2 is not enabled: " + this.oauthEnabled);
        }
        configurer.accept(properties);
    }

    protected void configureOAuthOverPlain(Properties properties) {
        properties.setProperty("sasl.enabled.mechanisms", "PLAIN");
        properties.setProperty("sasl.mechanism.inter.broker.protocol", "PLAIN");
        String securityProtocolMap = this.configureListenerSecurityProtocolMap("SASL_PLAINTEXT");
        securityProtocolMap = this.ensureControllerMapping(securityProtocolMap, "SASL_PLAINTEXT");
        properties.setProperty("listener.security.protocol.map", securityProtocolMap);
        properties.setProperty("sasl.mechanism.controller.protocol", "PLAIN");
        properties.setProperty("principal.builder.class", "io.strimzi.kafka.oauth.server.OAuthKafkaPrincipalBuilder");
        String jaasConfig = String.format("org.apache.kafka.common.security.plain.PlainLoginModule required username=\"%s\" password=\"%s\";", this.saslUsername, this.saslPassword);
        String callbackHandler = "io.strimzi.kafka.oauth.server.plain.JaasServerOauthOverPlainValidatorCallbackHandler";
        for (String listenerName : this.listenerNames) {
            properties.setProperty("listener.name." + listenerName.toLowerCase(Locale.ROOT) + ".plain.sasl.jaas.config", jaasConfig);
            properties.setProperty("listener.name." + listenerName.toLowerCase(Locale.ROOT) + ".plain.sasl.server.callback.handler.class", "io.strimzi.kafka.oauth.server.plain.JaasServerOauthOverPlainValidatorCallbackHandler");
        }
    }

    protected void configureOAuthBearer(Properties properties) {
        properties.setProperty("sasl.enabled.mechanisms", "OAUTHBEARER");
        properties.setProperty("sasl.mechanism.inter.broker.protocol", "OAUTHBEARER");
        String securityProtocolMap = this.configureListenerSecurityProtocolMap("SASL_PLAINTEXT");
        securityProtocolMap = this.ensureControllerMapping(securityProtocolMap, "SASL_PLAINTEXT");
        properties.setProperty("listener.security.protocol.map", securityProtocolMap);
        properties.setProperty("sasl.mechanism.controller.protocol", "OAUTHBEARER");
        properties.setProperty("principal.builder.class", "io.strimzi.kafka.oauth.server.OAuthKafkaPrincipalBuilder");
        String jaasConfig = "org.apache.kafka.common.security.oauthbearer.OAuthBearerLoginModule required ;";
        String serverCallbackHandler = "io.strimzi.kafka.oauth.server.JaasServerOauthValidatorCallbackHandler";
        String clientSideCallbackHandler = "io.strimzi.kafka.oauth.client.JaasClientOauthLoginCallbackHandler";
        for (String listenerName : this.listenerNames) {
            properties.setProperty("listener.name." + listenerName.toLowerCase(Locale.ROOT) + ".oauthbearer.sasl.jaas.config", "org.apache.kafka.common.security.oauthbearer.OAuthBearerLoginModule required ;");
            properties.setProperty("listener.name." + listenerName.toLowerCase(Locale.ROOT) + ".oauthbearer.sasl.server.callback.handler.class", "io.strimzi.kafka.oauth.server.JaasServerOauthValidatorCallbackHandler");
            properties.setProperty("listener.name." + listenerName.toLowerCase(Locale.ROOT) + ".oauthbearer.sasl.login.callback.handler.class", "io.strimzi.kafka.oauth.client.JaasClientOauthLoginCallbackHandler");
        }
    }

    protected String configureListenerSecurityProtocolMap(String securityProtocol) {
        return this.listenerNames.stream().map(listenerName -> listenerName + ":" + securityProtocol).collect(Collectors.joining(","));
    }

    private String ensureControllerMapping(String securityProtocolMap, String controllerProtocol) {
        String securityProtocolMapWithControllerMapping;
        String string = securityProtocolMapWithControllerMapping = securityProtocolMap == null ? "" : securityProtocolMap.trim();
        if (securityProtocolMapWithControllerMapping.contains("CONTROLLER:")) {
            return securityProtocolMapWithControllerMapping;
        }
        return securityProtocolMapWithControllerMapping.isEmpty() ? "CONTROLLER:" + controllerProtocol : securityProtocolMapWithControllerMapping + ",CONTROLLER:" + controllerProtocol;
    }

    protected String overrideProperties(Properties defaultProperties, Map<String, String> overrides) {
        if (overrides != null && !overrides.isEmpty()) {
            overrides.forEach(defaultProperties::setProperty);
        }
        StringWriter writer = new StringWriter();
        try {
            defaultProperties.store(writer, null);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to store Kafka server properties", e);
        }
        return writer.toString();
    }

    @Override
    @DoNotMutate
    public String getBootstrapServers() {
        if (this.nodeRole == KafkaNodeRole.CONTROLLER) {
            throw new UnsupportedOperationException("Controller-only nodes do not provide bootstrap servers. Use broker or combined-role nodes for client connections.");
        }
        if (this.proxyContainer != null) {
            return String.format("PLAINTEXT://%s", this.getProxy().getListen());
        }
        return this.bootstrapServersProvider.apply(this);
    }

    public String getNetworkBootstrapServers() {
        if (this.nodeRole == KafkaNodeRole.CONTROLLER) {
            throw new UnsupportedOperationException("Controller-only nodes do not provide bootstrap servers. Use broker or combined-role nodes for client connections.");
        }
        return NETWORK_ALIAS_PREFIX + this.brokerId + ":9091";
    }

    @Override
    @DoNotMutate
    public String getBootstrapControllers() {
        if (!this.nodeRole.isController()) {
            throw new UnsupportedOperationException("Broker-only nodes do not provide controller endpoints. Use controller or combined-role nodes for controller connections.");
        }
        return String.format("CONTROLLER://%s:%d", this.getHost(), this.controllerExposedPort);
    }

    public String getNetworkBootstrapControllers() {
        if (!this.nodeRole.isController()) {
            throw new UnsupportedOperationException("Broker-only nodes do not provide controller endpoints. Use controller or combined-role nodes for controller connections.");
        }
        return NETWORK_ALIAS_PREFIX + this.brokerId + ":9094";
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public StrimziKafkaContainer withKafkaConfigurationMap(Map<String, String> kafkaConfigurationMap) {
        this.kafkaConfigurationMap = kafkaConfigurationMap;
        return this;
    }

    public StrimziKafkaContainer withBrokerId(int brokerId) {
        this.brokerId = brokerId;
        return (StrimziKafkaContainer)this.self();
    }

    public StrimziKafkaContainer withNodeId(int nodeId) {
        this.nodeId = nodeId;
        return (StrimziKafkaContainer)this.self();
    }

    public StrimziKafkaContainer withKafkaVersion(String kafkaVersion) {
        this.kafkaVersion = kafkaVersion;
        return (StrimziKafkaContainer)this.self();
    }

    public StrimziKafkaContainer withPort(int fixedPort) {
        if (fixedPort <= 0) {
            throw new IllegalArgumentException("The fixed Kafka port must be greater than 0");
        }
        this.addFixedExposedPort(fixedPort, 9092);
        return (StrimziKafkaContainer)this.self();
    }

    public StrimziKafkaContainer withServerProperties(MountableFile serverPropertiesFile) {
        this.serverPropertiesFile = serverPropertiesFile;
        return (StrimziKafkaContainer)this.self();
    }

    public StrimziKafkaContainer withBootstrapServers(Function<StrimziKafkaContainer, String> provider) {
        this.bootstrapServersProvider = provider;
        return (StrimziKafkaContainer)this.self();
    }

    public StrimziKafkaContainer withProxyContainer(ToxiproxyContainer proxyContainer) {
        if (proxyContainer != null) {
            this.proxyContainer = proxyContainer;
            proxyContainer.setNetworkAliases(List.of("toxiproxy"));
        }
        return (StrimziKafkaContainer)this.self();
    }

    public StrimziKafkaContainer withOAuthConfig(String realm, String clientId, String clientSecret, String oauthUri, String usernameClaim) {
        this.oauthEnabled = true;
        this.realm = realm;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.oauthUri = oauthUri;
        this.usernameClaim = usernameClaim;
        return (StrimziKafkaContainer)this.self();
    }

    public StrimziKafkaContainer withAuthenticationType(AuthenticationType authType) {
        if (authType != null) {
            this.authenticationType = authType;
        }
        return (StrimziKafkaContainer)this.self();
    }

    public StrimziKafkaContainer withSaslUsername(String saslUsername) {
        if (saslUsername == null || saslUsername.trim().isEmpty()) {
            throw new IllegalArgumentException("SASL username cannot be null or empty.");
        }
        this.saslUsername = saslUsername;
        return (StrimziKafkaContainer)this.self();
    }

    public StrimziKafkaContainer withSaslPassword(String saslPassword) {
        if (saslPassword == null || saslPassword.trim().isEmpty()) {
            throw new IllegalArgumentException("SASL password cannot be null or empty.");
        }
        this.saslPassword = saslPassword;
        return (StrimziKafkaContainer)this.self();
    }

    protected StrimziKafkaContainer withClusterId(String clusterId) {
        this.clusterId = clusterId;
        return (StrimziKafkaContainer)this.self();
    }

    public StrimziKafkaContainer withNodeRole(KafkaNodeRole nodeRole) {
        this.nodeRole = nodeRole;
        return (StrimziKafkaContainer)this.self();
    }

    public StrimziKafkaContainer withKafkaLog(Level level) {
        String log4j2Yaml = "Configuration:\n  Properties:\n    Property:\n      - name: logPattern\n        value: \"[%d] %p %m (%c)%n\"\n  Appenders:\n    Console:\n      name: STDOUT\n      PatternLayout:\n        pattern: \"${logPattern}\"\n  Loggers:\n    Root:\n      level: " + level.name() + "\n      AppenderRef:\n        - ref: STDOUT\n    Logger:\n      - name: io.strimzi\n        level: " + level.name() + "\n";
        this.withCopyToContainer(Transferable.of((byte[])log4j2Yaml.getBytes(StandardCharsets.UTF_8)), "/opt/kafka/config/log4j2.yaml");
        return (StrimziKafkaContainer)this.self();
    }

    public StrimziKafkaContainer withLogCollection() {
        this.logFilePath = "target/strimzi-test-container-logs/";
        return (StrimziKafkaContainer)this.self();
    }

    public StrimziKafkaContainer withLogCollection(String logFilePath) {
        if (logFilePath == null || logFilePath.trim().isEmpty()) {
            throw new IllegalArgumentException("Log file path cannot be null or empty.");
        }
        this.logFilePath = logFilePath.trim();
        return (StrimziKafkaContainer)this.self();
    }

    public synchronized Proxy getProxy() {
        if (this.proxyContainer == null) {
            throw new IllegalStateException("The proxy container has not been configured");
        }
        if (this.proxy == null) {
            if (this.toxiproxyClient == null) {
                this.toxiproxyClient = new ToxiproxyClient(this.proxyContainer.getHost(), this.proxyContainer.getControlPort());
            }
            try {
                int listenPort = 8666 + this.brokerId;
                this.proxy = this.toxiproxyClient.createProxy("kafka" + this.brokerId, "0.0.0.0:" + listenPort, "toxiproxy:" + Utils.getFreePort());
            }
            catch (IOException e) {
                LOGGER.error("Error happened during creation of the Proxy: {}", (Object)e.getMessage());
                throw new RuntimeException(e);
            }
        }
        return this.proxy;
    }

    String getKafkaVersion() {
        return this.kafkaVersion;
    }

    int getBrokerId() {
        return this.brokerId;
    }

    Map<String, String> getKafkaConfigurationMap() {
        return this.kafkaConfigurationMap;
    }

    public boolean isOAuthEnabled() {
        return this.oauthEnabled;
    }

    public String getSaslUsername() {
        return this.saslUsername;
    }

    public String getSaslPassword() {
        return this.saslPassword;
    }

    public String getRealm() {
        return this.realm;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getOauthUri() {
        return this.oauthUri;
    }

    public String getUsernameClaim() {
        return this.usernameClaim;
    }

    public AuthenticationType getAuthenticationType() {
        return this.authenticationType;
    }

    public KafkaNodeRole getNodeRole() {
        return this.nodeRole;
    }
}

