/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi;

import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.model.ContainerNetwork;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.images.builder.Transferable;

public class StrimziKafkaContainer
extends GenericContainer<StrimziKafkaContainer> {
    private static final Logger LOGGER = LogManager.getLogger(StrimziKafkaContainer.class);
    private static final String STARTER_SCRIPT = "/testcontainers_start.sh";
    private static final int KAFKA_PORT = 9092;
    private static final int ZOOKEEPER_PORT = 2181;
    private static final String LATEST_KAFKA_VERSION;
    private static final List<String> SUPPORTED_KAFKA_VERSIONS;
    private static final String STRIMZI_VERSION;
    private int kafkaExposedPort;

    public StrimziKafkaContainer(String version) {
        super("quay.io/strimzi/kafka:" + version);
        super.withNetwork(Network.SHARED);
        this.withExposedPorts(new Integer[]{9092});
        this.withEnv("LOG_DIR", "/tmp");
    }

    public StrimziKafkaContainer() {
        this(STRIMZI_VERSION + "-kafka-" + LATEST_KAFKA_VERSION);
    }

    protected void doStart() {
        this.withCommand(new String[]{"sh", "-c", "while [ ! -f /testcontainers_start.sh ]; do sleep 0.1; done; /testcontainers_start.sh"});
        super.doStart();
    }

    protected void containerIsStarting(InspectContainerResponse containerInfo, boolean reused) {
        super.containerIsStarting(containerInfo, reused);
        this.kafkaExposedPort = this.getMappedPort(9092);
        LOGGER.info("This is mapped port {}", (Object)this.kafkaExposedPort);
        StringBuilder advertisedListeners = new StringBuilder(this.getBootstrapServers());
        Collection cns = containerInfo.getNetworkSettings().getNetworks().values();
        int advertisedListenerNumber = 1;
        ArrayList<String> advertisedListenersNames = new ArrayList<String>();
        for (ContainerNetwork cn : cns) {
            String advertisedName = "BROKER" + advertisedListenerNumber;
            advertisedListeners.append(",").append(advertisedName).append("://").append(cn.getIpAddress()).append(":9093");
            advertisedListenersNames.add(advertisedName);
            ++advertisedListenerNumber;
        }
        LOGGER.info("This is all advertised listeners for Kafka {}", (Object)advertisedListeners.toString());
        StringBuilder kafkaListeners = new StringBuilder();
        StringBuilder kafkaListenerSecurityProtocol = new StringBuilder();
        advertisedListenersNames.forEach(name -> {
            kafkaListeners.append((String)name);
            kafkaListeners.append("://0.0.0.0:9093");
            kafkaListeners.append(",");
            kafkaListenerSecurityProtocol.append((String)name);
            kafkaListenerSecurityProtocol.append(":PLAINTEXT");
            kafkaListenerSecurityProtocol.append(",");
        });
        String command = "#!/bin/bash \n";
        command = command + "bin/zookeeper-server-start.sh config/zookeeper.properties &\n";
        command = command + "bin/kafka-server-start.sh config/server.properties --override listeners=" + kafkaListeners + "PLAINTEXT://0.0.0.0:" + 9092 + " --override advertised.listeners=" + advertisedListeners + " --override zookeeper.connect=localhost:" + 2181 + " --override listener.security.protocol.map=" + kafkaListenerSecurityProtocol + "PLAINTEXT:PLAINTEXT --override inter.broker.listener.name=BROKER1\n";
        LOGGER.info("Copying command to 'STARTER_SCRIPT' script.");
        this.copyFileToContainer(Transferable.of((byte[])command.getBytes(StandardCharsets.UTF_8), (int)700), STARTER_SCRIPT);
    }

    public String getBootstrapServers() {
        return String.format("PLAINTEXT://%s:%s", this.getContainerIpAddress(), this.kafkaExposedPort);
    }

    public static List<String> getSupportedKafkaVersions() {
        return SUPPORTED_KAFKA_VERSIONS;
    }

    public static String getLatestKafkaVersion() {
        return LATEST_KAFKA_VERSION;
    }

    public static String getStrimziVersion() {
        return STRIMZI_VERSION;
    }

    public boolean equals(Object o) {
        return super.equals(o);
    }

    public int hashCode() {
        return super.hashCode();
    }

    static {
        SUPPORTED_KAFKA_VERSIONS = new ArrayList<String>(5);
        InputStream kafkaVersionsInputStream = StrimziKafkaContainer.class.getResourceAsStream("/kafka-versions.txt");
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(kafkaVersionsInputStream, StandardCharsets.UTF_8));){
            String kafkaVersion;
            while ((kafkaVersion = bufferedReader.readLine()) != null) {
                SUPPORTED_KAFKA_VERSIONS.add(kafkaVersion);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        LOGGER.info("Supported Kafka versions: {}", SUPPORTED_KAFKA_VERSIONS);
        Collections.sort(SUPPORTED_KAFKA_VERSIONS);
        LATEST_KAFKA_VERSION = SUPPORTED_KAFKA_VERSIONS.get(SUPPORTED_KAFKA_VERSIONS.size() - 1);
        InputStream strimziVersionsInputStream = StrimziKafkaContainer.class.getResourceAsStream("/strimzi-version.txt");
        String strimziVersion = null;
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(strimziVersionsInputStream, StandardCharsets.UTF_8));){
            strimziVersion = bufferedReader.readLine();
            if (strimziVersion == null) {
                throw new RuntimeException("Failed to read Strimzi version");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        STRIMZI_VERSION = strimziVersion;
        LOGGER.info("Supported Strimzi version: {}", (Object)STRIMZI_VERSION);
    }
}

