/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.expression.proto;

import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.InvalidProtocolBufferException;
import io.substrait.expression.Expression;
import io.substrait.expression.ExpressionVisitor;
import io.substrait.expression.FieldReference;
import io.substrait.expression.FunctionArg;
import io.substrait.expression.WindowBound;
import io.substrait.extension.ExtensionCollector;
import io.substrait.extension.SimpleExtension;
import io.substrait.proto.Expression;
import io.substrait.proto.FunctionArgument;
import io.substrait.proto.Rel;
import io.substrait.proto.SortField;
import io.substrait.proto.Type;
import io.substrait.relation.RelVisitor;
import io.substrait.type.proto.TypeProtoConverter;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionProtoConverter
implements ExpressionVisitor<io.substrait.proto.Expression, RuntimeException> {
    static final Logger logger = LoggerFactory.getLogger(ExpressionProtoConverter.class);
    private final ExtensionCollector extensionCollector;
    private final RelVisitor<Rel, RuntimeException> relVisitor;
    private final TypeProtoConverter typeProtoConverter;

    public ExpressionProtoConverter(ExtensionCollector extensionCollector, RelVisitor<Rel, RuntimeException> relVisitor) {
        this.extensionCollector = extensionCollector;
        this.relVisitor = relVisitor;
        this.typeProtoConverter = new TypeProtoConverter(extensionCollector);
    }

    @Override
    public io.substrait.proto.Expression visit(Expression.NullLiteral expr) {
        return this.lit(bldr -> bldr.setNull(expr.type().accept(this.typeProtoConverter)));
    }

    private io.substrait.proto.Expression lit(Consumer<Expression.Literal.Builder> consumer) {
        Expression.Literal.Builder builder = Expression.Literal.newBuilder();
        consumer.accept(builder);
        return io.substrait.proto.Expression.newBuilder().setLiteral(builder).build();
    }

    @Override
    public io.substrait.proto.Expression visit(Expression.BoolLiteral expr) {
        return this.lit(bldr -> bldr.setNullable(expr.nullable()).setBoolean(expr.value()));
    }

    @Override
    public io.substrait.proto.Expression visit(Expression.I8Literal expr) {
        return this.lit(bldr -> bldr.setNullable(expr.nullable()).setI8(expr.value()));
    }

    @Override
    public io.substrait.proto.Expression visit(Expression.I16Literal expr) {
        return this.lit(bldr -> bldr.setNullable(expr.nullable()).setI16(expr.value()));
    }

    @Override
    public io.substrait.proto.Expression visit(Expression.I32Literal expr) {
        return this.lit(bldr -> bldr.setNullable(expr.nullable()).setI32(expr.value()));
    }

    @Override
    public io.substrait.proto.Expression visit(Expression.I64Literal expr) {
        return this.lit(bldr -> bldr.setNullable(expr.nullable()).setI64(expr.value()));
    }

    @Override
    public io.substrait.proto.Expression visit(Expression.FP32Literal expr) {
        return this.lit(bldr -> bldr.setNullable(expr.nullable()).setFp32(expr.value()));
    }

    @Override
    public io.substrait.proto.Expression visit(Expression.FP64Literal expr) {
        return this.lit(bldr -> bldr.setNullable(expr.nullable()).setFp64(expr.value()));
    }

    @Override
    public io.substrait.proto.Expression visit(Expression.StrLiteral expr) {
        return this.lit(bldr -> bldr.setNullable(expr.nullable()).setString(expr.value()));
    }

    @Override
    public io.substrait.proto.Expression visit(Expression.BinaryLiteral expr) {
        return this.lit(bldr -> bldr.setNullable(expr.nullable()).setBinary(expr.value()));
    }

    @Override
    public io.substrait.proto.Expression visit(Expression.TimeLiteral expr) {
        return this.lit(bldr -> bldr.setNullable(expr.nullable()).setTime(expr.value()));
    }

    @Override
    public io.substrait.proto.Expression visit(Expression.DateLiteral expr) {
        return this.lit(bldr -> bldr.setNullable(expr.nullable()).setDate(expr.value()));
    }

    @Override
    public io.substrait.proto.Expression visit(Expression.TimestampLiteral expr) {
        return this.lit(bldr -> bldr.setNullable(expr.nullable()).setTimestamp(expr.value()));
    }

    @Override
    public io.substrait.proto.Expression visit(Expression.TimestampTZLiteral expr) {
        return this.lit(bldr -> bldr.setNullable(expr.nullable()).setTimestampTz(expr.value()));
    }

    @Override
    public io.substrait.proto.Expression visit(Expression.IntervalYearLiteral expr) {
        return this.lit(bldr -> bldr.setNullable(expr.nullable()).setIntervalYearToMonth(Expression.Literal.IntervalYearToMonth.newBuilder().setYears(expr.years()).setMonths(expr.months())));
    }

    @Override
    public io.substrait.proto.Expression visit(Expression.IntervalDayLiteral expr) {
        return this.lit(bldr -> bldr.setNullable(expr.nullable()).setIntervalDayToSecond(Expression.Literal.IntervalDayToSecond.newBuilder().setDays(expr.days()).setSeconds(expr.seconds()).setMicroseconds(expr.microseconds())));
    }

    @Override
    public io.substrait.proto.Expression visit(Expression.UUIDLiteral expr) {
        return this.lit(bldr -> bldr.setNullable(expr.nullable()).setUuid(expr.toBytes()));
    }

    @Override
    public io.substrait.proto.Expression visit(Expression.FixedCharLiteral expr) {
        return this.lit(bldr -> bldr.setNullable(expr.nullable()).setFixedChar(expr.value()));
    }

    @Override
    public io.substrait.proto.Expression visit(Expression.VarCharLiteral expr) {
        return this.lit(bldr -> bldr.setNullable(expr.nullable()).setVarChar(Expression.Literal.VarChar.newBuilder().setValue(expr.value()).setLength(expr.length())));
    }

    @Override
    public io.substrait.proto.Expression visit(Expression.FixedBinaryLiteral expr) {
        return this.lit(bldr -> bldr.setNullable(expr.nullable()).setFixedBinary(expr.value()));
    }

    @Override
    public io.substrait.proto.Expression visit(Expression.DecimalLiteral expr) {
        return this.lit(bldr -> bldr.setNullable(expr.nullable()).setDecimal(Expression.Literal.Decimal.newBuilder().setValue(expr.value()).setPrecision(expr.precision()).setScale(expr.scale())));
    }

    @Override
    public io.substrait.proto.Expression visit(Expression.MapLiteral expr) {
        return this.lit(bldr -> {
            List keyValues = expr.values().entrySet().stream().map(e -> {
                Expression.Literal key = this.toLiteral((Expression)e.getKey());
                Expression.Literal value = this.toLiteral((Expression)e.getValue());
                return Expression.Literal.Map.KeyValue.newBuilder().setKey(key).setValue(value).build();
            }).collect(Collectors.toList());
            bldr.setNullable(expr.nullable()).setMap(Expression.Literal.Map.newBuilder().addAllKeyValues(keyValues));
        });
    }

    @Override
    public io.substrait.proto.Expression visit(Expression.ListLiteral expr) {
        return this.lit(bldr -> {
            List values = expr.values().stream().map(this::toLiteral).collect(Collectors.toList());
            bldr.setNullable(expr.nullable()).setList(Expression.Literal.List.newBuilder().addAllValues(values));
        });
    }

    @Override
    public io.substrait.proto.Expression visit(Expression.EmptyListLiteral expr) throws RuntimeException {
        return this.lit(builder -> {
            Type protoListType = expr.getType().accept(this.typeProtoConverter);
            builder.setEmptyList(protoListType.getList()).setNullable(expr.nullable());
        });
    }

    @Override
    public io.substrait.proto.Expression visit(Expression.StructLiteral expr) {
        return this.lit(bldr -> {
            List values = expr.fields().stream().map(this::toLiteral).collect(Collectors.toList());
            bldr.setNullable(expr.nullable()).setStruct(Expression.Literal.Struct.newBuilder().addAllFields(values));
        });
    }

    @Override
    public io.substrait.proto.Expression visit(Expression.UserDefinedLiteral expr) {
        int typeReference = this.extensionCollector.getTypeReference(SimpleExtension.TypeAnchor.of(expr.uri(), expr.name()));
        return this.lit(bldr -> {
            try {
                bldr.setNullable(expr.nullable()).setUserDefined(Expression.Literal.UserDefined.newBuilder().setTypeReference(typeReference).setValue(Any.parseFrom((ByteString)expr.value()))).build();
            }
            catch (InvalidProtocolBufferException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private Expression.Literal toLiteral(Expression expression) {
        io.substrait.proto.Expression e = expression.accept(this);
        assert (e.getRexTypeCase() == Expression.RexTypeCase.LITERAL);
        return e.getLiteral();
    }

    @Override
    public io.substrait.proto.Expression visit(Expression.Switch expr) {
        List clauses = expr.switchClauses().stream().map(s -> Expression.SwitchExpression.IfValue.newBuilder().setIf(this.toLiteral(s.condition())).setThen(s.then().accept(this)).build()).collect(Collectors.toList());
        return io.substrait.proto.Expression.newBuilder().setSwitchExpression(Expression.SwitchExpression.newBuilder().setMatch(expr.match().accept(this)).addAllIfs(clauses).setElse(expr.defaultClause().accept(this))).build();
    }

    @Override
    public io.substrait.proto.Expression visit(Expression.IfThen expr) {
        List clauses = expr.ifClauses().stream().map(s -> Expression.IfThen.IfClause.newBuilder().setIf(s.condition().accept(this)).setThen(s.then().accept(this)).build()).collect(Collectors.toList());
        return io.substrait.proto.Expression.newBuilder().setIfThen(Expression.IfThen.newBuilder().addAllIfs(clauses).setElse(expr.elseClause().accept(this))).build();
    }

    @Override
    public io.substrait.proto.Expression visit(Expression.ScalarFunctionInvocation expr) {
        FunctionArg.FuncArgVisitor<FunctionArgument, RuntimeException> argVisitor = FunctionArg.toProto(this.typeProtoConverter, this);
        return io.substrait.proto.Expression.newBuilder().setScalarFunction(Expression.ScalarFunction.newBuilder().setOutputType(expr.getType().accept(this.typeProtoConverter)).setFunctionReference(this.extensionCollector.getFunctionReference(expr.declaration())).addAllArguments(expr.arguments().stream().map(a -> (FunctionArgument)a.accept(expr.declaration(), 0, argVisitor)).collect(Collectors.toList()))).build();
    }

    @Override
    public io.substrait.proto.Expression visit(Expression.Cast expr) {
        return io.substrait.proto.Expression.newBuilder().setCast(Expression.Cast.newBuilder().setInput(expr.input().accept(this)).setType(expr.getType().accept(this.typeProtoConverter)).setFailureBehavior(expr.failureBehavior().toProto())).build();
    }

    private io.substrait.proto.Expression from(Expression expr) {
        return expr.accept(this);
    }

    private List<io.substrait.proto.Expression> from(List<Expression> expr) {
        return expr.stream().map(this::from).collect(Collectors.toList());
    }

    @Override
    public io.substrait.proto.Expression visit(Expression.SingleOrList expr) throws RuntimeException {
        return io.substrait.proto.Expression.newBuilder().setSingularOrList(Expression.SingularOrList.newBuilder().setValue(expr.condition().accept(this)).addAllOptions(this.from(expr.options()))).build();
    }

    @Override
    public io.substrait.proto.Expression visit(Expression.MultiOrList expr) throws RuntimeException {
        return io.substrait.proto.Expression.newBuilder().setMultiOrList(Expression.MultiOrList.newBuilder().addAllValue(this.from(expr.conditions())).addAllOptions(expr.optionCombinations().stream().map(r -> Expression.MultiOrList.Record.newBuilder().addAllFields(this.from(r.values())).build()).collect(Collectors.toList()))).build();
    }

    @Override
    public io.substrait.proto.Expression visit(FieldReference expr) {
        Expression.ReferenceSegment seg = null;
        for (FieldReference.ReferenceSegment segment : expr.segments()) {
            Expression.ReferenceSegment builtSegment;
            Expression.ReferenceSegment.Builder protoSegment;
            GeneratedMessageV3.Builder bldr;
            if (segment instanceof FieldReference.StructField) {
                FieldReference.StructField f = (FieldReference.StructField)segment;
                bldr = Expression.ReferenceSegment.StructField.newBuilder().setField(f.offset());
                if (seg != null) {
                    bldr.setChild(seg);
                }
                protoSegment = Expression.ReferenceSegment.newBuilder().setStructField((Expression.ReferenceSegment.StructField.Builder)bldr);
            } else if (segment instanceof FieldReference.ListElement) {
                FieldReference.ListElement f = (FieldReference.ListElement)segment;
                bldr = Expression.ReferenceSegment.ListElement.newBuilder().setOffset(f.offset());
                if (seg != null) {
                    bldr.setChild(seg);
                }
                protoSegment = Expression.ReferenceSegment.newBuilder().setListElement((Expression.ReferenceSegment.ListElement.Builder)bldr);
            } else if (segment instanceof FieldReference.MapKey) {
                FieldReference.MapKey f = (FieldReference.MapKey)segment;
                bldr = Expression.ReferenceSegment.MapKey.newBuilder().setMapKey(this.toLiteral(f.key()));
                if (seg != null) {
                    bldr.setChild(seg);
                }
                protoSegment = Expression.ReferenceSegment.newBuilder().setMapKey((Expression.ReferenceSegment.MapKey.Builder)bldr);
            } else {
                throw new IllegalArgumentException("Unhandled type: " + segment);
            }
            seg = builtSegment = protoSegment.build();
        }
        Expression.FieldReference.Builder out = Expression.FieldReference.newBuilder().setDirectReference(seg);
        if (expr.inputExpression().isPresent()) {
            out.setExpression(this.from(expr.inputExpression().get()));
        } else if (expr.outerReferenceStepsOut().isPresent()) {
            out.setOuterReference(Expression.FieldReference.OuterReference.newBuilder().setStepsOut(expr.outerReferenceStepsOut().get()));
        } else {
            out.setRootReference(Expression.FieldReference.RootReference.getDefaultInstance());
        }
        return io.substrait.proto.Expression.newBuilder().setSelection(out).build();
    }

    @Override
    public io.substrait.proto.Expression visit(Expression.SetPredicate expr) throws RuntimeException {
        return io.substrait.proto.Expression.newBuilder().setSubquery(Expression.Subquery.newBuilder().setSetPredicate(Expression.Subquery.SetPredicate.newBuilder().setPredicateOp(expr.predicateOp().toProto()).setTuples(expr.tuples().accept(this.relVisitor)).build()).build()).build();
    }

    @Override
    public io.substrait.proto.Expression visit(Expression.ScalarSubquery expr) throws RuntimeException {
        return io.substrait.proto.Expression.newBuilder().setSubquery(Expression.Subquery.newBuilder().setScalar(Expression.Subquery.Scalar.newBuilder().setInput(expr.input().accept(this.relVisitor)).build()).build()).build();
    }

    @Override
    public io.substrait.proto.Expression visit(Expression.InPredicate expr) throws RuntimeException {
        return io.substrait.proto.Expression.newBuilder().setSubquery(Expression.Subquery.newBuilder().setInPredicate(Expression.Subquery.InPredicate.newBuilder().setHaystack(expr.haystack().accept(this.relVisitor)).addAllNeedles(this.from(expr.needles())).build()).build()).build();
    }

    @Override
    public io.substrait.proto.Expression visit(Expression.WindowFunctionInvocation expr) throws RuntimeException {
        FunctionArg.FuncArgVisitor<FunctionArgument, RuntimeException> argVisitor = FunctionArg.toProto(this.typeProtoConverter, this);
        List args = expr.arguments().stream().map(a -> (FunctionArgument)a.accept(expr.declaration(), 0, argVisitor)).collect(Collectors.toList());
        Type outputType = expr.getType().accept(this.typeProtoConverter);
        List partitionExprs = expr.partitionBy().stream().map(e -> e.accept(this)).collect(Collectors.toList());
        List sortFields = expr.sort().stream().map(s -> SortField.newBuilder().setDirection(s.direction().toProto()).setExpr(s.expr().accept(this)).build()).collect(Collectors.toList());
        Expression.WindowFunction.Bound lowerBound = BoundConverter.convert(expr.lowerBound());
        Expression.WindowFunction.Bound upperBound = BoundConverter.convert(expr.upperBound());
        return io.substrait.proto.Expression.newBuilder().setWindowFunction(Expression.WindowFunction.newBuilder().setFunctionReference(this.extensionCollector.getFunctionReference(expr.declaration())).addAllArguments(args).setOutputType(outputType).setPhase(expr.aggregationPhase().toProto()).setInvocation(expr.invocation().toProto()).addAllSorts(sortFields).addAllPartitions(partitionExprs).setBoundsType(expr.boundsType().toProto()).setLowerBound(lowerBound).setUpperBound(upperBound)).build();
    }

    public static class BoundConverter
    implements WindowBound.WindowBoundVisitor<Expression.WindowFunction.Bound, RuntimeException> {
        private static final BoundConverter TO_BOUND_VISITOR = new BoundConverter();

        public static Expression.WindowFunction.Bound convert(WindowBound bound) {
            return bound.accept(TO_BOUND_VISITOR);
        }

        private BoundConverter() {
        }

        @Override
        public Expression.WindowFunction.Bound visit(WindowBound.Preceding preceding) {
            return Expression.WindowFunction.Bound.newBuilder().setPreceding(Expression.WindowFunction.Bound.Preceding.newBuilder().setOffset(preceding.offset())).build();
        }

        @Override
        public Expression.WindowFunction.Bound visit(WindowBound.Following following) {
            return Expression.WindowFunction.Bound.newBuilder().setFollowing(Expression.WindowFunction.Bound.Following.newBuilder().setOffset(following.offset())).build();
        }

        @Override
        public Expression.WindowFunction.Bound visit(WindowBound.CurrentRow currentRow) {
            return Expression.WindowFunction.Bound.newBuilder().setCurrentRow(Expression.WindowFunction.Bound.CurrentRow.getDefaultInstance()).build();
        }

        @Override
        public Expression.WindowFunction.Bound visit(WindowBound.Unbounded unbounded) {
            return Expression.WindowFunction.Bound.newBuilder().setUnbounded(Expression.WindowFunction.Bound.Unbounded.getDefaultInstance()).build();
        }
    }
}

