/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.expression.proto;

import io.substrait.expression.Expression;
import io.substrait.expression.ExpressionCreator;
import io.substrait.expression.FieldReference;
import io.substrait.expression.FunctionArg;
import io.substrait.expression.FunctionOption;
import io.substrait.expression.ImmutableExpression;
import io.substrait.expression.ImmutableFunctionOption;
import io.substrait.expression.WindowBound;
import io.substrait.extension.ExtensionLookup;
import io.substrait.extension.SimpleExtension;
import io.substrait.proto.ConsistentPartitionWindowRel;
import io.substrait.proto.Expression;
import io.substrait.proto.FunctionArgument;
import io.substrait.proto.SortField;
import io.substrait.relation.ConsistentPartitionWindow;
import io.substrait.relation.ProtoRelConverter;
import io.substrait.relation.Rel;
import io.substrait.type.Type;
import io.substrait.type.proto.ProtoTypeConverter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtoExpressionConverter {
    static final Logger logger = LoggerFactory.getLogger(ProtoExpressionConverter.class);
    public static final Type.Struct EMPTY_TYPE = Type.Struct.builder().nullable(false).build();
    private final ExtensionLookup lookup;
    private final SimpleExtension.ExtensionCollection extensions;
    private final Type.Struct rootType;
    private final ProtoTypeConverter protoTypeConverter;
    private final ProtoRelConverter protoRelConverter;

    public ProtoExpressionConverter(ExtensionLookup lookup, SimpleExtension.ExtensionCollection extensions, Type.Struct rootType, ProtoRelConverter relConverter) {
        this.lookup = lookup;
        this.extensions = extensions;
        this.rootType = Objects.requireNonNull(rootType, "rootType");
        this.protoTypeConverter = new ProtoTypeConverter(lookup, extensions);
        this.protoRelConverter = relConverter;
    }

    public FieldReference from(Expression.FieldReference reference) {
        switch (reference.getReferenceTypeCase()) {
            case DIRECT_REFERENCE: {
                FieldReference fieldReference;
                Expression.ReferenceSegment segment = reference.getDirectReference();
                ArrayList<FieldReference.ReferenceSegment> segments = new ArrayList<FieldReference.ReferenceSegment>();
                while (segment != Expression.ReferenceSegment.getDefaultInstance()) {
                    FieldReference.ReferenceSegment referenceSegment;
                    switch (segment.getReferenceTypeCase()) {
                        default: {
                            throw new IncompatibleClassChangeError();
                        }
                        case MAP_KEY: {
                            Expression.ReferenceSegment.MapKey mapKey = segment.getMapKey();
                            segment = mapKey.getChild();
                            referenceSegment = FieldReference.MapKey.of(this.from(mapKey.getMapKey()));
                            break;
                        }
                        case STRUCT_FIELD: {
                            Expression.ReferenceSegment.StructField structField = segment.getStructField();
                            segment = structField.getChild();
                            referenceSegment = FieldReference.StructField.of(structField.getField());
                            break;
                        }
                        case LIST_ELEMENT: {
                            Expression.ReferenceSegment.ListElement listElement = segment.getListElement();
                            segment = listElement.getChild();
                            referenceSegment = FieldReference.ListElement.of(listElement.getOffset());
                            break;
                        }
                        case REFERENCETYPE_NOT_SET: {
                            throw new IllegalArgumentException("Unhandled type: " + (Object)((Object)segment.getReferenceTypeCase()));
                        }
                    }
                    segments.add(referenceSegment);
                }
                Collections.reverse(segments);
                switch (reference.getRootTypeCase()) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case EXPRESSION: {
                        fieldReference = FieldReference.ofExpression(this.from(reference.getExpression()), segments);
                        break;
                    }
                    case ROOT_REFERENCE: {
                        fieldReference = FieldReference.ofRoot(this.rootType, segments);
                        break;
                    }
                    case OUTER_REFERENCE: {
                        fieldReference = FieldReference.newRootStructOuterReference(reference.getDirectReference().getStructField().getField(), this.rootType, reference.getOuterReference().getStepsOut());
                        break;
                    }
                    case ROOTTYPE_NOT_SET: {
                        throw new IllegalArgumentException("Unhandled type: " + (Object)((Object)reference.getRootTypeCase()));
                    }
                }
                FieldReference fieldReference2 = fieldReference;
                return fieldReference2;
            }
            case MASKED_REFERENCE: {
                throw new IllegalArgumentException("Unsupported type: " + (Object)((Object)reference.getReferenceTypeCase()));
            }
        }
        throw new IllegalArgumentException("Unhandled type: " + (Object)((Object)reference.getReferenceTypeCase()));
    }

    public Expression from(io.substrait.proto.Expression expr) {
        Expression expression;
        block0 : switch (expr.getRexTypeCase()) {
            case LITERAL: {
                expression = this.from(expr.getLiteral());
                break;
            }
            case SELECTION: {
                expression = this.from(expr.getSelection());
                break;
            }
            case SCALAR_FUNCTION: {
                Expression.ScalarFunction scalarFunction = expr.getScalarFunction();
                int functionReference = scalarFunction.getFunctionReference();
                SimpleExtension.ScalarFunctionVariant declaration = this.lookup.getScalarFunction(functionReference, this.extensions);
                FunctionArg.ProtoFrom pF = new FunctionArg.ProtoFrom(this, this.protoTypeConverter);
                List args = IntStream.range(0, scalarFunction.getArgumentsCount()).mapToObj(i -> pF.convert(declaration, i, scalarFunction.getArguments(i))).collect(Collectors.toList());
                expression = ImmutableExpression.ScalarFunctionInvocation.builder().addAllArguments(args).declaration(declaration).outputType(this.protoTypeConverter.from(scalarFunction.getOutputType())).build();
                break;
            }
            case WINDOW_FUNCTION: {
                expression = this.fromWindowFunction(expr.getWindowFunction());
                break;
            }
            case IF_THEN: {
                Expression.IfThen ifThen = expr.getIfThen();
                List clauses = ifThen.getIfsList().stream().map(t -> ExpressionCreator.ifThenClause(this.from(t.getIf()), this.from(t.getThen()))).collect(Collectors.toList());
                expression = ExpressionCreator.ifThenStatement(this.from(ifThen.getElse()), clauses);
                break;
            }
            case SWITCH_EXPRESSION: {
                Expression.SwitchExpression switchExpr = expr.getSwitchExpression();
                List clauses = switchExpr.getIfsList().stream().map(t -> ExpressionCreator.switchClause(this.from(t.getIf()), this.from(t.getThen()))).collect(Collectors.toList());
                expression = ExpressionCreator.switchStatement(this.from(switchExpr.getMatch()), this.from(switchExpr.getElse()), clauses);
                break;
            }
            case SINGULAR_OR_LIST: {
                Expression.SingularOrList orList = expr.getSingularOrList();
                List values = orList.getOptionsList().stream().map(this::from).collect(Collectors.toList());
                expression = ImmutableExpression.SingleOrList.builder().condition(this.from(orList.getValue())).addAllOptions(values).build();
                break;
            }
            case MULTI_OR_LIST: {
                Expression.MultiOrList multiOrList = expr.getMultiOrList();
                List values = multiOrList.getOptionsList().stream().map(t -> ImmutableExpression.MultiOrListRecord.builder().addAllValues(t.getFieldsList().stream().map(this::from).collect(Collectors.toList())).build()).collect(Collectors.toList());
                expression = ImmutableExpression.MultiOrList.builder().addAllOptionCombinations(values).addAllConditions(multiOrList.getValueList().stream().map(this::from).collect(Collectors.toList())).build();
                break;
            }
            case CAST: {
                expression = ExpressionCreator.cast(this.protoTypeConverter.from(expr.getCast().getType()), this.from(expr.getCast().getInput()), Expression.FailureBehavior.fromProto(expr.getCast().getFailureBehavior()));
                break;
            }
            case SUBQUERY: {
                switch (expr.getSubquery().getSubqueryTypeCase()) {
                    case SET_PREDICATE: {
                        Rel rel = this.protoRelConverter.from(expr.getSubquery().getSetPredicate().getTuples());
                        expression = ImmutableExpression.SetPredicate.builder().tuples(rel).predicateOp(Expression.PredicateOp.fromProto(expr.getSubquery().getSetPredicate().getPredicateOp())).build();
                        break block0;
                    }
                    case SCALAR: {
                        Rel rel = this.protoRelConverter.from(expr.getSubquery().getScalar().getInput());
                        expression = ImmutableExpression.ScalarSubquery.builder().input(rel).type(rel.getRecordType()).build();
                        break block0;
                    }
                    case IN_PREDICATE: {
                        Rel rel = this.protoRelConverter.from(expr.getSubquery().getInPredicate().getHaystack());
                        List needles = expr.getSubquery().getInPredicate().getNeedlesList().stream().map(e -> this.from((io.substrait.proto.Expression)e)).collect(Collectors.toList());
                        expression = ImmutableExpression.InPredicate.builder().haystack(rel).needles(needles).build();
                        break block0;
                    }
                    case SET_COMPARISON: {
                        throw new UnsupportedOperationException("Unsupported subquery type: " + (Object)((Object)expr.getSubquery().getSubqueryTypeCase()));
                    }
                }
                throw new IllegalArgumentException("Unknown subquery type: " + (Object)((Object)expr.getSubquery().getSubqueryTypeCase()));
            }
            case ENUM: {
                throw new UnsupportedOperationException("Unsupported type: " + (Object)((Object)expr.getRexTypeCase()));
            }
            default: {
                throw new IllegalArgumentException("Unknown type: " + (Object)((Object)expr.getRexTypeCase()));
            }
        }
        return expression;
    }

    public Expression.WindowFunctionInvocation fromWindowFunction(Expression.WindowFunction windowFunction) {
        int functionReference = windowFunction.getFunctionReference();
        SimpleExtension.WindowFunctionVariant declaration = this.lookup.getWindowFunction(functionReference, this.extensions);
        FunctionArg.ProtoFrom argVisitor = new FunctionArg.ProtoFrom(this, this.protoTypeConverter);
        List<FunctionArg> args = ProtoExpressionConverter.fromFunctionArgumentList(windowFunction.getArgumentsCount(), argVisitor, declaration, windowFunction::getArguments);
        List partitionExprs = windowFunction.getPartitionsList().stream().map(this::from).collect(Collectors.toList());
        List sortFields = windowFunction.getSortsList().stream().map(this::fromSortField).collect(Collectors.toList());
        Map options = windowFunction.getOptionsList().stream().map(this::fromFunctionOption).collect(Collectors.toMap(FunctionOption::getName, Function.identity()));
        WindowBound lowerBound = this.toWindowBound(windowFunction.getLowerBound());
        WindowBound upperBound = this.toWindowBound(windowFunction.getUpperBound());
        return Expression.WindowFunctionInvocation.builder().arguments(args).declaration(declaration).outputType(this.protoTypeConverter.from(windowFunction.getOutputType())).aggregationPhase(Expression.AggregationPhase.fromProto(windowFunction.getPhase())).partitionBy(partitionExprs).sort(sortFields).boundsType(Expression.WindowBoundsType.fromProto(windowFunction.getBoundsType())).lowerBound(lowerBound).upperBound(upperBound).invocation(Expression.AggregationInvocation.fromProto(windowFunction.getInvocation())).options(options).build();
    }

    public ConsistentPartitionWindow.WindowRelFunctionInvocation fromWindowRelFunction(ConsistentPartitionWindowRel.WindowRelFunction windowRelFunction) {
        int functionReference = windowRelFunction.getFunctionReference();
        SimpleExtension.WindowFunctionVariant declaration = this.lookup.getWindowFunction(functionReference, this.extensions);
        FunctionArg.ProtoFrom argVisitor = new FunctionArg.ProtoFrom(this, this.protoTypeConverter);
        List<FunctionArg> args = ProtoExpressionConverter.fromFunctionArgumentList(windowRelFunction.getArgumentsCount(), argVisitor, declaration, windowRelFunction::getArguments);
        Map options = windowRelFunction.getOptionsList().stream().map(this::fromFunctionOption).collect(Collectors.toMap(FunctionOption::getName, Function.identity()));
        WindowBound lowerBound = this.toWindowBound(windowRelFunction.getLowerBound());
        WindowBound upperBound = this.toWindowBound(windowRelFunction.getUpperBound());
        return ConsistentPartitionWindow.WindowRelFunctionInvocation.builder().arguments(args).declaration(declaration).outputType(this.protoTypeConverter.from(windowRelFunction.getOutputType())).aggregationPhase(Expression.AggregationPhase.fromProto(windowRelFunction.getPhase())).boundsType(Expression.WindowBoundsType.fromProto(windowRelFunction.getBoundsType())).lowerBound(lowerBound).upperBound(upperBound).invocation(Expression.AggregationInvocation.fromProto(windowRelFunction.getInvocation())).options(options).build();
    }

    private WindowBound toWindowBound(Expression.WindowFunction.Bound bound) {
        WindowBound windowBound;
        switch (bound.getKindCase()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case PRECEDING: {
                windowBound = WindowBound.Preceding.of(bound.getPreceding().getOffset());
                break;
            }
            case FOLLOWING: {
                windowBound = WindowBound.Following.of(bound.getFollowing().getOffset());
                break;
            }
            case CURRENT_ROW: {
                windowBound = WindowBound.CURRENT_ROW;
                break;
            }
            case UNBOUNDED: {
                windowBound = WindowBound.UNBOUNDED;
                break;
            }
            case KIND_NOT_SET: {
                windowBound = WindowBound.UNBOUNDED;
            }
        }
        return windowBound;
    }

    public Expression.Literal from(Expression.Literal literal) {
        Expression.Literal literal2;
        switch (literal.getLiteralTypeCase()) {
            case BOOLEAN: {
                literal2 = ExpressionCreator.bool(literal.getNullable(), literal.getBoolean());
                break;
            }
            case I8: {
                literal2 = ExpressionCreator.i8(literal.getNullable(), literal.getI8());
                break;
            }
            case I16: {
                literal2 = ExpressionCreator.i16(literal.getNullable(), literal.getI16());
                break;
            }
            case I32: {
                literal2 = ExpressionCreator.i32(literal.getNullable(), literal.getI32());
                break;
            }
            case I64: {
                literal2 = ExpressionCreator.i64(literal.getNullable(), literal.getI64());
                break;
            }
            case FP32: {
                literal2 = ExpressionCreator.fp32(literal.getNullable(), literal.getFp32());
                break;
            }
            case FP64: {
                literal2 = ExpressionCreator.fp64(literal.getNullable(), literal.getFp64());
                break;
            }
            case STRING: {
                literal2 = ExpressionCreator.string(literal.getNullable(), literal.getString());
                break;
            }
            case BINARY: {
                literal2 = ExpressionCreator.binary(literal.getNullable(), literal.getBinary());
                break;
            }
            case TIMESTAMP: {
                literal2 = ExpressionCreator.timestamp(literal.getNullable(), literal.getTimestamp());
                break;
            }
            case DATE: {
                literal2 = ExpressionCreator.date(literal.getNullable(), literal.getDate());
                break;
            }
            case TIME: {
                literal2 = ExpressionCreator.time(literal.getNullable(), literal.getTime());
                break;
            }
            case INTERVAL_YEAR_TO_MONTH: {
                literal2 = ExpressionCreator.intervalYear(literal.getNullable(), literal.getIntervalYearToMonth().getYears(), literal.getIntervalYearToMonth().getMonths());
                break;
            }
            case INTERVAL_DAY_TO_SECOND: {
                literal2 = ExpressionCreator.intervalDay(literal.getNullable(), literal.getIntervalDayToSecond().getDays(), literal.getIntervalDayToSecond().getSeconds(), literal.getIntervalDayToSecond().getMicroseconds());
                break;
            }
            case FIXED_CHAR: {
                literal2 = ExpressionCreator.fixedChar(literal.getNullable(), literal.getFixedChar());
                break;
            }
            case VAR_CHAR: {
                literal2 = ExpressionCreator.varChar(literal.getNullable(), literal.getVarChar().getValue(), literal.getVarChar().getLength());
                break;
            }
            case FIXED_BINARY: {
                literal2 = ExpressionCreator.fixedBinary(literal.getNullable(), literal.getFixedBinary());
                break;
            }
            case DECIMAL: {
                literal2 = ExpressionCreator.decimal(literal.getNullable(), literal.getDecimal().getValue(), literal.getDecimal().getPrecision(), literal.getDecimal().getScale());
                break;
            }
            case STRUCT: {
                literal2 = ExpressionCreator.struct(literal.getNullable(), literal.getStruct().getFieldsList().stream().map(this::from).collect(Collectors.toList()));
                break;
            }
            case MAP: {
                literal2 = ExpressionCreator.map(literal.getNullable(), literal.getMap().getKeyValuesList().stream().collect(Collectors.toMap(kv -> this.from(kv.getKey()), kv -> this.from(kv.getValue()))));
                break;
            }
            case TIMESTAMP_TZ: {
                literal2 = ExpressionCreator.timestampTZ(literal.getNullable(), literal.getTimestampTz());
                break;
            }
            case UUID: {
                literal2 = ExpressionCreator.uuid(literal.getNullable(), literal.getUuid());
                break;
            }
            case NULL: {
                literal2 = ExpressionCreator.typedNull(this.protoTypeConverter.from(literal.getNull()));
                break;
            }
            case LIST: {
                literal2 = ExpressionCreator.list(literal.getNullable(), literal.getList().getValuesList().stream().map(this::from).collect(Collectors.toList()));
                break;
            }
            case EMPTY_LIST: {
                Type.ListType listType = this.protoTypeConverter.fromList(literal.getEmptyList());
                literal2 = ExpressionCreator.emptyList(listType.nullable(), listType.elementType());
                break;
            }
            case USER_DEFINED: {
                Expression.Literal.UserDefined userDefinedLiteral = literal.getUserDefined();
                SimpleExtension.Type type = this.lookup.getType(userDefinedLiteral.getTypeReference(), this.extensions);
                literal2 = ExpressionCreator.userDefinedLiteral(literal.getNullable(), type.uri(), type.name(), userDefinedLiteral.getValue());
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + (Object)((Object)literal.getLiteralTypeCase()));
            }
        }
        return literal2;
    }

    private static List<FunctionArg> fromFunctionArgumentList(int argumentsCount, FunctionArg.ProtoFrom argVisitor, SimpleExtension.Function declaration, Function<Integer, FunctionArgument> argFunction) {
        return IntStream.range(0, argumentsCount).mapToObj(i -> argVisitor.convert(declaration, i, (FunctionArgument)argFunction.apply(i))).collect(Collectors.toList());
    }

    public Expression.SortField fromSortField(SortField s) {
        return Expression.SortField.builder().direction(Expression.SortDirection.fromProto(s.getDirection())).expr(this.from(s.getExpr())).build();
    }

    public FunctionOption fromFunctionOption(io.substrait.proto.FunctionOption o) {
        return ImmutableFunctionOption.builder().name(o.getName()).addAllValues((Iterable<String>)o.getPreferenceList()).build();
    }
}

