/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.extension;

import io.substrait.extension.AbstractExtensionLookup;
import io.substrait.extension.SimpleExtension;
import io.substrait.proto.ExtendedExpression;
import io.substrait.proto.Plan;
import io.substrait.proto.SimpleExtensionDeclaration;
import io.substrait.proto.SimpleExtensionURI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionCollector
extends AbstractExtensionLookup {
    static final Logger logger = LoggerFactory.getLogger(ExtensionCollector.class);
    private final BidiMap<Integer, SimpleExtension.FunctionAnchor> funcMap = new BidiMap(this.functionAnchorMap);
    private final BidiMap<Integer, SimpleExtension.TypeAnchor> typeMap = new BidiMap(this.typeAnchorMap);
    private final BidiMap<Integer, String> uriMap = new BidiMap(new HashMap());
    private int counter = -1;

    public ExtensionCollector() {
        super(new HashMap<Integer, SimpleExtension.FunctionAnchor>(), new HashMap<Integer, SimpleExtension.TypeAnchor>());
    }

    public int getFunctionReference(SimpleExtension.Function declaration) {
        Integer i = this.funcMap.reverseGet(declaration.getAnchor());
        if (i != null) {
            return i;
        }
        ++this.counter;
        this.funcMap.put(this.counter, declaration.getAnchor());
        return this.counter;
    }

    public int getTypeReference(SimpleExtension.TypeAnchor typeAnchor) {
        Integer i = this.typeMap.reverseGet(typeAnchor);
        if (i != null) {
            return i;
        }
        ++this.counter;
        this.typeMap.put(this.counter, typeAnchor);
        return this.counter;
    }

    public void addExtensionsToPlan(Plan.Builder builder) {
        SimpleExtensions simpleExtensions = this.getExtensions();
        builder.addAllExtensionUris(simpleExtensions.uris().values());
        builder.addAllExtensions(simpleExtensions.extensionList());
    }

    public void addExtensionsToExtendedExpression(ExtendedExpression.Builder builder) {
        SimpleExtensions simpleExtensions = this.getExtensions();
        builder.addAllExtensionUris(simpleExtensions.uris().values());
        builder.addAllExtensions(simpleExtensions.extensionList());
    }

    private SimpleExtensions getExtensions() {
        SimpleExtensionDeclaration decl;
        SimpleExtensionURI uri;
        AtomicInteger uriPos = new AtomicInteger(1);
        HashMap<String, SimpleExtensionURI> uris = new HashMap<String, SimpleExtensionURI>();
        ArrayList<SimpleExtensionDeclaration> extensionList = new ArrayList<SimpleExtensionDeclaration>();
        for (Map.Entry e : ((BidiMap)this.funcMap).forwardMap.entrySet()) {
            uri = uris.computeIfAbsent(((SimpleExtension.FunctionAnchor)e.getValue()).namespace(), k -> SimpleExtensionURI.newBuilder().setExtensionUriAnchor(uriPos.getAndIncrement()).setUri((String)k).build());
            decl = SimpleExtensionDeclaration.newBuilder().setExtensionFunction(SimpleExtensionDeclaration.ExtensionFunction.newBuilder().setFunctionAnchor((Integer)e.getKey()).setName(((SimpleExtension.FunctionAnchor)e.getValue()).key()).setExtensionUriReference(uri.getExtensionUriAnchor())).build();
            extensionList.add(decl);
        }
        for (Map.Entry e : ((BidiMap)this.typeMap).forwardMap.entrySet()) {
            uri = uris.computeIfAbsent(((SimpleExtension.TypeAnchor)e.getValue()).namespace(), k -> SimpleExtensionURI.newBuilder().setExtensionUriAnchor(uriPos.getAndIncrement()).setUri((String)k).build());
            decl = SimpleExtensionDeclaration.newBuilder().setExtensionType(SimpleExtensionDeclaration.ExtensionType.newBuilder().setTypeAnchor((Integer)e.getKey()).setName(((SimpleExtension.TypeAnchor)e.getValue()).key()).setExtensionUriReference(uri.getExtensionUriAnchor())).build();
            extensionList.add(decl);
        }
        return new SimpleExtensions(uris, extensionList);
    }

    private static class BidiMap<T1, T2> {
        private final Map<T1, T2> forwardMap;
        private final Map<T2, T1> reverseMap;

        public BidiMap(Map<T1, T2> forwardMap) {
            this.forwardMap = forwardMap;
            this.reverseMap = new HashMap<T2, T1>();
        }

        public T2 get(T1 t1) {
            return this.forwardMap.get(t1);
        }

        public T1 reverseGet(T2 t2) {
            return this.reverseMap.get(t2);
        }

        public void put(T1 t1, T2 t2) {
            this.forwardMap.put(t1, t2);
            this.reverseMap.put(t2, t1);
        }
    }

    private static final class SimpleExtensions {
        private final HashMap<String, SimpleExtensionURI> uris;
        private final ArrayList<SimpleExtensionDeclaration> extensionList;

        private SimpleExtensions(HashMap<String, SimpleExtensionURI> uris, ArrayList<SimpleExtensionDeclaration> extensionList) {
            this.uris = uris;
            this.extensionList = extensionList;
        }

        public String toString() {
            return "SimpleExtensions[" + "uris=" + this.uris + "," + "extensionList=" + this.extensionList + "]";
        }

        public int hashCode() {
            int result = 0;
            result = 31 * result + (this.uris != null ? this.uris.hashCode() : 0);
            result = 31 * result + (this.extensionList != null ? this.extensionList.hashCode() : 0);
            return result;
        }

        public final boolean equals(Object arg0) {
            if (this == arg0) {
                return true;
            }
            if (arg0 == null) {
                return false;
            }
            if (arg0.getClass() != this.getClass()) {
                return false;
            }
            if (!Objects.equals(((SimpleExtensions)arg0).uris, this.uris)) {
                return false;
            }
            return Objects.equals(((SimpleExtensions)arg0).extensionList, this.extensionList);
            {
            }
        }

        public HashMap<String, SimpleExtensionURI> uris() {
            return this.uris;
        }

        public ArrayList<SimpleExtensionDeclaration> extensionList() {
            return this.extensionList;
        }
    }
}

