/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.extension;

import io.substrait.extension.AdvancedExtension;
import io.substrait.relation.Extension;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="AdvancedExtension", generator="Immutables")
@Immutable
public final class ImmutableAdvancedExtension
extends AdvancedExtension {
    @Nullable
    private final Extension.Optimization optimization;
    @Nullable
    private final Extension.Enhancement enhancement;

    private ImmutableAdvancedExtension(@Nullable Extension.Optimization optimization, @Nullable Extension.Enhancement enhancement) {
        this.optimization = optimization;
        this.enhancement = enhancement;
    }

    @Override
    public Optional<Extension.Optimization> getOptimization() {
        return Optional.ofNullable(this.optimization);
    }

    @Override
    public Optional<Extension.Enhancement> getEnhancement() {
        return Optional.ofNullable(this.enhancement);
    }

    public final ImmutableAdvancedExtension withOptimization(Extension.Optimization value) {
        Extension.Optimization newValue = Objects.requireNonNull(value, "optimization");
        if (this.optimization == newValue) {
            return this;
        }
        return new ImmutableAdvancedExtension(newValue, this.enhancement);
    }

    public final ImmutableAdvancedExtension withOptimization(Optional<? extends Extension.Optimization> optional) {
        Extension.Optimization value = optional.orElse(null);
        if (this.optimization == value) {
            return this;
        }
        return new ImmutableAdvancedExtension(value, this.enhancement);
    }

    public final ImmutableAdvancedExtension withEnhancement(Extension.Enhancement value) {
        Extension.Enhancement newValue = Objects.requireNonNull(value, "enhancement");
        if (this.enhancement == newValue) {
            return this;
        }
        return new ImmutableAdvancedExtension(this.optimization, newValue);
    }

    public final ImmutableAdvancedExtension withEnhancement(Optional<? extends Extension.Enhancement> optional) {
        Extension.Enhancement value = optional.orElse(null);
        if (this.enhancement == value) {
            return this;
        }
        return new ImmutableAdvancedExtension(this.optimization, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAdvancedExtension && this.equalTo(0, (ImmutableAdvancedExtension)another);
    }

    private boolean equalTo(int synthetic, ImmutableAdvancedExtension another) {
        return Objects.equals(this.optimization, another.optimization) && Objects.equals(this.enhancement, another.enhancement);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.optimization);
        h += (h << 5) + Objects.hashCode(this.enhancement);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("AdvancedExtension{");
        if (this.optimization != null) {
            builder.append("optimization=").append(this.optimization);
        }
        if (this.enhancement != null) {
            if (builder.length() > 18) {
                builder.append(", ");
            }
            builder.append("enhancement=").append(this.enhancement);
        }
        return builder.append("}").toString();
    }

    public static ImmutableAdvancedExtension copyOf(AdvancedExtension instance) {
        if (instance instanceof ImmutableAdvancedExtension) {
            return (ImmutableAdvancedExtension)instance;
        }
        return ImmutableAdvancedExtension.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AdvancedExtension", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private Extension.Optimization optimization;
        @Nullable
        private Extension.Enhancement enhancement;

        private Builder() {
        }

        public final Builder from(AdvancedExtension instance) {
            Optional<Extension.Enhancement> enhancementOptional;
            Objects.requireNonNull(instance, "instance");
            Optional<Extension.Optimization> optimizationOptional = instance.getOptimization();
            if (optimizationOptional.isPresent()) {
                this.optimization(optimizationOptional);
            }
            if ((enhancementOptional = instance.getEnhancement()).isPresent()) {
                this.enhancement(enhancementOptional);
            }
            return this;
        }

        public final Builder optimization(Extension.Optimization optimization) {
            this.optimization = Objects.requireNonNull(optimization, "optimization");
            return this;
        }

        public final Builder optimization(Optional<? extends Extension.Optimization> optimization) {
            this.optimization = optimization.orElse(null);
            return this;
        }

        public final Builder enhancement(Extension.Enhancement enhancement) {
            this.enhancement = Objects.requireNonNull(enhancement, "enhancement");
            return this;
        }

        public final Builder enhancement(Optional<? extends Extension.Enhancement> enhancement) {
            this.enhancement = enhancement.orElse(null);
            return this;
        }

        public ImmutableAdvancedExtension build() {
            return new ImmutableAdvancedExtension(this.optimization, this.enhancement);
        }
    }
}

