/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.relation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;

public class CopyOnWriteUtils {
    public static boolean allEmpty(Optional<?> ... optionals) {
        return Arrays.stream(optionals).noneMatch(Optional::isPresent);
    }

    public static <T> Optional<T> or(Optional<T> left, Supplier<? extends Optional<T>> right) {
        if (left.isPresent()) {
            return left;
        }
        return right.get();
    }

    public static <ITEM, E extends Exception> Optional<List<ITEM>> transformList(List<ITEM> items, TransformFunction<ITEM, E> transform) throws E {
        ArrayList<ITEM> newItems = new ArrayList<ITEM>();
        boolean listUpdated = false;
        for (ITEM item : items) {
            Optional<ITEM> newItem = transform.apply(item);
            if (newItem.isPresent()) {
                newItems.add(newItem.get());
                listUpdated = true;
                continue;
            }
            newItems.add(item);
        }
        return listUpdated ? Optional.of(newItems) : Optional.empty();
    }

    @FunctionalInterface
    public static interface TransformFunction<T, E extends Exception> {
        public Optional<T> apply(T var1) throws E;
    }
}

