/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.relation;

import com.google.protobuf.Any;
import io.substrait.expression.AggregateFunctionInvocation;
import io.substrait.expression.Expression;
import io.substrait.expression.FunctionArg;
import io.substrait.expression.ImmutableExpression;
import io.substrait.expression.proto.ProtoExpressionConverter;
import io.substrait.extension.ExtensionLookup;
import io.substrait.extension.ImmutableAdvancedExtension;
import io.substrait.extension.SimpleExtension;
import io.substrait.proto.AdvancedExtension;
import io.substrait.proto.AggregateFunction;
import io.substrait.proto.AggregateRel;
import io.substrait.proto.ConsistentPartitionWindowRel;
import io.substrait.proto.CrossRel;
import io.substrait.proto.Expression;
import io.substrait.proto.ExtensionLeafRel;
import io.substrait.proto.ExtensionMultiRel;
import io.substrait.proto.ExtensionSingleRel;
import io.substrait.proto.FetchRel;
import io.substrait.proto.FilterRel;
import io.substrait.proto.HashJoinRel;
import io.substrait.proto.JoinRel;
import io.substrait.proto.MergeJoinRel;
import io.substrait.proto.NamedStruct;
import io.substrait.proto.NestedLoopJoinRel;
import io.substrait.proto.ProjectRel;
import io.substrait.proto.ReadRel;
import io.substrait.proto.Rel;
import io.substrait.proto.RelCommon;
import io.substrait.proto.SetRel;
import io.substrait.proto.SortRel;
import io.substrait.proto.Type;
import io.substrait.relation.Aggregate;
import io.substrait.relation.ConsistentPartitionWindow;
import io.substrait.relation.Cross;
import io.substrait.relation.EmptyScan;
import io.substrait.relation.Extension;
import io.substrait.relation.ExtensionLeaf;
import io.substrait.relation.ExtensionMulti;
import io.substrait.relation.ExtensionSingle;
import io.substrait.relation.ExtensionTable;
import io.substrait.relation.Fetch;
import io.substrait.relation.Filter;
import io.substrait.relation.ImmutableAggregate;
import io.substrait.relation.ImmutableConsistentPartitionWindow;
import io.substrait.relation.ImmutableCross;
import io.substrait.relation.ImmutableEmptyScan;
import io.substrait.relation.ImmutableExtensionLeaf;
import io.substrait.relation.ImmutableExtensionMulti;
import io.substrait.relation.ImmutableExtensionSingle;
import io.substrait.relation.ImmutableExtensionTable;
import io.substrait.relation.ImmutableFetch;
import io.substrait.relation.ImmutableFilter;
import io.substrait.relation.ImmutableGrouping;
import io.substrait.relation.ImmutableJoin;
import io.substrait.relation.ImmutableLocalFiles;
import io.substrait.relation.ImmutableMeasure;
import io.substrait.relation.ImmutableNamedScan;
import io.substrait.relation.ImmutableProject;
import io.substrait.relation.ImmutableSet;
import io.substrait.relation.ImmutableSort;
import io.substrait.relation.ImmutableVirtualTableScan;
import io.substrait.relation.Join;
import io.substrait.relation.LocalFiles;
import io.substrait.relation.NamedScan;
import io.substrait.relation.Project;
import io.substrait.relation.Rel;
import io.substrait.relation.Set;
import io.substrait.relation.Sort;
import io.substrait.relation.VirtualTableScan;
import io.substrait.relation.extensions.EmptyDetail;
import io.substrait.relation.extensions.EmptyOptimization;
import io.substrait.relation.files.FileOrFiles;
import io.substrait.relation.files.ImmutableFileFormat;
import io.substrait.relation.files.ImmutableFileOrFiles;
import io.substrait.relation.physical.HashJoin;
import io.substrait.relation.physical.ImmutableHashJoin;
import io.substrait.relation.physical.ImmutableMergeJoin;
import io.substrait.relation.physical.ImmutableNestedLoopJoin;
import io.substrait.relation.physical.MergeJoin;
import io.substrait.relation.physical.NestedLoopJoin;
import io.substrait.type.ImmutableNamedStruct;
import io.substrait.type.ImmutableType;
import io.substrait.type.Type;
import io.substrait.type.proto.ProtoTypeConverter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtoRelConverter {
    static final Logger logger = LoggerFactory.getLogger(ProtoRelConverter.class);
    protected final ExtensionLookup lookup;
    protected final SimpleExtension.ExtensionCollection extensions;
    private final ProtoTypeConverter protoTypeConverter;

    public ProtoRelConverter(ExtensionLookup lookup) throws IOException {
        this(lookup, SimpleExtension.loadDefaults());
    }

    public ProtoRelConverter(ExtensionLookup lookup, SimpleExtension.ExtensionCollection extensions) {
        this.lookup = lookup;
        this.extensions = extensions;
        this.protoTypeConverter = new ProtoTypeConverter(lookup, extensions);
    }

    public Rel from(io.substrait.proto.Rel rel) {
        Rel.RelTypeCase relType = rel.getRelTypeCase();
        switch (relType) {
            case READ: {
                return this.newRead(rel.getRead());
            }
            case FILTER: {
                return this.newFilter(rel.getFilter());
            }
            case FETCH: {
                return this.newFetch(rel.getFetch());
            }
            case AGGREGATE: {
                return this.newAggregate(rel.getAggregate());
            }
            case SORT: {
                return this.newSort(rel.getSort());
            }
            case JOIN: {
                return this.newJoin(rel.getJoin());
            }
            case SET: {
                return this.newSet(rel.getSet());
            }
            case PROJECT: {
                return this.newProject(rel.getProject());
            }
            case CROSS: {
                return this.newCross(rel.getCross());
            }
            case EXTENSION_LEAF: {
                return this.newExtensionLeaf(rel.getExtensionLeaf());
            }
            case EXTENSION_SINGLE: {
                return this.newExtensionSingle(rel.getExtensionSingle());
            }
            case EXTENSION_MULTI: {
                return this.newExtensionMulti(rel.getExtensionMulti());
            }
            case HASH_JOIN: {
                return this.newHashJoin(rel.getHashJoin());
            }
            case MERGE_JOIN: {
                return this.newMergeJoin(rel.getMergeJoin());
            }
            case NESTED_LOOP_JOIN: {
                return this.newNestedLoopJoin(rel.getNestedLoopJoin());
            }
            case WINDOW: {
                return this.newConsistentPartitionWindow(rel.getWindow());
            }
        }
        throw new UnsupportedOperationException("Unsupported RelTypeCase of " + (Object)((Object)relType));
    }

    private Rel newRead(ReadRel rel) {
        if (rel.hasVirtualTable()) {
            ReadRel.VirtualTable virtualTable = rel.getVirtualTable();
            if (virtualTable.getValuesCount() == 0) {
                return this.newEmptyScan(rel);
            }
            return this.newVirtualTable(rel);
        }
        if (rel.hasNamedTable()) {
            return this.newNamedScan(rel);
        }
        if (rel.hasLocalFiles()) {
            return this.newLocalFiles(rel);
        }
        if (rel.hasExtensionTable()) {
            return this.newExtensionTable(rel);
        }
        return this.newEmptyScan(rel);
    }

    private Filter newFilter(FilterRel rel) {
        Rel input = this.from(rel.getInput());
        ImmutableFilter.Builder builder = Filter.builder().input(input).condition(new ProtoExpressionConverter(this.lookup, this.extensions, input.getRecordType(), this).from(rel.getCondition()));
        builder.commonExtension(this.optionalAdvancedExtension(rel.getCommon())).remap(ProtoRelConverter.optionalRelmap(rel.getCommon()));
        if (rel.hasAdvancedExtension()) {
            builder.extension(this.advancedExtension(rel.getAdvancedExtension()));
        }
        return builder.build();
    }

    private io.substrait.type.NamedStruct newNamedStruct(ReadRel rel) {
        NamedStruct namedStruct = rel.getBaseSchema();
        Type.Struct struct = namedStruct.getStruct();
        return ImmutableNamedStruct.builder().names((Iterable<String>)namedStruct.getNamesList()).struct(Type.Struct.builder().fields(struct.getTypesList().stream().map(this.protoTypeConverter::from).collect(Collectors.toList())).nullable(ProtoTypeConverter.isNullable(struct.getNullability())).build()).build();
    }

    private EmptyScan newEmptyScan(ReadRel rel) {
        io.substrait.type.NamedStruct namedStruct = this.newNamedStruct(rel);
        ImmutableEmptyScan.Builder builder = EmptyScan.builder().initialSchema(namedStruct).filter(Optional.ofNullable(rel.hasFilter() ? new ProtoExpressionConverter(this.lookup, this.extensions, namedStruct.struct(), this).from(rel.getFilter()) : null));
        builder.commonExtension(this.optionalAdvancedExtension(rel.getCommon())).remap(ProtoRelConverter.optionalRelmap(rel.getCommon()));
        if (rel.hasAdvancedExtension()) {
            builder.extension(this.advancedExtension(rel.getAdvancedExtension()));
        }
        return builder.build();
    }

    private ExtensionLeaf newExtensionLeaf(ExtensionLeafRel rel) {
        Extension.LeafRelDetail detail = this.detailFromExtensionLeafRel(rel.getDetail());
        ImmutableExtensionLeaf.Builder builder = ExtensionLeaf.from(detail).commonExtension(this.optionalAdvancedExtension(rel.getCommon())).remap(ProtoRelConverter.optionalRelmap(rel.getCommon()));
        return builder.build();
    }

    private ExtensionSingle newExtensionSingle(ExtensionSingleRel rel) {
        Extension.SingleRelDetail detail = this.detailFromExtensionSingleRel(rel.getDetail());
        Rel input = this.from(rel.getInput());
        ImmutableExtensionSingle.Builder builder = ExtensionSingle.from(detail, input).commonExtension(this.optionalAdvancedExtension(rel.getCommon())).remap(ProtoRelConverter.optionalRelmap(rel.getCommon()));
        return builder.build();
    }

    private ExtensionMulti newExtensionMulti(ExtensionMultiRel rel) {
        Extension.MultiRelDetail detail = this.detailFromExtensionMultiRel(rel.getDetail());
        List<Rel> inputs = rel.getInputsList().stream().map(this::from).collect(Collectors.toList());
        ImmutableExtensionMulti.Builder builder = ExtensionMulti.from(detail, inputs).commonExtension(this.optionalAdvancedExtension(rel.getCommon())).remap(ProtoRelConverter.optionalRelmap(rel.getCommon()));
        if (rel.hasDetail()) {
            builder.detail(this.detailFromExtensionMultiRel(rel.getDetail()));
        }
        return builder.build();
    }

    private NamedScan newNamedScan(ReadRel rel) {
        io.substrait.type.NamedStruct namedStruct = this.newNamedStruct(rel);
        ImmutableNamedScan.Builder builder = NamedScan.builder().initialSchema(namedStruct).names((Iterable<String>)rel.getNamedTable().getNamesList()).filter(Optional.ofNullable(rel.hasFilter() ? new ProtoExpressionConverter(this.lookup, this.extensions, namedStruct.struct(), this).from(rel.getFilter()) : null));
        builder.commonExtension(this.optionalAdvancedExtension(rel.getCommon())).remap(ProtoRelConverter.optionalRelmap(rel.getCommon()));
        if (rel.hasAdvancedExtension()) {
            builder.extension(this.advancedExtension(rel.getAdvancedExtension()));
        }
        return builder.build();
    }

    private ExtensionTable newExtensionTable(ReadRel rel) {
        Extension.ExtensionTableDetail detail = this.detailFromExtensionTable(rel.getExtensionTable().getDetail());
        ImmutableExtensionTable.Builder builder = ExtensionTable.from(detail);
        builder.commonExtension(this.optionalAdvancedExtension(rel.getCommon())).remap(ProtoRelConverter.optionalRelmap(rel.getCommon()));
        if (rel.hasAdvancedExtension()) {
            builder.extension(this.advancedExtension(rel.getAdvancedExtension()));
        }
        return builder.build();
    }

    private LocalFiles newLocalFiles(ReadRel rel) {
        io.substrait.type.NamedStruct namedStruct = this.newNamedStruct(rel);
        ImmutableLocalFiles.Builder builder = LocalFiles.builder().initialSchema(namedStruct).addAllItems(rel.getLocalFiles().getItemsList().stream().map(this::newFileOrFiles).collect(Collectors.toList())).filter(Optional.ofNullable(rel.hasFilter() ? new ProtoExpressionConverter(this.lookup, this.extensions, namedStruct.struct(), this).from(rel.getFilter()) : null));
        builder.commonExtension(this.optionalAdvancedExtension(rel.getCommon())).remap(ProtoRelConverter.optionalRelmap(rel.getCommon()));
        if (rel.hasAdvancedExtension()) {
            builder.extension(this.advancedExtension(rel.getAdvancedExtension()));
        }
        return builder.build();
    }

    private FileOrFiles newFileOrFiles(ReadRel.LocalFiles.FileOrFiles file) {
        ImmutableFileOrFiles.Builder builder = ImmutableFileOrFiles.builder().partitionIndex(file.getPartitionIndex()).start(file.getStart()).length(file.getLength());
        if (file.hasParquet()) {
            builder.fileFormat(ImmutableFileFormat.ParquetReadOptions.builder().build());
        } else if (file.hasOrc()) {
            builder.fileFormat(ImmutableFileFormat.OrcReadOptions.builder().build());
        } else if (file.hasArrow()) {
            builder.fileFormat(ImmutableFileFormat.ArrowReadOptions.builder().build());
        } else if (file.hasDwrf()) {
            builder.fileFormat(ImmutableFileFormat.DwrfReadOptions.builder().build());
        } else if (file.hasExtension()) {
            builder.fileFormat(ImmutableFileFormat.Extension.builder().extension(file.getExtension()).build());
        }
        if (file.hasUriFile()) {
            builder.pathType(FileOrFiles.PathType.URI_FILE).path(file.getUriFile());
        } else if (file.hasUriFolder()) {
            builder.pathType(FileOrFiles.PathType.URI_FOLDER).path(file.getUriFolder());
        } else if (file.hasUriPath()) {
            builder.pathType(FileOrFiles.PathType.URI_PATH).path(file.getUriPath());
        } else if (file.hasUriPathGlob()) {
            builder.pathType(FileOrFiles.PathType.URI_PATH_GLOB).path(file.getUriPathGlob());
        }
        return builder.build();
    }

    private VirtualTableScan newVirtualTable(ReadRel rel) {
        ReadRel.VirtualTable virtualTable = rel.getVirtualTable();
        io.substrait.type.NamedStruct virtualTableSchema = this.newNamedStruct(rel);
        ProtoExpressionConverter converter = new ProtoExpressionConverter(this.lookup, this.extensions, virtualTableSchema.struct(), this);
        ArrayList<ImmutableExpression.StructLiteral> structLiterals = new ArrayList<ImmutableExpression.StructLiteral>(virtualTable.getValuesCount());
        for (Expression.Literal.Struct struct : virtualTable.getValuesList()) {
            structLiterals.add(ImmutableExpression.StructLiteral.builder().fields(struct.getFieldsList().stream().map(converter::from).collect(Collectors.toList())).build());
        }
        List<String> fieldNames = rel.getBaseSchema().getNamesList().stream().collect(Collectors.toList());
        ImmutableVirtualTableScan.Builder builder = VirtualTableScan.builder().filter(Optional.ofNullable(rel.hasFilter() ? converter.from(rel.getFilter()) : null)).addAllDfsNames(fieldNames).rows(structLiterals);
        builder.commonExtension(this.optionalAdvancedExtension(rel.getCommon())).remap(ProtoRelConverter.optionalRelmap(rel.getCommon()));
        if (rel.hasAdvancedExtension()) {
            builder.extension(this.advancedExtension(rel.getAdvancedExtension()));
        }
        return builder.build();
    }

    private Fetch newFetch(FetchRel rel) {
        Rel input = this.from(rel.getInput());
        ImmutableFetch.Builder builder = Fetch.builder().input(input).offset(rel.getOffset());
        if (rel.getCount() != -1L) {
            builder.count(rel.getCount());
        }
        builder.commonExtension(this.optionalAdvancedExtension(rel.getCommon())).remap(ProtoRelConverter.optionalRelmap(rel.getCommon()));
        if (rel.hasAdvancedExtension()) {
            builder.extension(this.advancedExtension(rel.getAdvancedExtension()));
        }
        return builder.build();
    }

    private Project newProject(ProjectRel rel) {
        Rel input = this.from(rel.getInput());
        ProtoExpressionConverter converter = new ProtoExpressionConverter(this.lookup, this.extensions, input.getRecordType(), this);
        ImmutableProject.Builder builder = Project.builder().input(input).expressions(rel.getExpressionsList().stream().map(converter::from).collect(Collectors.toList()));
        builder.commonExtension(this.optionalAdvancedExtension(rel.getCommon())).remap(ProtoRelConverter.optionalRelmap(rel.getCommon()));
        if (rel.hasAdvancedExtension()) {
            builder.extension(this.advancedExtension(rel.getAdvancedExtension()));
        }
        return builder.build();
    }

    private Aggregate newAggregate(AggregateRel rel) {
        Rel input = this.from(rel.getInput());
        ProtoExpressionConverter protoExprConverter = new ProtoExpressionConverter(this.lookup, this.extensions, input.getRecordType(), this);
        ArrayList<ImmutableGrouping> groupings = new ArrayList<ImmutableGrouping>(rel.getGroupingsCount());
        for (AggregateRel.Grouping grouping : rel.getGroupingsList()) {
            groupings.add(Aggregate.Grouping.builder().expressions(grouping.getGroupingExpressionsList().stream().map(protoExprConverter::from).collect(Collectors.toList())).build());
        }
        ArrayList<ImmutableMeasure> measures = new ArrayList<ImmutableMeasure>(rel.getMeasuresCount());
        FunctionArg.ProtoFrom pF = new FunctionArg.ProtoFrom(protoExprConverter, this.protoTypeConverter);
        for (AggregateRel.Measure measure : rel.getMeasuresList()) {
            AggregateFunction func = measure.getMeasure();
            SimpleExtension.AggregateFunctionVariant funcDecl = this.lookup.getAggregateFunction(func.getFunctionReference(), this.extensions);
            List args = IntStream.range(0, measure.getMeasure().getArgumentsCount()).mapToObj(i -> pF.convert(funcDecl, i, measure.getMeasure().getArguments(i))).collect(Collectors.toList());
            measures.add(Aggregate.Measure.builder().function(AggregateFunctionInvocation.builder().arguments(args).declaration(funcDecl).outputType(this.protoTypeConverter.from(func.getOutputType())).aggregationPhase(Expression.AggregationPhase.fromProto(func.getPhase())).invocation(Expression.AggregationInvocation.fromProto(func.getInvocation())).build()).preMeasureFilter(Optional.ofNullable(measure.hasFilter() ? protoExprConverter.from(measure.getFilter()) : null)).build());
        }
        ImmutableAggregate.Builder builder = Aggregate.builder().input(input).groupings(groupings).measures(measures);
        builder.commonExtension(this.optionalAdvancedExtension(rel.getCommon())).remap(ProtoRelConverter.optionalRelmap(rel.getCommon()));
        if (rel.hasAdvancedExtension()) {
            builder.extension(this.advancedExtension(rel.getAdvancedExtension()));
        }
        return builder.build();
    }

    private Sort newSort(SortRel rel) {
        Rel input = this.from(rel.getInput());
        ProtoExpressionConverter converter = new ProtoExpressionConverter(this.lookup, this.extensions, input.getRecordType(), this);
        ImmutableSort.Builder builder = Sort.builder().input(input).sortFields(rel.getSortsList().stream().map(field -> Expression.SortField.builder().direction(Expression.SortDirection.fromProto(field.getDirection())).expr(converter.from(field.getExpr())).build()).collect(Collectors.toList()));
        builder.commonExtension(this.optionalAdvancedExtension(rel.getCommon())).remap(ProtoRelConverter.optionalRelmap(rel.getCommon()));
        if (rel.hasAdvancedExtension()) {
            builder.extension(this.advancedExtension(rel.getAdvancedExtension()));
        }
        return builder.build();
    }

    private Join newJoin(JoinRel rel) {
        Rel left = this.from(rel.getLeft());
        Rel right = this.from(rel.getRight());
        Type.Struct leftStruct = left.getRecordType();
        Type.Struct rightStruct = right.getRecordType();
        ImmutableType.Struct unionedStruct = Type.Struct.builder().from(leftStruct).from(rightStruct).build();
        ProtoExpressionConverter converter = new ProtoExpressionConverter(this.lookup, this.extensions, unionedStruct, this);
        ImmutableJoin.Builder builder = Join.builder().left(left).right(right).condition(converter.from(rel.getExpression())).joinType(Join.JoinType.fromProto(rel.getType())).postJoinFilter(Optional.ofNullable(rel.hasPostJoinFilter() ? converter.from(rel.getPostJoinFilter()) : null));
        builder.commonExtension(this.optionalAdvancedExtension(rel.getCommon())).remap(ProtoRelConverter.optionalRelmap(rel.getCommon()));
        if (rel.hasAdvancedExtension()) {
            builder.extension(this.advancedExtension(rel.getAdvancedExtension()));
        }
        return builder.build();
    }

    private Rel newCross(CrossRel rel) {
        Rel left = this.from(rel.getLeft());
        Rel right = this.from(rel.getRight());
        ImmutableCross.Builder builder = Cross.builder().left(left).right(right);
        builder.commonExtension(this.optionalAdvancedExtension(rel.getCommon())).remap(ProtoRelConverter.optionalRelmap(rel.getCommon()));
        if (rel.hasAdvancedExtension()) {
            builder.extension(this.advancedExtension(rel.getAdvancedExtension()));
        }
        return builder.build();
    }

    private Set newSet(SetRel rel) {
        List inputs = rel.getInputsList().stream().map(inputRel -> this.from((io.substrait.proto.Rel)inputRel)).collect(Collectors.toList());
        ImmutableSet.Builder builder = Set.builder().inputs(inputs).setOp(Set.SetOp.fromProto(rel.getOp()));
        builder.commonExtension(this.optionalAdvancedExtension(rel.getCommon())).remap(ProtoRelConverter.optionalRelmap(rel.getCommon()));
        if (rel.hasAdvancedExtension()) {
            builder.extension(this.advancedExtension(rel.getAdvancedExtension()));
        }
        return builder.build();
    }

    private Rel newHashJoin(HashJoinRel rel) {
        Rel left = this.from(rel.getLeft());
        Rel right = this.from(rel.getRight());
        List<Expression.FieldReference> leftKeys = rel.getLeftKeysList();
        List<Expression.FieldReference> rightKeys = rel.getRightKeysList();
        Type.Struct leftStruct = left.getRecordType();
        Type.Struct rightStruct = right.getRecordType();
        ImmutableType.Struct unionedStruct = Type.Struct.builder().from(leftStruct).from(rightStruct).build();
        ProtoExpressionConverter leftConverter = new ProtoExpressionConverter(this.lookup, this.extensions, leftStruct, this);
        ProtoExpressionConverter rightConverter = new ProtoExpressionConverter(this.lookup, this.extensions, rightStruct, this);
        ProtoExpressionConverter unionConverter = new ProtoExpressionConverter(this.lookup, this.extensions, unionedStruct, this);
        ImmutableHashJoin.Builder builder = HashJoin.builder().left(left).right(right).leftKeys(leftKeys.stream().map(leftConverter::from).collect(Collectors.toList())).rightKeys(rightKeys.stream().map(rightConverter::from).collect(Collectors.toList())).joinType(HashJoin.JoinType.fromProto(rel.getType())).postJoinFilter(Optional.ofNullable(rel.hasPostJoinFilter() ? unionConverter.from(rel.getPostJoinFilter()) : null));
        builder.commonExtension(this.optionalAdvancedExtension(rel.getCommon())).remap(ProtoRelConverter.optionalRelmap(rel.getCommon()));
        if (rel.hasAdvancedExtension()) {
            builder.extension(this.advancedExtension(rel.getAdvancedExtension()));
        }
        return builder.build();
    }

    private Rel newMergeJoin(MergeJoinRel rel) {
        Rel left = this.from(rel.getLeft());
        Rel right = this.from(rel.getRight());
        List<Expression.FieldReference> leftKeys = rel.getLeftKeysList();
        List<Expression.FieldReference> rightKeys = rel.getRightKeysList();
        Type.Struct leftStruct = left.getRecordType();
        Type.Struct rightStruct = right.getRecordType();
        ImmutableType.Struct unionedStruct = Type.Struct.builder().from(leftStruct).from(rightStruct).build();
        ProtoExpressionConverter leftConverter = new ProtoExpressionConverter(this.lookup, this.extensions, leftStruct, this);
        ProtoExpressionConverter rightConverter = new ProtoExpressionConverter(this.lookup, this.extensions, rightStruct, this);
        ProtoExpressionConverter unionConverter = new ProtoExpressionConverter(this.lookup, this.extensions, unionedStruct, this);
        ImmutableMergeJoin.Builder builder = MergeJoin.builder().left(left).right(right).leftKeys(leftKeys.stream().map(leftConverter::from).collect(Collectors.toList())).rightKeys(rightKeys.stream().map(rightConverter::from).collect(Collectors.toList())).joinType(MergeJoin.JoinType.fromProto(rel.getType())).postJoinFilter(Optional.ofNullable(rel.hasPostJoinFilter() ? unionConverter.from(rel.getPostJoinFilter()) : null));
        builder.commonExtension(this.optionalAdvancedExtension(rel.getCommon())).remap(ProtoRelConverter.optionalRelmap(rel.getCommon()));
        if (rel.hasAdvancedExtension()) {
            builder.extension(this.advancedExtension(rel.getAdvancedExtension()));
        }
        return builder.build();
    }

    private NestedLoopJoin newNestedLoopJoin(NestedLoopJoinRel rel) {
        Rel left = this.from(rel.getLeft());
        Rel right = this.from(rel.getRight());
        Type.Struct leftStruct = left.getRecordType();
        Type.Struct rightStruct = right.getRecordType();
        ImmutableType.Struct unionedStruct = Type.Struct.builder().from(leftStruct).from(rightStruct).build();
        ProtoExpressionConverter converter = new ProtoExpressionConverter(this.lookup, this.extensions, unionedStruct, this);
        ImmutableNestedLoopJoin.Builder builder = NestedLoopJoin.builder().left(left).right(right).condition(rel.hasExpression() ? converter.from(rel.getExpression()) : Expression.BoolLiteral.builder().value(true).build()).joinType(NestedLoopJoin.JoinType.fromProto(rel.getType()));
        builder.commonExtension(this.optionalAdvancedExtension(rel.getCommon())).remap(ProtoRelConverter.optionalRelmap(rel.getCommon()));
        if (rel.hasAdvancedExtension()) {
            builder.extension(this.advancedExtension(rel.getAdvancedExtension()));
        }
        return builder.build();
    }

    private ConsistentPartitionWindow newConsistentPartitionWindow(ConsistentPartitionWindowRel rel) {
        Rel input = this.from(rel.getInput());
        ProtoExpressionConverter protoExpressionConverter = new ProtoExpressionConverter(this.lookup, this.extensions, input.getRecordType(), this);
        List partitionExprs = rel.getPartitionExpressionsList().stream().map(protoExpressionConverter::from).collect(Collectors.toList());
        List sortFields = rel.getSortsList().stream().map(protoExpressionConverter::fromSortField).collect(Collectors.toList());
        List windowRelFunctions = rel.getWindowFunctionsList().stream().map(protoExpressionConverter::fromWindowRelFunction).collect(Collectors.toList());
        ImmutableConsistentPartitionWindow.Builder builder = ConsistentPartitionWindow.builder().input(input).partitionExpressions(partitionExprs).sorts(sortFields).windowFunctions(windowRelFunctions);
        builder.commonExtension(this.optionalAdvancedExtension(rel.getCommon())).remap(ProtoRelConverter.optionalRelmap(rel.getCommon()));
        if (rel.hasAdvancedExtension()) {
            builder.extension(this.advancedExtension(rel.getAdvancedExtension()));
        }
        return builder.build();
    }

    private static Optional<Rel.Remap> optionalRelmap(RelCommon relCommon) {
        return Optional.ofNullable(relCommon.hasEmit() ? Rel.Remap.of(relCommon.getEmit().getOutputMappingList()) : null);
    }

    private Optional<io.substrait.extension.AdvancedExtension> optionalAdvancedExtension(RelCommon relCommon) {
        return Optional.ofNullable(relCommon.hasAdvancedExtension() ? this.advancedExtension(relCommon.getAdvancedExtension()) : null);
    }

    private io.substrait.extension.AdvancedExtension advancedExtension(AdvancedExtension advancedExtension) {
        ImmutableAdvancedExtension.Builder builder = io.substrait.extension.AdvancedExtension.builder();
        if (advancedExtension.hasEnhancement()) {
            builder.enhancement(this.enhancementFromAdvancedExtension(advancedExtension.getEnhancement()));
        }
        if (advancedExtension.hasOptimization()) {
            builder.optimization(this.optimizationFromAdvancedExtension(advancedExtension.getOptimization()));
        }
        return builder.build();
    }

    protected Extension.Optimization optimizationFromAdvancedExtension(Any any) {
        return new EmptyOptimization();
    }

    protected Extension.Enhancement enhancementFromAdvancedExtension(Any any) {
        throw new RuntimeException("enhancements cannot be ignored by consumers");
    }

    protected Extension.LeafRelDetail detailFromExtensionLeafRel(Any any) {
        return this.emptyDetail();
    }

    protected Extension.SingleRelDetail detailFromExtensionSingleRel(Any any) {
        return this.emptyDetail();
    }

    protected Extension.MultiRelDetail detailFromExtensionMultiRel(Any any) {
        return this.emptyDetail();
    }

    protected Extension.ExtensionTableDetail detailFromExtensionTable(Any any) {
        return this.emptyDetail();
    }

    private EmptyDetail emptyDetail() {
        return new EmptyDetail();
    }
}

