/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.relation;

import io.substrait.extension.AdvancedExtension;
import io.substrait.relation.ImmutableRemap;
import io.substrait.relation.RelVisitor;
import io.substrait.type.Type;
import io.substrait.type.TypeCreator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.immutables.value.Value;

public interface Rel {
    public Optional<Remap> getRemap();

    public Optional<AdvancedExtension> getCommonExtension();

    public Type.Struct getRecordType();

    public List<Rel> getInputs();

    public <O, E extends Exception> O accept(RelVisitor<O, E> var1) throws E;

    @Value.Immutable
    public static abstract class Remap {
        public abstract List<Integer> indices();

        public Type.Struct remap(Type.Struct initial) {
            List<Type> types = initial.fields();
            return TypeCreator.of(initial.nullable()).struct(this.indices().stream().map(i -> (Type)types.get((int)i)));
        }

        public static Remap of(Iterable<Integer> fields) {
            return ImmutableRemap.builder().addAllIndices(fields).build();
        }

        public static Remap offset(int start, int length) {
            return Remap.of(IntStream.range(start, start + length).mapToObj(i -> i).collect(Collectors.toList()));
        }
    }
}

