/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.relation.files;

import io.substrait.proto.ReadRel;
import io.substrait.relation.files.FileFormat;
import java.util.Optional;
import org.immutables.value.Value;

@Value.Immutable
public interface FileOrFiles {
    public Optional<PathType> pathType();

    public Optional<String> getPath();

    public long getPartitionIndex();

    public long getStart();

    public long getLength();

    public Optional<FileFormat> getFileFormat();

    default public ReadRel.LocalFiles.FileOrFiles toProto() {
        ReadRel.LocalFiles.FileOrFiles.Builder builder = ReadRel.LocalFiles.FileOrFiles.newBuilder();
        this.getFileFormat().ifPresent(fileFormat -> {
            if (fileFormat instanceof FileFormat.ParquetReadOptions) {
                FileFormat.ParquetReadOptions options = (FileFormat.ParquetReadOptions)fileFormat;
                builder.setParquet(ReadRel.LocalFiles.FileOrFiles.ParquetReadOptions.newBuilder().build());
            } else if (fileFormat instanceof FileFormat.ArrowReadOptions) {
                FileFormat.ArrowReadOptions options = (FileFormat.ArrowReadOptions)fileFormat;
                builder.setArrow(ReadRel.LocalFiles.FileOrFiles.ArrowReadOptions.newBuilder().build());
            } else if (fileFormat instanceof FileFormat.OrcReadOptions) {
                FileFormat.OrcReadOptions options = (FileFormat.OrcReadOptions)fileFormat;
                builder.setOrc(ReadRel.LocalFiles.FileOrFiles.OrcReadOptions.newBuilder().build());
            } else if (fileFormat instanceof FileFormat.DwrfReadOptions) {
                FileFormat.DwrfReadOptions options = (FileFormat.DwrfReadOptions)fileFormat;
                builder.setDwrf(ReadRel.LocalFiles.FileOrFiles.DwrfReadOptions.newBuilder().build());
            } else if (fileFormat instanceof FileFormat.Extension) {
                FileFormat.Extension options = (FileFormat.Extension)fileFormat;
                builder.setExtension(options.getExtension());
            } else {
                throw new UnsupportedOperationException("Unable to convert file format of " + fileFormat.getClass());
            }
        });
        this.pathType().ifPresent(pathType -> this.getPath().ifPresent(path -> {
            switch (pathType) {
                case URI_PATH: {
                    builder.setUriPath((String)path);
                    break;
                }
                case URI_PATH_GLOB: {
                    builder.setUriPathGlob((String)path);
                    break;
                }
                case URI_FILE: {
                    builder.setUriFile((String)path);
                    break;
                }
                case URI_FOLDER: {
                    builder.setUriFolder((String)path);
                }
            }
        }));
        return builder.setPartitionIndex(this.getPartitionIndex()).setStart(this.getStart()).setLength(this.getLength()).build();
    }

    public static enum PathType {
        URI_PATH,
        URI_PATH_GLOB,
        URI_FILE,
        URI_FOLDER;

    }
}

