/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.type;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.substrait.extension.SimpleExtension;
import io.substrait.type.Deserializers;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YamlRead {
    static final Logger logger = LoggerFactory.getLogger(YamlRead.class);
    private static final List<String> FUNCTIONS = Collections.unmodifiableList(Arrays.asList("boolean", "aggregate_generic", "arithmetic_decimal", "arithmetic", "comparison", "datetime", "string"));

    public static void main(String[] args) throws Exception {
        System.out.println("Read: " + YamlRead.class.getResource("/functions_boolean.yaml"));
        List<SimpleExtension.Function> signatures = YamlRead.loadFunctions();
        signatures.forEach(f -> System.out.println(f.key()));
    }

    public static List<SimpleExtension.Function> loadFunctions() {
        return YamlRead.loadFunctions(FUNCTIONS.stream().map(c -> String.format("/src/substrait/extensions/functions_%s.yaml", c)).collect(Collectors.toList()));
    }

    public static List<SimpleExtension.Function> loadFunctions(List<String> files) {
        return files.stream().flatMap(YamlRead::parse).collect(Collectors.toList());
    }

    private static Stream<SimpleExtension.Function> parse(String name) {
        try {
            ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory()).enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY).registerModule((Module)Deserializers.MODULE);
            SimpleExtension.ExtensionSignatures doc = (SimpleExtension.ExtensionSignatures)mapper.readValue(new File(name), SimpleExtension.ExtensionSignatures.class);
            logger.debug("Parsed {} functions in file {}.", (Object)(Optional.ofNullable(doc.scalars()).map(List::size).orElse(0) + Optional.ofNullable(doc.aggregates()).map(List::size).orElse(0)), (Object)name);
            return doc.resolve(name);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException("Failure while parsing file " + name, ex);
        }
    }
}

