/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.type.proto;

import io.substrait.proto.Type;
import java.util.Arrays;

abstract class BaseProtoTypes<T, I> {
    protected final Type.Nullability nullability;
    public final T BOOLEAN;
    public final T I8;
    public final T I16;
    public final T I32;
    public final T I64;
    public final T FP32;
    public final T FP64;
    public final T STRING;
    public final T BINARY;
    public final T TIMESTAMP;
    public final T TIMESTAMP_TZ;
    public final T DATE;
    public final T TIME;
    public final T INTERVAL_DAY;
    public final T INTERVAL_YEAR;
    public final T UUID;

    public BaseProtoTypes(Type.Nullability nullability) {
        this.nullability = nullability;
        this.BOOLEAN = this.wrap(Type.Boolean.newBuilder().setNullability(nullability).build());
        this.I8 = this.wrap(Type.I8.newBuilder().setNullability(nullability).build());
        this.I16 = this.wrap(Type.I16.newBuilder().setNullability(nullability).build());
        this.I32 = this.wrap(Type.I32.newBuilder().setNullability(nullability).build());
        this.I64 = this.wrap(Type.I64.newBuilder().setNullability(nullability).build());
        this.FP32 = this.wrap(Type.FP32.newBuilder().setNullability(nullability).build());
        this.FP64 = this.wrap(Type.FP64.newBuilder().setNullability(nullability).build());
        this.STRING = this.wrap(Type.String.newBuilder().setNullability(nullability).build());
        this.BINARY = this.wrap(Type.Binary.newBuilder().setNullability(nullability).build());
        this.TIMESTAMP = this.wrap(Type.Timestamp.newBuilder().setNullability(nullability).build());
        this.TIMESTAMP_TZ = this.wrap(Type.TimestampTZ.newBuilder().setNullability(nullability).build());
        this.DATE = this.wrap(Type.Date.newBuilder().setNullability(nullability).build());
        this.TIME = this.wrap(Type.Time.newBuilder().setNullability(nullability).build());
        this.INTERVAL_DAY = this.wrap(Type.IntervalDay.newBuilder().setNullability(nullability).build());
        this.INTERVAL_YEAR = this.wrap(Type.IntervalYear.newBuilder().setNullability(nullability).build());
        this.UUID = this.wrap(Type.UUID.newBuilder().setNullability(nullability).build());
    }

    public abstract T fixedChar(I var1);

    public final T fixedChar(int len) {
        return this.fixedChar(this.i(len));
    }

    public final T fixedChar(String len) {
        return this.fixedChar(this.integerParam(len));
    }

    public final T varChar(int len) {
        return this.varChar(this.i(len));
    }

    public final T varChar(String len) {
        return this.varChar(this.integerParam(len));
    }

    public final T fixedBinary(int len) {
        return this.fixedBinary(this.i(len));
    }

    public final T fixedBinary(String len) {
        return this.fixedBinary(this.integerParam(len));
    }

    public final T decimal(int scale, int precision) {
        return this.decimal(this.i(scale), this.i(precision));
    }

    public final T decimal(I scale, int precision) {
        return this.decimal(scale, this.i(precision));
    }

    public final T decimal(int scale, I precision) {
        return this.decimal(this.i(scale), precision);
    }

    public final T precisionTimestamp(int precision) {
        return this.precisionTimestamp(this.i(precision));
    }

    public final T precisionTimestampTZ(int precision) {
        return this.precisionTimestampTZ(this.i(precision));
    }

    public abstract T typeParam(String var1);

    public abstract I integerParam(String var1);

    public abstract T varChar(I var1);

    public abstract T fixedBinary(I var1);

    public abstract T decimal(I var1, I var2);

    public abstract T precisionTimestamp(I var1);

    public abstract T precisionTimestampTZ(I var1);

    public final T struct(T ... types) {
        return this.struct((Iterable<T>)Arrays.asList(types));
    }

    public abstract T struct(Iterable<T> var1);

    public abstract T list(T var1);

    public abstract T map(T var1, T var2);

    public abstract T userDefined(int var1);

    protected abstract T wrap(Object var1);

    protected abstract I i(int var1);
}

