/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.type.proto;

import io.substrait.extension.ExtensionCollector;
import io.substrait.function.ParameterizedType;
import io.substrait.function.TypeExpression;
import io.substrait.proto.DerivationExpression;
import io.substrait.proto.Type;
import io.substrait.type.proto.BaseProtoConverter;
import io.substrait.type.proto.BaseProtoTypes;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeExpressionProtoVisitor
extends BaseProtoConverter<DerivationExpression, DerivationExpression> {
    static final Logger logger = LoggerFactory.getLogger(TypeExpressionProtoVisitor.class);
    private static final DerivationTypes DERIVATION_NULLABLE = new DerivationTypes(Type.Nullability.NULLABILITY_NULLABLE);
    private static final DerivationTypes DERIVATION_REQUIRED = new DerivationTypes(Type.Nullability.NULLABILITY_REQUIRED);

    public TypeExpressionProtoVisitor(ExtensionCollector extensionCollector) {
        super(extensionCollector, "Unexpected expression type. This shouldn't happen.");
    }

    @Override
    public BaseProtoTypes<DerivationExpression, DerivationExpression> typeContainer(boolean nullable) {
        return nullable ? DERIVATION_NULLABLE : DERIVATION_REQUIRED;
    }

    @Override
    public DerivationExpression visit(TypeExpression.BinaryOperation expr) {
        DerivationExpression.BinaryOp.BinaryOpType binaryOpType;
        switch (expr.opType()) {
            case ADD: {
                binaryOpType = DerivationExpression.BinaryOp.BinaryOpType.BINARY_OP_TYPE_PLUS;
                break;
            }
            case SUBTRACT: {
                binaryOpType = DerivationExpression.BinaryOp.BinaryOpType.BINARY_OP_TYPE_MINUS;
                break;
            }
            case MIN: {
                binaryOpType = DerivationExpression.BinaryOp.BinaryOpType.BINARY_OP_TYPE_MIN;
                break;
            }
            case MAX: {
                binaryOpType = DerivationExpression.BinaryOp.BinaryOpType.BINARY_OP_TYPE_MAX;
                break;
            }
            case LT: {
                binaryOpType = DerivationExpression.BinaryOp.BinaryOpType.BINARY_OP_TYPE_LESS_THAN;
                break;
            }
            case GT: {
                binaryOpType = DerivationExpression.BinaryOp.BinaryOpType.BINARY_OP_TYPE_GREATER_THAN;
                break;
            }
            case EQ: {
                binaryOpType = DerivationExpression.BinaryOp.BinaryOpType.BINARY_OP_TYPE_EQUALS;
                break;
            }
            case COVERS: {
                binaryOpType = DerivationExpression.BinaryOp.BinaryOpType.BINARY_OP_TYPE_COVERS;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + (Object)((Object)expr.opType()));
            }
        }
        DerivationExpression.BinaryOp.BinaryOpType opType = binaryOpType;
        return DerivationExpression.newBuilder().setBinaryOp(DerivationExpression.BinaryOp.newBuilder().setArg1(expr.left().accept(this)).setArg2(expr.right().accept(this)).setOpType(opType).build()).build();
    }

    @Override
    public DerivationExpression visit(TypeExpression.NotOperation expr) {
        return DerivationExpression.newBuilder().setUnaryOp(DerivationExpression.UnaryOp.newBuilder().setOpType(DerivationExpression.UnaryOp.UnaryOpType.UNARY_OP_TYPE_BOOLEAN_NOT).setArg(expr.inner().accept(this))).build();
    }

    @Override
    public DerivationExpression visit(TypeExpression.IfOperation expr) {
        return DerivationExpression.newBuilder().setIfElse(DerivationExpression.IfElse.newBuilder().setIfCondition(expr.ifCondition().accept(this)).setIfReturn(expr.thenExpr().accept(this)).setElseReturn(expr.elseExpr().accept(this)).build()).build();
    }

    @Override
    public DerivationExpression visit(TypeExpression.IntegerLiteral expr) {
        return DerivationExpression.newBuilder().setIntegerLiteral(expr.value()).build();
    }

    @Override
    public DerivationExpression visit(TypeExpression.ReturnProgram expr) {
        List assignments = expr.assignments().stream().map(a -> DerivationExpression.ReturnProgram.Assignment.newBuilder().setName(a.name()).setExpression(a.expr().accept(this)).build()).collect(Collectors.toList());
        DerivationExpression finalExpr = expr.finalExpression().accept(this);
        return DerivationExpression.newBuilder().setReturnProgram(DerivationExpression.ReturnProgram.newBuilder().setFinalExpression(finalExpr).addAllAssignments(assignments).build()).build();
    }

    @Override
    public DerivationExpression visit(ParameterizedType.FixedChar expr) {
        return (DerivationExpression)this.typeContainer(expr).fixedChar(expr.length().value());
    }

    @Override
    public DerivationExpression visit(ParameterizedType.VarChar expr) {
        return (DerivationExpression)this.typeContainer(expr).varChar(expr.length().value());
    }

    @Override
    public DerivationExpression visit(ParameterizedType.FixedBinary expr) {
        return (DerivationExpression)this.typeContainer(expr).fixedBinary(expr.length().value());
    }

    @Override
    public DerivationExpression visit(ParameterizedType.Decimal expr) {
        return (DerivationExpression)this.typeContainer(expr).decimal(((ParameterizedType.BaseParameterizedType)expr.precision()).accept(this), ((ParameterizedType.BaseParameterizedType)expr.scale()).accept(this));
    }

    @Override
    public DerivationExpression visit(ParameterizedType.PrecisionTimestamp expr) {
        return (DerivationExpression)this.typeContainer(expr).precisionTimestamp(((ParameterizedType.BaseParameterizedType)expr.precision()).accept(this));
    }

    @Override
    public DerivationExpression visit(TypeExpression.PrecisionTimestampTZ expr) {
        return (DerivationExpression)this.typeContainer(expr).precisionTimestampTZ(expr.precision().accept(this));
    }

    @Override
    public DerivationExpression visit(ParameterizedType.Struct expr) {
        return (DerivationExpression)this.typeContainer(expr).struct(expr.fields().stream().map(f -> f.accept(this)).collect(Collectors.toList()));
    }

    @Override
    public DerivationExpression visit(ParameterizedType.ListType expr) {
        return this.typeContainer(expr).list(expr.name().accept(this));
    }

    @Override
    public DerivationExpression visit(ParameterizedType.Map expr) {
        return this.typeContainer(expr).map(expr.key().accept(this), expr.value().accept(this));
    }

    @Override
    public DerivationExpression visit(ParameterizedType.StringLiteral stringLiteral) {
        return DerivationExpression.newBuilder().setTypeParameterName(stringLiteral.value()).build();
    }

    @Override
    public DerivationExpression visit(TypeExpression.FixedChar expr) {
        return (DerivationExpression)this.typeContainer(expr).fixedChar(expr.length().accept(this));
    }

    @Override
    public DerivationExpression visit(TypeExpression.VarChar expr) {
        return (DerivationExpression)this.typeContainer(expr).varChar(expr.length().accept(this));
    }

    @Override
    public DerivationExpression visit(TypeExpression.FixedBinary expr) {
        return (DerivationExpression)this.typeContainer(expr).fixedBinary(expr.length().accept(this));
    }

    @Override
    public DerivationExpression visit(TypeExpression.Decimal expr) {
        return (DerivationExpression)this.typeContainer(expr).decimal(expr.precision().accept(this), expr.scale().accept(this));
    }

    @Override
    public DerivationExpression visit(TypeExpression.Struct expr) {
        return (DerivationExpression)this.typeContainer(expr).struct(expr.fields().stream().map(f -> f.accept(this)).collect(Collectors.toList()));
    }

    @Override
    public DerivationExpression visit(TypeExpression.ListType expr) {
        return this.typeContainer(expr).list(expr.elementType().accept(this));
    }

    @Override
    public DerivationExpression visit(TypeExpression.Map expr) {
        return this.typeContainer(expr).map(expr.key().accept(this), expr.value().accept(this));
    }

    private static class DerivationTypes
    extends BaseProtoTypes<DerivationExpression, DerivationExpression> {
        public DerivationTypes(Type.Nullability nullability) {
            super(nullability);
        }

        @Override
        public DerivationExpression fixedChar(DerivationExpression len) {
            return this.wrap(DerivationExpression.ExpressionFixedChar.newBuilder().setLength(len).setNullability(this.nullability).build());
        }

        @Override
        public DerivationExpression typeParam(String name) {
            return DerivationExpression.newBuilder().setTypeParameterName(name).build();
        }

        @Override
        public DerivationExpression integerParam(String name) {
            return DerivationExpression.newBuilder().setIntegerParameterName(name).build();
        }

        @Override
        public DerivationExpression varChar(DerivationExpression len) {
            return this.wrap(DerivationExpression.ExpressionVarChar.newBuilder().setLength(len).setNullability(this.nullability).build());
        }

        @Override
        public DerivationExpression fixedBinary(DerivationExpression len) {
            return this.wrap(DerivationExpression.ExpressionFixedBinary.newBuilder().setLength(len).setNullability(this.nullability).build());
        }

        @Override
        public DerivationExpression decimal(DerivationExpression scale, DerivationExpression precision) {
            return this.wrap(DerivationExpression.ExpressionDecimal.newBuilder().setScale(scale).setPrecision(precision).setNullability(this.nullability).build());
        }

        @Override
        public DerivationExpression precisionTimestamp(DerivationExpression precision) {
            return this.wrap(DerivationExpression.ExpressionPrecisionTimestamp.newBuilder().setPrecision(precision).setNullability(this.nullability).build());
        }

        @Override
        public DerivationExpression precisionTimestampTZ(DerivationExpression precision) {
            return this.wrap(DerivationExpression.ExpressionPrecisionTimestampTZ.newBuilder().setPrecision(precision).setNullability(this.nullability).build());
        }

        @Override
        public DerivationExpression struct(Iterable<DerivationExpression> types) {
            return this.wrap(DerivationExpression.ExpressionStruct.newBuilder().addAllTypes(types).setNullability(this.nullability).build());
        }

        public DerivationExpression param(String name) {
            return DerivationExpression.newBuilder().setTypeParameterName(name).build();
        }

        @Override
        public DerivationExpression list(DerivationExpression type) {
            return this.wrap(DerivationExpression.ExpressionList.newBuilder().setType(type).setNullability(Type.Nullability.NULLABILITY_NULLABLE).build());
        }

        @Override
        public DerivationExpression map(DerivationExpression key, DerivationExpression value) {
            return this.wrap(DerivationExpression.ExpressionMap.newBuilder().setKey(key).setValue(value).setNullability(Type.Nullability.NULLABILITY_REQUIRED).build());
        }

        @Override
        public DerivationExpression userDefined(int ref) {
            throw new UnsupportedOperationException("User defined types are not supported in Derivation Expressions for now");
        }

        @Override
        protected DerivationExpression wrap(Object o) {
            DerivationExpression.Builder bldr = DerivationExpression.newBuilder();
            if (o instanceof Type.Boolean) {
                Type.Boolean t = (Type.Boolean)o;
                return bldr.setBool(t).build();
            }
            if (o instanceof Type.I8) {
                Type.I8 t = (Type.I8)o;
                return bldr.setI8(t).build();
            }
            if (o instanceof Type.I16) {
                Type.I16 t = (Type.I16)o;
                return bldr.setI16(t).build();
            }
            if (o instanceof Type.I32) {
                Type.I32 t = (Type.I32)o;
                return bldr.setI32(t).build();
            }
            if (o instanceof Type.I64) {
                Type.I64 t = (Type.I64)o;
                return bldr.setI64(t).build();
            }
            if (o instanceof Type.FP32) {
                Type.FP32 t = (Type.FP32)o;
                return bldr.setFp32(t).build();
            }
            if (o instanceof Type.FP64) {
                Type.FP64 t = (Type.FP64)o;
                return bldr.setFp64(t).build();
            }
            if (o instanceof Type.String) {
                Type.String t = (Type.String)o;
                return bldr.setString(t).build();
            }
            if (o instanceof Type.Binary) {
                Type.Binary t = (Type.Binary)o;
                return bldr.setBinary(t).build();
            }
            if (o instanceof Type.Timestamp) {
                Type.Timestamp t = (Type.Timestamp)o;
                return bldr.setTimestamp(t).build();
            }
            if (o instanceof Type.Date) {
                Type.Date t = (Type.Date)o;
                return bldr.setDate(t).build();
            }
            if (o instanceof Type.Time) {
                Type.Time t = (Type.Time)o;
                return bldr.setTime(t).build();
            }
            if (o instanceof Type.TimestampTZ) {
                Type.TimestampTZ t = (Type.TimestampTZ)o;
                return bldr.setTimestampTz(t).build();
            }
            if (o instanceof Type.IntervalYear) {
                Type.IntervalYear t = (Type.IntervalYear)o;
                return bldr.setIntervalYear(t).build();
            }
            if (o instanceof Type.IntervalDay) {
                Type.IntervalDay t = (Type.IntervalDay)o;
                return bldr.setIntervalDay(t).build();
            }
            if (o instanceof DerivationExpression.ExpressionFixedChar) {
                DerivationExpression.ExpressionFixedChar t = (DerivationExpression.ExpressionFixedChar)o;
                return bldr.setFixedChar(t).build();
            }
            if (o instanceof DerivationExpression.ExpressionVarChar) {
                DerivationExpression.ExpressionVarChar t = (DerivationExpression.ExpressionVarChar)o;
                return bldr.setVarchar(t).build();
            }
            if (o instanceof DerivationExpression.ExpressionFixedBinary) {
                DerivationExpression.ExpressionFixedBinary t = (DerivationExpression.ExpressionFixedBinary)o;
                return bldr.setFixedBinary(t).build();
            }
            if (o instanceof DerivationExpression.ExpressionDecimal) {
                DerivationExpression.ExpressionDecimal t = (DerivationExpression.ExpressionDecimal)o;
                return bldr.setDecimal(t).build();
            }
            if (o instanceof DerivationExpression.ExpressionPrecisionTimestamp) {
                DerivationExpression.ExpressionPrecisionTimestamp t = (DerivationExpression.ExpressionPrecisionTimestamp)o;
                return bldr.setPrecisionTimestamp(t).build();
            }
            if (o instanceof DerivationExpression.ExpressionPrecisionTimestampTZ) {
                DerivationExpression.ExpressionPrecisionTimestampTZ t = (DerivationExpression.ExpressionPrecisionTimestampTZ)o;
                return bldr.setPrecisionTimestampTz(t).build();
            }
            if (o instanceof DerivationExpression.ExpressionStruct) {
                DerivationExpression.ExpressionStruct t = (DerivationExpression.ExpressionStruct)o;
                return bldr.setStruct(t).build();
            }
            if (o instanceof DerivationExpression.ExpressionList) {
                DerivationExpression.ExpressionList t = (DerivationExpression.ExpressionList)o;
                return bldr.setList(t).build();
            }
            if (o instanceof DerivationExpression.ExpressionMap) {
                DerivationExpression.ExpressionMap t = (DerivationExpression.ExpressionMap)o;
                return bldr.setMap(t).build();
            }
            if (o instanceof Type.UUID) {
                Type.UUID t = (Type.UUID)o;
                return bldr.setUuid(t).build();
            }
            throw new UnsupportedOperationException("Unable to wrap type of " + o.getClass());
        }

        @Override
        protected DerivationExpression i(int integerValue) {
            return DerivationExpression.newBuilder().setIntegerLiteral(integerValue).build();
        }
    }
}

