/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.expression;

import io.substrait.expression.Expression;
import io.substrait.expression.ExpressionVisitor;
import io.substrait.expression.ImmutableFieldReference;
import io.substrait.expression.ImmutableListElement;
import io.substrait.expression.ImmutableMapKey;
import io.substrait.expression.ImmutableStructField;
import io.substrait.relation.Rel;
import io.substrait.type.Type;
import io.substrait.type.TypeVisitor;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.immutables.value.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Value.Immutable
public abstract class FieldReference
implements Expression {
    static final Logger logger = LoggerFactory.getLogger(FieldReference.class);

    public abstract List<ReferenceSegment> segments();

    public abstract Type type();

    public abstract Optional<Expression> inputExpression();

    public abstract Optional<Integer> outerReferenceStepsOut();

    @Override
    public Type getType() {
        return this.type();
    }

    public static ImmutableFieldReference.Builder builder() {
        return ImmutableFieldReference.builder();
    }

    @Override
    public <R, E extends Throwable> R accept(ExpressionVisitor<R, E> visitor) throws E {
        return visitor.visit(this);
    }

    public boolean isSimpleRootReference() {
        return this.segments().size() == 1 && !this.inputExpression().isPresent();
    }

    public FieldReference dereferenceStruct(int index) {
        Type newType = StructFieldFinder.getReferencedType(this.type(), index);
        return this.dereference(newType, StructField.of(index));
    }

    private FieldReference dereference(Type newType, ReferenceSegment nextSegment) {
        return ImmutableFieldReference.builder().type(newType).addSegments(nextSegment).addAllSegments(this.segments()).inputExpression(this.inputExpression()).build();
    }

    public FieldReference dereferenceList(int index) {
        Type newType = ListIndexFinder.getReferencedType(this.type(), index);
        return this.dereference(newType, ListElement.of(index));
    }

    public FieldReference dereferenceMap(Expression.Literal mapKey) {
        Type newType = MapKeyFinder.getReferencedType(this.type(), mapKey.getType());
        return this.dereference(newType, MapKey.of(mapKey));
    }

    public static FieldReference newMapReference(Expression.Literal mapKey, Expression expression) {
        return ImmutableFieldReference.builder().addSegments((ReferenceSegment)MapKey.of(mapKey)).inputExpression(expression).type(MapKeyFinder.getReferencedType(expression.getType(), mapKey.getType())).build();
    }

    public static FieldReference newListReference(int index, Expression expression) {
        return ImmutableFieldReference.builder().addSegments((ReferenceSegment)ListElement.of(index)).inputExpression(expression).type(ListIndexFinder.getReferencedType(expression.getType(), index)).build();
    }

    public static FieldReference newStructReference(int index, Expression expression) {
        return ImmutableFieldReference.builder().addSegments((ReferenceSegment)StructField.of(index)).inputExpression(expression).type(StructFieldFinder.getReferencedType(expression.getType(), index)).build();
    }

    public static FieldReference newRootStructReference(int index, Type knownType) {
        return ImmutableFieldReference.builder().addSegments((ReferenceSegment)StructField.of(index)).type(knownType).build();
    }

    public static FieldReference newRootStructOuterReference(int index, Type knownType, int stepsOut) {
        return ImmutableFieldReference.builder().addSegments((ReferenceSegment)StructField.of(index)).type(knownType).outerReferenceStepsOut(stepsOut).build();
    }

    public static FieldReference newInputRelReference(int index, Rel rel) {
        return FieldReference.newInputRelReference(index, Collections.singletonList(rel));
    }

    public static FieldReference newInputRelReference(int index, List<Rel> rels) {
        int currentOffset = 0;
        for (Rel r : rels) {
            int relSize = r.getRecordType().fields().size();
            if (index < currentOffset + relSize) {
                Type referenceType = r.getRecordType().fields().get(index - currentOffset);
                return ImmutableFieldReference.builder().addSegments((ReferenceSegment)StructField.of(index)).type(referenceType).build();
            }
            currentOffset += relSize;
        }
        throw new IllegalArgumentException(String.format("The current index %d wasn't found within the number of fields %d", index, currentOffset));
    }

    public static FieldReference ofExpression(Expression expression, List<ReferenceSegment> segments) {
        return FieldReference.of(null, expression, segments);
    }

    private static FieldReference of(Type.Struct struct, Expression expression, List<ReferenceSegment> segments) {
        FieldReference reference = null;
        Collections.reverse(segments);
        for (int i = 0; i < segments.size(); ++i) {
            if (i == 0) {
                ReferenceSegment last = segments.get(0);
                reference = struct == null ? last.constructOnExpression(expression) : last.constructOnRoot(struct);
                continue;
            }
            reference = segments.get(i).apply(reference);
        }
        return reference;
    }

    public static FieldReference ofRoot(Type.Struct struct, List<ReferenceSegment> segments) {
        return FieldReference.of(struct, null, segments);
    }

    private static class StructFieldFinder
    extends TypeVisitor.TypeThrowsVisitor<Type, RuntimeException> {
        private final int index;

        private StructFieldFinder(int index) {
            super("This visitor only supports retrieving struct types. Was applied to a non-struct type.");
            this.index = index;
        }

        @Override
        public Type visit(Type.Struct expr) throws RuntimeException {
            if (expr.fields().size() < this.index) {
                throw new IllegalArgumentException("Undefined struct type.");
            }
            return expr.fields().get(this.index);
        }

        public static Type getReferencedType(Type type, int index) {
            return type.accept(new StructFieldFinder(index));
        }
    }

    @Value.Immutable
    public static abstract class StructField
    implements ReferenceSegment {
        public abstract int offset();

        public static StructField of(int index) {
            return ImmutableStructField.builder().offset(index).build();
        }

        @Override
        public FieldReference apply(FieldReference reference) {
            return reference.dereferenceStruct(this.offset());
        }

        @Override
        public FieldReference constructOnExpression(Expression expr) {
            return FieldReference.newStructReference(this.offset(), expr);
        }

        @Override
        public FieldReference constructOnRoot(Type.Struct struct) {
            if (this.offset() >= struct.fields().size()) {
                throw new IllegalArgumentException(String.format("Field reference offset (%s) must be less than number of fields in struct (%s)", this.offset(), struct.fields().size()));
            }
            return FieldReference.newRootStructReference(this.offset(), struct.fields().get(this.offset()));
        }
    }

    public static interface ReferenceSegment {
        public FieldReference apply(FieldReference var1);

        public FieldReference constructOnExpression(Expression var1);

        public FieldReference constructOnRoot(Type.Struct var1);
    }

    private static class ListIndexFinder
    extends TypeVisitor.TypeThrowsVisitor<Type, RuntimeException> {
        private final int index;

        private ListIndexFinder(int index) {
            super("This visitor only supports retrieving array index offsets. Was applied to a non-array type.");
            this.index = index;
        }

        @Override
        public Type visit(Type.ListType expr) throws RuntimeException {
            return expr.elementType();
        }

        public static Type getReferencedType(Type type, int index) {
            return type.accept(new ListIndexFinder(index));
        }
    }

    @Value.Immutable
    public static abstract class ListElement
    implements ReferenceSegment {
        public abstract int offset();

        public static ListElement of(int index) {
            return ImmutableListElement.builder().offset(index).build();
        }

        @Override
        public FieldReference apply(FieldReference reference) {
            return reference.dereferenceList(this.offset());
        }

        @Override
        public FieldReference constructOnExpression(Expression expr) {
            return FieldReference.newListReference(this.offset(), expr);
        }

        @Override
        public FieldReference constructOnRoot(Type.Struct struct) {
            throw new UnsupportedOperationException();
        }
    }

    private static class MapKeyFinder
    extends TypeVisitor.TypeThrowsVisitor<Type, RuntimeException> {
        private final Type keyType;

        private MapKeyFinder(Type keyType) {
            super("This visitor only supports retrieving map values using map keys. Was applied to a non-map type.");
            this.keyType = keyType;
        }

        @Override
        public Type visit(Type.Map expr) throws RuntimeException {
            if (!expr.key().equals(this.keyType)) {
                throw new IllegalArgumentException(String.format("Key type %s of map does not matched expected type of %s.", expr.key(), this.keyType));
            }
            return expr.value();
        }

        public static Type getReferencedType(Type typeToDereference, Type keyType) {
            return typeToDereference.accept(new MapKeyFinder(keyType));
        }
    }

    @Value.Immutable
    public static abstract class MapKey
    implements ReferenceSegment {
        public abstract Expression.Literal key();

        public static MapKey of(Expression.Literal key) {
            return ImmutableMapKey.builder().key(key).build();
        }

        @Override
        public FieldReference apply(FieldReference reference) {
            return reference.dereferenceMap(this.key());
        }

        @Override
        public FieldReference constructOnExpression(Expression expr) {
            return FieldReference.newMapReference(this.key(), expr);
        }

        @Override
        public FieldReference constructOnRoot(Type.Struct struct) {
            throw new UnsupportedOperationException();
        }
    }
}

