/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.extension;

import io.substrait.extension.AdvancedExtension;
import io.substrait.relation.Extension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="AdvancedExtension", generator="Immutables")
@Immutable
public final class ImmutableAdvancedExtension
extends AdvancedExtension {
    private final List<Extension.Optimization> optimizations;
    @Nullable
    private final Extension.Enhancement enhancement;

    private ImmutableAdvancedExtension(List<Extension.Optimization> optimizations, @Nullable Extension.Enhancement enhancement) {
        this.optimizations = optimizations;
        this.enhancement = enhancement;
    }

    @Override
    public List<Extension.Optimization> getOptimizations() {
        return this.optimizations;
    }

    @Override
    public Optional<Extension.Enhancement> getEnhancement() {
        return Optional.ofNullable(this.enhancement);
    }

    public final ImmutableAdvancedExtension withOptimizations(Extension.Optimization ... elements) {
        List<Extension.Optimization> newValue = ImmutableAdvancedExtension.createUnmodifiableList(false, ImmutableAdvancedExtension.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableAdvancedExtension(newValue, this.enhancement);
    }

    public final ImmutableAdvancedExtension withOptimizations(Iterable<? extends Extension.Optimization> elements) {
        if (this.optimizations == elements) {
            return this;
        }
        List<Extension.Optimization> newValue = ImmutableAdvancedExtension.createUnmodifiableList(false, ImmutableAdvancedExtension.createSafeList(elements, true, false));
        return new ImmutableAdvancedExtension(newValue, this.enhancement);
    }

    public final ImmutableAdvancedExtension withEnhancement(Extension.Enhancement value) {
        Extension.Enhancement newValue = Objects.requireNonNull(value, "enhancement");
        if (this.enhancement == newValue) {
            return this;
        }
        return new ImmutableAdvancedExtension(this.optimizations, newValue);
    }

    public final ImmutableAdvancedExtension withEnhancement(Optional<? extends Extension.Enhancement> optional) {
        Extension.Enhancement value = optional.orElse(null);
        if (this.enhancement == value) {
            return this;
        }
        return new ImmutableAdvancedExtension(this.optimizations, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAdvancedExtension && this.equalTo(0, (ImmutableAdvancedExtension)another);
    }

    private boolean equalTo(int synthetic, ImmutableAdvancedExtension another) {
        return this.optimizations.equals(another.optimizations) && Objects.equals(this.enhancement, another.enhancement);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.optimizations.hashCode();
        h += (h << 5) + Objects.hashCode(this.enhancement);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("AdvancedExtension{");
        builder.append("optimizations=").append(this.optimizations);
        if (this.enhancement != null) {
            builder.append(", ");
            builder.append("enhancement=").append(this.enhancement);
        }
        return builder.append("}").toString();
    }

    public static ImmutableAdvancedExtension copyOf(AdvancedExtension instance) {
        if (instance instanceof ImmutableAdvancedExtension) {
            return (ImmutableAdvancedExtension)instance;
        }
        return ImmutableAdvancedExtension.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="AdvancedExtension", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private List<Extension.Optimization> optimizations = new ArrayList<Extension.Optimization>();
        @Nullable
        private Extension.Enhancement enhancement;

        private Builder() {
        }

        public final Builder from(AdvancedExtension instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllOptimizations(instance.getOptimizations());
            Optional<Extension.Enhancement> enhancementOptional = instance.getEnhancement();
            if (enhancementOptional.isPresent()) {
                this.enhancement(enhancementOptional);
            }
            return this;
        }

        public final Builder addOptimizations(Extension.Optimization element) {
            this.optimizations.add(Objects.requireNonNull(element, "optimizations element"));
            return this;
        }

        public final Builder addOptimizations(Extension.Optimization ... elements) {
            for (Extension.Optimization element : elements) {
                this.optimizations.add(Objects.requireNonNull(element, "optimizations element"));
            }
            return this;
        }

        public final Builder optimizations(Iterable<? extends Extension.Optimization> elements) {
            this.optimizations.clear();
            return this.addAllOptimizations(elements);
        }

        public final Builder addAllOptimizations(Iterable<? extends Extension.Optimization> elements) {
            for (Extension.Optimization optimization : elements) {
                this.optimizations.add(Objects.requireNonNull(optimization, "optimizations element"));
            }
            return this;
        }

        public final Builder enhancement(Extension.Enhancement enhancement) {
            this.enhancement = Objects.requireNonNull(enhancement, "enhancement");
            return this;
        }

        public final Builder enhancement(Optional<? extends Extension.Enhancement> enhancement) {
            this.enhancement = enhancement.orElse(null);
            return this;
        }

        public ImmutableAdvancedExtension build() {
            return new ImmutableAdvancedExtension(ImmutableAdvancedExtension.createUnmodifiableList(true, this.optimizations), this.enhancement);
        }
    }
}

