/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.extension;

import io.substrait.extension.AbstractExtensionLookup;
import io.substrait.extension.SimpleExtension;
import io.substrait.proto.ExtendedExpression;
import io.substrait.proto.Plan;
import io.substrait.proto.SimpleExtensionDeclaration;
import io.substrait.proto.SimpleExtensionURI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImmutableExtensionLookup
extends AbstractExtensionLookup {
    static final Logger logger = LoggerFactory.getLogger(ImmutableExtensionLookup.class);
    private int counter = -1;

    private ImmutableExtensionLookup(Map<Integer, SimpleExtension.FunctionAnchor> functionMap, Map<Integer, SimpleExtension.TypeAnchor> typeMap) {
        super(functionMap, typeMap);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Map<Integer, SimpleExtension.FunctionAnchor> functionMap = new HashMap<Integer, SimpleExtension.FunctionAnchor>();
        private final Map<Integer, SimpleExtension.TypeAnchor> typeMap = new HashMap<Integer, SimpleExtension.TypeAnchor>();

        public Builder from(Plan plan) {
            return this.from(plan.getExtensionUrisList(), plan.getExtensionsList());
        }

        public Builder from(ExtendedExpression extendedExpression) {
            return this.from(extendedExpression.getExtensionUrisList(), extendedExpression.getExtensionsList());
        }

        private Builder from(List<SimpleExtensionURI> simpleExtensionURIs, List<SimpleExtensionDeclaration> simpleExtensionDeclarations) {
            SimpleExtension.Anchor anchor;
            String name;
            String namespace;
            int reference;
            HashMap<Integer, String> namespaceMap = new HashMap<Integer, String>();
            for (SimpleExtensionURI simpleExtensionURI : simpleExtensionURIs) {
                namespaceMap.put(simpleExtensionURI.getExtensionUriAnchor(), simpleExtensionURI.getUri());
            }
            for (SimpleExtensionDeclaration simpleExtensionDeclaration : simpleExtensionDeclarations) {
                if (!simpleExtensionDeclaration.hasExtensionFunction()) continue;
                SimpleExtensionDeclaration.ExtensionFunction func = simpleExtensionDeclaration.getExtensionFunction();
                reference = func.getFunctionAnchor();
                namespace = (String)namespaceMap.get(func.getExtensionUriReference());
                if (namespace == null) {
                    throw new IllegalStateException("Could not find extension URI of " + func.getExtensionUriReference());
                }
                name = func.getName();
                anchor = SimpleExtension.FunctionAnchor.of(namespace, name);
                this.functionMap.put(reference, (SimpleExtension.FunctionAnchor)anchor);
            }
            for (SimpleExtensionDeclaration simpleExtensionDeclaration : simpleExtensionDeclarations) {
                if (!simpleExtensionDeclaration.hasExtensionType()) continue;
                SimpleExtensionDeclaration.ExtensionType type = simpleExtensionDeclaration.getExtensionType();
                reference = type.getTypeAnchor();
                namespace = (String)namespaceMap.get(type.getExtensionUriReference());
                if (namespace == null) {
                    throw new IllegalStateException("Could not find extension URI of " + type.getExtensionUriReference());
                }
                name = type.getName();
                anchor = SimpleExtension.TypeAnchor.of(namespace, name);
                this.typeMap.put(reference, (SimpleExtension.TypeAnchor)anchor);
            }
            return this;
        }

        public ImmutableExtensionLookup build() {
            return new ImmutableExtensionLookup(Collections.unmodifiableMap(this.functionMap), Collections.unmodifiableMap(this.typeMap));
        }
    }
}

