/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.extension;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.substrait.extension.SimpleExtension;
import io.substrait.function.ParameterizedType;
import io.substrait.function.TypeExpression;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="SimpleExtension", generator="Immutables")
public final class ImmutableSimpleExtension {
    private ImmutableSimpleExtension() {
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size() * 4 / 3 + 1);
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="SimpleExtension.ExtensionCollection", generator="Immutables")
    @Immutable
    public static final class ExtensionCollection
    extends SimpleExtension.ExtensionCollection {
        private final List<SimpleExtension.Type> types;
        private final List<SimpleExtension.ScalarFunctionVariant> scalarFunctions;
        private final List<SimpleExtension.AggregateFunctionVariant> aggregateFunctions;
        private final List<SimpleExtension.WindowFunctionVariant> windowFunctions;

        private ExtensionCollection(List<SimpleExtension.Type> types, List<SimpleExtension.ScalarFunctionVariant> scalarFunctions, List<SimpleExtension.AggregateFunctionVariant> aggregateFunctions, List<SimpleExtension.WindowFunctionVariant> windowFunctions) {
            this.types = types;
            this.scalarFunctions = scalarFunctions;
            this.aggregateFunctions = aggregateFunctions;
            this.windowFunctions = windowFunctions;
        }

        @Override
        public List<SimpleExtension.Type> types() {
            return this.types;
        }

        @Override
        public List<SimpleExtension.ScalarFunctionVariant> scalarFunctions() {
            return this.scalarFunctions;
        }

        @Override
        public List<SimpleExtension.AggregateFunctionVariant> aggregateFunctions() {
            return this.aggregateFunctions;
        }

        @Override
        public List<SimpleExtension.WindowFunctionVariant> windowFunctions() {
            return this.windowFunctions;
        }

        public final ExtensionCollection withTypes(SimpleExtension.Type ... elements) {
            List newValue = ImmutableSimpleExtension.createUnmodifiableList(false, ImmutableSimpleExtension.createSafeList(Arrays.asList(elements), true, false));
            return new ExtensionCollection(newValue, this.scalarFunctions, this.aggregateFunctions, this.windowFunctions);
        }

        public final ExtensionCollection withTypes(Iterable<? extends SimpleExtension.Type> elements) {
            if (this.types == elements) {
                return this;
            }
            List newValue = ImmutableSimpleExtension.createUnmodifiableList(false, ImmutableSimpleExtension.createSafeList(elements, true, false));
            return new ExtensionCollection(newValue, this.scalarFunctions, this.aggregateFunctions, this.windowFunctions);
        }

        public final ExtensionCollection withScalarFunctions(SimpleExtension.ScalarFunctionVariant ... elements) {
            List newValue = ImmutableSimpleExtension.createUnmodifiableList(false, ImmutableSimpleExtension.createSafeList(Arrays.asList(elements), true, false));
            return new ExtensionCollection(this.types, newValue, this.aggregateFunctions, this.windowFunctions);
        }

        public final ExtensionCollection withScalarFunctions(Iterable<? extends SimpleExtension.ScalarFunctionVariant> elements) {
            if (this.scalarFunctions == elements) {
                return this;
            }
            List newValue = ImmutableSimpleExtension.createUnmodifiableList(false, ImmutableSimpleExtension.createSafeList(elements, true, false));
            return new ExtensionCollection(this.types, newValue, this.aggregateFunctions, this.windowFunctions);
        }

        public final ExtensionCollection withAggregateFunctions(SimpleExtension.AggregateFunctionVariant ... elements) {
            List newValue = ImmutableSimpleExtension.createUnmodifiableList(false, ImmutableSimpleExtension.createSafeList(Arrays.asList(elements), true, false));
            return new ExtensionCollection(this.types, this.scalarFunctions, newValue, this.windowFunctions);
        }

        public final ExtensionCollection withAggregateFunctions(Iterable<? extends SimpleExtension.AggregateFunctionVariant> elements) {
            if (this.aggregateFunctions == elements) {
                return this;
            }
            List newValue = ImmutableSimpleExtension.createUnmodifiableList(false, ImmutableSimpleExtension.createSafeList(elements, true, false));
            return new ExtensionCollection(this.types, this.scalarFunctions, newValue, this.windowFunctions);
        }

        public final ExtensionCollection withWindowFunctions(SimpleExtension.WindowFunctionVariant ... elements) {
            List newValue = ImmutableSimpleExtension.createUnmodifiableList(false, ImmutableSimpleExtension.createSafeList(Arrays.asList(elements), true, false));
            return new ExtensionCollection(this.types, this.scalarFunctions, this.aggregateFunctions, newValue);
        }

        public final ExtensionCollection withWindowFunctions(Iterable<? extends SimpleExtension.WindowFunctionVariant> elements) {
            if (this.windowFunctions == elements) {
                return this;
            }
            List newValue = ImmutableSimpleExtension.createUnmodifiableList(false, ImmutableSimpleExtension.createSafeList(elements, true, false));
            return new ExtensionCollection(this.types, this.scalarFunctions, this.aggregateFunctions, newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof ExtensionCollection && this.equalTo(0, (ExtensionCollection)another);
        }

        private boolean equalTo(int synthetic, ExtensionCollection another) {
            return this.types.equals(another.types) && this.scalarFunctions.equals(another.scalarFunctions) && this.aggregateFunctions.equals(another.aggregateFunctions) && this.windowFunctions.equals(another.windowFunctions);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.types.hashCode();
            h += (h << 5) + this.scalarFunctions.hashCode();
            h += (h << 5) + this.aggregateFunctions.hashCode();
            h += (h << 5) + this.windowFunctions.hashCode();
            return h;
        }

        public String toString() {
            return "ExtensionCollection{types=" + this.types + ", scalarFunctions=" + this.scalarFunctions + ", aggregateFunctions=" + this.aggregateFunctions + ", windowFunctions=" + this.windowFunctions + "}";
        }

        public static ExtensionCollection copyOf(SimpleExtension.ExtensionCollection instance) {
            if (instance instanceof ExtensionCollection) {
                return (ExtensionCollection)instance;
            }
            return ExtensionCollection.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="SimpleExtension.ExtensionCollection", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private List<SimpleExtension.Type> types = new ArrayList<SimpleExtension.Type>();
            private List<SimpleExtension.ScalarFunctionVariant> scalarFunctions = new ArrayList<SimpleExtension.ScalarFunctionVariant>();
            private List<SimpleExtension.AggregateFunctionVariant> aggregateFunctions = new ArrayList<SimpleExtension.AggregateFunctionVariant>();
            private List<SimpleExtension.WindowFunctionVariant> windowFunctions = new ArrayList<SimpleExtension.WindowFunctionVariant>();

            private Builder() {
            }

            public final Builder from(SimpleExtension.ExtensionCollection instance) {
                Objects.requireNonNull(instance, "instance");
                this.addAllTypes(instance.types());
                this.addAllScalarFunctions(instance.scalarFunctions());
                this.addAllAggregateFunctions(instance.aggregateFunctions());
                this.addAllWindowFunctions(instance.windowFunctions());
                return this;
            }

            public final Builder addTypes(SimpleExtension.Type element) {
                this.types.add(Objects.requireNonNull(element, "types element"));
                return this;
            }

            public final Builder addTypes(SimpleExtension.Type ... elements) {
                for (SimpleExtension.Type element : elements) {
                    this.types.add(Objects.requireNonNull(element, "types element"));
                }
                return this;
            }

            public final Builder types(Iterable<? extends SimpleExtension.Type> elements) {
                this.types.clear();
                return this.addAllTypes(elements);
            }

            public final Builder addAllTypes(Iterable<? extends SimpleExtension.Type> elements) {
                for (SimpleExtension.Type type : elements) {
                    this.types.add(Objects.requireNonNull(type, "types element"));
                }
                return this;
            }

            public final Builder addScalarFunctions(SimpleExtension.ScalarFunctionVariant element) {
                this.scalarFunctions.add(Objects.requireNonNull(element, "scalarFunctions element"));
                return this;
            }

            public final Builder addScalarFunctions(SimpleExtension.ScalarFunctionVariant ... elements) {
                for (SimpleExtension.ScalarFunctionVariant element : elements) {
                    this.scalarFunctions.add(Objects.requireNonNull(element, "scalarFunctions element"));
                }
                return this;
            }

            public final Builder scalarFunctions(Iterable<? extends SimpleExtension.ScalarFunctionVariant> elements) {
                this.scalarFunctions.clear();
                return this.addAllScalarFunctions(elements);
            }

            public final Builder addAllScalarFunctions(Iterable<? extends SimpleExtension.ScalarFunctionVariant> elements) {
                for (SimpleExtension.ScalarFunctionVariant scalarFunctionVariant : elements) {
                    this.scalarFunctions.add(Objects.requireNonNull(scalarFunctionVariant, "scalarFunctions element"));
                }
                return this;
            }

            public final Builder addAggregateFunctions(SimpleExtension.AggregateFunctionVariant element) {
                this.aggregateFunctions.add(Objects.requireNonNull(element, "aggregateFunctions element"));
                return this;
            }

            public final Builder addAggregateFunctions(SimpleExtension.AggregateFunctionVariant ... elements) {
                for (SimpleExtension.AggregateFunctionVariant element : elements) {
                    this.aggregateFunctions.add(Objects.requireNonNull(element, "aggregateFunctions element"));
                }
                return this;
            }

            public final Builder aggregateFunctions(Iterable<? extends SimpleExtension.AggregateFunctionVariant> elements) {
                this.aggregateFunctions.clear();
                return this.addAllAggregateFunctions(elements);
            }

            public final Builder addAllAggregateFunctions(Iterable<? extends SimpleExtension.AggregateFunctionVariant> elements) {
                for (SimpleExtension.AggregateFunctionVariant aggregateFunctionVariant : elements) {
                    this.aggregateFunctions.add(Objects.requireNonNull(aggregateFunctionVariant, "aggregateFunctions element"));
                }
                return this;
            }

            public final Builder addWindowFunctions(SimpleExtension.WindowFunctionVariant element) {
                this.windowFunctions.add(Objects.requireNonNull(element, "windowFunctions element"));
                return this;
            }

            public final Builder addWindowFunctions(SimpleExtension.WindowFunctionVariant ... elements) {
                for (SimpleExtension.WindowFunctionVariant element : elements) {
                    this.windowFunctions.add(Objects.requireNonNull(element, "windowFunctions element"));
                }
                return this;
            }

            public final Builder windowFunctions(Iterable<? extends SimpleExtension.WindowFunctionVariant> elements) {
                this.windowFunctions.clear();
                return this.addAllWindowFunctions(elements);
            }

            public final Builder addAllWindowFunctions(Iterable<? extends SimpleExtension.WindowFunctionVariant> elements) {
                for (SimpleExtension.WindowFunctionVariant windowFunctionVariant : elements) {
                    this.windowFunctions.add(Objects.requireNonNull(windowFunctionVariant, "windowFunctions element"));
                }
                return this;
            }

            public ExtensionCollection build() {
                return new ExtensionCollection(ImmutableSimpleExtension.createUnmodifiableList(true, this.types), ImmutableSimpleExtension.createUnmodifiableList(true, this.scalarFunctions), ImmutableSimpleExtension.createUnmodifiableList(true, this.aggregateFunctions), ImmutableSimpleExtension.createUnmodifiableList(true, this.windowFunctions));
            }
        }
    }

    @Generated(from="SimpleExtension.ExtensionSignatures", generator="Immutables")
    @Immutable
    public static final class ExtensionSignatures
    extends SimpleExtension.ExtensionSignatures {
        private final List<SimpleExtension.Type> types;
        private final List<SimpleExtension.ScalarFunction> scalars;
        private final List<SimpleExtension.AggregateFunction> aggregates;
        private final List<SimpleExtension.WindowFunction> windows;

        private ExtensionSignatures(List<SimpleExtension.Type> types, List<SimpleExtension.ScalarFunction> scalars, List<SimpleExtension.AggregateFunction> aggregates, List<SimpleExtension.WindowFunction> windows) {
            this.types = types;
            this.scalars = scalars;
            this.aggregates = aggregates;
            this.windows = windows;
        }

        @Override
        @JsonProperty(value="types")
        public List<SimpleExtension.Type> types() {
            return this.types;
        }

        @Override
        @JsonProperty(value="scalar_functions")
        public List<SimpleExtension.ScalarFunction> scalars() {
            return this.scalars;
        }

        @Override
        @JsonProperty(value="aggregate_functions")
        public List<SimpleExtension.AggregateFunction> aggregates() {
            return this.aggregates;
        }

        @Override
        @JsonProperty(value="window_functions")
        public List<SimpleExtension.WindowFunction> windows() {
            return this.windows;
        }

        public final ExtensionSignatures withTypes(SimpleExtension.Type ... elements) {
            List newValue = ImmutableSimpleExtension.createUnmodifiableList(false, ImmutableSimpleExtension.createSafeList(Arrays.asList(elements), true, false));
            return new ExtensionSignatures(newValue, this.scalars, this.aggregates, this.windows);
        }

        public final ExtensionSignatures withTypes(Iterable<? extends SimpleExtension.Type> elements) {
            if (this.types == elements) {
                return this;
            }
            List newValue = ImmutableSimpleExtension.createUnmodifiableList(false, ImmutableSimpleExtension.createSafeList(elements, true, false));
            return new ExtensionSignatures(newValue, this.scalars, this.aggregates, this.windows);
        }

        public final ExtensionSignatures withScalars(SimpleExtension.ScalarFunction ... elements) {
            List newValue = ImmutableSimpleExtension.createUnmodifiableList(false, ImmutableSimpleExtension.createSafeList(Arrays.asList(elements), true, false));
            return new ExtensionSignatures(this.types, newValue, this.aggregates, this.windows);
        }

        public final ExtensionSignatures withScalars(Iterable<? extends SimpleExtension.ScalarFunction> elements) {
            if (this.scalars == elements) {
                return this;
            }
            List newValue = ImmutableSimpleExtension.createUnmodifiableList(false, ImmutableSimpleExtension.createSafeList(elements, true, false));
            return new ExtensionSignatures(this.types, newValue, this.aggregates, this.windows);
        }

        public final ExtensionSignatures withAggregates(SimpleExtension.AggregateFunction ... elements) {
            List newValue = ImmutableSimpleExtension.createUnmodifiableList(false, ImmutableSimpleExtension.createSafeList(Arrays.asList(elements), true, false));
            return new ExtensionSignatures(this.types, this.scalars, newValue, this.windows);
        }

        public final ExtensionSignatures withAggregates(Iterable<? extends SimpleExtension.AggregateFunction> elements) {
            if (this.aggregates == elements) {
                return this;
            }
            List newValue = ImmutableSimpleExtension.createUnmodifiableList(false, ImmutableSimpleExtension.createSafeList(elements, true, false));
            return new ExtensionSignatures(this.types, this.scalars, newValue, this.windows);
        }

        public final ExtensionSignatures withWindows(SimpleExtension.WindowFunction ... elements) {
            List newValue = ImmutableSimpleExtension.createUnmodifiableList(false, ImmutableSimpleExtension.createSafeList(Arrays.asList(elements), true, false));
            return new ExtensionSignatures(this.types, this.scalars, this.aggregates, newValue);
        }

        public final ExtensionSignatures withWindows(Iterable<? extends SimpleExtension.WindowFunction> elements) {
            if (this.windows == elements) {
                return this;
            }
            List newValue = ImmutableSimpleExtension.createUnmodifiableList(false, ImmutableSimpleExtension.createSafeList(elements, true, false));
            return new ExtensionSignatures(this.types, this.scalars, this.aggregates, newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof ExtensionSignatures && this.equalTo(0, (ExtensionSignatures)another);
        }

        private boolean equalTo(int synthetic, ExtensionSignatures another) {
            return this.types.equals(another.types) && this.scalars.equals(another.scalars) && this.aggregates.equals(another.aggregates) && this.windows.equals(another.windows);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.types.hashCode();
            h += (h << 5) + this.scalars.hashCode();
            h += (h << 5) + this.aggregates.hashCode();
            h += (h << 5) + this.windows.hashCode();
            return h;
        }

        public String toString() {
            return "ExtensionSignatures{types=" + this.types + ", scalars=" + this.scalars + ", aggregates=" + this.aggregates + ", windows=" + this.windows + "}";
        }

        @Deprecated
        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        static ExtensionSignatures fromJson(Json json) {
            Builder builder = ExtensionSignatures.builder();
            if (json.types != null) {
                builder.addAllTypes(json.types);
            }
            if (json.scalars != null) {
                builder.addAllScalars(json.scalars);
            }
            if (json.aggregates != null) {
                builder.addAllAggregates(json.aggregates);
            }
            if (json.windows != null) {
                builder.addAllWindows(json.windows);
            }
            return builder.build();
        }

        public static ExtensionSignatures copyOf(SimpleExtension.ExtensionSignatures instance) {
            if (instance instanceof ExtensionSignatures) {
                return (ExtensionSignatures)instance;
            }
            return ExtensionSignatures.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="SimpleExtension.ExtensionSignatures", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private List<SimpleExtension.Type> types = new ArrayList<SimpleExtension.Type>();
            private List<SimpleExtension.ScalarFunction> scalars = new ArrayList<SimpleExtension.ScalarFunction>();
            private List<SimpleExtension.AggregateFunction> aggregates = new ArrayList<SimpleExtension.AggregateFunction>();
            private List<SimpleExtension.WindowFunction> windows = new ArrayList<SimpleExtension.WindowFunction>();

            private Builder() {
            }

            public final Builder from(SimpleExtension.ExtensionSignatures instance) {
                Objects.requireNonNull(instance, "instance");
                this.addAllTypes(instance.types());
                this.addAllScalars(instance.scalars());
                this.addAllAggregates(instance.aggregates());
                this.addAllWindows(instance.windows());
                return this;
            }

            public final Builder addTypes(SimpleExtension.Type element) {
                this.types.add(Objects.requireNonNull(element, "types element"));
                return this;
            }

            public final Builder addTypes(SimpleExtension.Type ... elements) {
                for (SimpleExtension.Type element : elements) {
                    this.types.add(Objects.requireNonNull(element, "types element"));
                }
                return this;
            }

            @JsonProperty(value="types")
            public final Builder types(Iterable<? extends SimpleExtension.Type> elements) {
                this.types.clear();
                return this.addAllTypes(elements);
            }

            public final Builder addAllTypes(Iterable<? extends SimpleExtension.Type> elements) {
                for (SimpleExtension.Type type : elements) {
                    this.types.add(Objects.requireNonNull(type, "types element"));
                }
                return this;
            }

            public final Builder addScalars(SimpleExtension.ScalarFunction element) {
                this.scalars.add(Objects.requireNonNull(element, "scalars element"));
                return this;
            }

            public final Builder addScalars(SimpleExtension.ScalarFunction ... elements) {
                for (SimpleExtension.ScalarFunction element : elements) {
                    this.scalars.add(Objects.requireNonNull(element, "scalars element"));
                }
                return this;
            }

            @JsonProperty(value="scalar_functions")
            public final Builder scalars(Iterable<? extends SimpleExtension.ScalarFunction> elements) {
                this.scalars.clear();
                return this.addAllScalars(elements);
            }

            public final Builder addAllScalars(Iterable<? extends SimpleExtension.ScalarFunction> elements) {
                for (SimpleExtension.ScalarFunction scalarFunction : elements) {
                    this.scalars.add(Objects.requireNonNull(scalarFunction, "scalars element"));
                }
                return this;
            }

            public final Builder addAggregates(SimpleExtension.AggregateFunction element) {
                this.aggregates.add(Objects.requireNonNull(element, "aggregates element"));
                return this;
            }

            public final Builder addAggregates(SimpleExtension.AggregateFunction ... elements) {
                for (SimpleExtension.AggregateFunction element : elements) {
                    this.aggregates.add(Objects.requireNonNull(element, "aggregates element"));
                }
                return this;
            }

            @JsonProperty(value="aggregate_functions")
            public final Builder aggregates(Iterable<? extends SimpleExtension.AggregateFunction> elements) {
                this.aggregates.clear();
                return this.addAllAggregates(elements);
            }

            public final Builder addAllAggregates(Iterable<? extends SimpleExtension.AggregateFunction> elements) {
                for (SimpleExtension.AggregateFunction aggregateFunction : elements) {
                    this.aggregates.add(Objects.requireNonNull(aggregateFunction, "aggregates element"));
                }
                return this;
            }

            public final Builder addWindows(SimpleExtension.WindowFunction element) {
                this.windows.add(Objects.requireNonNull(element, "windows element"));
                return this;
            }

            public final Builder addWindows(SimpleExtension.WindowFunction ... elements) {
                for (SimpleExtension.WindowFunction element : elements) {
                    this.windows.add(Objects.requireNonNull(element, "windows element"));
                }
                return this;
            }

            @JsonProperty(value="window_functions")
            public final Builder windows(Iterable<? extends SimpleExtension.WindowFunction> elements) {
                this.windows.clear();
                return this.addAllWindows(elements);
            }

            public final Builder addAllWindows(Iterable<? extends SimpleExtension.WindowFunction> elements) {
                for (SimpleExtension.WindowFunction windowFunction : elements) {
                    this.windows.add(Objects.requireNonNull(windowFunction, "windows element"));
                }
                return this;
            }

            public ExtensionSignatures build() {
                return new ExtensionSignatures(ImmutableSimpleExtension.createUnmodifiableList(true, this.types), ImmutableSimpleExtension.createUnmodifiableList(true, this.scalars), ImmutableSimpleExtension.createUnmodifiableList(true, this.aggregates), ImmutableSimpleExtension.createUnmodifiableList(true, this.windows));
            }
        }

        @Deprecated
        @JsonDeserialize
        @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
        @Generated(from="SimpleExtension.ExtensionSignatures", generator="Immutables")
        static final class Json
        extends SimpleExtension.ExtensionSignatures {
            @Nullable
            List<SimpleExtension.Type> types = Collections.emptyList();
            @Nullable
            List<SimpleExtension.ScalarFunction> scalars = Collections.emptyList();
            @Nullable
            List<SimpleExtension.AggregateFunction> aggregates = Collections.emptyList();
            @Nullable
            List<SimpleExtension.WindowFunction> windows = Collections.emptyList();

            Json() {
            }

            @JsonProperty(value="types")
            public void setTypes(List<SimpleExtension.Type> types) {
                this.types = types;
            }

            @JsonProperty(value="scalar_functions")
            public void setScalars(List<SimpleExtension.ScalarFunction> scalars) {
                this.scalars = scalars;
            }

            @JsonProperty(value="aggregate_functions")
            public void setAggregates(List<SimpleExtension.AggregateFunction> aggregates) {
                this.aggregates = aggregates;
            }

            @JsonProperty(value="window_functions")
            public void setWindows(List<SimpleExtension.WindowFunction> windows) {
                this.windows = windows;
            }

            @Override
            public List<SimpleExtension.Type> types() {
                throw new UnsupportedOperationException();
            }

            @Override
            public List<SimpleExtension.ScalarFunction> scalars() {
                throw new UnsupportedOperationException();
            }

            @Override
            public List<SimpleExtension.AggregateFunction> aggregates() {
                throw new UnsupportedOperationException();
            }

            @Override
            public List<SimpleExtension.WindowFunction> windows() {
                throw new UnsupportedOperationException();
            }
        }
    }

    @Generated(from="SimpleExtension.Type", generator="Immutables")
    @Immutable
    public static final class Type
    extends SimpleExtension.Type {
        private final String name;
        private final String uri;
        @Nullable
        private final Object structure;

        private Type(String name, String uri, @Nullable Object structure) {
            this.name = name;
            this.uri = uri;
            this.structure = structure;
        }

        @Override
        @JsonProperty(value="name")
        public String name() {
            return this.name;
        }

        @Override
        @JsonProperty(value="uri")
        @JacksonInject(value="uri")
        public String uri() {
            return this.uri;
        }

        @Override
        @JsonProperty(value="structure")
        protected Optional<Object> structure() {
            return Optional.ofNullable(this.structure);
        }

        public final Type withName(String value) {
            String newValue = Objects.requireNonNull(value, "name");
            if (this.name.equals(newValue)) {
                return this;
            }
            return new Type(newValue, this.uri, this.structure);
        }

        public final Type withUri(String value) {
            String newValue = Objects.requireNonNull(value, "uri");
            if (this.uri.equals(newValue)) {
                return this;
            }
            return new Type(this.name, newValue, this.structure);
        }

        public final Type withStructure(Object value) {
            Object newValue = Objects.requireNonNull(value, "structure");
            if (this.structure == newValue) {
                return this;
            }
            return new Type(this.name, this.uri, newValue);
        }

        public final Type withStructure(Optional<? extends Object> optional) {
            Object value = optional.orElse(null);
            if (this.structure == value) {
                return this;
            }
            return new Type(this.name, this.uri, value);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Type && this.equalTo(0, (Type)another);
        }

        private boolean equalTo(int synthetic, Type another) {
            return this.name.equals(another.name) && this.uri.equals(another.uri) && Objects.equals(this.structure, another.structure);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.name.hashCode();
            h += (h << 5) + this.uri.hashCode();
            h += (h << 5) + Objects.hashCode(this.structure);
            return h;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("Type{");
            builder.append("name=").append(this.name);
            builder.append(", ");
            builder.append("uri=").append(this.uri);
            if (this.structure != null) {
                builder.append(", ");
                builder.append("structure=").append(this.structure);
            }
            return builder.append("}").toString();
        }

        @Deprecated
        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        static Type fromJson(Json json) {
            Builder builder = Type.builder();
            if (json.name != null) {
                builder.name(json.name);
            }
            if (json.uri != null) {
                builder.uri(json.uri);
            }
            if (json.structure != null) {
                builder.structure(json.structure);
            }
            return builder.build();
        }

        public static Type copyOf(SimpleExtension.Type instance) {
            if (instance instanceof Type) {
                return (Type)instance;
            }
            return Type.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="SimpleExtension.Type", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_NAME = 1L;
            private static final long INIT_BIT_URI = 2L;
            private long initBits = 3L;
            @Nullable
            private String name;
            @Nullable
            private String uri;
            @Nullable
            private Object structure;

            private Builder() {
            }

            public final Builder from(SimpleExtension.Type instance) {
                Objects.requireNonNull(instance, "instance");
                this.name(instance.name());
                this.uri(instance.uri());
                Optional<Object> structureOptional = instance.structure();
                if (structureOptional.isPresent()) {
                    this.structure(structureOptional);
                }
                return this;
            }

            @JsonProperty(value="name")
            public final Builder name(String name) {
                this.name = Objects.requireNonNull(name, "name");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            @JsonProperty(value="uri")
            @JacksonInject(value="uri")
            public final Builder uri(String uri) {
                this.uri = Objects.requireNonNull(uri, "uri");
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            public final Builder structure(Object structure) {
                this.structure = Objects.requireNonNull(structure, "structure");
                return this;
            }

            @JsonProperty(value="structure")
            public final Builder structure(Optional<? extends Object> structure) {
                this.structure = structure.orElse(null);
                return this;
            }

            public Type build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new Type(this.name, this.uri, this.structure);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("name");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("uri");
                }
                return "Cannot build Type, some of required attributes are not set " + attributes;
            }
        }

        @Deprecated
        @JsonDeserialize
        @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
        @Generated(from="SimpleExtension.Type", generator="Immutables")
        static final class Json
        extends SimpleExtension.Type {
            @Nullable
            String name;
            @Nullable
            String uri;
            @Nullable
            Optional<Object> structure = Optional.empty();

            Json() {
            }

            @JsonProperty(value="name")
            public void setName(String name) {
                this.name = name;
            }

            @JsonProperty(value="uri")
            @JacksonInject(value="uri")
            public void setUri(String uri) {
                this.uri = uri;
            }

            @JsonProperty(value="structure")
            public void setStructure(Optional<Object> structure) {
                this.structure = structure;
            }

            @Override
            public String name() {
                throw new UnsupportedOperationException();
            }

            @Override
            public String uri() {
                throw new UnsupportedOperationException();
            }

            @Override
            protected Optional<Object> structure() {
                throw new UnsupportedOperationException();
            }
        }
    }

    @Generated(from="SimpleExtension.WindowFunctionVariant", generator="Immutables")
    @Immutable
    public static final class WindowFunctionVariant
    extends SimpleExtension.WindowFunctionVariant {
        private final String name;
        private final String uri;
        @Nullable
        private final SimpleExtension.VariadicBehavior variadic;
        @Nullable
        private final String description;
        private final List<SimpleExtension.Argument> args;
        private final Map<String, SimpleExtension.Option> options;
        private final SimpleExtension.Nullability nullability;
        @Nullable
        private final Boolean ordered;
        private final TypeExpression returnType;
        private final SimpleExtension.Decomposability decomposability;
        @Nullable
        private final TypeExpression intermediate;
        private final SimpleExtension.WindowType windowType;
        private static final byte STAGE_INITIALIZING = -1;
        private static final byte STAGE_UNINITIALIZED = 0;
        private static final byte STAGE_INITIALIZED = 1;
        private volatile transient InitShim initShim = new InitShim();

        private WindowFunctionVariant(Builder builder) {
            this.variadic = builder.variadic;
            this.args = ImmutableSimpleExtension.createUnmodifiableList(true, builder.args);
            this.options = ImmutableSimpleExtension.createUnmodifiableMap(false, false, builder.options);
            this.ordered = builder.ordered;
            this.returnType = builder.returnType;
            this.intermediate = builder.intermediate;
            if (builder.name != null) {
                this.initShim.name(builder.name);
            }
            if (builder.uri != null) {
                this.initShim.uri(builder.uri);
            }
            if (builder.descriptionIsSet()) {
                this.initShim.description(builder.description);
            }
            if (builder.nullability != null) {
                this.initShim.nullability(builder.nullability);
            }
            if (builder.decomposability != null) {
                this.initShim.decomposability(builder.decomposability);
            }
            if (builder.windowType != null) {
                this.initShim.windowType(builder.windowType);
            }
            this.name = this.initShim.name();
            this.uri = this.initShim.uri();
            this.description = this.initShim.description();
            this.nullability = this.initShim.nullability();
            this.decomposability = this.initShim.decomposability();
            this.windowType = this.initShim.windowType();
            this.initShim = null;
        }

        private WindowFunctionVariant(String name, String uri, @Nullable SimpleExtension.VariadicBehavior variadic, @Nullable String description, List<SimpleExtension.Argument> args, Map<String, SimpleExtension.Option> options, SimpleExtension.Nullability nullability, @Nullable Boolean ordered, TypeExpression returnType, SimpleExtension.Decomposability decomposability, @Nullable TypeExpression intermediate, SimpleExtension.WindowType windowType) {
            this.name = name;
            this.uri = uri;
            this.variadic = variadic;
            this.description = description;
            this.args = args;
            this.options = options;
            this.nullability = nullability;
            this.ordered = ordered;
            this.returnType = returnType;
            this.decomposability = decomposability;
            this.intermediate = intermediate;
            this.windowType = windowType;
            this.initShim = null;
        }

        @Override
        @JsonProperty(value="name")
        public String name() {
            InitShim shim = this.initShim;
            return shim != null ? shim.name() : this.name;
        }

        @Override
        @JsonProperty(value="uri")
        public String uri() {
            InitShim shim = this.initShim;
            return shim != null ? shim.uri() : this.uri;
        }

        @Override
        @JsonProperty(value="variadic")
        public Optional<SimpleExtension.VariadicBehavior> variadic() {
            return Optional.ofNullable(this.variadic);
        }

        @Override
        @JsonProperty(value="description")
        @Nullable
        public String description() {
            InitShim shim = this.initShim;
            return shim != null ? shim.description() : this.description;
        }

        @Override
        @JsonProperty(value="args")
        public List<SimpleExtension.Argument> args() {
            return this.args;
        }

        @Override
        @JsonProperty(value="options")
        public Map<String, SimpleExtension.Option> options() {
            return this.options;
        }

        @Override
        @JsonProperty(value="nullability")
        public SimpleExtension.Nullability nullability() {
            InitShim shim = this.initShim;
            return shim != null ? shim.nullability() : this.nullability;
        }

        @Override
        @JsonProperty(value="ordered")
        @Nullable
        public Boolean ordered() {
            return this.ordered;
        }

        @Override
        @JsonProperty(value="return")
        public TypeExpression returnType() {
            return this.returnType;
        }

        @Override
        @JsonProperty(value="decomposable")
        public SimpleExtension.Decomposability decomposability() {
            InitShim shim = this.initShim;
            return shim != null ? shim.decomposability() : this.decomposability;
        }

        @Override
        @JsonProperty(value="intermediate")
        @Nullable
        public TypeExpression intermediate() {
            return this.intermediate;
        }

        @Override
        @JsonProperty(value="window_type")
        public SimpleExtension.WindowType windowType() {
            InitShim shim = this.initShim;
            return shim != null ? shim.windowType() : this.windowType;
        }

        public final WindowFunctionVariant withName(String value) {
            String newValue = Objects.requireNonNull(value, "name");
            if (this.name.equals(newValue)) {
                return this;
            }
            return new WindowFunctionVariant(newValue, this.uri, this.variadic, this.description, this.args, this.options, this.nullability, this.ordered, this.returnType, this.decomposability, this.intermediate, this.windowType);
        }

        public final WindowFunctionVariant withUri(String value) {
            String newValue = Objects.requireNonNull(value, "uri");
            if (this.uri.equals(newValue)) {
                return this;
            }
            return new WindowFunctionVariant(this.name, newValue, this.variadic, this.description, this.args, this.options, this.nullability, this.ordered, this.returnType, this.decomposability, this.intermediate, this.windowType);
        }

        public final WindowFunctionVariant withVariadic(SimpleExtension.VariadicBehavior value) {
            SimpleExtension.VariadicBehavior newValue = Objects.requireNonNull(value, "variadic");
            if (this.variadic == newValue) {
                return this;
            }
            return new WindowFunctionVariant(this.name, this.uri, newValue, this.description, this.args, this.options, this.nullability, this.ordered, this.returnType, this.decomposability, this.intermediate, this.windowType);
        }

        public final WindowFunctionVariant withVariadic(Optional<? extends SimpleExtension.VariadicBehavior> optional) {
            SimpleExtension.VariadicBehavior value = optional.orElse(null);
            if (this.variadic == value) {
                return this;
            }
            return new WindowFunctionVariant(this.name, this.uri, value, this.description, this.args, this.options, this.nullability, this.ordered, this.returnType, this.decomposability, this.intermediate, this.windowType);
        }

        public final WindowFunctionVariant withDescription(@Nullable String value) {
            if (Objects.equals(this.description, value)) {
                return this;
            }
            return new WindowFunctionVariant(this.name, this.uri, this.variadic, value, this.args, this.options, this.nullability, this.ordered, this.returnType, this.decomposability, this.intermediate, this.windowType);
        }

        public final WindowFunctionVariant withArgs(SimpleExtension.Argument ... elements) {
            List newValue = ImmutableSimpleExtension.createUnmodifiableList(false, ImmutableSimpleExtension.createSafeList(Arrays.asList(elements), true, false));
            return new WindowFunctionVariant(this.name, this.uri, this.variadic, this.description, newValue, this.options, this.nullability, this.ordered, this.returnType, this.decomposability, this.intermediate, this.windowType);
        }

        public final WindowFunctionVariant withArgs(Iterable<? extends SimpleExtension.Argument> elements) {
            if (this.args == elements) {
                return this;
            }
            List newValue = ImmutableSimpleExtension.createUnmodifiableList(false, ImmutableSimpleExtension.createSafeList(elements, true, false));
            return new WindowFunctionVariant(this.name, this.uri, this.variadic, this.description, newValue, this.options, this.nullability, this.ordered, this.returnType, this.decomposability, this.intermediate, this.windowType);
        }

        public final WindowFunctionVariant withOptions(Map<String, ? extends SimpleExtension.Option> entries) {
            if (this.options == entries) {
                return this;
            }
            Map newValue = ImmutableSimpleExtension.createUnmodifiableMap(true, false, entries);
            return new WindowFunctionVariant(this.name, this.uri, this.variadic, this.description, this.args, newValue, this.nullability, this.ordered, this.returnType, this.decomposability, this.intermediate, this.windowType);
        }

        public final WindowFunctionVariant withNullability(SimpleExtension.Nullability value) {
            SimpleExtension.Nullability newValue = Objects.requireNonNull(value, "nullability");
            if (this.nullability == newValue) {
                return this;
            }
            return new WindowFunctionVariant(this.name, this.uri, this.variadic, this.description, this.args, this.options, newValue, this.ordered, this.returnType, this.decomposability, this.intermediate, this.windowType);
        }

        public final WindowFunctionVariant withOrdered(@Nullable Boolean value) {
            if (Objects.equals(this.ordered, value)) {
                return this;
            }
            return new WindowFunctionVariant(this.name, this.uri, this.variadic, this.description, this.args, this.options, this.nullability, value, this.returnType, this.decomposability, this.intermediate, this.windowType);
        }

        public final WindowFunctionVariant withReturnType(TypeExpression value) {
            if (this.returnType == value) {
                return this;
            }
            TypeExpression newValue = Objects.requireNonNull(value, "returnType");
            return new WindowFunctionVariant(this.name, this.uri, this.variadic, this.description, this.args, this.options, this.nullability, this.ordered, newValue, this.decomposability, this.intermediate, this.windowType);
        }

        public final WindowFunctionVariant withDecomposability(SimpleExtension.Decomposability value) {
            SimpleExtension.Decomposability newValue = Objects.requireNonNull(value, "decomposability");
            if (this.decomposability == newValue) {
                return this;
            }
            return new WindowFunctionVariant(this.name, this.uri, this.variadic, this.description, this.args, this.options, this.nullability, this.ordered, this.returnType, newValue, this.intermediate, this.windowType);
        }

        public final WindowFunctionVariant withIntermediate(@Nullable TypeExpression value) {
            if (this.intermediate == value) {
                return this;
            }
            return new WindowFunctionVariant(this.name, this.uri, this.variadic, this.description, this.args, this.options, this.nullability, this.ordered, this.returnType, this.decomposability, value, this.windowType);
        }

        public final WindowFunctionVariant withWindowType(SimpleExtension.WindowType value) {
            SimpleExtension.WindowType newValue = Objects.requireNonNull(value, "windowType");
            if (this.windowType == newValue) {
                return this;
            }
            return new WindowFunctionVariant(this.name, this.uri, this.variadic, this.description, this.args, this.options, this.nullability, this.ordered, this.returnType, this.decomposability, this.intermediate, newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof WindowFunctionVariant && this.equalTo(0, (WindowFunctionVariant)another);
        }

        private boolean equalTo(int synthetic, WindowFunctionVariant another) {
            return this.name.equals(another.name) && this.uri.equals(another.uri) && Objects.equals(this.variadic, another.variadic) && Objects.equals(this.description, another.description) && this.args.equals(another.args) && this.options.equals(another.options) && this.nullability.equals((Object)another.nullability) && Objects.equals(this.ordered, another.ordered) && this.returnType.equals(another.returnType) && this.decomposability.equals((Object)another.decomposability) && Objects.equals(this.intermediate, another.intermediate) && this.windowType.equals((Object)another.windowType);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.name.hashCode();
            h += (h << 5) + this.uri.hashCode();
            h += (h << 5) + Objects.hashCode(this.variadic);
            h += (h << 5) + Objects.hashCode(this.description);
            h += (h << 5) + this.args.hashCode();
            h += (h << 5) + this.options.hashCode();
            h += (h << 5) + this.nullability.hashCode();
            h += (h << 5) + Objects.hashCode(this.ordered);
            h += (h << 5) + this.returnType.hashCode();
            h += (h << 5) + this.decomposability.hashCode();
            h += (h << 5) + Objects.hashCode(this.intermediate);
            h += (h << 5) + this.windowType.hashCode();
            return h;
        }

        @Deprecated
        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        static WindowFunctionVariant fromJson(Json json) {
            Builder builder = WindowFunctionVariant.builder();
            if (json.name != null) {
                builder.name(json.name);
            }
            if (json.uri != null) {
                builder.uri(json.uri);
            }
            if (json.variadic != null) {
                builder.variadic(json.variadic);
            }
            if (json.descriptionIsSet) {
                builder.description(json.description);
            }
            if (json.args != null) {
                builder.addAllArgs(json.args);
            }
            if (json.options != null) {
                builder.putAllOptions(json.options);
            }
            if (json.nullability != null) {
                builder.nullability(json.nullability);
            }
            if (json.ordered != null) {
                builder.ordered(json.ordered);
            }
            if (json.returnType != null) {
                builder.returnType(json.returnType);
            }
            if (json.decomposability != null) {
                builder.decomposability(json.decomposability);
            }
            if (json.intermediate != null) {
                builder.intermediate(json.intermediate);
            }
            if (json.windowType != null) {
                builder.windowType(json.windowType);
            }
            return builder.build();
        }

        public static WindowFunctionVariant copyOf(SimpleExtension.WindowFunctionVariant instance) {
            if (instance instanceof WindowFunctionVariant) {
                return (WindowFunctionVariant)instance;
            }
            return WindowFunctionVariant.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="SimpleExtension.WindowFunctionVariant", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_RETURN_TYPE = 1L;
            private static final long OPT_BIT_DESCRIPTION = 1L;
            private long initBits = 1L;
            private long optBits;
            @Nullable
            private String name;
            @Nullable
            private String uri;
            @Nullable
            private SimpleExtension.VariadicBehavior variadic;
            @Nullable
            private String description;
            private List<SimpleExtension.Argument> args = new ArrayList<SimpleExtension.Argument>();
            private Map<String, SimpleExtension.Option> options = new LinkedHashMap<String, SimpleExtension.Option>();
            @Nullable
            private SimpleExtension.Nullability nullability;
            @Nullable
            private Boolean ordered;
            @Nullable
            private TypeExpression returnType;
            @Nullable
            private SimpleExtension.Decomposability decomposability;
            @Nullable
            private TypeExpression intermediate;
            @Nullable
            private SimpleExtension.WindowType windowType;

            private Builder() {
            }

            public final Builder from(SimpleExtension.Function instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((short)0, instance);
                return this;
            }

            public final Builder from(SimpleExtension.WindowFunctionVariant instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((short)0, instance);
                return this;
            }

            private void from(short _unused, Object object) {
                SimpleExtension.Function instance;
                if (object instanceof SimpleExtension.Function) {
                    Optional<SimpleExtension.VariadicBehavior> variadicOptional;
                    instance = (SimpleExtension.Function)object;
                    this.addAllArgs(instance.args());
                    Boolean orderedValue = instance.ordered();
                    if (orderedValue != null) {
                        this.ordered(orderedValue);
                    }
                    this.nullability(instance.nullability());
                    this.name(instance.name());
                    this.putAllOptions(instance.options());
                    String descriptionValue = instance.description();
                    if (descriptionValue != null) {
                        this.description(descriptionValue);
                    }
                    if ((variadicOptional = instance.variadic()).isPresent()) {
                        this.variadic(variadicOptional);
                    }
                    this.uri(instance.uri());
                    this.returnType(instance.returnType());
                }
                if (object instanceof SimpleExtension.WindowFunctionVariant) {
                    instance = (SimpleExtension.WindowFunctionVariant)object;
                    this.decomposability(((SimpleExtension.WindowFunctionVariant)instance).decomposability());
                    TypeExpression intermediateValue = ((SimpleExtension.WindowFunctionVariant)instance).intermediate();
                    if (intermediateValue != null) {
                        this.intermediate(intermediateValue);
                    }
                    this.windowType(((SimpleExtension.WindowFunctionVariant)instance).windowType());
                }
            }

            @JsonProperty(value="name")
            public final Builder name(String name) {
                this.name = Objects.requireNonNull(name, "name");
                return this;
            }

            @JsonProperty(value="uri")
            public final Builder uri(String uri) {
                this.uri = Objects.requireNonNull(uri, "uri");
                return this;
            }

            public final Builder variadic(SimpleExtension.VariadicBehavior variadic) {
                this.variadic = Objects.requireNonNull(variadic, "variadic");
                return this;
            }

            @JsonProperty(value="variadic")
            public final Builder variadic(Optional<? extends SimpleExtension.VariadicBehavior> variadic) {
                this.variadic = variadic.orElse(null);
                return this;
            }

            @JsonProperty(value="description")
            public final Builder description(@Nullable String description) {
                this.description = description;
                this.optBits |= 1L;
                return this;
            }

            public final Builder addArgs(SimpleExtension.Argument element) {
                this.args.add(Objects.requireNonNull(element, "args element"));
                return this;
            }

            public final Builder addArgs(SimpleExtension.Argument ... elements) {
                for (SimpleExtension.Argument element : elements) {
                    this.args.add(Objects.requireNonNull(element, "args element"));
                }
                return this;
            }

            @JsonProperty(value="args")
            public final Builder args(Iterable<? extends SimpleExtension.Argument> elements) {
                this.args.clear();
                return this.addAllArgs(elements);
            }

            public final Builder addAllArgs(Iterable<? extends SimpleExtension.Argument> elements) {
                for (SimpleExtension.Argument argument : elements) {
                    this.args.add(Objects.requireNonNull(argument, "args element"));
                }
                return this;
            }

            public final Builder putOptions(String key, SimpleExtension.Option value) {
                this.options.put(Objects.requireNonNull(key, "options key"), Objects.requireNonNull(value, value == null ? "options value for key: " + key : null));
                return this;
            }

            public final Builder putOptions(Map.Entry<String, ? extends SimpleExtension.Option> entry) {
                SimpleExtension.Option v;
                String k = entry.getKey();
                this.options.put(Objects.requireNonNull(k, "options key"), Objects.requireNonNull(v, (v = entry.getValue()) == null ? "options value for key: " + k : null));
                return this;
            }

            @JsonProperty(value="options")
            public final Builder options(Map<String, ? extends SimpleExtension.Option> entries) {
                this.options.clear();
                return this.putAllOptions(entries);
            }

            public final Builder putAllOptions(Map<String, ? extends SimpleExtension.Option> entries) {
                for (Map.Entry<String, ? extends SimpleExtension.Option> e : entries.entrySet()) {
                    SimpleExtension.Option v;
                    String k = e.getKey();
                    this.options.put(Objects.requireNonNull(k, "options key"), Objects.requireNonNull(v, (v = e.getValue()) == null ? "options value for key: " + k : null));
                }
                return this;
            }

            @JsonProperty(value="nullability")
            public final Builder nullability(SimpleExtension.Nullability nullability) {
                this.nullability = Objects.requireNonNull(nullability, "nullability");
                return this;
            }

            @JsonProperty(value="ordered")
            public final Builder ordered(@Nullable Boolean ordered) {
                this.ordered = ordered;
                return this;
            }

            @JsonProperty(value="return")
            public final Builder returnType(TypeExpression returnType) {
                this.returnType = Objects.requireNonNull(returnType, "returnType");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            @JsonProperty(value="decomposable")
            public final Builder decomposability(SimpleExtension.Decomposability decomposability) {
                this.decomposability = Objects.requireNonNull(decomposability, "decomposability");
                return this;
            }

            @JsonProperty(value="intermediate")
            public final Builder intermediate(@Nullable TypeExpression intermediate) {
                this.intermediate = intermediate;
                return this;
            }

            @JsonProperty(value="window_type")
            public final Builder windowType(SimpleExtension.WindowType windowType) {
                this.windowType = Objects.requireNonNull(windowType, "windowType");
                return this;
            }

            public WindowFunctionVariant build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new WindowFunctionVariant(this);
            }

            private boolean descriptionIsSet() {
                return (this.optBits & 1L) != 0L;
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("returnType");
                }
                return "Cannot build WindowFunctionVariant, some of required attributes are not set " + attributes;
            }
        }

        @Generated(from="SimpleExtension.WindowFunctionVariant", generator="Immutables")
        private final class InitShim {
            private byte nameBuildStage = 0;
            private String name;
            private byte uriBuildStage = 0;
            private String uri;
            private byte descriptionBuildStage = 0;
            private String description;
            private byte nullabilityBuildStage = 0;
            private SimpleExtension.Nullability nullability;
            private byte decomposabilityBuildStage = 0;
            private SimpleExtension.Decomposability decomposability;
            private byte windowTypeBuildStage = 0;
            private SimpleExtension.WindowType windowType;

            private InitShim() {
            }

            String name() {
                if (this.nameBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.nameBuildStage == 0) {
                    this.nameBuildStage = (byte)-1;
                    this.name = Objects.requireNonNull(WindowFunctionVariant.super.name(), "name");
                    this.nameBuildStage = 1;
                }
                return this.name;
            }

            void name(String name) {
                this.name = name;
                this.nameBuildStage = 1;
            }

            String uri() {
                if (this.uriBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.uriBuildStage == 0) {
                    this.uriBuildStage = (byte)-1;
                    this.uri = Objects.requireNonNull(WindowFunctionVariant.super.uri(), "uri");
                    this.uriBuildStage = 1;
                }
                return this.uri;
            }

            void uri(String uri) {
                this.uri = uri;
                this.uriBuildStage = 1;
            }

            String description() {
                if (this.descriptionBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.descriptionBuildStage == 0) {
                    this.descriptionBuildStage = (byte)-1;
                    this.description = WindowFunctionVariant.super.description();
                    this.descriptionBuildStage = 1;
                }
                return this.description;
            }

            void description(String description) {
                this.description = description;
                this.descriptionBuildStage = 1;
            }

            SimpleExtension.Nullability nullability() {
                if (this.nullabilityBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.nullabilityBuildStage == 0) {
                    this.nullabilityBuildStage = (byte)-1;
                    this.nullability = Objects.requireNonNull(WindowFunctionVariant.super.nullability(), "nullability");
                    this.nullabilityBuildStage = 1;
                }
                return this.nullability;
            }

            void nullability(SimpleExtension.Nullability nullability) {
                this.nullability = nullability;
                this.nullabilityBuildStage = 1;
            }

            SimpleExtension.Decomposability decomposability() {
                if (this.decomposabilityBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.decomposabilityBuildStage == 0) {
                    this.decomposabilityBuildStage = (byte)-1;
                    this.decomposability = Objects.requireNonNull(WindowFunctionVariant.super.decomposability(), "decomposability");
                    this.decomposabilityBuildStage = 1;
                }
                return this.decomposability;
            }

            void decomposability(SimpleExtension.Decomposability decomposability) {
                this.decomposability = decomposability;
                this.decomposabilityBuildStage = 1;
            }

            SimpleExtension.WindowType windowType() {
                if (this.windowTypeBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.windowTypeBuildStage == 0) {
                    this.windowTypeBuildStage = (byte)-1;
                    this.windowType = Objects.requireNonNull(WindowFunctionVariant.super.windowType(), "windowType");
                    this.windowTypeBuildStage = 1;
                }
                return this.windowType;
            }

            void windowType(SimpleExtension.WindowType windowType) {
                this.windowType = windowType;
                this.windowTypeBuildStage = 1;
            }

            private String formatInitCycleMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if (this.nameBuildStage == -1) {
                    attributes.add("name");
                }
                if (this.uriBuildStage == -1) {
                    attributes.add("uri");
                }
                if (this.descriptionBuildStage == -1) {
                    attributes.add("description");
                }
                if (this.nullabilityBuildStage == -1) {
                    attributes.add("nullability");
                }
                if (this.decomposabilityBuildStage == -1) {
                    attributes.add("decomposability");
                }
                if (this.windowTypeBuildStage == -1) {
                    attributes.add("windowType");
                }
                return "Cannot build WindowFunctionVariant, attribute initializers form cycle " + attributes;
            }
        }

        @Deprecated
        @JsonDeserialize
        @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
        @Generated(from="SimpleExtension.WindowFunctionVariant", generator="Immutables")
        static final class Json
        extends SimpleExtension.WindowFunctionVariant {
            @Nullable
            String name;
            @Nullable
            String uri;
            @Nullable
            Optional<SimpleExtension.VariadicBehavior> variadic = Optional.empty();
            @Nullable
            String description;
            boolean descriptionIsSet;
            @Nullable
            List<SimpleExtension.Argument> args = Collections.emptyList();
            @Nullable
            Map<String, SimpleExtension.Option> options = Collections.emptyMap();
            @Nullable
            SimpleExtension.Nullability nullability;
            @Nullable
            Boolean ordered;
            @Nullable
            TypeExpression returnType;
            @Nullable
            SimpleExtension.Decomposability decomposability;
            @Nullable
            TypeExpression intermediate;
            @Nullable
            SimpleExtension.WindowType windowType;

            Json() {
            }

            @JsonProperty(value="name")
            public void setName(String name) {
                this.name = name;
            }

            @JsonProperty(value="uri")
            public void setUri(String uri) {
                this.uri = uri;
            }

            @JsonProperty(value="variadic")
            public void setVariadic(Optional<SimpleExtension.VariadicBehavior> variadic) {
                this.variadic = variadic;
            }

            @JsonProperty(value="description")
            public void setDescription(@Nullable String description) {
                this.description = description;
                this.descriptionIsSet = true;
            }

            @JsonProperty(value="args")
            public void setArgs(List<SimpleExtension.Argument> args) {
                this.args = args;
            }

            @JsonProperty(value="options")
            public void setOptions(Map<String, SimpleExtension.Option> options) {
                this.options = options;
            }

            @JsonProperty(value="nullability")
            public void setNullability(SimpleExtension.Nullability nullability) {
                this.nullability = nullability;
            }

            @JsonProperty(value="ordered")
            public void setOrdered(@Nullable Boolean ordered) {
                this.ordered = ordered;
            }

            @JsonProperty(value="return")
            public void setReturnType(TypeExpression returnType) {
                this.returnType = returnType;
            }

            @JsonProperty(value="decomposable")
            public void setDecomposability(SimpleExtension.Decomposability decomposability) {
                this.decomposability = decomposability;
            }

            @JsonProperty(value="intermediate")
            public void setIntermediate(@Nullable TypeExpression intermediate) {
                this.intermediate = intermediate;
            }

            @JsonProperty(value="window_type")
            public void setWindowType(SimpleExtension.WindowType windowType) {
                this.windowType = windowType;
            }

            @Override
            public String name() {
                throw new UnsupportedOperationException();
            }

            @Override
            public String uri() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Optional<SimpleExtension.VariadicBehavior> variadic() {
                throw new UnsupportedOperationException();
            }

            @Override
            public String description() {
                throw new UnsupportedOperationException();
            }

            @Override
            public List<SimpleExtension.Argument> args() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Map<String, SimpleExtension.Option> options() {
                throw new UnsupportedOperationException();
            }

            @Override
            public SimpleExtension.Nullability nullability() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Boolean ordered() {
                throw new UnsupportedOperationException();
            }

            @Override
            public TypeExpression returnType() {
                throw new UnsupportedOperationException();
            }

            @Override
            public SimpleExtension.Decomposability decomposability() {
                throw new UnsupportedOperationException();
            }

            @Override
            public TypeExpression intermediate() {
                throw new UnsupportedOperationException();
            }

            @Override
            public SimpleExtension.WindowType windowType() {
                throw new UnsupportedOperationException();
            }
        }
    }

    @Generated(from="SimpleExtension.AggregateFunctionVariant", generator="Immutables")
    @Immutable
    public static final class AggregateFunctionVariant
    extends SimpleExtension.AggregateFunctionVariant {
        private final String name;
        private final String uri;
        @Nullable
        private final SimpleExtension.VariadicBehavior variadic;
        @Nullable
        private final String description;
        private final List<SimpleExtension.Argument> args;
        private final Map<String, SimpleExtension.Option> options;
        private final SimpleExtension.Nullability nullability;
        @Nullable
        private final Boolean ordered;
        private final TypeExpression returnType;
        private final SimpleExtension.Decomposability decomposability;
        @Nullable
        private final TypeExpression intermediate;
        private static final byte STAGE_INITIALIZING = -1;
        private static final byte STAGE_UNINITIALIZED = 0;
        private static final byte STAGE_INITIALIZED = 1;
        private volatile transient InitShim initShim = new InitShim();

        private AggregateFunctionVariant(Builder builder) {
            this.variadic = builder.variadic;
            this.args = ImmutableSimpleExtension.createUnmodifiableList(true, builder.args);
            this.options = ImmutableSimpleExtension.createUnmodifiableMap(false, false, builder.options);
            this.ordered = builder.ordered;
            this.returnType = builder.returnType;
            this.intermediate = builder.intermediate;
            if (builder.name != null) {
                this.initShim.name(builder.name);
            }
            if (builder.uri != null) {
                this.initShim.uri(builder.uri);
            }
            if (builder.descriptionIsSet()) {
                this.initShim.description(builder.description);
            }
            if (builder.nullability != null) {
                this.initShim.nullability(builder.nullability);
            }
            if (builder.decomposability != null) {
                this.initShim.decomposability(builder.decomposability);
            }
            this.name = this.initShim.name();
            this.uri = this.initShim.uri();
            this.description = this.initShim.description();
            this.nullability = this.initShim.nullability();
            this.decomposability = this.initShim.decomposability();
            this.initShim = null;
        }

        private AggregateFunctionVariant(String name, String uri, @Nullable SimpleExtension.VariadicBehavior variadic, @Nullable String description, List<SimpleExtension.Argument> args, Map<String, SimpleExtension.Option> options, SimpleExtension.Nullability nullability, @Nullable Boolean ordered, TypeExpression returnType, SimpleExtension.Decomposability decomposability, @Nullable TypeExpression intermediate) {
            this.name = name;
            this.uri = uri;
            this.variadic = variadic;
            this.description = description;
            this.args = args;
            this.options = options;
            this.nullability = nullability;
            this.ordered = ordered;
            this.returnType = returnType;
            this.decomposability = decomposability;
            this.intermediate = intermediate;
            this.initShim = null;
        }

        @Override
        @JsonProperty(value="name")
        public String name() {
            InitShim shim = this.initShim;
            return shim != null ? shim.name() : this.name;
        }

        @Override
        @JsonProperty(value="uri")
        public String uri() {
            InitShim shim = this.initShim;
            return shim != null ? shim.uri() : this.uri;
        }

        @Override
        @JsonProperty(value="variadic")
        public Optional<SimpleExtension.VariadicBehavior> variadic() {
            return Optional.ofNullable(this.variadic);
        }

        @Override
        @JsonProperty(value="description")
        @Nullable
        public String description() {
            InitShim shim = this.initShim;
            return shim != null ? shim.description() : this.description;
        }

        @Override
        @JsonProperty(value="args")
        public List<SimpleExtension.Argument> args() {
            return this.args;
        }

        @Override
        @JsonProperty(value="options")
        public Map<String, SimpleExtension.Option> options() {
            return this.options;
        }

        @Override
        @JsonProperty(value="nullability")
        public SimpleExtension.Nullability nullability() {
            InitShim shim = this.initShim;
            return shim != null ? shim.nullability() : this.nullability;
        }

        @Override
        @JsonProperty(value="ordered")
        @Nullable
        public Boolean ordered() {
            return this.ordered;
        }

        @Override
        @JsonProperty(value="return")
        public TypeExpression returnType() {
            return this.returnType;
        }

        @Override
        @JsonProperty(value="decomposable")
        public SimpleExtension.Decomposability decomposability() {
            InitShim shim = this.initShim;
            return shim != null ? shim.decomposability() : this.decomposability;
        }

        @Override
        @JsonProperty(value="intermediate")
        @Nullable
        public TypeExpression intermediate() {
            return this.intermediate;
        }

        public final AggregateFunctionVariant withName(String value) {
            String newValue = Objects.requireNonNull(value, "name");
            if (this.name.equals(newValue)) {
                return this;
            }
            return new AggregateFunctionVariant(newValue, this.uri, this.variadic, this.description, this.args, this.options, this.nullability, this.ordered, this.returnType, this.decomposability, this.intermediate);
        }

        public final AggregateFunctionVariant withUri(String value) {
            String newValue = Objects.requireNonNull(value, "uri");
            if (this.uri.equals(newValue)) {
                return this;
            }
            return new AggregateFunctionVariant(this.name, newValue, this.variadic, this.description, this.args, this.options, this.nullability, this.ordered, this.returnType, this.decomposability, this.intermediate);
        }

        public final AggregateFunctionVariant withVariadic(SimpleExtension.VariadicBehavior value) {
            SimpleExtension.VariadicBehavior newValue = Objects.requireNonNull(value, "variadic");
            if (this.variadic == newValue) {
                return this;
            }
            return new AggregateFunctionVariant(this.name, this.uri, newValue, this.description, this.args, this.options, this.nullability, this.ordered, this.returnType, this.decomposability, this.intermediate);
        }

        public final AggregateFunctionVariant withVariadic(Optional<? extends SimpleExtension.VariadicBehavior> optional) {
            SimpleExtension.VariadicBehavior value = optional.orElse(null);
            if (this.variadic == value) {
                return this;
            }
            return new AggregateFunctionVariant(this.name, this.uri, value, this.description, this.args, this.options, this.nullability, this.ordered, this.returnType, this.decomposability, this.intermediate);
        }

        public final AggregateFunctionVariant withDescription(@Nullable String value) {
            if (Objects.equals(this.description, value)) {
                return this;
            }
            return new AggregateFunctionVariant(this.name, this.uri, this.variadic, value, this.args, this.options, this.nullability, this.ordered, this.returnType, this.decomposability, this.intermediate);
        }

        public final AggregateFunctionVariant withArgs(SimpleExtension.Argument ... elements) {
            List newValue = ImmutableSimpleExtension.createUnmodifiableList(false, ImmutableSimpleExtension.createSafeList(Arrays.asList(elements), true, false));
            return new AggregateFunctionVariant(this.name, this.uri, this.variadic, this.description, newValue, this.options, this.nullability, this.ordered, this.returnType, this.decomposability, this.intermediate);
        }

        public final AggregateFunctionVariant withArgs(Iterable<? extends SimpleExtension.Argument> elements) {
            if (this.args == elements) {
                return this;
            }
            List newValue = ImmutableSimpleExtension.createUnmodifiableList(false, ImmutableSimpleExtension.createSafeList(elements, true, false));
            return new AggregateFunctionVariant(this.name, this.uri, this.variadic, this.description, newValue, this.options, this.nullability, this.ordered, this.returnType, this.decomposability, this.intermediate);
        }

        public final AggregateFunctionVariant withOptions(Map<String, ? extends SimpleExtension.Option> entries) {
            if (this.options == entries) {
                return this;
            }
            Map newValue = ImmutableSimpleExtension.createUnmodifiableMap(true, false, entries);
            return new AggregateFunctionVariant(this.name, this.uri, this.variadic, this.description, this.args, newValue, this.nullability, this.ordered, this.returnType, this.decomposability, this.intermediate);
        }

        public final AggregateFunctionVariant withNullability(SimpleExtension.Nullability value) {
            SimpleExtension.Nullability newValue = Objects.requireNonNull(value, "nullability");
            if (this.nullability == newValue) {
                return this;
            }
            return new AggregateFunctionVariant(this.name, this.uri, this.variadic, this.description, this.args, this.options, newValue, this.ordered, this.returnType, this.decomposability, this.intermediate);
        }

        public final AggregateFunctionVariant withOrdered(@Nullable Boolean value) {
            if (Objects.equals(this.ordered, value)) {
                return this;
            }
            return new AggregateFunctionVariant(this.name, this.uri, this.variadic, this.description, this.args, this.options, this.nullability, value, this.returnType, this.decomposability, this.intermediate);
        }

        public final AggregateFunctionVariant withReturnType(TypeExpression value) {
            if (this.returnType == value) {
                return this;
            }
            TypeExpression newValue = Objects.requireNonNull(value, "returnType");
            return new AggregateFunctionVariant(this.name, this.uri, this.variadic, this.description, this.args, this.options, this.nullability, this.ordered, newValue, this.decomposability, this.intermediate);
        }

        public final AggregateFunctionVariant withDecomposability(SimpleExtension.Decomposability value) {
            SimpleExtension.Decomposability newValue = Objects.requireNonNull(value, "decomposability");
            if (this.decomposability == newValue) {
                return this;
            }
            return new AggregateFunctionVariant(this.name, this.uri, this.variadic, this.description, this.args, this.options, this.nullability, this.ordered, this.returnType, newValue, this.intermediate);
        }

        public final AggregateFunctionVariant withIntermediate(@Nullable TypeExpression value) {
            if (this.intermediate == value) {
                return this;
            }
            return new AggregateFunctionVariant(this.name, this.uri, this.variadic, this.description, this.args, this.options, this.nullability, this.ordered, this.returnType, this.decomposability, value);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof AggregateFunctionVariant && this.equalTo(0, (AggregateFunctionVariant)another);
        }

        private boolean equalTo(int synthetic, AggregateFunctionVariant another) {
            return this.name.equals(another.name) && this.uri.equals(another.uri) && Objects.equals(this.variadic, another.variadic) && Objects.equals(this.description, another.description) && this.args.equals(another.args) && this.options.equals(another.options) && this.nullability.equals((Object)another.nullability) && Objects.equals(this.ordered, another.ordered) && this.returnType.equals(another.returnType) && this.decomposability.equals((Object)another.decomposability) && Objects.equals(this.intermediate, another.intermediate);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.name.hashCode();
            h += (h << 5) + this.uri.hashCode();
            h += (h << 5) + Objects.hashCode(this.variadic);
            h += (h << 5) + Objects.hashCode(this.description);
            h += (h << 5) + this.args.hashCode();
            h += (h << 5) + this.options.hashCode();
            h += (h << 5) + this.nullability.hashCode();
            h += (h << 5) + Objects.hashCode(this.ordered);
            h += (h << 5) + this.returnType.hashCode();
            h += (h << 5) + this.decomposability.hashCode();
            h += (h << 5) + Objects.hashCode(this.intermediate);
            return h;
        }

        @Deprecated
        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        static AggregateFunctionVariant fromJson(Json json) {
            Builder builder = AggregateFunctionVariant.builder();
            if (json.name != null) {
                builder.name(json.name);
            }
            if (json.uri != null) {
                builder.uri(json.uri);
            }
            if (json.variadic != null) {
                builder.variadic(json.variadic);
            }
            if (json.descriptionIsSet) {
                builder.description(json.description);
            }
            if (json.args != null) {
                builder.addAllArgs(json.args);
            }
            if (json.options != null) {
                builder.putAllOptions(json.options);
            }
            if (json.nullability != null) {
                builder.nullability(json.nullability);
            }
            if (json.ordered != null) {
                builder.ordered(json.ordered);
            }
            if (json.returnType != null) {
                builder.returnType(json.returnType);
            }
            if (json.decomposability != null) {
                builder.decomposability(json.decomposability);
            }
            if (json.intermediate != null) {
                builder.intermediate(json.intermediate);
            }
            return builder.build();
        }

        public static AggregateFunctionVariant copyOf(SimpleExtension.AggregateFunctionVariant instance) {
            if (instance instanceof AggregateFunctionVariant) {
                return (AggregateFunctionVariant)instance;
            }
            return AggregateFunctionVariant.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="SimpleExtension.AggregateFunctionVariant", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_RETURN_TYPE = 1L;
            private static final long OPT_BIT_DESCRIPTION = 1L;
            private long initBits = 1L;
            private long optBits;
            @Nullable
            private String name;
            @Nullable
            private String uri;
            @Nullable
            private SimpleExtension.VariadicBehavior variadic;
            @Nullable
            private String description;
            private List<SimpleExtension.Argument> args = new ArrayList<SimpleExtension.Argument>();
            private Map<String, SimpleExtension.Option> options = new LinkedHashMap<String, SimpleExtension.Option>();
            @Nullable
            private SimpleExtension.Nullability nullability;
            @Nullable
            private Boolean ordered;
            @Nullable
            private TypeExpression returnType;
            @Nullable
            private SimpleExtension.Decomposability decomposability;
            @Nullable
            private TypeExpression intermediate;

            private Builder() {
            }

            public final Builder from(SimpleExtension.Function instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((short)0, instance);
                return this;
            }

            public final Builder from(SimpleExtension.AggregateFunctionVariant instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((short)0, instance);
                return this;
            }

            private void from(short _unused, Object object) {
                SimpleExtension.Function instance;
                if (object instanceof SimpleExtension.Function) {
                    Optional<SimpleExtension.VariadicBehavior> variadicOptional;
                    instance = (SimpleExtension.Function)object;
                    this.addAllArgs(instance.args());
                    Boolean orderedValue = instance.ordered();
                    if (orderedValue != null) {
                        this.ordered(orderedValue);
                    }
                    this.nullability(instance.nullability());
                    this.name(instance.name());
                    this.putAllOptions(instance.options());
                    String descriptionValue = instance.description();
                    if (descriptionValue != null) {
                        this.description(descriptionValue);
                    }
                    if ((variadicOptional = instance.variadic()).isPresent()) {
                        this.variadic(variadicOptional);
                    }
                    this.uri(instance.uri());
                    this.returnType(instance.returnType());
                }
                if (object instanceof SimpleExtension.AggregateFunctionVariant) {
                    instance = (SimpleExtension.AggregateFunctionVariant)object;
                    this.decomposability(((SimpleExtension.AggregateFunctionVariant)instance).decomposability());
                    TypeExpression intermediateValue = ((SimpleExtension.AggregateFunctionVariant)instance).intermediate();
                    if (intermediateValue != null) {
                        this.intermediate(intermediateValue);
                    }
                }
            }

            @JsonProperty(value="name")
            public final Builder name(String name) {
                this.name = Objects.requireNonNull(name, "name");
                return this;
            }

            @JsonProperty(value="uri")
            public final Builder uri(String uri) {
                this.uri = Objects.requireNonNull(uri, "uri");
                return this;
            }

            public final Builder variadic(SimpleExtension.VariadicBehavior variadic) {
                this.variadic = Objects.requireNonNull(variadic, "variadic");
                return this;
            }

            @JsonProperty(value="variadic")
            public final Builder variadic(Optional<? extends SimpleExtension.VariadicBehavior> variadic) {
                this.variadic = variadic.orElse(null);
                return this;
            }

            @JsonProperty(value="description")
            public final Builder description(@Nullable String description) {
                this.description = description;
                this.optBits |= 1L;
                return this;
            }

            public final Builder addArgs(SimpleExtension.Argument element) {
                this.args.add(Objects.requireNonNull(element, "args element"));
                return this;
            }

            public final Builder addArgs(SimpleExtension.Argument ... elements) {
                for (SimpleExtension.Argument element : elements) {
                    this.args.add(Objects.requireNonNull(element, "args element"));
                }
                return this;
            }

            @JsonProperty(value="args")
            public final Builder args(Iterable<? extends SimpleExtension.Argument> elements) {
                this.args.clear();
                return this.addAllArgs(elements);
            }

            public final Builder addAllArgs(Iterable<? extends SimpleExtension.Argument> elements) {
                for (SimpleExtension.Argument argument : elements) {
                    this.args.add(Objects.requireNonNull(argument, "args element"));
                }
                return this;
            }

            public final Builder putOptions(String key, SimpleExtension.Option value) {
                this.options.put(Objects.requireNonNull(key, "options key"), Objects.requireNonNull(value, value == null ? "options value for key: " + key : null));
                return this;
            }

            public final Builder putOptions(Map.Entry<String, ? extends SimpleExtension.Option> entry) {
                SimpleExtension.Option v;
                String k = entry.getKey();
                this.options.put(Objects.requireNonNull(k, "options key"), Objects.requireNonNull(v, (v = entry.getValue()) == null ? "options value for key: " + k : null));
                return this;
            }

            @JsonProperty(value="options")
            public final Builder options(Map<String, ? extends SimpleExtension.Option> entries) {
                this.options.clear();
                return this.putAllOptions(entries);
            }

            public final Builder putAllOptions(Map<String, ? extends SimpleExtension.Option> entries) {
                for (Map.Entry<String, ? extends SimpleExtension.Option> e : entries.entrySet()) {
                    SimpleExtension.Option v;
                    String k = e.getKey();
                    this.options.put(Objects.requireNonNull(k, "options key"), Objects.requireNonNull(v, (v = e.getValue()) == null ? "options value for key: " + k : null));
                }
                return this;
            }

            @JsonProperty(value="nullability")
            public final Builder nullability(SimpleExtension.Nullability nullability) {
                this.nullability = Objects.requireNonNull(nullability, "nullability");
                return this;
            }

            @JsonProperty(value="ordered")
            public final Builder ordered(@Nullable Boolean ordered) {
                this.ordered = ordered;
                return this;
            }

            @JsonProperty(value="return")
            public final Builder returnType(TypeExpression returnType) {
                this.returnType = Objects.requireNonNull(returnType, "returnType");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            @JsonProperty(value="decomposable")
            public final Builder decomposability(SimpleExtension.Decomposability decomposability) {
                this.decomposability = Objects.requireNonNull(decomposability, "decomposability");
                return this;
            }

            @JsonProperty(value="intermediate")
            public final Builder intermediate(@Nullable TypeExpression intermediate) {
                this.intermediate = intermediate;
                return this;
            }

            public AggregateFunctionVariant build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new AggregateFunctionVariant(this);
            }

            private boolean descriptionIsSet() {
                return (this.optBits & 1L) != 0L;
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("returnType");
                }
                return "Cannot build AggregateFunctionVariant, some of required attributes are not set " + attributes;
            }
        }

        @Generated(from="SimpleExtension.AggregateFunctionVariant", generator="Immutables")
        private final class InitShim {
            private byte nameBuildStage = 0;
            private String name;
            private byte uriBuildStage = 0;
            private String uri;
            private byte descriptionBuildStage = 0;
            private String description;
            private byte nullabilityBuildStage = 0;
            private SimpleExtension.Nullability nullability;
            private byte decomposabilityBuildStage = 0;
            private SimpleExtension.Decomposability decomposability;

            private InitShim() {
            }

            String name() {
                if (this.nameBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.nameBuildStage == 0) {
                    this.nameBuildStage = (byte)-1;
                    this.name = Objects.requireNonNull(AggregateFunctionVariant.super.name(), "name");
                    this.nameBuildStage = 1;
                }
                return this.name;
            }

            void name(String name) {
                this.name = name;
                this.nameBuildStage = 1;
            }

            String uri() {
                if (this.uriBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.uriBuildStage == 0) {
                    this.uriBuildStage = (byte)-1;
                    this.uri = Objects.requireNonNull(AggregateFunctionVariant.super.uri(), "uri");
                    this.uriBuildStage = 1;
                }
                return this.uri;
            }

            void uri(String uri) {
                this.uri = uri;
                this.uriBuildStage = 1;
            }

            String description() {
                if (this.descriptionBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.descriptionBuildStage == 0) {
                    this.descriptionBuildStage = (byte)-1;
                    this.description = AggregateFunctionVariant.super.description();
                    this.descriptionBuildStage = 1;
                }
                return this.description;
            }

            void description(String description) {
                this.description = description;
                this.descriptionBuildStage = 1;
            }

            SimpleExtension.Nullability nullability() {
                if (this.nullabilityBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.nullabilityBuildStage == 0) {
                    this.nullabilityBuildStage = (byte)-1;
                    this.nullability = Objects.requireNonNull(AggregateFunctionVariant.super.nullability(), "nullability");
                    this.nullabilityBuildStage = 1;
                }
                return this.nullability;
            }

            void nullability(SimpleExtension.Nullability nullability) {
                this.nullability = nullability;
                this.nullabilityBuildStage = 1;
            }

            SimpleExtension.Decomposability decomposability() {
                if (this.decomposabilityBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.decomposabilityBuildStage == 0) {
                    this.decomposabilityBuildStage = (byte)-1;
                    this.decomposability = Objects.requireNonNull(AggregateFunctionVariant.super.decomposability(), "decomposability");
                    this.decomposabilityBuildStage = 1;
                }
                return this.decomposability;
            }

            void decomposability(SimpleExtension.Decomposability decomposability) {
                this.decomposability = decomposability;
                this.decomposabilityBuildStage = 1;
            }

            private String formatInitCycleMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if (this.nameBuildStage == -1) {
                    attributes.add("name");
                }
                if (this.uriBuildStage == -1) {
                    attributes.add("uri");
                }
                if (this.descriptionBuildStage == -1) {
                    attributes.add("description");
                }
                if (this.nullabilityBuildStage == -1) {
                    attributes.add("nullability");
                }
                if (this.decomposabilityBuildStage == -1) {
                    attributes.add("decomposability");
                }
                return "Cannot build AggregateFunctionVariant, attribute initializers form cycle " + attributes;
            }
        }

        @Deprecated
        @JsonDeserialize
        @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
        @Generated(from="SimpleExtension.AggregateFunctionVariant", generator="Immutables")
        static final class Json
        extends SimpleExtension.AggregateFunctionVariant {
            @Nullable
            String name;
            @Nullable
            String uri;
            @Nullable
            Optional<SimpleExtension.VariadicBehavior> variadic = Optional.empty();
            @Nullable
            String description;
            boolean descriptionIsSet;
            @Nullable
            List<SimpleExtension.Argument> args = Collections.emptyList();
            @Nullable
            Map<String, SimpleExtension.Option> options = Collections.emptyMap();
            @Nullable
            SimpleExtension.Nullability nullability;
            @Nullable
            Boolean ordered;
            @Nullable
            TypeExpression returnType;
            @Nullable
            SimpleExtension.Decomposability decomposability;
            @Nullable
            TypeExpression intermediate;

            Json() {
            }

            @JsonProperty(value="name")
            public void setName(String name) {
                this.name = name;
            }

            @JsonProperty(value="uri")
            public void setUri(String uri) {
                this.uri = uri;
            }

            @JsonProperty(value="variadic")
            public void setVariadic(Optional<SimpleExtension.VariadicBehavior> variadic) {
                this.variadic = variadic;
            }

            @JsonProperty(value="description")
            public void setDescription(@Nullable String description) {
                this.description = description;
                this.descriptionIsSet = true;
            }

            @JsonProperty(value="args")
            public void setArgs(List<SimpleExtension.Argument> args) {
                this.args = args;
            }

            @JsonProperty(value="options")
            public void setOptions(Map<String, SimpleExtension.Option> options) {
                this.options = options;
            }

            @JsonProperty(value="nullability")
            public void setNullability(SimpleExtension.Nullability nullability) {
                this.nullability = nullability;
            }

            @JsonProperty(value="ordered")
            public void setOrdered(@Nullable Boolean ordered) {
                this.ordered = ordered;
            }

            @JsonProperty(value="return")
            public void setReturnType(TypeExpression returnType) {
                this.returnType = returnType;
            }

            @JsonProperty(value="decomposable")
            public void setDecomposability(SimpleExtension.Decomposability decomposability) {
                this.decomposability = decomposability;
            }

            @JsonProperty(value="intermediate")
            public void setIntermediate(@Nullable TypeExpression intermediate) {
                this.intermediate = intermediate;
            }

            @Override
            public String name() {
                throw new UnsupportedOperationException();
            }

            @Override
            public String uri() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Optional<SimpleExtension.VariadicBehavior> variadic() {
                throw new UnsupportedOperationException();
            }

            @Override
            public String description() {
                throw new UnsupportedOperationException();
            }

            @Override
            public List<SimpleExtension.Argument> args() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Map<String, SimpleExtension.Option> options() {
                throw new UnsupportedOperationException();
            }

            @Override
            public SimpleExtension.Nullability nullability() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Boolean ordered() {
                throw new UnsupportedOperationException();
            }

            @Override
            public TypeExpression returnType() {
                throw new UnsupportedOperationException();
            }

            @Override
            public SimpleExtension.Decomposability decomposability() {
                throw new UnsupportedOperationException();
            }

            @Override
            public TypeExpression intermediate() {
                throw new UnsupportedOperationException();
            }
        }
    }

    @Generated(from="SimpleExtension.WindowFunction", generator="Immutables")
    @Immutable
    public static final class WindowFunction
    extends SimpleExtension.WindowFunction {
        @Nullable
        private final String name;
        @Nullable
        private final String description;
        private final List<SimpleExtension.WindowFunctionVariant> impls;

        private WindowFunction(@Nullable String name, @Nullable String description, List<SimpleExtension.WindowFunctionVariant> impls) {
            this.name = name;
            this.description = description;
            this.impls = impls;
        }

        @Override
        @JsonProperty(value="name")
        @Nullable
        public String name() {
            return this.name;
        }

        @Override
        @JsonProperty(value="description")
        @Nullable
        public String description() {
            return this.description;
        }

        @Override
        @JsonProperty(value="impls")
        public List<SimpleExtension.WindowFunctionVariant> impls() {
            return this.impls;
        }

        public final WindowFunction withName(@Nullable String value) {
            if (Objects.equals(this.name, value)) {
                return this;
            }
            return new WindowFunction(value, this.description, this.impls);
        }

        public final WindowFunction withDescription(@Nullable String value) {
            if (Objects.equals(this.description, value)) {
                return this;
            }
            return new WindowFunction(this.name, value, this.impls);
        }

        public final WindowFunction withImpls(SimpleExtension.WindowFunctionVariant ... elements) {
            List newValue = ImmutableSimpleExtension.createUnmodifiableList(false, ImmutableSimpleExtension.createSafeList(Arrays.asList(elements), true, false));
            return new WindowFunction(this.name, this.description, newValue);
        }

        public final WindowFunction withImpls(Iterable<? extends SimpleExtension.WindowFunctionVariant> elements) {
            if (this.impls == elements) {
                return this;
            }
            List newValue = ImmutableSimpleExtension.createUnmodifiableList(false, ImmutableSimpleExtension.createSafeList(elements, true, false));
            return new WindowFunction(this.name, this.description, newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof WindowFunction && this.equalTo(0, (WindowFunction)another);
        }

        private boolean equalTo(int synthetic, WindowFunction another) {
            return Objects.equals(this.name, another.name) && Objects.equals(this.description, another.description) && this.impls.equals(another.impls);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Objects.hashCode(this.name);
            h += (h << 5) + Objects.hashCode(this.description);
            h += (h << 5) + this.impls.hashCode();
            return h;
        }

        public String toString() {
            return "WindowFunction{name=" + this.name + ", description=" + this.description + ", impls=" + this.impls + "}";
        }

        @Deprecated
        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        static WindowFunction fromJson(Json json) {
            Builder builder = WindowFunction.builder();
            if (json.name != null) {
                builder.name(json.name);
            }
            if (json.description != null) {
                builder.description(json.description);
            }
            if (json.impls != null) {
                builder.addAllImpls(json.impls);
            }
            return builder.build();
        }

        public static WindowFunction copyOf(SimpleExtension.WindowFunction instance) {
            if (instance instanceof WindowFunction) {
                return (WindowFunction)instance;
            }
            return WindowFunction.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="SimpleExtension.WindowFunction", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            @Nullable
            private String name;
            @Nullable
            private String description;
            private List<SimpleExtension.WindowFunctionVariant> impls = new ArrayList<SimpleExtension.WindowFunctionVariant>();

            private Builder() {
            }

            public final Builder from(SimpleExtension.WindowFunction instance) {
                String descriptionValue;
                Objects.requireNonNull(instance, "instance");
                String nameValue = instance.name();
                if (nameValue != null) {
                    this.name(nameValue);
                }
                if ((descriptionValue = instance.description()) != null) {
                    this.description(descriptionValue);
                }
                this.addAllImpls(instance.impls());
                return this;
            }

            @JsonProperty(value="name")
            public final Builder name(@Nullable String name) {
                this.name = name;
                return this;
            }

            @JsonProperty(value="description")
            public final Builder description(@Nullable String description) {
                this.description = description;
                return this;
            }

            public final Builder addImpls(SimpleExtension.WindowFunctionVariant element) {
                this.impls.add(Objects.requireNonNull(element, "impls element"));
                return this;
            }

            public final Builder addImpls(SimpleExtension.WindowFunctionVariant ... elements) {
                for (SimpleExtension.WindowFunctionVariant element : elements) {
                    this.impls.add(Objects.requireNonNull(element, "impls element"));
                }
                return this;
            }

            @JsonProperty(value="impls")
            public final Builder impls(Iterable<? extends SimpleExtension.WindowFunctionVariant> elements) {
                this.impls.clear();
                return this.addAllImpls(elements);
            }

            public final Builder addAllImpls(Iterable<? extends SimpleExtension.WindowFunctionVariant> elements) {
                for (SimpleExtension.WindowFunctionVariant windowFunctionVariant : elements) {
                    this.impls.add(Objects.requireNonNull(windowFunctionVariant, "impls element"));
                }
                return this;
            }

            public WindowFunction build() {
                return new WindowFunction(this.name, this.description, ImmutableSimpleExtension.createUnmodifiableList(true, this.impls));
            }
        }

        @Deprecated
        @JsonDeserialize
        @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
        @Generated(from="SimpleExtension.WindowFunction", generator="Immutables")
        static final class Json
        extends SimpleExtension.WindowFunction {
            @Nullable
            String name;
            @Nullable
            String description;
            @Nullable
            List<SimpleExtension.WindowFunctionVariant> impls = Collections.emptyList();

            Json() {
            }

            @JsonProperty(value="name")
            public void setName(@Nullable String name) {
                this.name = name;
            }

            @JsonProperty(value="description")
            public void setDescription(@Nullable String description) {
                this.description = description;
            }

            @JsonProperty(value="impls")
            public void setImpls(List<SimpleExtension.WindowFunctionVariant> impls) {
                this.impls = impls;
            }

            @Override
            public String name() {
                throw new UnsupportedOperationException();
            }

            @Override
            public String description() {
                throw new UnsupportedOperationException();
            }

            @Override
            public List<SimpleExtension.WindowFunctionVariant> impls() {
                throw new UnsupportedOperationException();
            }
        }
    }

    @Generated(from="SimpleExtension.AggregateFunction", generator="Immutables")
    @Immutable
    public static final class AggregateFunction
    extends SimpleExtension.AggregateFunction {
        @Nullable
        private final String name;
        @Nullable
        private final String description;
        private final List<SimpleExtension.AggregateFunctionVariant> impls;

        private AggregateFunction(@Nullable String name, @Nullable String description, List<SimpleExtension.AggregateFunctionVariant> impls) {
            this.name = name;
            this.description = description;
            this.impls = impls;
        }

        @Override
        @JsonProperty(value="name")
        @Nullable
        public String name() {
            return this.name;
        }

        @Override
        @JsonProperty(value="description")
        @Nullable
        public String description() {
            return this.description;
        }

        @Override
        @JsonProperty(value="impls")
        public List<SimpleExtension.AggregateFunctionVariant> impls() {
            return this.impls;
        }

        public final AggregateFunction withName(@Nullable String value) {
            if (Objects.equals(this.name, value)) {
                return this;
            }
            return new AggregateFunction(value, this.description, this.impls);
        }

        public final AggregateFunction withDescription(@Nullable String value) {
            if (Objects.equals(this.description, value)) {
                return this;
            }
            return new AggregateFunction(this.name, value, this.impls);
        }

        public final AggregateFunction withImpls(SimpleExtension.AggregateFunctionVariant ... elements) {
            List newValue = ImmutableSimpleExtension.createUnmodifiableList(false, ImmutableSimpleExtension.createSafeList(Arrays.asList(elements), true, false));
            return new AggregateFunction(this.name, this.description, newValue);
        }

        public final AggregateFunction withImpls(Iterable<? extends SimpleExtension.AggregateFunctionVariant> elements) {
            if (this.impls == elements) {
                return this;
            }
            List newValue = ImmutableSimpleExtension.createUnmodifiableList(false, ImmutableSimpleExtension.createSafeList(elements, true, false));
            return new AggregateFunction(this.name, this.description, newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof AggregateFunction && this.equalTo(0, (AggregateFunction)another);
        }

        private boolean equalTo(int synthetic, AggregateFunction another) {
            return Objects.equals(this.name, another.name) && Objects.equals(this.description, another.description) && this.impls.equals(another.impls);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Objects.hashCode(this.name);
            h += (h << 5) + Objects.hashCode(this.description);
            h += (h << 5) + this.impls.hashCode();
            return h;
        }

        public String toString() {
            return "AggregateFunction{name=" + this.name + ", description=" + this.description + ", impls=" + this.impls + "}";
        }

        @Deprecated
        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        static AggregateFunction fromJson(Json json) {
            Builder builder = AggregateFunction.builder();
            if (json.name != null) {
                builder.name(json.name);
            }
            if (json.description != null) {
                builder.description(json.description);
            }
            if (json.impls != null) {
                builder.addAllImpls(json.impls);
            }
            return builder.build();
        }

        public static AggregateFunction copyOf(SimpleExtension.AggregateFunction instance) {
            if (instance instanceof AggregateFunction) {
                return (AggregateFunction)instance;
            }
            return AggregateFunction.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="SimpleExtension.AggregateFunction", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            @Nullable
            private String name;
            @Nullable
            private String description;
            private List<SimpleExtension.AggregateFunctionVariant> impls = new ArrayList<SimpleExtension.AggregateFunctionVariant>();

            private Builder() {
            }

            public final Builder from(SimpleExtension.AggregateFunction instance) {
                String descriptionValue;
                Objects.requireNonNull(instance, "instance");
                String nameValue = instance.name();
                if (nameValue != null) {
                    this.name(nameValue);
                }
                if ((descriptionValue = instance.description()) != null) {
                    this.description(descriptionValue);
                }
                this.addAllImpls(instance.impls());
                return this;
            }

            @JsonProperty(value="name")
            public final Builder name(@Nullable String name) {
                this.name = name;
                return this;
            }

            @JsonProperty(value="description")
            public final Builder description(@Nullable String description) {
                this.description = description;
                return this;
            }

            public final Builder addImpls(SimpleExtension.AggregateFunctionVariant element) {
                this.impls.add(Objects.requireNonNull(element, "impls element"));
                return this;
            }

            public final Builder addImpls(SimpleExtension.AggregateFunctionVariant ... elements) {
                for (SimpleExtension.AggregateFunctionVariant element : elements) {
                    this.impls.add(Objects.requireNonNull(element, "impls element"));
                }
                return this;
            }

            @JsonProperty(value="impls")
            public final Builder impls(Iterable<? extends SimpleExtension.AggregateFunctionVariant> elements) {
                this.impls.clear();
                return this.addAllImpls(elements);
            }

            public final Builder addAllImpls(Iterable<? extends SimpleExtension.AggregateFunctionVariant> elements) {
                for (SimpleExtension.AggregateFunctionVariant aggregateFunctionVariant : elements) {
                    this.impls.add(Objects.requireNonNull(aggregateFunctionVariant, "impls element"));
                }
                return this;
            }

            public AggregateFunction build() {
                return new AggregateFunction(this.name, this.description, ImmutableSimpleExtension.createUnmodifiableList(true, this.impls));
            }
        }

        @Deprecated
        @JsonDeserialize
        @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
        @Generated(from="SimpleExtension.AggregateFunction", generator="Immutables")
        static final class Json
        extends SimpleExtension.AggregateFunction {
            @Nullable
            String name;
            @Nullable
            String description;
            @Nullable
            List<SimpleExtension.AggregateFunctionVariant> impls = Collections.emptyList();

            Json() {
            }

            @JsonProperty(value="name")
            public void setName(@Nullable String name) {
                this.name = name;
            }

            @JsonProperty(value="description")
            public void setDescription(@Nullable String description) {
                this.description = description;
            }

            @JsonProperty(value="impls")
            public void setImpls(List<SimpleExtension.AggregateFunctionVariant> impls) {
                this.impls = impls;
            }

            @Override
            public String name() {
                throw new UnsupportedOperationException();
            }

            @Override
            public String description() {
                throw new UnsupportedOperationException();
            }

            @Override
            public List<SimpleExtension.AggregateFunctionVariant> impls() {
                throw new UnsupportedOperationException();
            }
        }
    }

    @Generated(from="SimpleExtension.ScalarFunctionVariant", generator="Immutables")
    @Immutable
    public static final class ScalarFunctionVariant
    extends SimpleExtension.ScalarFunctionVariant {
        private final String name;
        private final String uri;
        @Nullable
        private final SimpleExtension.VariadicBehavior variadic;
        @Nullable
        private final String description;
        private final List<SimpleExtension.Argument> args;
        private final Map<String, SimpleExtension.Option> options;
        private final SimpleExtension.Nullability nullability;
        @Nullable
        private final Boolean ordered;
        private final TypeExpression returnType;
        private static final byte STAGE_INITIALIZING = -1;
        private static final byte STAGE_UNINITIALIZED = 0;
        private static final byte STAGE_INITIALIZED = 1;
        private volatile transient InitShim initShim = new InitShim();

        private ScalarFunctionVariant(Builder builder) {
            this.variadic = builder.variadic;
            this.args = ImmutableSimpleExtension.createUnmodifiableList(true, builder.args);
            this.options = ImmutableSimpleExtension.createUnmodifiableMap(false, false, builder.options);
            this.ordered = builder.ordered;
            this.returnType = builder.returnType;
            if (builder.name != null) {
                this.initShim.name(builder.name);
            }
            if (builder.uri != null) {
                this.initShim.uri(builder.uri);
            }
            if (builder.descriptionIsSet()) {
                this.initShim.description(builder.description);
            }
            if (builder.nullability != null) {
                this.initShim.nullability(builder.nullability);
            }
            this.name = this.initShim.name();
            this.uri = this.initShim.uri();
            this.description = this.initShim.description();
            this.nullability = this.initShim.nullability();
            this.initShim = null;
        }

        private ScalarFunctionVariant(String name, String uri, @Nullable SimpleExtension.VariadicBehavior variadic, @Nullable String description, List<SimpleExtension.Argument> args, Map<String, SimpleExtension.Option> options, SimpleExtension.Nullability nullability, @Nullable Boolean ordered, TypeExpression returnType) {
            this.name = name;
            this.uri = uri;
            this.variadic = variadic;
            this.description = description;
            this.args = args;
            this.options = options;
            this.nullability = nullability;
            this.ordered = ordered;
            this.returnType = returnType;
            this.initShim = null;
        }

        @Override
        @JsonProperty(value="name")
        public String name() {
            InitShim shim = this.initShim;
            return shim != null ? shim.name() : this.name;
        }

        @Override
        @JsonProperty(value="uri")
        public String uri() {
            InitShim shim = this.initShim;
            return shim != null ? shim.uri() : this.uri;
        }

        @Override
        @JsonProperty(value="variadic")
        public Optional<SimpleExtension.VariadicBehavior> variadic() {
            return Optional.ofNullable(this.variadic);
        }

        @Override
        @JsonProperty(value="description")
        @Nullable
        public String description() {
            InitShim shim = this.initShim;
            return shim != null ? shim.description() : this.description;
        }

        @Override
        @JsonProperty(value="args")
        public List<SimpleExtension.Argument> args() {
            return this.args;
        }

        @Override
        @JsonProperty(value="options")
        public Map<String, SimpleExtension.Option> options() {
            return this.options;
        }

        @Override
        @JsonProperty(value="nullability")
        public SimpleExtension.Nullability nullability() {
            InitShim shim = this.initShim;
            return shim != null ? shim.nullability() : this.nullability;
        }

        @Override
        @JsonProperty(value="ordered")
        @Nullable
        public Boolean ordered() {
            return this.ordered;
        }

        @Override
        @JsonProperty(value="return")
        public TypeExpression returnType() {
            return this.returnType;
        }

        public final ScalarFunctionVariant withName(String value) {
            String newValue = Objects.requireNonNull(value, "name");
            if (this.name.equals(newValue)) {
                return this;
            }
            return new ScalarFunctionVariant(newValue, this.uri, this.variadic, this.description, this.args, this.options, this.nullability, this.ordered, this.returnType);
        }

        public final ScalarFunctionVariant withUri(String value) {
            String newValue = Objects.requireNonNull(value, "uri");
            if (this.uri.equals(newValue)) {
                return this;
            }
            return new ScalarFunctionVariant(this.name, newValue, this.variadic, this.description, this.args, this.options, this.nullability, this.ordered, this.returnType);
        }

        public final ScalarFunctionVariant withVariadic(SimpleExtension.VariadicBehavior value) {
            SimpleExtension.VariadicBehavior newValue = Objects.requireNonNull(value, "variadic");
            if (this.variadic == newValue) {
                return this;
            }
            return new ScalarFunctionVariant(this.name, this.uri, newValue, this.description, this.args, this.options, this.nullability, this.ordered, this.returnType);
        }

        public final ScalarFunctionVariant withVariadic(Optional<? extends SimpleExtension.VariadicBehavior> optional) {
            SimpleExtension.VariadicBehavior value = optional.orElse(null);
            if (this.variadic == value) {
                return this;
            }
            return new ScalarFunctionVariant(this.name, this.uri, value, this.description, this.args, this.options, this.nullability, this.ordered, this.returnType);
        }

        public final ScalarFunctionVariant withDescription(@Nullable String value) {
            if (Objects.equals(this.description, value)) {
                return this;
            }
            return new ScalarFunctionVariant(this.name, this.uri, this.variadic, value, this.args, this.options, this.nullability, this.ordered, this.returnType);
        }

        public final ScalarFunctionVariant withArgs(SimpleExtension.Argument ... elements) {
            List newValue = ImmutableSimpleExtension.createUnmodifiableList(false, ImmutableSimpleExtension.createSafeList(Arrays.asList(elements), true, false));
            return new ScalarFunctionVariant(this.name, this.uri, this.variadic, this.description, newValue, this.options, this.nullability, this.ordered, this.returnType);
        }

        public final ScalarFunctionVariant withArgs(Iterable<? extends SimpleExtension.Argument> elements) {
            if (this.args == elements) {
                return this;
            }
            List newValue = ImmutableSimpleExtension.createUnmodifiableList(false, ImmutableSimpleExtension.createSafeList(elements, true, false));
            return new ScalarFunctionVariant(this.name, this.uri, this.variadic, this.description, newValue, this.options, this.nullability, this.ordered, this.returnType);
        }

        public final ScalarFunctionVariant withOptions(Map<String, ? extends SimpleExtension.Option> entries) {
            if (this.options == entries) {
                return this;
            }
            Map newValue = ImmutableSimpleExtension.createUnmodifiableMap(true, false, entries);
            return new ScalarFunctionVariant(this.name, this.uri, this.variadic, this.description, this.args, newValue, this.nullability, this.ordered, this.returnType);
        }

        public final ScalarFunctionVariant withNullability(SimpleExtension.Nullability value) {
            SimpleExtension.Nullability newValue = Objects.requireNonNull(value, "nullability");
            if (this.nullability == newValue) {
                return this;
            }
            return new ScalarFunctionVariant(this.name, this.uri, this.variadic, this.description, this.args, this.options, newValue, this.ordered, this.returnType);
        }

        public final ScalarFunctionVariant withOrdered(@Nullable Boolean value) {
            if (Objects.equals(this.ordered, value)) {
                return this;
            }
            return new ScalarFunctionVariant(this.name, this.uri, this.variadic, this.description, this.args, this.options, this.nullability, value, this.returnType);
        }

        public final ScalarFunctionVariant withReturnType(TypeExpression value) {
            if (this.returnType == value) {
                return this;
            }
            TypeExpression newValue = Objects.requireNonNull(value, "returnType");
            return new ScalarFunctionVariant(this.name, this.uri, this.variadic, this.description, this.args, this.options, this.nullability, this.ordered, newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof ScalarFunctionVariant && this.equalTo(0, (ScalarFunctionVariant)another);
        }

        private boolean equalTo(int synthetic, ScalarFunctionVariant another) {
            return this.name.equals(another.name) && this.uri.equals(another.uri) && Objects.equals(this.variadic, another.variadic) && Objects.equals(this.description, another.description) && this.args.equals(another.args) && this.options.equals(another.options) && this.nullability.equals((Object)another.nullability) && Objects.equals(this.ordered, another.ordered) && this.returnType.equals(another.returnType);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.name.hashCode();
            h += (h << 5) + this.uri.hashCode();
            h += (h << 5) + Objects.hashCode(this.variadic);
            h += (h << 5) + Objects.hashCode(this.description);
            h += (h << 5) + this.args.hashCode();
            h += (h << 5) + this.options.hashCode();
            h += (h << 5) + this.nullability.hashCode();
            h += (h << 5) + Objects.hashCode(this.ordered);
            h += (h << 5) + this.returnType.hashCode();
            return h;
        }

        @Deprecated
        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        static ScalarFunctionVariant fromJson(Json json) {
            Builder builder = ScalarFunctionVariant.builder();
            if (json.name != null) {
                builder.name(json.name);
            }
            if (json.uri != null) {
                builder.uri(json.uri);
            }
            if (json.variadic != null) {
                builder.variadic(json.variadic);
            }
            if (json.descriptionIsSet) {
                builder.description(json.description);
            }
            if (json.args != null) {
                builder.addAllArgs(json.args);
            }
            if (json.options != null) {
                builder.putAllOptions(json.options);
            }
            if (json.nullability != null) {
                builder.nullability(json.nullability);
            }
            if (json.ordered != null) {
                builder.ordered(json.ordered);
            }
            if (json.returnType != null) {
                builder.returnType(json.returnType);
            }
            return builder.build();
        }

        public static ScalarFunctionVariant copyOf(SimpleExtension.ScalarFunctionVariant instance) {
            if (instance instanceof ScalarFunctionVariant) {
                return (ScalarFunctionVariant)instance;
            }
            return ScalarFunctionVariant.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="SimpleExtension.ScalarFunctionVariant", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_RETURN_TYPE = 1L;
            private static final long OPT_BIT_DESCRIPTION = 1L;
            private long initBits = 1L;
            private long optBits;
            @Nullable
            private String name;
            @Nullable
            private String uri;
            @Nullable
            private SimpleExtension.VariadicBehavior variadic;
            @Nullable
            private String description;
            private List<SimpleExtension.Argument> args = new ArrayList<SimpleExtension.Argument>();
            private Map<String, SimpleExtension.Option> options = new LinkedHashMap<String, SimpleExtension.Option>();
            @Nullable
            private SimpleExtension.Nullability nullability;
            @Nullable
            private Boolean ordered;
            @Nullable
            private TypeExpression returnType;

            private Builder() {
            }

            public final Builder from(SimpleExtension.Function instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((short)0, instance);
                return this;
            }

            public final Builder from(SimpleExtension.ScalarFunctionVariant instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((short)0, instance);
                return this;
            }

            private void from(short _unused, Object object) {
                if (object instanceof SimpleExtension.Function) {
                    Optional<SimpleExtension.VariadicBehavior> variadicOptional;
                    SimpleExtension.Function instance = (SimpleExtension.Function)object;
                    this.addAllArgs(instance.args());
                    Boolean orderedValue = instance.ordered();
                    if (orderedValue != null) {
                        this.ordered(orderedValue);
                    }
                    this.nullability(instance.nullability());
                    this.name(instance.name());
                    this.putAllOptions(instance.options());
                    String descriptionValue = instance.description();
                    if (descriptionValue != null) {
                        this.description(descriptionValue);
                    }
                    if ((variadicOptional = instance.variadic()).isPresent()) {
                        this.variadic(variadicOptional);
                    }
                    this.uri(instance.uri());
                    this.returnType(instance.returnType());
                }
            }

            @JsonProperty(value="name")
            public final Builder name(String name) {
                this.name = Objects.requireNonNull(name, "name");
                return this;
            }

            @JsonProperty(value="uri")
            public final Builder uri(String uri) {
                this.uri = Objects.requireNonNull(uri, "uri");
                return this;
            }

            public final Builder variadic(SimpleExtension.VariadicBehavior variadic) {
                this.variadic = Objects.requireNonNull(variadic, "variadic");
                return this;
            }

            @JsonProperty(value="variadic")
            public final Builder variadic(Optional<? extends SimpleExtension.VariadicBehavior> variadic) {
                this.variadic = variadic.orElse(null);
                return this;
            }

            @JsonProperty(value="description")
            public final Builder description(@Nullable String description) {
                this.description = description;
                this.optBits |= 1L;
                return this;
            }

            public final Builder addArgs(SimpleExtension.Argument element) {
                this.args.add(Objects.requireNonNull(element, "args element"));
                return this;
            }

            public final Builder addArgs(SimpleExtension.Argument ... elements) {
                for (SimpleExtension.Argument element : elements) {
                    this.args.add(Objects.requireNonNull(element, "args element"));
                }
                return this;
            }

            @JsonProperty(value="args")
            public final Builder args(Iterable<? extends SimpleExtension.Argument> elements) {
                this.args.clear();
                return this.addAllArgs(elements);
            }

            public final Builder addAllArgs(Iterable<? extends SimpleExtension.Argument> elements) {
                for (SimpleExtension.Argument argument : elements) {
                    this.args.add(Objects.requireNonNull(argument, "args element"));
                }
                return this;
            }

            public final Builder putOptions(String key, SimpleExtension.Option value) {
                this.options.put(Objects.requireNonNull(key, "options key"), Objects.requireNonNull(value, value == null ? "options value for key: " + key : null));
                return this;
            }

            public final Builder putOptions(Map.Entry<String, ? extends SimpleExtension.Option> entry) {
                SimpleExtension.Option v;
                String k = entry.getKey();
                this.options.put(Objects.requireNonNull(k, "options key"), Objects.requireNonNull(v, (v = entry.getValue()) == null ? "options value for key: " + k : null));
                return this;
            }

            @JsonProperty(value="options")
            public final Builder options(Map<String, ? extends SimpleExtension.Option> entries) {
                this.options.clear();
                return this.putAllOptions(entries);
            }

            public final Builder putAllOptions(Map<String, ? extends SimpleExtension.Option> entries) {
                for (Map.Entry<String, ? extends SimpleExtension.Option> e : entries.entrySet()) {
                    SimpleExtension.Option v;
                    String k = e.getKey();
                    this.options.put(Objects.requireNonNull(k, "options key"), Objects.requireNonNull(v, (v = e.getValue()) == null ? "options value for key: " + k : null));
                }
                return this;
            }

            @JsonProperty(value="nullability")
            public final Builder nullability(SimpleExtension.Nullability nullability) {
                this.nullability = Objects.requireNonNull(nullability, "nullability");
                return this;
            }

            @JsonProperty(value="ordered")
            public final Builder ordered(@Nullable Boolean ordered) {
                this.ordered = ordered;
                return this;
            }

            @JsonProperty(value="return")
            public final Builder returnType(TypeExpression returnType) {
                this.returnType = Objects.requireNonNull(returnType, "returnType");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public ScalarFunctionVariant build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new ScalarFunctionVariant(this);
            }

            private boolean descriptionIsSet() {
                return (this.optBits & 1L) != 0L;
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("returnType");
                }
                return "Cannot build ScalarFunctionVariant, some of required attributes are not set " + attributes;
            }
        }

        @Generated(from="SimpleExtension.ScalarFunctionVariant", generator="Immutables")
        private final class InitShim {
            private byte nameBuildStage = 0;
            private String name;
            private byte uriBuildStage = 0;
            private String uri;
            private byte descriptionBuildStage = 0;
            private String description;
            private byte nullabilityBuildStage = 0;
            private SimpleExtension.Nullability nullability;

            private InitShim() {
            }

            String name() {
                if (this.nameBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.nameBuildStage == 0) {
                    this.nameBuildStage = (byte)-1;
                    this.name = Objects.requireNonNull(ScalarFunctionVariant.super.name(), "name");
                    this.nameBuildStage = 1;
                }
                return this.name;
            }

            void name(String name) {
                this.name = name;
                this.nameBuildStage = 1;
            }

            String uri() {
                if (this.uriBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.uriBuildStage == 0) {
                    this.uriBuildStage = (byte)-1;
                    this.uri = Objects.requireNonNull(ScalarFunctionVariant.super.uri(), "uri");
                    this.uriBuildStage = 1;
                }
                return this.uri;
            }

            void uri(String uri) {
                this.uri = uri;
                this.uriBuildStage = 1;
            }

            String description() {
                if (this.descriptionBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.descriptionBuildStage == 0) {
                    this.descriptionBuildStage = (byte)-1;
                    this.description = ScalarFunctionVariant.super.description();
                    this.descriptionBuildStage = 1;
                }
                return this.description;
            }

            void description(String description) {
                this.description = description;
                this.descriptionBuildStage = 1;
            }

            SimpleExtension.Nullability nullability() {
                if (this.nullabilityBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.nullabilityBuildStage == 0) {
                    this.nullabilityBuildStage = (byte)-1;
                    this.nullability = Objects.requireNonNull(ScalarFunctionVariant.super.nullability(), "nullability");
                    this.nullabilityBuildStage = 1;
                }
                return this.nullability;
            }

            void nullability(SimpleExtension.Nullability nullability) {
                this.nullability = nullability;
                this.nullabilityBuildStage = 1;
            }

            private String formatInitCycleMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if (this.nameBuildStage == -1) {
                    attributes.add("name");
                }
                if (this.uriBuildStage == -1) {
                    attributes.add("uri");
                }
                if (this.descriptionBuildStage == -1) {
                    attributes.add("description");
                }
                if (this.nullabilityBuildStage == -1) {
                    attributes.add("nullability");
                }
                return "Cannot build ScalarFunctionVariant, attribute initializers form cycle " + attributes;
            }
        }

        @Deprecated
        @JsonDeserialize
        @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
        @Generated(from="SimpleExtension.ScalarFunctionVariant", generator="Immutables")
        static final class Json
        extends SimpleExtension.ScalarFunctionVariant {
            @Nullable
            String name;
            @Nullable
            String uri;
            @Nullable
            Optional<SimpleExtension.VariadicBehavior> variadic = Optional.empty();
            @Nullable
            String description;
            boolean descriptionIsSet;
            @Nullable
            List<SimpleExtension.Argument> args = Collections.emptyList();
            @Nullable
            Map<String, SimpleExtension.Option> options = Collections.emptyMap();
            @Nullable
            SimpleExtension.Nullability nullability;
            @Nullable
            Boolean ordered;
            @Nullable
            TypeExpression returnType;

            Json() {
            }

            @JsonProperty(value="name")
            public void setName(String name) {
                this.name = name;
            }

            @JsonProperty(value="uri")
            public void setUri(String uri) {
                this.uri = uri;
            }

            @JsonProperty(value="variadic")
            public void setVariadic(Optional<SimpleExtension.VariadicBehavior> variadic) {
                this.variadic = variadic;
            }

            @JsonProperty(value="description")
            public void setDescription(@Nullable String description) {
                this.description = description;
                this.descriptionIsSet = true;
            }

            @JsonProperty(value="args")
            public void setArgs(List<SimpleExtension.Argument> args) {
                this.args = args;
            }

            @JsonProperty(value="options")
            public void setOptions(Map<String, SimpleExtension.Option> options) {
                this.options = options;
            }

            @JsonProperty(value="nullability")
            public void setNullability(SimpleExtension.Nullability nullability) {
                this.nullability = nullability;
            }

            @JsonProperty(value="ordered")
            public void setOrdered(@Nullable Boolean ordered) {
                this.ordered = ordered;
            }

            @JsonProperty(value="return")
            public void setReturnType(TypeExpression returnType) {
                this.returnType = returnType;
            }

            @Override
            public String name() {
                throw new UnsupportedOperationException();
            }

            @Override
            public String uri() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Optional<SimpleExtension.VariadicBehavior> variadic() {
                throw new UnsupportedOperationException();
            }

            @Override
            public String description() {
                throw new UnsupportedOperationException();
            }

            @Override
            public List<SimpleExtension.Argument> args() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Map<String, SimpleExtension.Option> options() {
                throw new UnsupportedOperationException();
            }

            @Override
            public SimpleExtension.Nullability nullability() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Boolean ordered() {
                throw new UnsupportedOperationException();
            }

            @Override
            public TypeExpression returnType() {
                throw new UnsupportedOperationException();
            }
        }
    }

    @Generated(from="SimpleExtension.ScalarFunction", generator="Immutables")
    @Immutable
    public static final class ScalarFunction
    extends SimpleExtension.ScalarFunction {
        private final String name;
        @Nullable
        private final String description;
        private final List<SimpleExtension.ScalarFunctionVariant> impls;

        private ScalarFunction(String name, @Nullable String description, List<SimpleExtension.ScalarFunctionVariant> impls) {
            this.name = name;
            this.description = description;
            this.impls = impls;
        }

        @Override
        @JsonProperty(value="name")
        public String name() {
            return this.name;
        }

        @Override
        @JsonProperty(value="description")
        @Nullable
        public String description() {
            return this.description;
        }

        @Override
        @JsonProperty(value="impls")
        public List<SimpleExtension.ScalarFunctionVariant> impls() {
            return this.impls;
        }

        public final ScalarFunction withName(String value) {
            String newValue = Objects.requireNonNull(value, "name");
            if (this.name.equals(newValue)) {
                return this;
            }
            return new ScalarFunction(newValue, this.description, this.impls);
        }

        public final ScalarFunction withDescription(@Nullable String value) {
            if (Objects.equals(this.description, value)) {
                return this;
            }
            return new ScalarFunction(this.name, value, this.impls);
        }

        public final ScalarFunction withImpls(SimpleExtension.ScalarFunctionVariant ... elements) {
            List newValue = ImmutableSimpleExtension.createUnmodifiableList(false, ImmutableSimpleExtension.createSafeList(Arrays.asList(elements), true, false));
            return new ScalarFunction(this.name, this.description, newValue);
        }

        public final ScalarFunction withImpls(Iterable<? extends SimpleExtension.ScalarFunctionVariant> elements) {
            if (this.impls == elements) {
                return this;
            }
            List newValue = ImmutableSimpleExtension.createUnmodifiableList(false, ImmutableSimpleExtension.createSafeList(elements, true, false));
            return new ScalarFunction(this.name, this.description, newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof ScalarFunction && this.equalTo(0, (ScalarFunction)another);
        }

        private boolean equalTo(int synthetic, ScalarFunction another) {
            return this.name.equals(another.name) && Objects.equals(this.description, another.description) && this.impls.equals(another.impls);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.name.hashCode();
            h += (h << 5) + Objects.hashCode(this.description);
            h += (h << 5) + this.impls.hashCode();
            return h;
        }

        public String toString() {
            return "ScalarFunction{name=" + this.name + ", description=" + this.description + ", impls=" + this.impls + "}";
        }

        @Deprecated
        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        static ScalarFunction fromJson(Json json) {
            Builder builder = ScalarFunction.builder();
            if (json.name != null) {
                builder.name(json.name);
            }
            if (json.description != null) {
                builder.description(json.description);
            }
            if (json.impls != null) {
                builder.addAllImpls(json.impls);
            }
            return builder.build();
        }

        public static ScalarFunction copyOf(SimpleExtension.ScalarFunction instance) {
            if (instance instanceof ScalarFunction) {
                return (ScalarFunction)instance;
            }
            return ScalarFunction.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="SimpleExtension.ScalarFunction", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_NAME = 1L;
            private long initBits = 1L;
            @Nullable
            private String name;
            @Nullable
            private String description;
            private List<SimpleExtension.ScalarFunctionVariant> impls = new ArrayList<SimpleExtension.ScalarFunctionVariant>();

            private Builder() {
            }

            public final Builder from(SimpleExtension.ScalarFunction instance) {
                Objects.requireNonNull(instance, "instance");
                this.name(instance.name());
                String descriptionValue = instance.description();
                if (descriptionValue != null) {
                    this.description(descriptionValue);
                }
                this.addAllImpls(instance.impls());
                return this;
            }

            @JsonProperty(value="name")
            public final Builder name(String name) {
                this.name = Objects.requireNonNull(name, "name");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            @JsonProperty(value="description")
            public final Builder description(@Nullable String description) {
                this.description = description;
                return this;
            }

            public final Builder addImpls(SimpleExtension.ScalarFunctionVariant element) {
                this.impls.add(Objects.requireNonNull(element, "impls element"));
                return this;
            }

            public final Builder addImpls(SimpleExtension.ScalarFunctionVariant ... elements) {
                for (SimpleExtension.ScalarFunctionVariant element : elements) {
                    this.impls.add(Objects.requireNonNull(element, "impls element"));
                }
                return this;
            }

            @JsonProperty(value="impls")
            public final Builder impls(Iterable<? extends SimpleExtension.ScalarFunctionVariant> elements) {
                this.impls.clear();
                return this.addAllImpls(elements);
            }

            public final Builder addAllImpls(Iterable<? extends SimpleExtension.ScalarFunctionVariant> elements) {
                for (SimpleExtension.ScalarFunctionVariant scalarFunctionVariant : elements) {
                    this.impls.add(Objects.requireNonNull(scalarFunctionVariant, "impls element"));
                }
                return this;
            }

            public ScalarFunction build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new ScalarFunction(this.name, this.description, ImmutableSimpleExtension.createUnmodifiableList(true, this.impls));
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("name");
                }
                return "Cannot build ScalarFunction, some of required attributes are not set " + attributes;
            }
        }

        @Deprecated
        @JsonDeserialize
        @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
        @Generated(from="SimpleExtension.ScalarFunction", generator="Immutables")
        static final class Json
        extends SimpleExtension.ScalarFunction {
            @Nullable
            String name;
            @Nullable
            String description;
            @Nullable
            List<SimpleExtension.ScalarFunctionVariant> impls = Collections.emptyList();

            Json() {
            }

            @JsonProperty(value="name")
            public void setName(String name) {
                this.name = name;
            }

            @JsonProperty(value="description")
            public void setDescription(@Nullable String description) {
                this.description = description;
            }

            @JsonProperty(value="impls")
            public void setImpls(List<SimpleExtension.ScalarFunctionVariant> impls) {
                this.impls = impls;
            }

            @Override
            public String name() {
                throw new UnsupportedOperationException();
            }

            @Override
            public String description() {
                throw new UnsupportedOperationException();
            }

            @Override
            public List<SimpleExtension.ScalarFunctionVariant> impls() {
                throw new UnsupportedOperationException();
            }
        }
    }

    @Generated(from="SimpleExtension.VariadicBehavior", generator="Immutables")
    @Immutable
    public static final class VariadicBehavior
    implements SimpleExtension.VariadicBehavior {
        private final int min;
        @Nullable
        private final Integer max;

        private VariadicBehavior(int min, @Nullable Integer max) {
            this.min = min;
            this.max = max;
        }

        @Override
        @JsonProperty(value="min")
        public int getMin() {
            return this.min;
        }

        @Override
        @JsonProperty(value="max")
        public OptionalInt getMax() {
            return this.max != null ? OptionalInt.of(this.max) : OptionalInt.empty();
        }

        public final VariadicBehavior withMin(int value) {
            if (this.min == value) {
                return this;
            }
            return new VariadicBehavior(value, this.max);
        }

        public final VariadicBehavior withMax(int value) {
            Integer newValue = value;
            if (Objects.equals(this.max, newValue)) {
                return this;
            }
            return new VariadicBehavior(this.min, newValue);
        }

        public final VariadicBehavior withMax(OptionalInt optional) {
            Integer value;
            Integer n = value = optional.isPresent() ? Integer.valueOf(optional.getAsInt()) : null;
            if (Objects.equals(this.max, value)) {
                return this;
            }
            return new VariadicBehavior(this.min, value);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof VariadicBehavior && this.equalTo(0, (VariadicBehavior)another);
        }

        private boolean equalTo(int synthetic, VariadicBehavior another) {
            return this.min == another.min && Objects.equals(this.max, another.max);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.min;
            h += (h << 5) + Objects.hashCode(this.max);
            return h;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("VariadicBehavior{");
            builder.append("min=").append(this.min);
            if (this.max != null) {
                builder.append(", ");
                builder.append("max=").append(this.max);
            }
            return builder.append("}").toString();
        }

        @Deprecated
        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        static VariadicBehavior fromJson(Json json) {
            Builder builder = VariadicBehavior.builder();
            if (json.minIsSet) {
                builder.min(json.min);
            }
            if (json.max != null) {
                builder.max(json.max);
            }
            return builder.build();
        }

        public static VariadicBehavior copyOf(SimpleExtension.VariadicBehavior instance) {
            if (instance instanceof VariadicBehavior) {
                return (VariadicBehavior)instance;
            }
            return VariadicBehavior.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="SimpleExtension.VariadicBehavior", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_MIN = 1L;
            private long initBits = 1L;
            private int min;
            @Nullable
            private Integer max;

            private Builder() {
            }

            public final Builder from(SimpleExtension.VariadicBehavior instance) {
                Objects.requireNonNull(instance, "instance");
                this.min(instance.getMin());
                OptionalInt maxOptional = instance.getMax();
                if (maxOptional.isPresent()) {
                    this.max(maxOptional);
                }
                return this;
            }

            @JsonProperty(value="min")
            public final Builder min(int min) {
                this.min = min;
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public final Builder max(int max) {
                this.max = max;
                return this;
            }

            @JsonProperty(value="max")
            public final Builder max(OptionalInt max) {
                this.max = max.isPresent() ? Integer.valueOf(max.getAsInt()) : null;
                return this;
            }

            public VariadicBehavior build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new VariadicBehavior(this.min, this.max);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("min");
                }
                return "Cannot build VariadicBehavior, some of required attributes are not set " + attributes;
            }
        }

        @Deprecated
        @JsonDeserialize
        @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
        @Generated(from="SimpleExtension.VariadicBehavior", generator="Immutables")
        static final class Json
        implements SimpleExtension.VariadicBehavior {
            int min;
            boolean minIsSet;
            @Nullable
            OptionalInt max = OptionalInt.empty();

            Json() {
            }

            @JsonProperty(value="min")
            public void setMin(int min) {
                this.min = min;
                this.minIsSet = true;
            }

            @JsonProperty(value="max")
            public void setMax(OptionalInt max) {
                this.max = max;
            }

            @Override
            public int getMin() {
                throw new UnsupportedOperationException();
            }

            @Override
            public OptionalInt getMax() {
                throw new UnsupportedOperationException();
            }
        }
    }

    @Generated(from="SimpleExtension.TypeAnchor", generator="Immutables")
    @Immutable
    public static final class TypeAnchor
    implements SimpleExtension.TypeAnchor {
        private final String namespace;
        private final String key;

        private TypeAnchor(String namespace, String key) {
            this.namespace = namespace;
            this.key = key;
        }

        @Override
        public String namespace() {
            return this.namespace;
        }

        @Override
        public String key() {
            return this.key;
        }

        public final TypeAnchor withNamespace(String value) {
            String newValue = Objects.requireNonNull(value, "namespace");
            if (this.namespace.equals(newValue)) {
                return this;
            }
            return new TypeAnchor(newValue, this.key);
        }

        public final TypeAnchor withKey(String value) {
            String newValue = Objects.requireNonNull(value, "key");
            if (this.key.equals(newValue)) {
                return this;
            }
            return new TypeAnchor(this.namespace, newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof TypeAnchor && this.equalTo(0, (TypeAnchor)another);
        }

        private boolean equalTo(int synthetic, TypeAnchor another) {
            return this.namespace.equals(another.namespace) && this.key.equals(another.key);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.namespace.hashCode();
            h += (h << 5) + this.key.hashCode();
            return h;
        }

        public String toString() {
            return "TypeAnchor{namespace=" + this.namespace + ", key=" + this.key + "}";
        }

        public static TypeAnchor copyOf(SimpleExtension.TypeAnchor instance) {
            if (instance instanceof TypeAnchor) {
                return (TypeAnchor)instance;
            }
            return TypeAnchor.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="SimpleExtension.TypeAnchor", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_NAMESPACE = 1L;
            private static final long INIT_BIT_KEY = 2L;
            private long initBits = 3L;
            @Nullable
            private String namespace;
            @Nullable
            private String key;

            private Builder() {
            }

            public final Builder from(SimpleExtension.TypeAnchor instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((short)0, instance);
                return this;
            }

            public final Builder from(SimpleExtension.Anchor instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((short)0, instance);
                return this;
            }

            private void from(short _unused, Object object) {
                SimpleExtension.Anchor instance;
                long bits = 0L;
                if (object instanceof SimpleExtension.TypeAnchor) {
                    instance = (SimpleExtension.TypeAnchor)object;
                    if ((bits & 1L) == 0L) {
                        this.namespace(instance.namespace());
                        bits |= 1L;
                    }
                    if ((bits & 2L) == 0L) {
                        this.key(instance.key());
                        bits |= 2L;
                    }
                }
                if (object instanceof SimpleExtension.Anchor) {
                    instance = (SimpleExtension.Anchor)object;
                    if ((bits & 1L) == 0L) {
                        this.namespace(instance.namespace());
                        bits |= 1L;
                    }
                    if ((bits & 2L) == 0L) {
                        this.key(instance.key());
                        bits |= 2L;
                    }
                }
            }

            public final Builder namespace(String namespace) {
                this.namespace = Objects.requireNonNull(namespace, "namespace");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public final Builder key(String key) {
                this.key = Objects.requireNonNull(key, "key");
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            public TypeAnchor build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new TypeAnchor(this.namespace, this.key);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("namespace");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("key");
                }
                return "Cannot build TypeAnchor, some of required attributes are not set " + attributes;
            }
        }
    }

    @Generated(from="SimpleExtension.FunctionAnchor", generator="Immutables")
    @Immutable
    public static final class FunctionAnchor
    implements SimpleExtension.FunctionAnchor {
        private final String namespace;
        private final String key;

        private FunctionAnchor(String namespace, String key) {
            this.namespace = namespace;
            this.key = key;
        }

        @Override
        public String namespace() {
            return this.namespace;
        }

        @Override
        public String key() {
            return this.key;
        }

        public final FunctionAnchor withNamespace(String value) {
            String newValue = Objects.requireNonNull(value, "namespace");
            if (this.namespace.equals(newValue)) {
                return this;
            }
            return new FunctionAnchor(newValue, this.key);
        }

        public final FunctionAnchor withKey(String value) {
            String newValue = Objects.requireNonNull(value, "key");
            if (this.key.equals(newValue)) {
                return this;
            }
            return new FunctionAnchor(this.namespace, newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof FunctionAnchor && this.equalTo(0, (FunctionAnchor)another);
        }

        private boolean equalTo(int synthetic, FunctionAnchor another) {
            return this.namespace.equals(another.namespace) && this.key.equals(another.key);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.namespace.hashCode();
            h += (h << 5) + this.key.hashCode();
            return h;
        }

        public String toString() {
            return "FunctionAnchor{namespace=" + this.namespace + ", key=" + this.key + "}";
        }

        public static FunctionAnchor copyOf(SimpleExtension.FunctionAnchor instance) {
            if (instance instanceof FunctionAnchor) {
                return (FunctionAnchor)instance;
            }
            return FunctionAnchor.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="SimpleExtension.FunctionAnchor", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_NAMESPACE = 1L;
            private static final long INIT_BIT_KEY = 2L;
            private long initBits = 3L;
            @Nullable
            private String namespace;
            @Nullable
            private String key;

            private Builder() {
            }

            public final Builder from(SimpleExtension.Anchor instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((short)0, instance);
                return this;
            }

            public final Builder from(SimpleExtension.FunctionAnchor instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((short)0, instance);
                return this;
            }

            private void from(short _unused, Object object) {
                SimpleExtension.Anchor instance;
                long bits = 0L;
                if (object instanceof SimpleExtension.Anchor) {
                    instance = (SimpleExtension.Anchor)object;
                    if ((bits & 1L) == 0L) {
                        this.namespace(instance.namespace());
                        bits |= 1L;
                    }
                    if ((bits & 2L) == 0L) {
                        this.key(instance.key());
                        bits |= 2L;
                    }
                }
                if (object instanceof SimpleExtension.FunctionAnchor) {
                    instance = (SimpleExtension.FunctionAnchor)object;
                    if ((bits & 1L) == 0L) {
                        this.namespace(instance.namespace());
                        bits |= 1L;
                    }
                    if ((bits & 2L) == 0L) {
                        this.key(instance.key());
                        bits |= 2L;
                    }
                }
            }

            public final Builder namespace(String namespace) {
                this.namespace = Objects.requireNonNull(namespace, "namespace");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public final Builder key(String key) {
                this.key = Objects.requireNonNull(key, "key");
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            public FunctionAnchor build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new FunctionAnchor(this.namespace, this.key);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("namespace");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("key");
                }
                return "Cannot build FunctionAnchor, some of required attributes are not set " + attributes;
            }
        }
    }

    @Generated(from="SimpleExtension.EnumArgument", generator="Immutables")
    @Immutable
    public static final class EnumArgument
    extends SimpleExtension.EnumArgument {
        @Nullable
        private final String name;
        @Nullable
        private final String description;
        private final List<String> options;

        private EnumArgument(@Nullable String name, @Nullable String description, List<String> options) {
            this.name = name;
            this.description = description;
            this.options = options;
        }

        @Override
        @JsonProperty
        @Nullable
        public String name() {
            return this.name;
        }

        @Override
        @JsonProperty
        @Nullable
        public String description() {
            return this.description;
        }

        @Override
        @JsonProperty(required=true)
        public List<String> options() {
            return this.options;
        }

        public final EnumArgument withName(@Nullable String value) {
            if (Objects.equals(this.name, value)) {
                return this;
            }
            return new EnumArgument(value, this.description, this.options);
        }

        public final EnumArgument withDescription(@Nullable String value) {
            if (Objects.equals(this.description, value)) {
                return this;
            }
            return new EnumArgument(this.name, value, this.options);
        }

        public final EnumArgument withOptions(String ... elements) {
            List newValue = ImmutableSimpleExtension.createUnmodifiableList(false, ImmutableSimpleExtension.createSafeList(Arrays.asList(elements), true, false));
            return new EnumArgument(this.name, this.description, newValue);
        }

        public final EnumArgument withOptions(Iterable<String> elements) {
            if (this.options == elements) {
                return this;
            }
            List newValue = ImmutableSimpleExtension.createUnmodifiableList(false, ImmutableSimpleExtension.createSafeList(elements, true, false));
            return new EnumArgument(this.name, this.description, newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof EnumArgument && this.equalTo(0, (EnumArgument)another);
        }

        private boolean equalTo(int synthetic, EnumArgument another) {
            return Objects.equals(this.name, another.name) && Objects.equals(this.description, another.description) && this.options.equals(another.options);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Objects.hashCode(this.name);
            h += (h << 5) + Objects.hashCode(this.description);
            h += (h << 5) + this.options.hashCode();
            return h;
        }

        public String toString() {
            return "EnumArgument{name=" + this.name + ", description=" + this.description + ", options=" + this.options + "}";
        }

        @Deprecated
        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        static EnumArgument fromJson(Json json) {
            Builder builder = EnumArgument.builder();
            if (json.name != null) {
                builder.name(json.name);
            }
            if (json.description != null) {
                builder.description(json.description);
            }
            if (json.options != null) {
                builder.addAllOptions(json.options);
            }
            return builder.build();
        }

        public static EnumArgument copyOf(SimpleExtension.EnumArgument instance) {
            if (instance instanceof EnumArgument) {
                return (EnumArgument)instance;
            }
            return EnumArgument.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="SimpleExtension.EnumArgument", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            @Nullable
            private String name;
            @Nullable
            private String description;
            private List<String> options = new ArrayList<String>();

            private Builder() {
            }

            public final Builder from(SimpleExtension.Argument instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((short)0, instance);
                return this;
            }

            public final Builder from(SimpleExtension.EnumArgument instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((short)0, instance);
                return this;
            }

            private void from(short _unused, Object object) {
                SimpleExtension.Argument instance;
                if (object instanceof SimpleExtension.Argument) {
                    String descriptionValue;
                    instance = (SimpleExtension.Argument)object;
                    String nameValue = instance.name();
                    if (nameValue != null) {
                        this.name(nameValue);
                    }
                    if ((descriptionValue = instance.description()) != null) {
                        this.description(descriptionValue);
                    }
                }
                if (object instanceof SimpleExtension.EnumArgument) {
                    instance = (SimpleExtension.EnumArgument)object;
                    this.addAllOptions(((SimpleExtension.EnumArgument)instance).options());
                }
            }

            @JsonProperty
            public final Builder name(@Nullable String name) {
                this.name = name;
                return this;
            }

            @JsonProperty
            public final Builder description(@Nullable String description) {
                this.description = description;
                return this;
            }

            public final Builder addOptions(String element) {
                this.options.add(Objects.requireNonNull(element, "options element"));
                return this;
            }

            public final Builder addOptions(String ... elements) {
                for (String element : elements) {
                    this.options.add(Objects.requireNonNull(element, "options element"));
                }
                return this;
            }

            @JsonProperty(required=true)
            public final Builder options(Iterable<String> elements) {
                this.options.clear();
                return this.addAllOptions(elements);
            }

            public final Builder addAllOptions(Iterable<String> elements) {
                for (String element : elements) {
                    this.options.add(Objects.requireNonNull(element, "options element"));
                }
                return this;
            }

            public EnumArgument build() {
                return new EnumArgument(this.name, this.description, ImmutableSimpleExtension.createUnmodifiableList(true, this.options));
            }
        }

        @Deprecated
        @JsonDeserialize
        @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
        @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
        @Generated(from="SimpleExtension.EnumArgument", generator="Immutables")
        static final class Json
        extends SimpleExtension.EnumArgument {
            @Nullable
            String name;
            @Nullable
            String description;
            @Nullable
            List<String> options = Collections.emptyList();

            Json() {
            }

            @JsonProperty
            public void setName(@Nullable String name) {
                this.name = name;
            }

            @JsonProperty
            public void setDescription(@Nullable String description) {
                this.description = description;
            }

            @JsonProperty(required=true)
            public void setOptions(List<String> options) {
                this.options = options;
            }

            @Override
            public String name() {
                throw new UnsupportedOperationException();
            }

            @Override
            public String description() {
                throw new UnsupportedOperationException();
            }

            @Override
            public List<String> options() {
                throw new UnsupportedOperationException();
            }
        }
    }

    @Generated(from="SimpleExtension.TypeArgument", generator="Immutables")
    @Immutable
    public static final class TypeArgument
    extends SimpleExtension.TypeArgument {
        @Nullable
        private final String name;
        @Nullable
        private final String description;
        private final ParameterizedType type;

        private TypeArgument(@Nullable String name, @Nullable String description, ParameterizedType type) {
            this.name = name;
            this.description = description;
            this.type = type;
        }

        @Override
        @JsonProperty
        @Nullable
        public String name() {
            return this.name;
        }

        @Override
        @JsonProperty
        @Nullable
        public String description() {
            return this.description;
        }

        @Override
        @JsonProperty(required=true)
        public ParameterizedType type() {
            return this.type;
        }

        public final TypeArgument withName(@Nullable String value) {
            if (Objects.equals(this.name, value)) {
                return this;
            }
            return new TypeArgument(value, this.description, this.type);
        }

        public final TypeArgument withDescription(@Nullable String value) {
            if (Objects.equals(this.description, value)) {
                return this;
            }
            return new TypeArgument(this.name, value, this.type);
        }

        public final TypeArgument withType(ParameterizedType value) {
            if (this.type == value) {
                return this;
            }
            ParameterizedType newValue = Objects.requireNonNull(value, "type");
            return new TypeArgument(this.name, this.description, newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof TypeArgument && this.equalTo(0, (TypeArgument)another);
        }

        private boolean equalTo(int synthetic, TypeArgument another) {
            return Objects.equals(this.name, another.name) && Objects.equals(this.description, another.description) && this.type.equals(another.type);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Objects.hashCode(this.name);
            h += (h << 5) + Objects.hashCode(this.description);
            h += (h << 5) + this.type.hashCode();
            return h;
        }

        public String toString() {
            return "TypeArgument{name=" + this.name + ", description=" + this.description + ", type=" + this.type + "}";
        }

        @Deprecated
        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        static TypeArgument fromJson(Json json) {
            Builder builder = TypeArgument.builder();
            if (json.name != null) {
                builder.name(json.name);
            }
            if (json.description != null) {
                builder.description(json.description);
            }
            if (json.type != null) {
                builder.type(json.type);
            }
            return builder.build();
        }

        public static TypeArgument copyOf(SimpleExtension.TypeArgument instance) {
            if (instance instanceof TypeArgument) {
                return (TypeArgument)instance;
            }
            return TypeArgument.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="SimpleExtension.TypeArgument", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_TYPE = 1L;
            private long initBits = 1L;
            @Nullable
            private String name;
            @Nullable
            private String description;
            @Nullable
            private ParameterizedType type;

            private Builder() {
            }

            public final Builder from(SimpleExtension.Argument instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((short)0, instance);
                return this;
            }

            public final Builder from(SimpleExtension.TypeArgument instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((short)0, instance);
                return this;
            }

            private void from(short _unused, Object object) {
                SimpleExtension.Argument instance;
                if (object instanceof SimpleExtension.Argument) {
                    String descriptionValue;
                    instance = (SimpleExtension.Argument)object;
                    String nameValue = instance.name();
                    if (nameValue != null) {
                        this.name(nameValue);
                    }
                    if ((descriptionValue = instance.description()) != null) {
                        this.description(descriptionValue);
                    }
                }
                if (object instanceof SimpleExtension.TypeArgument) {
                    instance = (SimpleExtension.TypeArgument)object;
                    this.type(((SimpleExtension.TypeArgument)instance).type());
                }
            }

            @JsonProperty
            public final Builder name(@Nullable String name) {
                this.name = name;
                return this;
            }

            @JsonProperty
            public final Builder description(@Nullable String description) {
                this.description = description;
                return this;
            }

            @JsonProperty(required=true)
            public final Builder type(ParameterizedType type) {
                this.type = Objects.requireNonNull(type, "type");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public TypeArgument build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new TypeArgument(this.name, this.description, this.type);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("type");
                }
                return "Cannot build TypeArgument, some of required attributes are not set " + attributes;
            }
        }

        @Deprecated
        @JsonDeserialize
        @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
        @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
        @Generated(from="SimpleExtension.TypeArgument", generator="Immutables")
        static final class Json
        extends SimpleExtension.TypeArgument {
            @Nullable
            String name;
            @Nullable
            String description;
            @Nullable
            ParameterizedType type;

            Json() {
            }

            @JsonProperty
            public void setName(@Nullable String name) {
                this.name = name;
            }

            @JsonProperty
            public void setDescription(@Nullable String description) {
                this.description = description;
            }

            @JsonProperty(required=true)
            public void setType(ParameterizedType type) {
                this.type = type;
            }

            @Override
            public String name() {
                throw new UnsupportedOperationException();
            }

            @Override
            public String description() {
                throw new UnsupportedOperationException();
            }

            @Override
            public ParameterizedType type() {
                throw new UnsupportedOperationException();
            }
        }
    }

    @Generated(from="SimpleExtension.ValueArgument", generator="Immutables")
    @Immutable
    public static final class ValueArgument
    extends SimpleExtension.ValueArgument {
        @Nullable
        private final String name;
        @Nullable
        private final String description;
        private final ParameterizedType value;
        @Nullable
        private final Boolean constant;

        private ValueArgument(@Nullable String name, @Nullable String description, ParameterizedType value, @Nullable Boolean constant) {
            this.name = name;
            this.description = description;
            this.value = value;
            this.constant = constant;
        }

        @Override
        @JsonProperty
        @Nullable
        public String name() {
            return this.name;
        }

        @Override
        @JsonProperty
        @Nullable
        public String description() {
            return this.description;
        }

        @Override
        @JsonProperty(required=true)
        public ParameterizedType value() {
            return this.value;
        }

        @Override
        @JsonProperty
        @Nullable
        public Boolean constant() {
            return this.constant;
        }

        public final ValueArgument withName(@Nullable String value) {
            if (Objects.equals(this.name, value)) {
                return this;
            }
            return new ValueArgument(value, this.description, this.value, this.constant);
        }

        public final ValueArgument withDescription(@Nullable String value) {
            if (Objects.equals(this.description, value)) {
                return this;
            }
            return new ValueArgument(this.name, value, this.value, this.constant);
        }

        public final ValueArgument withValue(ParameterizedType value) {
            if (this.value == value) {
                return this;
            }
            ParameterizedType newValue = Objects.requireNonNull(value, "value");
            return new ValueArgument(this.name, this.description, newValue, this.constant);
        }

        public final ValueArgument withConstant(@Nullable Boolean value) {
            if (Objects.equals(this.constant, value)) {
                return this;
            }
            return new ValueArgument(this.name, this.description, this.value, value);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof ValueArgument && this.equalTo(0, (ValueArgument)another);
        }

        private boolean equalTo(int synthetic, ValueArgument another) {
            return Objects.equals(this.name, another.name) && Objects.equals(this.description, another.description) && this.value.equals(another.value) && Objects.equals(this.constant, another.constant);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Objects.hashCode(this.name);
            h += (h << 5) + Objects.hashCode(this.description);
            h += (h << 5) + this.value.hashCode();
            h += (h << 5) + Objects.hashCode(this.constant);
            return h;
        }

        public String toString() {
            return "ValueArgument{name=" + this.name + ", description=" + this.description + ", value=" + this.value + ", constant=" + this.constant + "}";
        }

        @Deprecated
        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        static ValueArgument fromJson(Json json) {
            Builder builder = ValueArgument.builder();
            if (json.name != null) {
                builder.name(json.name);
            }
            if (json.description != null) {
                builder.description(json.description);
            }
            if (json.value != null) {
                builder.value(json.value);
            }
            if (json.constant != null) {
                builder.constant(json.constant);
            }
            return builder.build();
        }

        public static ValueArgument copyOf(SimpleExtension.ValueArgument instance) {
            if (instance instanceof ValueArgument) {
                return (ValueArgument)instance;
            }
            return ValueArgument.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="SimpleExtension.ValueArgument", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_VALUE = 1L;
            private long initBits = 1L;
            @Nullable
            private String name;
            @Nullable
            private String description;
            @Nullable
            private ParameterizedType value;
            @Nullable
            private Boolean constant;

            private Builder() {
            }

            public final Builder from(SimpleExtension.ValueArgument instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((short)0, instance);
                return this;
            }

            public final Builder from(SimpleExtension.Argument instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((short)0, instance);
                return this;
            }

            private void from(short _unused, Object object) {
                SimpleExtension.Argument instance;
                if (object instanceof SimpleExtension.ValueArgument) {
                    instance = (SimpleExtension.ValueArgument)object;
                    this.value(((SimpleExtension.ValueArgument)instance).value());
                    Boolean constantValue = ((SimpleExtension.ValueArgument)instance).constant();
                    if (constantValue != null) {
                        this.constant(constantValue);
                    }
                }
                if (object instanceof SimpleExtension.Argument) {
                    String descriptionValue;
                    instance = (SimpleExtension.Argument)object;
                    String nameValue = instance.name();
                    if (nameValue != null) {
                        this.name(nameValue);
                    }
                    if ((descriptionValue = instance.description()) != null) {
                        this.description(descriptionValue);
                    }
                }
            }

            @JsonProperty
            public final Builder name(@Nullable String name) {
                this.name = name;
                return this;
            }

            @JsonProperty
            public final Builder description(@Nullable String description) {
                this.description = description;
                return this;
            }

            @JsonProperty(required=true)
            public final Builder value(ParameterizedType value) {
                this.value = Objects.requireNonNull(value, "value");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            @JsonProperty
            public final Builder constant(@Nullable Boolean constant) {
                this.constant = constant;
                return this;
            }

            public ValueArgument build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new ValueArgument(this.name, this.description, this.value, this.constant);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("value");
                }
                return "Cannot build ValueArgument, some of required attributes are not set " + attributes;
            }
        }

        @Deprecated
        @JsonDeserialize
        @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
        @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
        @Generated(from="SimpleExtension.ValueArgument", generator="Immutables")
        static final class Json
        extends SimpleExtension.ValueArgument {
            @Nullable
            String name;
            @Nullable
            String description;
            @Nullable
            ParameterizedType value;
            @Nullable
            Boolean constant;

            Json() {
            }

            @JsonProperty
            public void setName(@Nullable String name) {
                this.name = name;
            }

            @JsonProperty
            public void setDescription(@Nullable String description) {
                this.description = description;
            }

            @JsonProperty(required=true)
            public void setValue(ParameterizedType value) {
                this.value = value;
            }

            @JsonProperty
            public void setConstant(@Nullable Boolean constant) {
                this.constant = constant;
            }

            @Override
            public String name() {
                throw new UnsupportedOperationException();
            }

            @Override
            public String description() {
                throw new UnsupportedOperationException();
            }

            @Override
            public ParameterizedType value() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Boolean constant() {
                throw new UnsupportedOperationException();
            }
        }
    }

    @Generated(from="SimpleExtension.Option", generator="Immutables")
    @Immutable
    public static final class Option
    implements SimpleExtension.Option {
        @Nullable
        private final String description;
        private final List<String> values;

        private Option(@Nullable String description, List<String> values) {
            this.description = description;
            this.values = values;
        }

        @Override
        @JsonProperty(value="description")
        public Optional<String> getDescription() {
            return Optional.ofNullable(this.description);
        }

        @Override
        @JsonProperty(value="values")
        public List<String> getValues() {
            return this.values;
        }

        public final Option withDescription(String value) {
            String newValue = Objects.requireNonNull(value, "description");
            if (Objects.equals(this.description, newValue)) {
                return this;
            }
            return new Option(newValue, this.values);
        }

        public final Option withDescription(Optional<String> optional) {
            String value = optional.orElse(null);
            if (Objects.equals(this.description, value)) {
                return this;
            }
            return new Option(value, this.values);
        }

        public final Option withValues(String ... elements) {
            List newValue = ImmutableSimpleExtension.createUnmodifiableList(false, ImmutableSimpleExtension.createSafeList(Arrays.asList(elements), true, false));
            return new Option(this.description, newValue);
        }

        public final Option withValues(Iterable<String> elements) {
            if (this.values == elements) {
                return this;
            }
            List newValue = ImmutableSimpleExtension.createUnmodifiableList(false, ImmutableSimpleExtension.createSafeList(elements, true, false));
            return new Option(this.description, newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Option && this.equalTo(0, (Option)another);
        }

        private boolean equalTo(int synthetic, Option another) {
            return Objects.equals(this.description, another.description) && this.values.equals(another.values);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Objects.hashCode(this.description);
            h += (h << 5) + this.values.hashCode();
            return h;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("Option{");
            if (this.description != null) {
                builder.append("description=").append(this.description);
            }
            if (builder.length() > 7) {
                builder.append(", ");
            }
            builder.append("values=").append(this.values);
            return builder.append("}").toString();
        }

        @Deprecated
        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        static Option fromJson(Json json) {
            Builder builder = Option.builder();
            if (json.description != null) {
                builder.description(json.description);
            }
            if (json.values != null) {
                builder.addAllValues(json.values);
            }
            return builder.build();
        }

        public static Option copyOf(SimpleExtension.Option instance) {
            if (instance instanceof Option) {
                return (Option)instance;
            }
            return Option.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="SimpleExtension.Option", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            @Nullable
            private String description;
            private List<String> values = new ArrayList<String>();

            private Builder() {
            }

            public final Builder from(SimpleExtension.Option instance) {
                Objects.requireNonNull(instance, "instance");
                Optional<String> descriptionOptional = instance.getDescription();
                if (descriptionOptional.isPresent()) {
                    this.description(descriptionOptional);
                }
                this.addAllValues(instance.getValues());
                return this;
            }

            public final Builder description(String description) {
                this.description = Objects.requireNonNull(description, "description");
                return this;
            }

            @JsonProperty(value="description")
            public final Builder description(Optional<String> description) {
                this.description = description.orElse(null);
                return this;
            }

            public final Builder addValues(String element) {
                this.values.add(Objects.requireNonNull(element, "values element"));
                return this;
            }

            public final Builder addValues(String ... elements) {
                for (String element : elements) {
                    this.values.add(Objects.requireNonNull(element, "values element"));
                }
                return this;
            }

            @JsonProperty(value="values")
            public final Builder values(Iterable<String> elements) {
                this.values.clear();
                return this.addAllValues(elements);
            }

            public final Builder addAllValues(Iterable<String> elements) {
                for (String element : elements) {
                    this.values.add(Objects.requireNonNull(element, "values element"));
                }
                return this;
            }

            public Option build() {
                return new Option(this.description, ImmutableSimpleExtension.createUnmodifiableList(true, this.values));
            }
        }

        @Deprecated
        @JsonDeserialize
        @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
        @Generated(from="SimpleExtension.Option", generator="Immutables")
        static final class Json
        implements SimpleExtension.Option {
            @Nullable
            Optional<String> description = Optional.empty();
            @Nullable
            List<String> values = Collections.emptyList();

            Json() {
            }

            @JsonProperty(value="description")
            public void setDescription(Optional<String> description) {
                this.description = description;
            }

            @JsonProperty(value="values")
            public void setValues(List<String> values) {
                this.values = values;
            }

            @Override
            public Optional<String> getDescription() {
                throw new UnsupportedOperationException();
            }

            @Override
            public List<String> getValues() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

