/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.extension;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import io.substrait.expression.Expression;
import io.substrait.extension.ImmutableSimpleExtension;
import io.substrait.function.ParameterizedType;
import io.substrait.function.ToTypeString;
import io.substrait.function.TypeExpression;
import io.substrait.type.Deserializers;
import io.substrait.type.TypeExpressionEvaluator;
import io.substrait.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.immutables.value.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Value.Enclosing
public class SimpleExtension {
    static final Logger logger = LoggerFactory.getLogger(SimpleExtension.class);
    public static final String URI_LOCATOR_KEY = "uri";

    private static ObjectMapper objectMapper(String namespace) {
        InjectableValues.Std iv = new InjectableValues.Std();
        iv.addValue(URI_LOCATOR_KEY, (Object)namespace);
        return new ObjectMapper((JsonFactory)new YAMLFactory()).enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY).registerModule((Module)new Jdk8Module()).registerModule((Module)Deserializers.MODULE).setInjectableValues((InjectableValues)iv);
    }

    private SimpleExtension() {
    }

    public static ExtensionCollection loadDefaults() throws IOException {
        List<String> defaultFiles = Arrays.asList("boolean", "aggregate_generic", "aggregate_approx", "arithmetic_decimal", "arithmetic", "comparison", "datetime", "logarithmic", "rounding", "string").stream().map(c -> String.format("/functions_%s.yaml", c)).collect(Collectors.toList());
        return SimpleExtension.load(defaultFiles);
    }

    public static ExtensionCollection load(List<String> resourcePaths) {
        if (resourcePaths.isEmpty()) {
            throw new IllegalArgumentException("Require at least one resource path.");
        }
        List extensions = resourcePaths.stream().map(path -> {
            ExtensionCollection extensionCollection;
            block8: {
                InputStream stream = ExtensionCollection.class.getResourceAsStream((String)path);
                try {
                    extensionCollection = SimpleExtension.load(path, stream);
                    if (stream == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                stream.close();
            }
            return extensionCollection;
        }).collect(Collectors.toList());
        ExtensionCollection complete = (ExtensionCollection)extensions.get(0);
        for (int i = 1; i < extensions.size(); ++i) {
            complete = complete.merge((ExtensionCollection)extensions.get(i));
        }
        return complete;
    }

    public static ExtensionCollection load(String namespace, String str) {
        try {
            ExtensionSignatures doc = (ExtensionSignatures)SimpleExtension.objectMapper(namespace).readValue(str, ExtensionSignatures.class);
            return SimpleExtension.buildExtensionCollection(namespace, doc);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static ExtensionCollection load(String namespace, InputStream stream) {
        try {
            ExtensionSignatures doc = (ExtensionSignatures)SimpleExtension.objectMapper(namespace).readValue(stream, ExtensionSignatures.class);
            return SimpleExtension.buildExtensionCollection(namespace, doc);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException("Failure while parsing " + namespace, ex);
        }
    }

    public static ExtensionCollection buildExtensionCollection(String namespace, ExtensionSignatures extensionSignatures) {
        List scalarFunctionVariants = extensionSignatures.scalars().stream().flatMap(t -> t.resolve(namespace)).collect(Collectors.toList());
        List aggregateFunctionVariants = extensionSignatures.aggregates().stream().flatMap(t -> t.resolve(namespace)).collect(Collectors.toList());
        Stream windowFunctionVariants = extensionSignatures.windows().stream().flatMap(t -> t.resolve(namespace));
        Stream<WindowFunctionVariant> windowAggFunctionVariants = aggregateFunctionVariants.stream().map(afi -> WindowFunctionVariant.builder().from((Function)afi).decomposability(afi.decomposability()).intermediate(afi.intermediate()).windowType(WindowType.STREAMING).build());
        List allWindowFunctionVariants = Stream.concat(windowFunctionVariants, windowAggFunctionVariants).collect(Collectors.toList());
        ImmutableSimpleExtension.ExtensionCollection collection = ImmutableSimpleExtension.ExtensionCollection.builder().scalarFunctions(scalarFunctionVariants).aggregateFunctions(aggregateFunctionVariants).windowFunctions(allWindowFunctionVariants).addAllTypes(extensionSignatures.types()).build();
        logger.atDebug().log("Loaded {} aggregate functions and {} scalar functions from {}.", new Object[]{collection.aggregateFunctions().size(), collection.scalarFunctions().size(), namespace});
        return collection;
    }

    @Value.Immutable
    public static abstract class ExtensionCollection {
        private final Supplier<Set<String>> namespaceSupplier = Util.memoize(() -> Stream.concat(Stream.concat(this.scalarFunctions().stream().map(Function::uri), this.aggregateFunctions().stream().map(Function::uri)), this.windowFunctions().stream().map(Function::uri)).collect(Collectors.toSet()));
        private final Supplier<Map<TypeAnchor, Type>> typeLookup = Util.memoize(() -> this.types().stream().collect(Collectors.toMap(Type::getAnchor, java.util.function.Function.identity())));
        private final Supplier<Map<FunctionAnchor, ScalarFunctionVariant>> scalarFunctionsLookup = Util.memoize(() -> this.scalarFunctions().stream().collect(Collectors.toMap(Function::getAnchor, java.util.function.Function.identity())));
        private final Supplier<Map<FunctionAnchor, AggregateFunctionVariant>> aggregateFunctionsLookup = Util.memoize(() -> this.aggregateFunctions().stream().collect(Collectors.toMap(Function::getAnchor, java.util.function.Function.identity())));
        private final Supplier<Map<FunctionAnchor, WindowFunctionVariant>> windowFunctionsLookup = Util.memoize(() -> this.windowFunctions().stream().collect(Collectors.toMap(Function::getAnchor, java.util.function.Function.identity())));

        public abstract List<Type> types();

        public abstract List<ScalarFunctionVariant> scalarFunctions();

        public abstract List<AggregateFunctionVariant> aggregateFunctions();

        public abstract List<WindowFunctionVariant> windowFunctions();

        public Type getType(TypeAnchor anchor) {
            Type type = this.typeLookup.get().get(anchor);
            if (type != null) {
                return type;
            }
            this.checkNamespace(anchor.namespace());
            throw new IllegalArgumentException(String.format("Unexpected type with name %s. The namespace %s is loaded but no type with this name found.", anchor.key(), anchor.namespace()));
        }

        public ScalarFunctionVariant getScalarFunction(FunctionAnchor anchor) {
            ScalarFunctionVariant variant = this.scalarFunctionsLookup.get().get(anchor);
            if (variant != null) {
                return variant;
            }
            this.checkNamespace(anchor.namespace());
            throw new IllegalArgumentException(String.format("Unexpected scalar function with key %s. The namespace %s is loaded but no scalar function with this key found.", anchor.key(), anchor.namespace()));
        }

        private void checkNamespace(String name) {
            if (this.namespaceSupplier.get().contains(name)) {
                return;
            }
            throw new IllegalArgumentException(String.format("Received a reference for extension %s but that extension is not currently loaded.", name));
        }

        public AggregateFunctionVariant getAggregateFunction(FunctionAnchor anchor) {
            AggregateFunctionVariant variant = this.aggregateFunctionsLookup.get().get(anchor);
            if (variant != null) {
                return variant;
            }
            this.checkNamespace(anchor.namespace());
            throw new IllegalArgumentException(String.format("Unexpected aggregate function with key %s. The namespace %s is loaded but no aggregate function with this key was found.", anchor.key(), anchor.namespace()));
        }

        public WindowFunctionVariant getWindowFunction(FunctionAnchor anchor) {
            WindowFunctionVariant variant = this.windowFunctionsLookup.get().get(anchor);
            if (variant != null) {
                return variant;
            }
            this.checkNamespace(anchor.namespace());
            throw new IllegalArgumentException(String.format("Unexpected window aggregate function with key %s. The namespace %s is loaded but no window aggregate function with this key was found.", anchor.key(), anchor.namespace()));
        }

        public ExtensionCollection merge(ExtensionCollection extensionCollection) {
            return ImmutableSimpleExtension.ExtensionCollection.builder().addAllAggregateFunctions(this.aggregateFunctions()).addAllAggregateFunctions(extensionCollection.aggregateFunctions()).addAllScalarFunctions(this.scalarFunctions()).addAllScalarFunctions(extensionCollection.scalarFunctions()).addAllWindowFunctions(this.windowFunctions()).addAllWindowFunctions(extensionCollection.windowFunctions()).addAllTypes(this.types()).addAllTypes(extensionCollection.types()).build();
        }
    }

    @JsonDeserialize(as=ImmutableSimpleExtension.ExtensionSignatures.class)
    @JsonSerialize(as=ImmutableSimpleExtension.ExtensionSignatures.class)
    @Value.Immutable
    public static abstract class ExtensionSignatures {
        @JsonProperty(value="types")
        public abstract List<Type> types();

        @JsonProperty(value="scalar_functions")
        public abstract List<ScalarFunction> scalars();

        @JsonProperty(value="aggregate_functions")
        public abstract List<AggregateFunction> aggregates();

        @JsonProperty(value="window_functions")
        public abstract List<WindowFunction> windows();

        public int size() {
            return (this.types() == null ? 0 : this.types().size()) + (this.scalars() == null ? 0 : this.scalars().size()) + (this.aggregates() == null ? 0 : this.aggregates().size()) + (this.windows() == null ? 0 : this.windows().size());
        }

        public Stream<Function> resolve(String uri) {
            return Stream.concat(Stream.concat(this.scalars() == null ? Stream.of(new Function[0]) : this.scalars().stream().flatMap(f -> f.resolve(uri)), this.aggregates() == null ? Stream.of(new Function[0]) : this.aggregates().stream().flatMap(f -> f.resolve(uri))), this.windows() == null ? Stream.of(new Function[0]) : this.windows().stream().flatMap(f -> f.resolve(uri)));
        }
    }

    @JsonDeserialize(as=ImmutableSimpleExtension.WindowFunctionVariant.class)
    @JsonSerialize(as=ImmutableSimpleExtension.WindowFunctionVariant.class)
    @Value.Immutable
    public static abstract class WindowFunctionVariant
    extends Function {
        @JsonProperty(value="decomposable")
        @Value.Default
        public Decomposability decomposability() {
            return Decomposability.NONE;
        }

        @Nullable
        public abstract TypeExpression intermediate();

        @JsonProperty(value="window_type")
        @Value.Default
        public WindowType windowType() {
            return WindowType.PARTITION;
        }

        @Override
        public String toString() {
            return super.toString();
        }

        WindowFunctionVariant resolve(String uri, String name, String description) {
            return ImmutableSimpleExtension.WindowFunctionVariant.builder().uri(uri).name(name).description(description).nullability(this.nullability()).args(this.args()).options(this.options()).ordered(this.ordered()).variadic(this.variadic()).decomposability(this.decomposability()).intermediate(this.intermediate()).returnType(this.returnType()).windowType(this.windowType()).build();
        }

        public static ImmutableSimpleExtension.WindowFunctionVariant.Builder builder() {
            return ImmutableSimpleExtension.WindowFunctionVariant.builder();
        }
    }

    public static abstract class Function {
        private final Supplier<FunctionAnchor> anchorSupplier = Util.memoize(() -> FunctionAnchor.of(this.uri(), this.key()));
        private final Supplier<String> keySupplier = Util.memoize(() -> Function.constructKey(this.name(), this.args()));
        private final Supplier<List<Argument>> requiredArgsSupplier = Util.memoize(() -> this.args().stream().filter(Argument::required).collect(Collectors.toList()));

        @Value.Default
        public String name() {
            return "";
        }

        @Value.Default
        public String uri() {
            return "";
        }

        public abstract Optional<VariadicBehavior> variadic();

        @Nullable
        @Value.Default
        public String description() {
            return "";
        }

        public abstract List<Argument> args();

        public abstract Map<String, Option> options();

        public List<Argument> requiredArguments() {
            return this.requiredArgsSupplier.get();
        }

        public String toString() {
            return this.key();
        }

        @Value.Default
        public Nullability nullability() {
            return Nullability.MIRROR;
        }

        @Nullable
        public abstract Boolean ordered();

        public FunctionAnchor getAnchor() {
            return this.anchorSupplier.get();
        }

        @JsonProperty(value="return")
        public abstract TypeExpression returnType();

        public static String constructKeyFromTypes(String name, List<io.substrait.type.Type> arguments) {
            try {
                return name + ":" + arguments.stream().map(t -> t.accept(ToTypeString.INSTANCE)).collect(Collectors.joining("_"));
            }
            catch (UnsupportedOperationException ex) {
                throw new UnsupportedOperationException(String.format("Failure converting types of function %s.", name), ex);
            }
        }

        public static String constructKey(String name, List<Argument> arguments) {
            try {
                return name + ":" + arguments.stream().map(Argument::toTypeString).collect(Collectors.joining("_"));
            }
            catch (UnsupportedOperationException ex) {
                throw new UnsupportedOperationException(String.format("Failure converting types of function %s.", name), ex);
            }
        }

        public Util.IntRange getRange() {
            long optionalCount = this.args().stream().filter(t -> !t.required()).count();
            int max = this.variadic().map(t -> {
                OptionalInt optionalMax = t.getMax();
                IntStream stream = optionalMax.isPresent() ? IntStream.of(optionalMax.getAsInt()) : IntStream.empty();
                return stream.map(x -> this.args().size() - 1 + x + 1).findFirst().orElse(Integer.MAX_VALUE);
            }).orElse(this.args().size() + 1);
            int min = this.variadic().map(t -> this.args().size() - 1 + t.getMin()).orElse(this.requiredArguments().size());
            return Util.IntRange.of(min, max);
        }

        public void validateOutputType(List<Expression> argumentExpressions, io.substrait.type.Type outputType) {
        }

        public String key() {
            return this.keySupplier.get();
        }

        public io.substrait.type.Type resolveType(List<io.substrait.type.Type> argumentTypes) {
            return TypeExpressionEvaluator.evaluateExpression(this.returnType(), this.args(), argumentTypes);
        }
    }

    @JsonDeserialize(as=ImmutableSimpleExtension.AggregateFunctionVariant.class)
    @JsonSerialize(as=ImmutableSimpleExtension.AggregateFunctionVariant.class)
    @Value.Immutable
    public static abstract class AggregateFunctionVariant
    extends Function {
        @JsonProperty(value="decomposable")
        @Value.Default
        public Decomposability decomposability() {
            return Decomposability.NONE;
        }

        @Override
        public String toString() {
            return super.toString();
        }

        @Nullable
        public abstract TypeExpression intermediate();

        AggregateFunctionVariant resolve(String uri, String name, String description) {
            return ImmutableSimpleExtension.AggregateFunctionVariant.builder().uri(uri).name(name).description(description).nullability(this.nullability()).args(this.args()).options(this.options()).ordered(this.ordered()).variadic(this.variadic()).decomposability(this.decomposability()).intermediate(this.intermediate()).returnType(this.returnType()).build();
        }
    }

    static enum Decomposability {
        NONE,
        ONE,
        MANY;

    }

    public static enum WindowType {
        PARTITION,
        STREAMING;

    }

    @JsonDeserialize(as=ImmutableSimpleExtension.WindowFunction.class)
    @JsonSerialize(as=ImmutableSimpleExtension.WindowFunction.class)
    @Value.Immutable
    public static abstract class WindowFunction {
        @Nullable
        public abstract String name();

        @Nullable
        public abstract String description();

        public abstract List<WindowFunctionVariant> impls();

        public Stream<WindowFunctionVariant> resolve(String uri) {
            return this.impls().stream().map(f -> f.resolve(uri, this.name(), this.description()));
        }

        public static ImmutableSimpleExtension.WindowFunction.Builder builder() {
            return ImmutableSimpleExtension.WindowFunction.builder();
        }
    }

    @JsonDeserialize(as=ImmutableSimpleExtension.AggregateFunction.class)
    @JsonSerialize(as=ImmutableSimpleExtension.AggregateFunction.class)
    @Value.Immutable
    public static abstract class AggregateFunction {
        @Nullable
        public abstract String name();

        @Nullable
        public abstract String description();

        public abstract List<AggregateFunctionVariant> impls();

        public Stream<AggregateFunctionVariant> resolve(String uri) {
            return this.impls().stream().map(f -> f.resolve(uri, this.name(), this.description()));
        }
    }

    @JsonDeserialize(as=ImmutableSimpleExtension.ScalarFunction.class)
    @JsonSerialize(as=ImmutableSimpleExtension.ScalarFunction.class)
    @Value.Immutable
    public static abstract class ScalarFunction {
        public abstract String name();

        @Nullable
        public abstract String description();

        public abstract List<ScalarFunctionVariant> impls();

        public Stream<ScalarFunctionVariant> resolve(String uri) {
            return this.impls().stream().map(f -> f.resolve(uri, this.name(), this.description()));
        }
    }

    @JsonDeserialize(as=ImmutableSimpleExtension.Type.class)
    @JsonSerialize(as=ImmutableSimpleExtension.Type.class)
    @Value.Immutable
    public static abstract class Type {
        private final Supplier<TypeAnchor> anchorSupplier = Util.memoize(() -> TypeAnchor.of(this.uri(), this.name()));

        public abstract String name();

        @JacksonInject(value="uri")
        public abstract String uri();

        protected abstract Optional<Object> structure();

        public TypeAnchor getAnchor() {
            return this.anchorSupplier.get();
        }
    }

    @JsonDeserialize(as=ImmutableSimpleExtension.ScalarFunctionVariant.class)
    @JsonSerialize(as=ImmutableSimpleExtension.ScalarFunctionVariant.class)
    @Value.Immutable
    public static abstract class ScalarFunctionVariant
    extends Function {
        public ScalarFunctionVariant resolve(String uri, String name, String description) {
            return ImmutableSimpleExtension.ScalarFunctionVariant.builder().uri(uri).name(name).description(description).nullability(this.nullability()).args(this.args()).options(this.options()).ordered(this.ordered()).variadic(this.variadic()).returnType(this.returnType()).build();
        }
    }

    @JsonDeserialize(as=ImmutableSimpleExtension.VariadicBehavior.class)
    @JsonSerialize(as=ImmutableSimpleExtension.VariadicBehavior.class)
    @Value.Immutable
    public static interface VariadicBehavior {
        public int getMin();

        public OptionalInt getMax();

        default public ParameterConsistency parameterConsistency() {
            return ParameterConsistency.CONSISTENT;
        }

        public static enum ParameterConsistency {
            CONSISTENT,
            INCONSISTENT;

        }
    }

    @Value.Immutable
    public static interface TypeAnchor
    extends Anchor {
        public static TypeAnchor of(String namespace, String name) {
            return ImmutableSimpleExtension.TypeAnchor.builder().namespace(namespace).key(name).build();
        }
    }

    @Value.Immutable
    public static interface FunctionAnchor
    extends Anchor {
        public static FunctionAnchor of(String namespace, String key) {
            return ImmutableSimpleExtension.FunctionAnchor.builder().namespace(namespace).key(key).build();
        }
    }

    public static interface Anchor {
        public String namespace();

        public String key();
    }

    @JsonSerialize(as=ImmutableSimpleExtension.EnumArgument.class)
    @JsonDeserialize(as=ImmutableSimpleExtension.EnumArgument.class)
    @Value.Immutable
    public static abstract class EnumArgument
    implements Argument {
        @JsonProperty(required=true)
        public abstract List<String> options();

        @Override
        public boolean required() {
            return true;
        }

        @Override
        public String toTypeString() {
            return "req";
        }

        public static ImmutableSimpleExtension.EnumArgument.Builder builder() {
            return ImmutableSimpleExtension.EnumArgument.builder();
        }
    }

    @JsonSerialize(as=ImmutableSimpleExtension.TypeArgument.class)
    @JsonDeserialize(as=ImmutableSimpleExtension.TypeArgument.class)
    @Value.Immutable
    public static abstract class TypeArgument
    implements Argument {
        @JsonProperty(required=true)
        public abstract ParameterizedType type();

        @Override
        public String toTypeString() {
            return "type";
        }

        @Override
        public boolean required() {
            return true;
        }

        public static ImmutableSimpleExtension.TypeArgument.Builder builder() {
            return ImmutableSimpleExtension.TypeArgument.builder();
        }
    }

    @JsonSerialize(as=ImmutableSimpleExtension.ValueArgument.class)
    @JsonDeserialize(as=ImmutableSimpleExtension.ValueArgument.class)
    @Value.Immutable
    public static abstract class ValueArgument
    implements Argument {
        @JsonProperty(required=true)
        public abstract ParameterizedType value();

        @JsonProperty
        @Nullable
        public abstract Boolean constant();

        @Override
        public String toTypeString() {
            return this.value().accept(ToTypeString.INSTANCE);
        }

        @Override
        public boolean required() {
            return true;
        }

        public static ImmutableSimpleExtension.ValueArgument.Builder builder() {
            return ImmutableSimpleExtension.ValueArgument.builder();
        }
    }

    @JsonDeserialize(as=ImmutableSimpleExtension.Option.class)
    @JsonSerialize(as=ImmutableSimpleExtension.Option.class)
    @Value.Immutable
    public static interface Option {
        public Optional<String> getDescription();

        public List<String> getValues();
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.DEDUCTION)
    @JsonSubTypes(value={@JsonSubTypes.Type(value=ValueArgument.class), @JsonSubTypes.Type(value=TypeArgument.class), @JsonSubTypes.Type(value=EnumArgument.class)})
    public static interface Argument {
        public String toTypeString();

        @JsonProperty
        @Nullable
        public String name();

        @JsonProperty
        @Nullable
        public String description();

        public boolean required();
    }

    static enum Nullability {
        MIRROR,
        DECLARED_OUTPUT,
        DISCRETE;

    }
}

