/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.hint;

import io.substrait.hint.Hint;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="Hint", generator="Immutables")
@Immutable
public final class ImmutableHint
extends Hint {
    @Nullable
    private final String alias;
    private final List<String> outputNames;

    private ImmutableHint(@Nullable String alias, List<String> outputNames) {
        this.alias = alias;
        this.outputNames = outputNames;
    }

    @Override
    public Optional<String> getAlias() {
        return Optional.ofNullable(this.alias);
    }

    @Override
    public List<String> getOutputNames() {
        return this.outputNames;
    }

    public final ImmutableHint withAlias(String value) {
        String newValue = Objects.requireNonNull(value, "alias");
        if (Objects.equals(this.alias, newValue)) {
            return this;
        }
        return new ImmutableHint(newValue, this.outputNames);
    }

    public final ImmutableHint withAlias(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.alias, value)) {
            return this;
        }
        return new ImmutableHint(value, this.outputNames);
    }

    public final ImmutableHint withOutputNames(String ... elements) {
        List<String> newValue = ImmutableHint.createUnmodifiableList(false, ImmutableHint.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableHint(this.alias, newValue);
    }

    public final ImmutableHint withOutputNames(Iterable<String> elements) {
        if (this.outputNames == elements) {
            return this;
        }
        List<String> newValue = ImmutableHint.createUnmodifiableList(false, ImmutableHint.createSafeList(elements, true, false));
        return new ImmutableHint(this.alias, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableHint && this.equalTo(0, (ImmutableHint)another);
    }

    private boolean equalTo(int synthetic, ImmutableHint another) {
        return Objects.equals(this.alias, another.alias) && this.outputNames.equals(another.outputNames);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.alias);
        h += (h << 5) + this.outputNames.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Hint{");
        if (this.alias != null) {
            builder.append("alias=").append(this.alias);
        }
        if (builder.length() > 5) {
            builder.append(", ");
        }
        builder.append("outputNames=").append(this.outputNames);
        return builder.append("}").toString();
    }

    public static ImmutableHint copyOf(Hint instance) {
        if (instance instanceof ImmutableHint) {
            return (ImmutableHint)instance;
        }
        return ImmutableHint.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="Hint", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String alias;
        private List<String> outputNames = new ArrayList<String>();

        private Builder() {
        }

        public final Builder from(Hint instance) {
            Objects.requireNonNull(instance, "instance");
            Optional<String> aliasOptional = instance.getAlias();
            if (aliasOptional.isPresent()) {
                this.alias(aliasOptional);
            }
            this.addAllOutputNames(instance.getOutputNames());
            return this;
        }

        public final Builder alias(String alias) {
            this.alias = Objects.requireNonNull(alias, "alias");
            return this;
        }

        public final Builder alias(Optional<String> alias) {
            this.alias = alias.orElse(null);
            return this;
        }

        public final Builder addOutputNames(String element) {
            this.outputNames.add(Objects.requireNonNull(element, "outputNames element"));
            return this;
        }

        public final Builder addOutputNames(String ... elements) {
            for (String element : elements) {
                this.outputNames.add(Objects.requireNonNull(element, "outputNames element"));
            }
            return this;
        }

        public final Builder outputNames(Iterable<String> elements) {
            this.outputNames.clear();
            return this.addAllOutputNames(elements);
        }

        public final Builder addAllOutputNames(Iterable<String> elements) {
            for (String element : elements) {
                this.outputNames.add(Objects.requireNonNull(element, "outputNames element"));
            }
            return this;
        }

        public ImmutableHint build() {
            return new ImmutableHint(this.alias, ImmutableHint.createUnmodifiableList(true, this.outputNames));
        }
    }
}

