/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.plan;

import io.substrait.plan.Plan;
import io.substrait.proto.AdvancedExtension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="Plan", generator="Immutables")
@Immutable
public final class ImmutablePlan
extends Plan {
    private final List<Plan.Root> roots;
    private final List<String> expectedTypeUrls;
    @Nullable
    private final AdvancedExtension advancedExtension;

    private ImmutablePlan(List<Plan.Root> roots, List<String> expectedTypeUrls, @Nullable AdvancedExtension advancedExtension) {
        this.roots = roots;
        this.expectedTypeUrls = expectedTypeUrls;
        this.advancedExtension = advancedExtension;
    }

    @Override
    public List<Plan.Root> getRoots() {
        return this.roots;
    }

    @Override
    public List<String> getExpectedTypeUrls() {
        return this.expectedTypeUrls;
    }

    @Override
    public Optional<AdvancedExtension> getAdvancedExtension() {
        return Optional.ofNullable(this.advancedExtension);
    }

    public final ImmutablePlan withRoots(Plan.Root ... elements) {
        List<Plan.Root> newValue = ImmutablePlan.createUnmodifiableList(false, ImmutablePlan.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutablePlan(newValue, this.expectedTypeUrls, this.advancedExtension);
    }

    public final ImmutablePlan withRoots(Iterable<? extends Plan.Root> elements) {
        if (this.roots == elements) {
            return this;
        }
        List<Plan.Root> newValue = ImmutablePlan.createUnmodifiableList(false, ImmutablePlan.createSafeList(elements, true, false));
        return new ImmutablePlan(newValue, this.expectedTypeUrls, this.advancedExtension);
    }

    public final ImmutablePlan withExpectedTypeUrls(String ... elements) {
        List<String> newValue = ImmutablePlan.createUnmodifiableList(false, ImmutablePlan.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutablePlan(this.roots, newValue, this.advancedExtension);
    }

    public final ImmutablePlan withExpectedTypeUrls(Iterable<String> elements) {
        if (this.expectedTypeUrls == elements) {
            return this;
        }
        List<String> newValue = ImmutablePlan.createUnmodifiableList(false, ImmutablePlan.createSafeList(elements, true, false));
        return new ImmutablePlan(this.roots, newValue, this.advancedExtension);
    }

    public final ImmutablePlan withAdvancedExtension(AdvancedExtension value) {
        AdvancedExtension newValue = Objects.requireNonNull(value, "advancedExtension");
        if (this.advancedExtension == newValue) {
            return this;
        }
        return new ImmutablePlan(this.roots, this.expectedTypeUrls, newValue);
    }

    public final ImmutablePlan withAdvancedExtension(Optional<? extends AdvancedExtension> optional) {
        AdvancedExtension value = optional.orElse(null);
        if (this.advancedExtension == value) {
            return this;
        }
        return new ImmutablePlan(this.roots, this.expectedTypeUrls, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePlan && this.equalTo(0, (ImmutablePlan)another);
    }

    private boolean equalTo(int synthetic, ImmutablePlan another) {
        return this.roots.equals(another.roots) && this.expectedTypeUrls.equals(another.expectedTypeUrls) && Objects.equals(this.advancedExtension, another.advancedExtension);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.roots.hashCode();
        h += (h << 5) + this.expectedTypeUrls.hashCode();
        h += (h << 5) + Objects.hashCode(this.advancedExtension);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Plan{");
        builder.append("roots=").append(this.roots);
        builder.append(", ");
        builder.append("expectedTypeUrls=").append(this.expectedTypeUrls);
        if (this.advancedExtension != null) {
            builder.append(", ");
            builder.append("advancedExtension=").append(this.advancedExtension);
        }
        return builder.append("}").toString();
    }

    public static ImmutablePlan copyOf(Plan instance) {
        if (instance instanceof ImmutablePlan) {
            return (ImmutablePlan)instance;
        }
        return ImmutablePlan.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="Plan", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private List<Plan.Root> roots = new ArrayList<Plan.Root>();
        private List<String> expectedTypeUrls = new ArrayList<String>();
        @Nullable
        private AdvancedExtension advancedExtension;

        private Builder() {
        }

        public final Builder from(Plan instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllRoots(instance.getRoots());
            this.addAllExpectedTypeUrls(instance.getExpectedTypeUrls());
            Optional<AdvancedExtension> advancedExtensionOptional = instance.getAdvancedExtension();
            if (advancedExtensionOptional.isPresent()) {
                this.advancedExtension(advancedExtensionOptional);
            }
            return this;
        }

        public final Builder addRoots(Plan.Root element) {
            this.roots.add(Objects.requireNonNull(element, "roots element"));
            return this;
        }

        public final Builder addRoots(Plan.Root ... elements) {
            for (Plan.Root element : elements) {
                this.roots.add(Objects.requireNonNull(element, "roots element"));
            }
            return this;
        }

        public final Builder roots(Iterable<? extends Plan.Root> elements) {
            this.roots.clear();
            return this.addAllRoots(elements);
        }

        public final Builder addAllRoots(Iterable<? extends Plan.Root> elements) {
            for (Plan.Root root : elements) {
                this.roots.add(Objects.requireNonNull(root, "roots element"));
            }
            return this;
        }

        public final Builder addExpectedTypeUrls(String element) {
            this.expectedTypeUrls.add(Objects.requireNonNull(element, "expectedTypeUrls element"));
            return this;
        }

        public final Builder addExpectedTypeUrls(String ... elements) {
            for (String element : elements) {
                this.expectedTypeUrls.add(Objects.requireNonNull(element, "expectedTypeUrls element"));
            }
            return this;
        }

        public final Builder expectedTypeUrls(Iterable<String> elements) {
            this.expectedTypeUrls.clear();
            return this.addAllExpectedTypeUrls(elements);
        }

        public final Builder addAllExpectedTypeUrls(Iterable<String> elements) {
            for (String element : elements) {
                this.expectedTypeUrls.add(Objects.requireNonNull(element, "expectedTypeUrls element"));
            }
            return this;
        }

        public final Builder advancedExtension(AdvancedExtension advancedExtension) {
            this.advancedExtension = Objects.requireNonNull(advancedExtension, "advancedExtension");
            return this;
        }

        public final Builder advancedExtension(Optional<? extends AdvancedExtension> advancedExtension) {
            this.advancedExtension = advancedExtension.orElse(null);
            return this;
        }

        public ImmutablePlan build() {
            return new ImmutablePlan(ImmutablePlan.createUnmodifiableList(true, this.roots), ImmutablePlan.createUnmodifiableList(true, this.expectedTypeUrls), this.advancedExtension);
        }
    }
}

