/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.plan;

import io.substrait.extension.ExtensionCollector;
import io.substrait.plan.Plan;
import io.substrait.proto.Plan;
import io.substrait.proto.PlanRel;
import io.substrait.proto.Rel;
import io.substrait.proto.RelRoot;
import io.substrait.relation.RelProtoConverter;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlanProtoConverter {
    static final Logger logger = LoggerFactory.getLogger(PlanProtoConverter.class);

    public io.substrait.proto.Plan toProto(Plan plan) {
        ArrayList<PlanRel> planRels = new ArrayList<PlanRel>();
        ExtensionCollector functionCollector = new ExtensionCollector();
        for (Plan.Root root : plan.getRoots()) {
            Rel input = new RelProtoConverter(functionCollector).toProto(root.getInput());
            planRels.add(PlanRel.newBuilder().setRoot(RelRoot.newBuilder().setInput(input).addAllNames(root.getNames())).build());
        }
        Plan.Builder builder = io.substrait.proto.Plan.newBuilder().addAllRelations(planRels).addAllExpectedTypeUrls(plan.getExpectedTypeUrls());
        functionCollector.addExtensionsToPlan(builder);
        if (plan.getAdvancedExtension().isPresent()) {
            builder.setAdvancedExtensions(plan.getAdvancedExtension().get());
        }
        return builder.build();
    }
}

