/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.plan;

import io.substrait.extension.ExtensionLookup;
import io.substrait.extension.ImmutableExtensionLookup;
import io.substrait.extension.SimpleExtension;
import io.substrait.plan.ImmutablePlan;
import io.substrait.plan.ImmutableRoot;
import io.substrait.plan.Plan;
import io.substrait.proto.PlanRel;
import io.substrait.proto.RelRoot;
import io.substrait.relation.ProtoRelConverter;
import io.substrait.relation.Rel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtoPlanConverter {
    static final Logger logger = LoggerFactory.getLogger(ProtoPlanConverter.class);
    protected final SimpleExtension.ExtensionCollection extensionCollection;

    public ProtoPlanConverter() throws IOException {
        this(SimpleExtension.loadDefaults());
    }

    public ProtoPlanConverter(SimpleExtension.ExtensionCollection extensionCollection) {
        this.extensionCollection = extensionCollection;
    }

    protected ProtoRelConverter getProtoRelConverter(ExtensionLookup functionLookup) {
        return new ProtoRelConverter(functionLookup, this.extensionCollection);
    }

    public Plan from(io.substrait.proto.Plan plan) {
        ImmutableExtensionLookup functionLookup = ImmutableExtensionLookup.builder().from(plan).build();
        ProtoRelConverter relConverter = this.getProtoRelConverter(functionLookup);
        ArrayList<ImmutableRoot> roots = new ArrayList<ImmutableRoot>();
        for (PlanRel planRel : plan.getRelationsList()) {
            RelRoot root = planRel.getRoot();
            Rel rel = relConverter.from(root.getInput());
            roots.add(ImmutableRoot.builder().input(rel).names((Iterable<String>)root.getNamesList()).build());
        }
        return ImmutablePlan.builder().roots(roots).expectedTypeUrls((Iterable<String>)plan.getExpectedTypeUrlsList()).advancedExtension(Optional.ofNullable(plan.hasAdvancedExtensions() ? plan.getAdvancedExtensions() : null)).build();
    }
}

