/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.relation;

import io.substrait.expression.Expression;
import io.substrait.expression.ExpressionVisitor;
import io.substrait.expression.FieldReference;
import io.substrait.expression.FunctionArg;
import io.substrait.relation.CopyOnWriteUtils;
import io.substrait.relation.Rel;
import io.substrait.relation.RelCopyOnWriteVisitor;
import java.util.List;
import java.util.Optional;

public class ExpressionCopyOnWriteVisitor<EXCEPTION extends Exception>
implements ExpressionVisitor<Optional<Expression>, EXCEPTION> {
    private final RelCopyOnWriteVisitor<EXCEPTION> relCopyOnWriteVisitor;

    public ExpressionCopyOnWriteVisitor(RelCopyOnWriteVisitor<EXCEPTION> relCopyOnWriteVisitor) {
        this.relCopyOnWriteVisitor = relCopyOnWriteVisitor;
    }

    protected final RelCopyOnWriteVisitor<EXCEPTION> getRelCopyOnWriteVisitor() {
        return this.relCopyOnWriteVisitor;
    }

    public Optional<Expression> visitLiteral(Expression.Literal literal) {
        return Optional.empty();
    }

    @Override
    public Optional<Expression> visit(Expression.NullLiteral expr) throws EXCEPTION {
        return this.visitLiteral(expr);
    }

    @Override
    public Optional<Expression> visit(Expression.BoolLiteral expr) throws EXCEPTION {
        return this.visitLiteral(expr);
    }

    @Override
    public Optional<Expression> visit(Expression.I8Literal expr) throws EXCEPTION {
        return this.visitLiteral(expr);
    }

    @Override
    public Optional<Expression> visit(Expression.I16Literal expr) throws EXCEPTION {
        return this.visitLiteral(expr);
    }

    @Override
    public Optional<Expression> visit(Expression.I32Literal expr) throws EXCEPTION {
        return this.visitLiteral(expr);
    }

    @Override
    public Optional<Expression> visit(Expression.I64Literal expr) throws EXCEPTION {
        return this.visitLiteral(expr);
    }

    @Override
    public Optional<Expression> visit(Expression.FP32Literal expr) throws EXCEPTION {
        return this.visitLiteral(expr);
    }

    @Override
    public Optional<Expression> visit(Expression.FP64Literal expr) throws EXCEPTION {
        return this.visitLiteral(expr);
    }

    @Override
    public Optional<Expression> visit(Expression.StrLiteral expr) throws EXCEPTION {
        return this.visitLiteral(expr);
    }

    @Override
    public Optional<Expression> visit(Expression.BinaryLiteral expr) throws EXCEPTION {
        return this.visitLiteral(expr);
    }

    @Override
    public Optional<Expression> visit(Expression.TimeLiteral expr) throws EXCEPTION {
        return this.visitLiteral(expr);
    }

    @Override
    public Optional<Expression> visit(Expression.DateLiteral expr) throws EXCEPTION {
        return this.visitLiteral(expr);
    }

    @Override
    public Optional<Expression> visit(Expression.TimestampLiteral expr) throws EXCEPTION {
        return this.visitLiteral(expr);
    }

    @Override
    public Optional<Expression> visit(Expression.TimestampTZLiteral expr) throws EXCEPTION {
        return this.visitLiteral(expr);
    }

    @Override
    public Optional<Expression> visit(Expression.PrecisionTimestampLiteral expr) throws EXCEPTION {
        return this.visitLiteral(expr);
    }

    @Override
    public Optional<Expression> visit(Expression.PrecisionTimestampTZLiteral expr) throws EXCEPTION {
        return this.visitLiteral(expr);
    }

    @Override
    public Optional<Expression> visit(Expression.IntervalYearLiteral expr) throws EXCEPTION {
        return this.visitLiteral(expr);
    }

    @Override
    public Optional<Expression> visit(Expression.IntervalDayLiteral expr) throws EXCEPTION {
        return this.visitLiteral(expr);
    }

    @Override
    public Optional<Expression> visit(Expression.IntervalCompoundLiteral expr) throws EXCEPTION {
        return this.visitLiteral(expr);
    }

    @Override
    public Optional<Expression> visit(Expression.UUIDLiteral expr) throws EXCEPTION {
        return this.visitLiteral(expr);
    }

    @Override
    public Optional<Expression> visit(Expression.FixedCharLiteral expr) throws EXCEPTION {
        return this.visitLiteral(expr);
    }

    @Override
    public Optional<Expression> visit(Expression.VarCharLiteral expr) throws EXCEPTION {
        return this.visitLiteral(expr);
    }

    @Override
    public Optional<Expression> visit(Expression.FixedBinaryLiteral expr) throws EXCEPTION {
        return this.visitLiteral(expr);
    }

    @Override
    public Optional<Expression> visit(Expression.DecimalLiteral expr) throws EXCEPTION {
        return this.visitLiteral(expr);
    }

    @Override
    public Optional<Expression> visit(Expression.MapLiteral expr) throws EXCEPTION {
        return this.visitLiteral(expr);
    }

    @Override
    public Optional<Expression> visit(Expression.EmptyMapLiteral expr) throws EXCEPTION {
        return this.visitLiteral(expr);
    }

    @Override
    public Optional<Expression> visit(Expression.ListLiteral expr) throws EXCEPTION {
        return this.visitLiteral(expr);
    }

    @Override
    public Optional<Expression> visit(Expression.EmptyListLiteral expr) throws EXCEPTION {
        return this.visitLiteral(expr);
    }

    @Override
    public Optional<Expression> visit(Expression.StructLiteral expr) throws EXCEPTION {
        return this.visitLiteral(expr);
    }

    @Override
    public Optional<Expression> visit(Expression.UserDefinedLiteral expr) throws EXCEPTION {
        return this.visitLiteral(expr);
    }

    @Override
    public Optional<Expression> visit(Expression.Switch expr) throws EXCEPTION {
        Optional match = (Optional)expr.match().accept(this);
        Optional<List<Expression.SwitchClause>> switchClauses = CopyOnWriteUtils.transformList(expr.switchClauses(), this::visitSwitchClause);
        Optional defaultClause = (Optional)expr.defaultClause().accept(this);
        if (CopyOnWriteUtils.allEmpty(match, switchClauses, defaultClause)) {
            return Optional.empty();
        }
        return Optional.of(Expression.Switch.builder().from(expr).match(match.orElse(expr.match())).switchClauses((Iterable<? extends Expression.SwitchClause>)switchClauses.orElse(expr.switchClauses())).defaultClause(defaultClause.orElse(expr.defaultClause())).build());
    }

    protected Optional<Expression.SwitchClause> visitSwitchClause(Expression.SwitchClause switchClause) throws EXCEPTION {
        return ((Optional)switchClause.then().accept(this)).map(then -> Expression.SwitchClause.builder().from(switchClause).then((Expression)then).build());
    }

    @Override
    public Optional<Expression> visit(Expression.IfThen ifThen) throws EXCEPTION {
        Optional<List<Expression.IfClause>> ifClauses = CopyOnWriteUtils.transformList(ifThen.ifClauses(), this::visitIfClause);
        Optional elseClause = (Optional)ifThen.elseClause().accept(this);
        if (CopyOnWriteUtils.allEmpty(ifClauses, elseClause)) {
            return Optional.empty();
        }
        return Optional.of(Expression.IfThen.builder().from(ifThen).ifClauses((Iterable<? extends Expression.IfClause>)ifClauses.orElse(ifThen.ifClauses())).elseClause(elseClause.orElse(ifThen.elseClause())).build());
    }

    protected Optional<Expression.IfClause> visitIfClause(Expression.IfClause ifClause) throws EXCEPTION {
        Optional condition = (Optional)ifClause.condition().accept(this);
        Optional then = (Optional)ifClause.then().accept(this);
        if (CopyOnWriteUtils.allEmpty(condition, then)) {
            return Optional.empty();
        }
        return Optional.of(Expression.IfClause.builder().from(ifClause).condition(condition.orElse(ifClause.condition())).then(then.orElse(ifClause.then())).build());
    }

    @Override
    public Optional<Expression> visit(Expression.ScalarFunctionInvocation sfi) throws EXCEPTION {
        return this.visitFunctionArguments(sfi.arguments()).map(arguments -> Expression.ScalarFunctionInvocation.builder().from(sfi).arguments((Iterable<? extends FunctionArg>)arguments).build());
    }

    @Override
    public Optional<Expression> visit(Expression.WindowFunctionInvocation wfi) throws EXCEPTION {
        Optional<List<FunctionArg>> arguments = this.visitFunctionArguments(wfi.arguments());
        Optional<List<Expression>> partitionBy = this.visitExprList(wfi.partitionBy());
        Optional<List<Expression.SortField>> sort = CopyOnWriteUtils.transformList(wfi.sort(), this::visitSortField);
        if (CopyOnWriteUtils.allEmpty(arguments, partitionBy, sort)) {
            return Optional.empty();
        }
        return Optional.of(Expression.WindowFunctionInvocation.builder().from(wfi).arguments((Iterable<? extends FunctionArg>)arguments.orElse(wfi.arguments())).partitionBy((Iterable<? extends Expression>)partitionBy.orElse(wfi.partitionBy())).sort((Iterable<? extends Expression.SortField>)sort.orElse(wfi.sort())).build());
    }

    @Override
    public Optional<Expression> visit(Expression.Cast cast) throws EXCEPTION {
        return ((Optional)cast.input().accept(this)).map(input -> Expression.Cast.builder().from(cast).input((Expression)input).build());
    }

    @Override
    public Optional<Expression> visit(Expression.SingleOrList singleOrList) throws EXCEPTION {
        Optional condition = (Optional)singleOrList.condition().accept(this);
        Optional<List<Expression>> options = this.visitExprList(singleOrList.options());
        if (CopyOnWriteUtils.allEmpty(condition, options)) {
            return Optional.empty();
        }
        return Optional.of(Expression.SingleOrList.builder().from(singleOrList).condition(condition.orElse(singleOrList.condition())).options((Iterable<? extends Expression>)options.orElse(singleOrList.options())).build());
    }

    @Override
    public Optional<Expression> visit(Expression.MultiOrList multiOrList) throws EXCEPTION {
        Optional<List<Expression>> conditions = this.visitExprList(multiOrList.conditions());
        Optional<List<Expression.MultiOrListRecord>> optionCombinations = CopyOnWriteUtils.transformList(multiOrList.optionCombinations(), this::visitMultiOrListRecord);
        if (CopyOnWriteUtils.allEmpty(conditions, optionCombinations)) {
            return Optional.empty();
        }
        return Optional.of(Expression.MultiOrList.builder().from(multiOrList).conditions((Iterable<? extends Expression>)conditions.orElse(multiOrList.conditions())).optionCombinations((Iterable<? extends Expression.MultiOrListRecord>)optionCombinations.orElse(multiOrList.optionCombinations())).build());
    }

    protected Optional<Expression.MultiOrListRecord> visitMultiOrListRecord(Expression.MultiOrListRecord multiOrListRecord) throws EXCEPTION {
        return this.visitExprList(multiOrListRecord.values()).map(values -> Expression.MultiOrListRecord.builder().from(multiOrListRecord).values((Iterable<? extends Expression>)values).build());
    }

    @Override
    public Optional<Expression> visit(FieldReference fieldReference) throws EXCEPTION {
        Optional<Expression> inputExpression = this.visitOptionalExpression(fieldReference.inputExpression());
        if (CopyOnWriteUtils.allEmpty(inputExpression)) {
            return Optional.empty();
        }
        return Optional.of(FieldReference.builder().inputExpression(inputExpression).build());
    }

    @Override
    public Optional<Expression> visit(Expression.SetPredicate setPredicate) throws EXCEPTION {
        return ((Optional)setPredicate.tuples().accept(this.getRelCopyOnWriteVisitor())).map(tuple -> Expression.SetPredicate.builder().from(setPredicate).tuples((Rel)tuple).build());
    }

    @Override
    public Optional<Expression> visit(Expression.ScalarSubquery scalarSubquery) throws EXCEPTION {
        return ((Optional)scalarSubquery.input().accept(this.getRelCopyOnWriteVisitor())).map(input -> Expression.ScalarSubquery.builder().from(scalarSubquery).input((Rel)input).build());
    }

    @Override
    public Optional<Expression> visit(Expression.InPredicate inPredicate) throws EXCEPTION {
        Optional haystack = (Optional)inPredicate.haystack().accept(this.getRelCopyOnWriteVisitor());
        Optional<List<Expression>> needles = this.visitExprList(inPredicate.needles());
        if (CopyOnWriteUtils.allEmpty(haystack, needles)) {
            return Optional.empty();
        }
        return Optional.of(Expression.InPredicate.builder().from(inPredicate).haystack(haystack.orElse(inPredicate.haystack())).needles((Iterable<? extends Expression>)needles.orElse(inPredicate.needles())).build());
    }

    protected Optional<List<Expression>> visitExprList(List<Expression> exprs) throws EXCEPTION {
        return CopyOnWriteUtils.transformList(exprs, e -> (Optional)e.accept(this));
    }

    private Optional<Expression> visitOptionalExpression(Optional<Expression> optExpr) throws EXCEPTION {
        if (optExpr.isPresent()) {
            return (Optional)optExpr.get().accept(this);
        }
        return Optional.empty();
    }

    protected Optional<List<FunctionArg>> visitFunctionArguments(List<FunctionArg> funcArgs) throws EXCEPTION {
        return CopyOnWriteUtils.transformList(funcArgs, arg -> {
            if (arg instanceof Expression) {
                Expression expr = (Expression)arg;
                return ((Optional)expr.accept(this)).flatMap(Optional::of);
            }
            return Optional.empty();
        });
    }

    protected Optional<Expression.SortField> visitSortField(Expression.SortField sortField) throws EXCEPTION {
        return ((Optional)sortField.expr().accept(this)).map(expr -> Expression.SortField.builder().from(sortField).expr((Expression)expr).build());
    }
}

