/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.relation;

import io.substrait.extension.AdvancedExtension;
import io.substrait.hint.Hint;
import io.substrait.relation.AbstractRel;
import io.substrait.relation.Aggregate;
import io.substrait.relation.HasExtension;
import io.substrait.relation.Rel;
import io.substrait.relation.SingleInputRel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="Aggregate", generator="Immutables")
@Immutable
public final class ImmutableAggregate
extends Aggregate {
    @Nullable
    private final AdvancedExtension extension;
    @Nullable
    private final Rel.Remap remap;
    @Nullable
    private final AdvancedExtension commonExtension;
    @Nullable
    private final Hint hint;
    private final Rel input;
    private final List<Aggregate.Grouping> groupings;
    private final List<Aggregate.Measure> measures;

    private ImmutableAggregate(@Nullable AdvancedExtension extension, @Nullable Rel.Remap remap, @Nullable AdvancedExtension commonExtension, @Nullable Hint hint, Rel input, List<Aggregate.Grouping> groupings, List<Aggregate.Measure> measures) {
        this.extension = extension;
        this.remap = remap;
        this.commonExtension = commonExtension;
        this.hint = hint;
        this.input = input;
        this.groupings = groupings;
        this.measures = measures;
    }

    @Override
    public Optional<AdvancedExtension> getExtension() {
        return Optional.ofNullable(this.extension);
    }

    @Override
    public Optional<Rel.Remap> getRemap() {
        return Optional.ofNullable(this.remap);
    }

    @Override
    public Optional<AdvancedExtension> getCommonExtension() {
        return Optional.ofNullable(this.commonExtension);
    }

    @Override
    public Optional<Hint> getHint() {
        return Optional.ofNullable(this.hint);
    }

    @Override
    public Rel getInput() {
        return this.input;
    }

    @Override
    public List<Aggregate.Grouping> getGroupings() {
        return this.groupings;
    }

    @Override
    public List<Aggregate.Measure> getMeasures() {
        return this.measures;
    }

    public final ImmutableAggregate withExtension(AdvancedExtension value) {
        AdvancedExtension newValue = Objects.requireNonNull(value, "extension");
        if (this.extension == newValue) {
            return this;
        }
        return new ImmutableAggregate(newValue, this.remap, this.commonExtension, this.hint, this.input, this.groupings, this.measures);
    }

    public final ImmutableAggregate withExtension(Optional<? extends AdvancedExtension> optional) {
        AdvancedExtension value = optional.orElse(null);
        if (this.extension == value) {
            return this;
        }
        return new ImmutableAggregate(value, this.remap, this.commonExtension, this.hint, this.input, this.groupings, this.measures);
    }

    public final ImmutableAggregate withRemap(Rel.Remap value) {
        Rel.Remap newValue = Objects.requireNonNull(value, "remap");
        if (this.remap == newValue) {
            return this;
        }
        return new ImmutableAggregate(this.extension, newValue, this.commonExtension, this.hint, this.input, this.groupings, this.measures);
    }

    public final ImmutableAggregate withRemap(Optional<? extends Rel.Remap> optional) {
        Rel.Remap value = optional.orElse(null);
        if (this.remap == value) {
            return this;
        }
        return new ImmutableAggregate(this.extension, value, this.commonExtension, this.hint, this.input, this.groupings, this.measures);
    }

    public final ImmutableAggregate withCommonExtension(AdvancedExtension value) {
        AdvancedExtension newValue = Objects.requireNonNull(value, "commonExtension");
        if (this.commonExtension == newValue) {
            return this;
        }
        return new ImmutableAggregate(this.extension, this.remap, newValue, this.hint, this.input, this.groupings, this.measures);
    }

    public final ImmutableAggregate withCommonExtension(Optional<? extends AdvancedExtension> optional) {
        AdvancedExtension value = optional.orElse(null);
        if (this.commonExtension == value) {
            return this;
        }
        return new ImmutableAggregate(this.extension, this.remap, value, this.hint, this.input, this.groupings, this.measures);
    }

    public final ImmutableAggregate withHint(Hint value) {
        Hint newValue = Objects.requireNonNull(value, "hint");
        if (this.hint == newValue) {
            return this;
        }
        return new ImmutableAggregate(this.extension, this.remap, this.commonExtension, newValue, this.input, this.groupings, this.measures);
    }

    public final ImmutableAggregate withHint(Optional<? extends Hint> optional) {
        Hint value = optional.orElse(null);
        if (this.hint == value) {
            return this;
        }
        return new ImmutableAggregate(this.extension, this.remap, this.commonExtension, value, this.input, this.groupings, this.measures);
    }

    public final ImmutableAggregate withInput(Rel value) {
        if (this.input == value) {
            return this;
        }
        Rel newValue = Objects.requireNonNull(value, "input");
        return new ImmutableAggregate(this.extension, this.remap, this.commonExtension, this.hint, newValue, this.groupings, this.measures);
    }

    public final ImmutableAggregate withGroupings(Aggregate.Grouping ... elements) {
        List<Aggregate.Grouping> newValue = ImmutableAggregate.createUnmodifiableList(false, ImmutableAggregate.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableAggregate(this.extension, this.remap, this.commonExtension, this.hint, this.input, newValue, this.measures);
    }

    public final ImmutableAggregate withGroupings(Iterable<? extends Aggregate.Grouping> elements) {
        if (this.groupings == elements) {
            return this;
        }
        List<Aggregate.Grouping> newValue = ImmutableAggregate.createUnmodifiableList(false, ImmutableAggregate.createSafeList(elements, true, false));
        return new ImmutableAggregate(this.extension, this.remap, this.commonExtension, this.hint, this.input, newValue, this.measures);
    }

    public final ImmutableAggregate withMeasures(Aggregate.Measure ... elements) {
        List<Aggregate.Measure> newValue = ImmutableAggregate.createUnmodifiableList(false, ImmutableAggregate.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableAggregate(this.extension, this.remap, this.commonExtension, this.hint, this.input, this.groupings, newValue);
    }

    public final ImmutableAggregate withMeasures(Iterable<? extends Aggregate.Measure> elements) {
        if (this.measures == elements) {
            return this;
        }
        List<Aggregate.Measure> newValue = ImmutableAggregate.createUnmodifiableList(false, ImmutableAggregate.createSafeList(elements, true, false));
        return new ImmutableAggregate(this.extension, this.remap, this.commonExtension, this.hint, this.input, this.groupings, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAggregate && this.equalTo(0, (ImmutableAggregate)another);
    }

    private boolean equalTo(int synthetic, ImmutableAggregate another) {
        return Objects.equals(this.extension, another.extension) && Objects.equals(this.remap, another.remap) && Objects.equals(this.commonExtension, another.commonExtension) && Objects.equals(this.hint, another.hint) && this.input.equals(another.input) && this.groupings.equals(another.groupings) && this.measures.equals(another.measures);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.extension);
        h += (h << 5) + Objects.hashCode(this.remap);
        h += (h << 5) + Objects.hashCode(this.commonExtension);
        h += (h << 5) + Objects.hashCode(this.hint);
        h += (h << 5) + this.input.hashCode();
        h += (h << 5) + this.groupings.hashCode();
        h += (h << 5) + this.measures.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Aggregate{");
        if (this.extension != null) {
            builder.append("extension=").append(this.extension);
        }
        if (this.remap != null) {
            if (builder.length() > 10) {
                builder.append(", ");
            }
            builder.append("remap=").append(this.remap);
        }
        if (this.commonExtension != null) {
            if (builder.length() > 10) {
                builder.append(", ");
            }
            builder.append("commonExtension=").append(this.commonExtension);
        }
        if (this.hint != null) {
            if (builder.length() > 10) {
                builder.append(", ");
            }
            builder.append("hint=").append(this.hint);
        }
        if (builder.length() > 10) {
            builder.append(", ");
        }
        builder.append("input=").append(this.input);
        builder.append(", ");
        builder.append("groupings=").append(this.groupings);
        builder.append(", ");
        builder.append("measures=").append(this.measures);
        return builder.append("}").toString();
    }

    public static ImmutableAggregate copyOf(Aggregate instance) {
        if (instance instanceof ImmutableAggregate) {
            return (ImmutableAggregate)instance;
        }
        return ImmutableAggregate.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="Aggregate", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_INPUT = 1L;
        private long initBits = 1L;
        @Nullable
        private AdvancedExtension extension;
        @Nullable
        private Rel.Remap remap;
        @Nullable
        private AdvancedExtension commonExtension;
        @Nullable
        private Hint hint;
        @Nullable
        private Rel input;
        private List<Aggregate.Grouping> groupings = new ArrayList<Aggregate.Grouping>();
        private List<Aggregate.Measure> measures = new ArrayList<Aggregate.Measure>();

        private Builder() {
        }

        public final Builder from(HasExtension instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(Rel instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(AbstractRel instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(SingleInputRel instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(Aggregate instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            Optional<Rel.Remap> remapOptional;
            Optional<Hint> hintOptional;
            Optional<AdvancedExtension> commonExtensionOptional;
            Optional<AdvancedExtension> extensionOptional;
            Object instance;
            long bits = 0L;
            if (object instanceof HasExtension) {
                instance = (HasExtension)object;
                if ((bits & 1L) == 0L) {
                    extensionOptional = instance.getExtension();
                    if (extensionOptional.isPresent()) {
                        this.extension(extensionOptional);
                    }
                    bits |= 1L;
                }
            }
            if (object instanceof Rel) {
                instance = (Rel)object;
                if ((bits & 2L) == 0L) {
                    commonExtensionOptional = instance.getCommonExtension();
                    if (commonExtensionOptional.isPresent()) {
                        this.commonExtension(commonExtensionOptional);
                    }
                    bits |= 2L;
                }
                if ((bits & 8L) == 0L) {
                    hintOptional = instance.getHint();
                    if (hintOptional.isPresent()) {
                        this.hint(hintOptional);
                    }
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    remapOptional = instance.getRemap();
                    if (remapOptional.isPresent()) {
                        this.remap(remapOptional);
                    }
                    bits |= 0x10L;
                }
            }
            if (object instanceof AbstractRel) {
                instance = (AbstractRel)object;
                if ((bits & 2L) == 0L) {
                    commonExtensionOptional = instance.getCommonExtension();
                    if (commonExtensionOptional.isPresent()) {
                        this.commonExtension(commonExtensionOptional);
                    }
                    bits |= 2L;
                }
                if ((bits & 8L) == 0L) {
                    hintOptional = instance.getHint();
                    if (hintOptional.isPresent()) {
                        this.hint(hintOptional);
                    }
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    remapOptional = instance.getRemap();
                    if (remapOptional.isPresent()) {
                        this.remap(remapOptional);
                    }
                    bits |= 0x10L;
                }
            }
            if (object instanceof SingleInputRel) {
                instance = (SingleInputRel)object;
                if ((bits & 4L) == 0L) {
                    this.input(((SingleInputRel)instance).getInput());
                    bits |= 4L;
                }
                if ((bits & 2L) == 0L) {
                    commonExtensionOptional = instance.getCommonExtension();
                    if (commonExtensionOptional.isPresent()) {
                        this.commonExtension(commonExtensionOptional);
                    }
                    bits |= 2L;
                }
                if ((bits & 8L) == 0L) {
                    hintOptional = instance.getHint();
                    if (hintOptional.isPresent()) {
                        this.hint(hintOptional);
                    }
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    remapOptional = instance.getRemap();
                    if (remapOptional.isPresent()) {
                        this.remap(remapOptional);
                    }
                    bits |= 0x10L;
                }
            }
            if (object instanceof Aggregate) {
                instance = (Aggregate)object;
                if ((bits & 4L) == 0L) {
                    this.input(((SingleInputRel)instance).getInput());
                    bits |= 4L;
                }
                if ((bits & 1L) == 0L) {
                    extensionOptional = instance.getExtension();
                    if (extensionOptional.isPresent()) {
                        this.extension(extensionOptional);
                    }
                    bits |= 1L;
                }
                this.addAllMeasures(((Aggregate)instance).getMeasures());
                this.addAllGroupings(((Aggregate)instance).getGroupings());
                if ((bits & 8L) == 0L) {
                    hintOptional = instance.getHint();
                    if (hintOptional.isPresent()) {
                        this.hint(hintOptional);
                    }
                    bits |= 8L;
                }
                if ((bits & 2L) == 0L) {
                    commonExtensionOptional = instance.getCommonExtension();
                    if (commonExtensionOptional.isPresent()) {
                        this.commonExtension(commonExtensionOptional);
                    }
                    bits |= 2L;
                }
                if ((bits & 0x10L) == 0L) {
                    remapOptional = instance.getRemap();
                    if (remapOptional.isPresent()) {
                        this.remap(remapOptional);
                    }
                    bits |= 0x10L;
                }
            }
        }

        public final Builder extension(AdvancedExtension extension) {
            this.extension = Objects.requireNonNull(extension, "extension");
            return this;
        }

        public final Builder extension(Optional<? extends AdvancedExtension> extension) {
            this.extension = extension.orElse(null);
            return this;
        }

        public final Builder remap(Rel.Remap remap) {
            this.remap = Objects.requireNonNull(remap, "remap");
            return this;
        }

        public final Builder remap(Optional<? extends Rel.Remap> remap) {
            this.remap = remap.orElse(null);
            return this;
        }

        public final Builder commonExtension(AdvancedExtension commonExtension) {
            this.commonExtension = Objects.requireNonNull(commonExtension, "commonExtension");
            return this;
        }

        public final Builder commonExtension(Optional<? extends AdvancedExtension> commonExtension) {
            this.commonExtension = commonExtension.orElse(null);
            return this;
        }

        public final Builder hint(Hint hint) {
            this.hint = Objects.requireNonNull(hint, "hint");
            return this;
        }

        public final Builder hint(Optional<? extends Hint> hint) {
            this.hint = hint.orElse(null);
            return this;
        }

        public final Builder input(Rel input) {
            this.input = Objects.requireNonNull(input, "input");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addGroupings(Aggregate.Grouping element) {
            this.groupings.add(Objects.requireNonNull(element, "groupings element"));
            return this;
        }

        public final Builder addGroupings(Aggregate.Grouping ... elements) {
            for (Aggregate.Grouping element : elements) {
                this.groupings.add(Objects.requireNonNull(element, "groupings element"));
            }
            return this;
        }

        public final Builder groupings(Iterable<? extends Aggregate.Grouping> elements) {
            this.groupings.clear();
            return this.addAllGroupings(elements);
        }

        public final Builder addAllGroupings(Iterable<? extends Aggregate.Grouping> elements) {
            for (Aggregate.Grouping grouping : elements) {
                this.groupings.add(Objects.requireNonNull(grouping, "groupings element"));
            }
            return this;
        }

        public final Builder addMeasures(Aggregate.Measure element) {
            this.measures.add(Objects.requireNonNull(element, "measures element"));
            return this;
        }

        public final Builder addMeasures(Aggregate.Measure ... elements) {
            for (Aggregate.Measure element : elements) {
                this.measures.add(Objects.requireNonNull(element, "measures element"));
            }
            return this;
        }

        public final Builder measures(Iterable<? extends Aggregate.Measure> elements) {
            this.measures.clear();
            return this.addAllMeasures(elements);
        }

        public final Builder addAllMeasures(Iterable<? extends Aggregate.Measure> elements) {
            for (Aggregate.Measure measure : elements) {
                this.measures.add(Objects.requireNonNull(measure, "measures element"));
            }
            return this;
        }

        public ImmutableAggregate build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAggregate(this.extension, this.remap, this.commonExtension, this.hint, this.input, ImmutableAggregate.createUnmodifiableList(true, this.groupings), ImmutableAggregate.createUnmodifiableList(true, this.measures));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("input");
            }
            return "Cannot build Aggregate, some of required attributes are not set " + attributes;
        }
    }
}

