/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.relation;

import io.substrait.extension.AdvancedExtension;
import io.substrait.hint.Hint;
import io.substrait.relation.AbstractRel;
import io.substrait.relation.Fetch;
import io.substrait.relation.HasExtension;
import io.substrait.relation.Rel;
import io.substrait.relation.SingleInputRel;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="Fetch", generator="Immutables")
@Immutable
public final class ImmutableFetch
extends Fetch {
    @Nullable
    private final AdvancedExtension extension;
    @Nullable
    private final Rel.Remap remap;
    @Nullable
    private final AdvancedExtension commonExtension;
    @Nullable
    private final Hint hint;
    private final Rel input;
    private final long offset;
    @Nullable
    private final Long count;

    private ImmutableFetch(@Nullable AdvancedExtension extension, @Nullable Rel.Remap remap, @Nullable AdvancedExtension commonExtension, @Nullable Hint hint, Rel input, long offset, @Nullable Long count) {
        this.extension = extension;
        this.remap = remap;
        this.commonExtension = commonExtension;
        this.hint = hint;
        this.input = input;
        this.offset = offset;
        this.count = count;
    }

    @Override
    public Optional<AdvancedExtension> getExtension() {
        return Optional.ofNullable(this.extension);
    }

    @Override
    public Optional<Rel.Remap> getRemap() {
        return Optional.ofNullable(this.remap);
    }

    @Override
    public Optional<AdvancedExtension> getCommonExtension() {
        return Optional.ofNullable(this.commonExtension);
    }

    @Override
    public Optional<Hint> getHint() {
        return Optional.ofNullable(this.hint);
    }

    @Override
    public Rel getInput() {
        return this.input;
    }

    @Override
    public long getOffset() {
        return this.offset;
    }

    @Override
    public OptionalLong getCount() {
        return this.count != null ? OptionalLong.of(this.count) : OptionalLong.empty();
    }

    public final ImmutableFetch withExtension(AdvancedExtension value) {
        AdvancedExtension newValue = Objects.requireNonNull(value, "extension");
        if (this.extension == newValue) {
            return this;
        }
        return new ImmutableFetch(newValue, this.remap, this.commonExtension, this.hint, this.input, this.offset, this.count);
    }

    public final ImmutableFetch withExtension(Optional<? extends AdvancedExtension> optional) {
        AdvancedExtension value = optional.orElse(null);
        if (this.extension == value) {
            return this;
        }
        return new ImmutableFetch(value, this.remap, this.commonExtension, this.hint, this.input, this.offset, this.count);
    }

    public final ImmutableFetch withRemap(Rel.Remap value) {
        Rel.Remap newValue = Objects.requireNonNull(value, "remap");
        if (this.remap == newValue) {
            return this;
        }
        return new ImmutableFetch(this.extension, newValue, this.commonExtension, this.hint, this.input, this.offset, this.count);
    }

    public final ImmutableFetch withRemap(Optional<? extends Rel.Remap> optional) {
        Rel.Remap value = optional.orElse(null);
        if (this.remap == value) {
            return this;
        }
        return new ImmutableFetch(this.extension, value, this.commonExtension, this.hint, this.input, this.offset, this.count);
    }

    public final ImmutableFetch withCommonExtension(AdvancedExtension value) {
        AdvancedExtension newValue = Objects.requireNonNull(value, "commonExtension");
        if (this.commonExtension == newValue) {
            return this;
        }
        return new ImmutableFetch(this.extension, this.remap, newValue, this.hint, this.input, this.offset, this.count);
    }

    public final ImmutableFetch withCommonExtension(Optional<? extends AdvancedExtension> optional) {
        AdvancedExtension value = optional.orElse(null);
        if (this.commonExtension == value) {
            return this;
        }
        return new ImmutableFetch(this.extension, this.remap, value, this.hint, this.input, this.offset, this.count);
    }

    public final ImmutableFetch withHint(Hint value) {
        Hint newValue = Objects.requireNonNull(value, "hint");
        if (this.hint == newValue) {
            return this;
        }
        return new ImmutableFetch(this.extension, this.remap, this.commonExtension, newValue, this.input, this.offset, this.count);
    }

    public final ImmutableFetch withHint(Optional<? extends Hint> optional) {
        Hint value = optional.orElse(null);
        if (this.hint == value) {
            return this;
        }
        return new ImmutableFetch(this.extension, this.remap, this.commonExtension, value, this.input, this.offset, this.count);
    }

    public final ImmutableFetch withInput(Rel value) {
        if (this.input == value) {
            return this;
        }
        Rel newValue = Objects.requireNonNull(value, "input");
        return new ImmutableFetch(this.extension, this.remap, this.commonExtension, this.hint, newValue, this.offset, this.count);
    }

    public final ImmutableFetch withOffset(long value) {
        if (this.offset == value) {
            return this;
        }
        return new ImmutableFetch(this.extension, this.remap, this.commonExtension, this.hint, this.input, value, this.count);
    }

    public final ImmutableFetch withCount(long value) {
        Long newValue = value;
        if (Objects.equals(this.count, newValue)) {
            return this;
        }
        return new ImmutableFetch(this.extension, this.remap, this.commonExtension, this.hint, this.input, this.offset, newValue);
    }

    public final ImmutableFetch withCount(OptionalLong optional) {
        Long value;
        Long l = value = optional.isPresent() ? Long.valueOf(optional.getAsLong()) : null;
        if (Objects.equals(this.count, value)) {
            return this;
        }
        return new ImmutableFetch(this.extension, this.remap, this.commonExtension, this.hint, this.input, this.offset, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFetch && this.equalTo(0, (ImmutableFetch)another);
    }

    private boolean equalTo(int synthetic, ImmutableFetch another) {
        return Objects.equals(this.extension, another.extension) && Objects.equals(this.remap, another.remap) && Objects.equals(this.commonExtension, another.commonExtension) && Objects.equals(this.hint, another.hint) && this.input.equals(another.input) && this.offset == another.offset && Objects.equals(this.count, another.count);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.extension);
        h += (h << 5) + Objects.hashCode(this.remap);
        h += (h << 5) + Objects.hashCode(this.commonExtension);
        h += (h << 5) + Objects.hashCode(this.hint);
        h += (h << 5) + this.input.hashCode();
        h += (h << 5) + Long.hashCode(this.offset);
        h += (h << 5) + Objects.hashCode(this.count);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Fetch{");
        if (this.extension != null) {
            builder.append("extension=").append(this.extension);
        }
        if (this.remap != null) {
            if (builder.length() > 6) {
                builder.append(", ");
            }
            builder.append("remap=").append(this.remap);
        }
        if (this.commonExtension != null) {
            if (builder.length() > 6) {
                builder.append(", ");
            }
            builder.append("commonExtension=").append(this.commonExtension);
        }
        if (this.hint != null) {
            if (builder.length() > 6) {
                builder.append(", ");
            }
            builder.append("hint=").append(this.hint);
        }
        if (builder.length() > 6) {
            builder.append(", ");
        }
        builder.append("input=").append(this.input);
        builder.append(", ");
        builder.append("offset=").append(this.offset);
        if (this.count != null) {
            builder.append(", ");
            builder.append("count=").append(this.count);
        }
        return builder.append("}").toString();
    }

    public static ImmutableFetch copyOf(Fetch instance) {
        if (instance instanceof ImmutableFetch) {
            return (ImmutableFetch)instance;
        }
        return ImmutableFetch.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Fetch", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_INPUT = 1L;
        private static final long INIT_BIT_OFFSET = 2L;
        private long initBits = 3L;
        @Nullable
        private AdvancedExtension extension;
        @Nullable
        private Rel.Remap remap;
        @Nullable
        private AdvancedExtension commonExtension;
        @Nullable
        private Hint hint;
        @Nullable
        private Rel input;
        private long offset;
        @Nullable
        private Long count;

        private Builder() {
        }

        public final Builder from(HasExtension instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(Rel instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(AbstractRel instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(SingleInputRel instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(Fetch instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            Optional<Rel.Remap> remapOptional;
            Optional<Hint> hintOptional;
            Optional<AdvancedExtension> commonExtensionOptional;
            Optional<AdvancedExtension> extensionOptional;
            Object instance;
            long bits = 0L;
            if (object instanceof HasExtension) {
                instance = (HasExtension)object;
                if ((bits & 1L) == 0L) {
                    extensionOptional = instance.getExtension();
                    if (extensionOptional.isPresent()) {
                        this.extension(extensionOptional);
                    }
                    bits |= 1L;
                }
            }
            if (object instanceof Rel) {
                instance = (Rel)object;
                if ((bits & 2L) == 0L) {
                    commonExtensionOptional = instance.getCommonExtension();
                    if (commonExtensionOptional.isPresent()) {
                        this.commonExtension(commonExtensionOptional);
                    }
                    bits |= 2L;
                }
                if ((bits & 8L) == 0L) {
                    hintOptional = instance.getHint();
                    if (hintOptional.isPresent()) {
                        this.hint(hintOptional);
                    }
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    remapOptional = instance.getRemap();
                    if (remapOptional.isPresent()) {
                        this.remap(remapOptional);
                    }
                    bits |= 0x10L;
                }
            }
            if (object instanceof AbstractRel) {
                instance = (AbstractRel)object;
                if ((bits & 2L) == 0L) {
                    commonExtensionOptional = instance.getCommonExtension();
                    if (commonExtensionOptional.isPresent()) {
                        this.commonExtension(commonExtensionOptional);
                    }
                    bits |= 2L;
                }
                if ((bits & 8L) == 0L) {
                    hintOptional = instance.getHint();
                    if (hintOptional.isPresent()) {
                        this.hint(hintOptional);
                    }
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    remapOptional = instance.getRemap();
                    if (remapOptional.isPresent()) {
                        this.remap(remapOptional);
                    }
                    bits |= 0x10L;
                }
            }
            if (object instanceof SingleInputRel) {
                instance = (SingleInputRel)object;
                if ((bits & 4L) == 0L) {
                    this.input(((SingleInputRel)instance).getInput());
                    bits |= 4L;
                }
                if ((bits & 2L) == 0L) {
                    commonExtensionOptional = instance.getCommonExtension();
                    if (commonExtensionOptional.isPresent()) {
                        this.commonExtension(commonExtensionOptional);
                    }
                    bits |= 2L;
                }
                if ((bits & 8L) == 0L) {
                    hintOptional = instance.getHint();
                    if (hintOptional.isPresent()) {
                        this.hint(hintOptional);
                    }
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    remapOptional = instance.getRemap();
                    if (remapOptional.isPresent()) {
                        this.remap(remapOptional);
                    }
                    bits |= 0x10L;
                }
            }
            if (object instanceof Fetch) {
                OptionalLong countOptional;
                instance = (Fetch)object;
                if ((bits & 4L) == 0L) {
                    this.input(((SingleInputRel)instance).getInput());
                    bits |= 4L;
                }
                if ((bits & 1L) == 0L) {
                    extensionOptional = instance.getExtension();
                    if (extensionOptional.isPresent()) {
                        this.extension(extensionOptional);
                    }
                    bits |= 1L;
                }
                this.offset(((Fetch)instance).getOffset());
                if ((bits & 8L) == 0L) {
                    hintOptional = instance.getHint();
                    if (hintOptional.isPresent()) {
                        this.hint(hintOptional);
                    }
                    bits |= 8L;
                }
                if ((countOptional = ((Fetch)instance).getCount()).isPresent()) {
                    this.count(countOptional);
                }
                if ((bits & 2L) == 0L) {
                    Optional<AdvancedExtension> commonExtensionOptional2 = instance.getCommonExtension();
                    if (commonExtensionOptional2.isPresent()) {
                        this.commonExtension(commonExtensionOptional2);
                    }
                    bits |= 2L;
                }
                if ((bits & 0x10L) == 0L) {
                    Optional<Rel.Remap> remapOptional2 = instance.getRemap();
                    if (remapOptional2.isPresent()) {
                        this.remap(remapOptional2);
                    }
                    bits |= 0x10L;
                }
            }
        }

        public final Builder extension(AdvancedExtension extension) {
            this.extension = Objects.requireNonNull(extension, "extension");
            return this;
        }

        public final Builder extension(Optional<? extends AdvancedExtension> extension) {
            this.extension = extension.orElse(null);
            return this;
        }

        public final Builder remap(Rel.Remap remap) {
            this.remap = Objects.requireNonNull(remap, "remap");
            return this;
        }

        public final Builder remap(Optional<? extends Rel.Remap> remap) {
            this.remap = remap.orElse(null);
            return this;
        }

        public final Builder commonExtension(AdvancedExtension commonExtension) {
            this.commonExtension = Objects.requireNonNull(commonExtension, "commonExtension");
            return this;
        }

        public final Builder commonExtension(Optional<? extends AdvancedExtension> commonExtension) {
            this.commonExtension = commonExtension.orElse(null);
            return this;
        }

        public final Builder hint(Hint hint) {
            this.hint = Objects.requireNonNull(hint, "hint");
            return this;
        }

        public final Builder hint(Optional<? extends Hint> hint) {
            this.hint = hint.orElse(null);
            return this;
        }

        public final Builder input(Rel input) {
            this.input = Objects.requireNonNull(input, "input");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder offset(long offset) {
            this.offset = offset;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder count(long count) {
            this.count = count;
            return this;
        }

        public final Builder count(OptionalLong count) {
            this.count = count.isPresent() ? Long.valueOf(count.getAsLong()) : null;
            return this;
        }

        public ImmutableFetch build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableFetch(this.extension, this.remap, this.commonExtension, this.hint, this.input, this.offset, this.count);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("input");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("offset");
            }
            return "Cannot build Fetch, some of required attributes are not set " + attributes;
        }
    }
}

