/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.relation;

import io.substrait.extension.AdvancedExtension;
import io.substrait.hint.Hint;
import io.substrait.relation.AbstractRel;
import io.substrait.relation.HasExtension;
import io.substrait.relation.Rel;
import io.substrait.relation.Set;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="Set", generator="Immutables")
@Immutable
public final class ImmutableSet
extends Set {
    @Nullable
    private final AdvancedExtension extension;
    @Nullable
    private final Rel.Remap remap;
    @Nullable
    private final AdvancedExtension commonExtension;
    private final List<Rel> inputs;
    @Nullable
    private final Hint hint;
    private final Set.SetOp setOp;

    private ImmutableSet(@Nullable AdvancedExtension extension, @Nullable Rel.Remap remap, @Nullable AdvancedExtension commonExtension, List<Rel> inputs, @Nullable Hint hint, Set.SetOp setOp) {
        this.extension = extension;
        this.remap = remap;
        this.commonExtension = commonExtension;
        this.inputs = inputs;
        this.hint = hint;
        this.setOp = setOp;
    }

    @Override
    public Optional<AdvancedExtension> getExtension() {
        return Optional.ofNullable(this.extension);
    }

    @Override
    public Optional<Rel.Remap> getRemap() {
        return Optional.ofNullable(this.remap);
    }

    @Override
    public Optional<AdvancedExtension> getCommonExtension() {
        return Optional.ofNullable(this.commonExtension);
    }

    @Override
    public List<Rel> getInputs() {
        return this.inputs;
    }

    @Override
    public Optional<Hint> getHint() {
        return Optional.ofNullable(this.hint);
    }

    @Override
    public Set.SetOp getSetOp() {
        return this.setOp;
    }

    public final ImmutableSet withExtension(AdvancedExtension value) {
        AdvancedExtension newValue = Objects.requireNonNull(value, "extension");
        if (this.extension == newValue) {
            return this;
        }
        return new ImmutableSet(newValue, this.remap, this.commonExtension, this.inputs, this.hint, this.setOp);
    }

    public final ImmutableSet withExtension(Optional<? extends AdvancedExtension> optional) {
        AdvancedExtension value = optional.orElse(null);
        if (this.extension == value) {
            return this;
        }
        return new ImmutableSet(value, this.remap, this.commonExtension, this.inputs, this.hint, this.setOp);
    }

    public final ImmutableSet withRemap(Rel.Remap value) {
        Rel.Remap newValue = Objects.requireNonNull(value, "remap");
        if (this.remap == newValue) {
            return this;
        }
        return new ImmutableSet(this.extension, newValue, this.commonExtension, this.inputs, this.hint, this.setOp);
    }

    public final ImmutableSet withRemap(Optional<? extends Rel.Remap> optional) {
        Rel.Remap value = optional.orElse(null);
        if (this.remap == value) {
            return this;
        }
        return new ImmutableSet(this.extension, value, this.commonExtension, this.inputs, this.hint, this.setOp);
    }

    public final ImmutableSet withCommonExtension(AdvancedExtension value) {
        AdvancedExtension newValue = Objects.requireNonNull(value, "commonExtension");
        if (this.commonExtension == newValue) {
            return this;
        }
        return new ImmutableSet(this.extension, this.remap, newValue, this.inputs, this.hint, this.setOp);
    }

    public final ImmutableSet withCommonExtension(Optional<? extends AdvancedExtension> optional) {
        AdvancedExtension value = optional.orElse(null);
        if (this.commonExtension == value) {
            return this;
        }
        return new ImmutableSet(this.extension, this.remap, value, this.inputs, this.hint, this.setOp);
    }

    public final ImmutableSet withInputs(Rel ... elements) {
        List<Rel> newValue = ImmutableSet.createUnmodifiableList(false, ImmutableSet.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableSet(this.extension, this.remap, this.commonExtension, newValue, this.hint, this.setOp);
    }

    public final ImmutableSet withInputs(Iterable<? extends Rel> elements) {
        if (this.inputs == elements) {
            return this;
        }
        List<Rel> newValue = ImmutableSet.createUnmodifiableList(false, ImmutableSet.createSafeList(elements, true, false));
        return new ImmutableSet(this.extension, this.remap, this.commonExtension, newValue, this.hint, this.setOp);
    }

    public final ImmutableSet withHint(Hint value) {
        Hint newValue = Objects.requireNonNull(value, "hint");
        if (this.hint == newValue) {
            return this;
        }
        return new ImmutableSet(this.extension, this.remap, this.commonExtension, this.inputs, newValue, this.setOp);
    }

    public final ImmutableSet withHint(Optional<? extends Hint> optional) {
        Hint value = optional.orElse(null);
        if (this.hint == value) {
            return this;
        }
        return new ImmutableSet(this.extension, this.remap, this.commonExtension, this.inputs, value, this.setOp);
    }

    public final ImmutableSet withSetOp(Set.SetOp value) {
        Set.SetOp newValue = Objects.requireNonNull(value, "setOp");
        if (this.setOp == newValue) {
            return this;
        }
        return new ImmutableSet(this.extension, this.remap, this.commonExtension, this.inputs, this.hint, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSet && this.equalTo(0, (ImmutableSet)another);
    }

    private boolean equalTo(int synthetic, ImmutableSet another) {
        return Objects.equals(this.extension, another.extension) && Objects.equals(this.remap, another.remap) && Objects.equals(this.commonExtension, another.commonExtension) && this.inputs.equals(another.inputs) && Objects.equals(this.hint, another.hint) && this.setOp.equals((Object)another.setOp);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.extension);
        h += (h << 5) + Objects.hashCode(this.remap);
        h += (h << 5) + Objects.hashCode(this.commonExtension);
        h += (h << 5) + this.inputs.hashCode();
        h += (h << 5) + Objects.hashCode(this.hint);
        h += (h << 5) + this.setOp.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Set{");
        if (this.extension != null) {
            builder.append("extension=").append(this.extension);
        }
        if (this.remap != null) {
            if (builder.length() > 4) {
                builder.append(", ");
            }
            builder.append("remap=").append(this.remap);
        }
        if (this.commonExtension != null) {
            if (builder.length() > 4) {
                builder.append(", ");
            }
            builder.append("commonExtension=").append(this.commonExtension);
        }
        if (builder.length() > 4) {
            builder.append(", ");
        }
        builder.append("inputs=").append(this.inputs);
        if (this.hint != null) {
            builder.append(", ");
            builder.append("hint=").append(this.hint);
        }
        builder.append(", ");
        builder.append("setOp=").append((Object)this.setOp);
        return builder.append("}").toString();
    }

    public static ImmutableSet copyOf(Set instance) {
        if (instance instanceof ImmutableSet) {
            return (ImmutableSet)instance;
        }
        return ImmutableSet.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="Set", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_SET_OP = 1L;
        private long initBits = 1L;
        @Nullable
        private AdvancedExtension extension;
        @Nullable
        private Rel.Remap remap;
        @Nullable
        private AdvancedExtension commonExtension;
        private List<Rel> inputs = new ArrayList<Rel>();
        @Nullable
        private Hint hint;
        @Nullable
        private Set.SetOp setOp;

        private Builder() {
        }

        public final Builder from(HasExtension instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(Rel instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(AbstractRel instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(Set instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            Optional<Rel.Remap> remapOptional;
            Optional<Hint> hintOptional;
            Optional<AdvancedExtension> commonExtensionOptional;
            Optional<AdvancedExtension> extensionOptional;
            Object instance;
            long bits = 0L;
            if (object instanceof HasExtension) {
                instance = (HasExtension)object;
                if ((bits & 1L) == 0L) {
                    extensionOptional = instance.getExtension();
                    if (extensionOptional.isPresent()) {
                        this.extension(extensionOptional);
                    }
                    bits |= 1L;
                }
            }
            if (object instanceof Rel) {
                instance = (Rel)object;
                if ((bits & 4L) == 0L) {
                    commonExtensionOptional = instance.getCommonExtension();
                    if (commonExtensionOptional.isPresent()) {
                        this.commonExtension(commonExtensionOptional);
                    }
                    bits |= 4L;
                }
                if ((bits & 2L) == 0L) {
                    this.addAllInputs(instance.getInputs());
                    bits |= 2L;
                }
                if ((bits & 8L) == 0L) {
                    hintOptional = instance.getHint();
                    if (hintOptional.isPresent()) {
                        this.hint(hintOptional);
                    }
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    remapOptional = instance.getRemap();
                    if (remapOptional.isPresent()) {
                        this.remap(remapOptional);
                    }
                    bits |= 0x10L;
                }
            }
            if (object instanceof AbstractRel) {
                instance = (AbstractRel)object;
                if ((bits & 4L) == 0L) {
                    commonExtensionOptional = instance.getCommonExtension();
                    if (commonExtensionOptional.isPresent()) {
                        this.commonExtension(commonExtensionOptional);
                    }
                    bits |= 4L;
                }
                if ((bits & 2L) == 0L) {
                    this.addAllInputs(instance.getInputs());
                    bits |= 2L;
                }
                if ((bits & 8L) == 0L) {
                    hintOptional = instance.getHint();
                    if (hintOptional.isPresent()) {
                        this.hint(hintOptional);
                    }
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    remapOptional = instance.getRemap();
                    if (remapOptional.isPresent()) {
                        this.remap(remapOptional);
                    }
                    bits |= 0x10L;
                }
            }
            if (object instanceof Set) {
                instance = (Set)object;
                if ((bits & 1L) == 0L) {
                    extensionOptional = instance.getExtension();
                    if (extensionOptional.isPresent()) {
                        this.extension(extensionOptional);
                    }
                    bits |= 1L;
                }
                if ((bits & 4L) == 0L) {
                    commonExtensionOptional = instance.getCommonExtension();
                    if (commonExtensionOptional.isPresent()) {
                        this.commonExtension(commonExtensionOptional);
                    }
                    bits |= 4L;
                }
                if ((bits & 2L) == 0L) {
                    this.addAllInputs(instance.getInputs());
                    bits |= 2L;
                }
                this.setOp(((Set)instance).getSetOp());
                if ((bits & 8L) == 0L) {
                    hintOptional = instance.getHint();
                    if (hintOptional.isPresent()) {
                        this.hint(hintOptional);
                    }
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    remapOptional = instance.getRemap();
                    if (remapOptional.isPresent()) {
                        this.remap(remapOptional);
                    }
                    bits |= 0x10L;
                }
            }
        }

        public final Builder extension(AdvancedExtension extension) {
            this.extension = Objects.requireNonNull(extension, "extension");
            return this;
        }

        public final Builder extension(Optional<? extends AdvancedExtension> extension) {
            this.extension = extension.orElse(null);
            return this;
        }

        public final Builder remap(Rel.Remap remap) {
            this.remap = Objects.requireNonNull(remap, "remap");
            return this;
        }

        public final Builder remap(Optional<? extends Rel.Remap> remap) {
            this.remap = remap.orElse(null);
            return this;
        }

        public final Builder commonExtension(AdvancedExtension commonExtension) {
            this.commonExtension = Objects.requireNonNull(commonExtension, "commonExtension");
            return this;
        }

        public final Builder commonExtension(Optional<? extends AdvancedExtension> commonExtension) {
            this.commonExtension = commonExtension.orElse(null);
            return this;
        }

        public final Builder addInputs(Rel element) {
            this.inputs.add(Objects.requireNonNull(element, "inputs element"));
            return this;
        }

        public final Builder addInputs(Rel ... elements) {
            for (Rel element : elements) {
                this.inputs.add(Objects.requireNonNull(element, "inputs element"));
            }
            return this;
        }

        public final Builder inputs(Iterable<? extends Rel> elements) {
            this.inputs.clear();
            return this.addAllInputs(elements);
        }

        public final Builder addAllInputs(Iterable<? extends Rel> elements) {
            for (Rel rel : elements) {
                this.inputs.add(Objects.requireNonNull(rel, "inputs element"));
            }
            return this;
        }

        public final Builder hint(Hint hint) {
            this.hint = Objects.requireNonNull(hint, "hint");
            return this;
        }

        public final Builder hint(Optional<? extends Hint> hint) {
            this.hint = hint.orElse(null);
            return this;
        }

        public final Builder setOp(Set.SetOp setOp) {
            this.setOp = Objects.requireNonNull(setOp, "setOp");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableSet build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSet(this.extension, this.remap, this.commonExtension, ImmutableSet.createUnmodifiableList(true, this.inputs), this.hint, this.setOp);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("setOp");
            }
            return "Cannot build Set, some of required attributes are not set " + attributes;
        }
    }
}

