/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.relation;

import io.substrait.expression.Expression;
import io.substrait.extension.AdvancedExtension;
import io.substrait.hint.Hint;
import io.substrait.relation.AbstractRel;
import io.substrait.relation.HasExtension;
import io.substrait.relation.Rel;
import io.substrait.relation.SingleInputRel;
import io.substrait.relation.Sort;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="Sort", generator="Immutables")
@Immutable
public final class ImmutableSort
extends Sort {
    @Nullable
    private final AdvancedExtension extension;
    @Nullable
    private final Rel.Remap remap;
    @Nullable
    private final AdvancedExtension commonExtension;
    @Nullable
    private final Hint hint;
    private final Rel input;
    private final List<Expression.SortField> sortFields;

    private ImmutableSort(@Nullable AdvancedExtension extension, @Nullable Rel.Remap remap, @Nullable AdvancedExtension commonExtension, @Nullable Hint hint, Rel input, List<Expression.SortField> sortFields) {
        this.extension = extension;
        this.remap = remap;
        this.commonExtension = commonExtension;
        this.hint = hint;
        this.input = input;
        this.sortFields = sortFields;
    }

    @Override
    public Optional<AdvancedExtension> getExtension() {
        return Optional.ofNullable(this.extension);
    }

    @Override
    public Optional<Rel.Remap> getRemap() {
        return Optional.ofNullable(this.remap);
    }

    @Override
    public Optional<AdvancedExtension> getCommonExtension() {
        return Optional.ofNullable(this.commonExtension);
    }

    @Override
    public Optional<Hint> getHint() {
        return Optional.ofNullable(this.hint);
    }

    @Override
    public Rel getInput() {
        return this.input;
    }

    @Override
    public List<Expression.SortField> getSortFields() {
        return this.sortFields;
    }

    public final ImmutableSort withExtension(AdvancedExtension value) {
        AdvancedExtension newValue = Objects.requireNonNull(value, "extension");
        if (this.extension == newValue) {
            return this;
        }
        return new ImmutableSort(newValue, this.remap, this.commonExtension, this.hint, this.input, this.sortFields);
    }

    public final ImmutableSort withExtension(Optional<? extends AdvancedExtension> optional) {
        AdvancedExtension value = optional.orElse(null);
        if (this.extension == value) {
            return this;
        }
        return new ImmutableSort(value, this.remap, this.commonExtension, this.hint, this.input, this.sortFields);
    }

    public final ImmutableSort withRemap(Rel.Remap value) {
        Rel.Remap newValue = Objects.requireNonNull(value, "remap");
        if (this.remap == newValue) {
            return this;
        }
        return new ImmutableSort(this.extension, newValue, this.commonExtension, this.hint, this.input, this.sortFields);
    }

    public final ImmutableSort withRemap(Optional<? extends Rel.Remap> optional) {
        Rel.Remap value = optional.orElse(null);
        if (this.remap == value) {
            return this;
        }
        return new ImmutableSort(this.extension, value, this.commonExtension, this.hint, this.input, this.sortFields);
    }

    public final ImmutableSort withCommonExtension(AdvancedExtension value) {
        AdvancedExtension newValue = Objects.requireNonNull(value, "commonExtension");
        if (this.commonExtension == newValue) {
            return this;
        }
        return new ImmutableSort(this.extension, this.remap, newValue, this.hint, this.input, this.sortFields);
    }

    public final ImmutableSort withCommonExtension(Optional<? extends AdvancedExtension> optional) {
        AdvancedExtension value = optional.orElse(null);
        if (this.commonExtension == value) {
            return this;
        }
        return new ImmutableSort(this.extension, this.remap, value, this.hint, this.input, this.sortFields);
    }

    public final ImmutableSort withHint(Hint value) {
        Hint newValue = Objects.requireNonNull(value, "hint");
        if (this.hint == newValue) {
            return this;
        }
        return new ImmutableSort(this.extension, this.remap, this.commonExtension, newValue, this.input, this.sortFields);
    }

    public final ImmutableSort withHint(Optional<? extends Hint> optional) {
        Hint value = optional.orElse(null);
        if (this.hint == value) {
            return this;
        }
        return new ImmutableSort(this.extension, this.remap, this.commonExtension, value, this.input, this.sortFields);
    }

    public final ImmutableSort withInput(Rel value) {
        if (this.input == value) {
            return this;
        }
        Rel newValue = Objects.requireNonNull(value, "input");
        return new ImmutableSort(this.extension, this.remap, this.commonExtension, this.hint, newValue, this.sortFields);
    }

    public final ImmutableSort withSortFields(Expression.SortField ... elements) {
        List<Expression.SortField> newValue = ImmutableSort.createUnmodifiableList(false, ImmutableSort.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableSort(this.extension, this.remap, this.commonExtension, this.hint, this.input, newValue);
    }

    public final ImmutableSort withSortFields(Iterable<? extends Expression.SortField> elements) {
        if (this.sortFields == elements) {
            return this;
        }
        List<Expression.SortField> newValue = ImmutableSort.createUnmodifiableList(false, ImmutableSort.createSafeList(elements, true, false));
        return new ImmutableSort(this.extension, this.remap, this.commonExtension, this.hint, this.input, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSort && this.equalTo(0, (ImmutableSort)another);
    }

    private boolean equalTo(int synthetic, ImmutableSort another) {
        return Objects.equals(this.extension, another.extension) && Objects.equals(this.remap, another.remap) && Objects.equals(this.commonExtension, another.commonExtension) && Objects.equals(this.hint, another.hint) && this.input.equals(another.input) && this.sortFields.equals(another.sortFields);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.extension);
        h += (h << 5) + Objects.hashCode(this.remap);
        h += (h << 5) + Objects.hashCode(this.commonExtension);
        h += (h << 5) + Objects.hashCode(this.hint);
        h += (h << 5) + this.input.hashCode();
        h += (h << 5) + this.sortFields.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Sort{");
        if (this.extension != null) {
            builder.append("extension=").append(this.extension);
        }
        if (this.remap != null) {
            if (builder.length() > 5) {
                builder.append(", ");
            }
            builder.append("remap=").append(this.remap);
        }
        if (this.commonExtension != null) {
            if (builder.length() > 5) {
                builder.append(", ");
            }
            builder.append("commonExtension=").append(this.commonExtension);
        }
        if (this.hint != null) {
            if (builder.length() > 5) {
                builder.append(", ");
            }
            builder.append("hint=").append(this.hint);
        }
        if (builder.length() > 5) {
            builder.append(", ");
        }
        builder.append("input=").append(this.input);
        builder.append(", ");
        builder.append("sortFields=").append(this.sortFields);
        return builder.append("}").toString();
    }

    public static ImmutableSort copyOf(Sort instance) {
        if (instance instanceof ImmutableSort) {
            return (ImmutableSort)instance;
        }
        return ImmutableSort.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="Sort", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_INPUT = 1L;
        private long initBits = 1L;
        @Nullable
        private AdvancedExtension extension;
        @Nullable
        private Rel.Remap remap;
        @Nullable
        private AdvancedExtension commonExtension;
        @Nullable
        private Hint hint;
        @Nullable
        private Rel input;
        private List<Expression.SortField> sortFields = new ArrayList<Expression.SortField>();

        private Builder() {
        }

        public final Builder from(HasExtension instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(Sort instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(Rel instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(AbstractRel instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(SingleInputRel instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            Optional<Rel.Remap> remapOptional;
            Optional<Hint> hintOptional;
            Optional<AdvancedExtension> commonExtensionOptional;
            Optional<AdvancedExtension> extensionOptional;
            Object instance;
            long bits = 0L;
            if (object instanceof HasExtension) {
                instance = (HasExtension)object;
                if ((bits & 1L) == 0L) {
                    extensionOptional = instance.getExtension();
                    if (extensionOptional.isPresent()) {
                        this.extension(extensionOptional);
                    }
                    bits |= 1L;
                }
            }
            if (object instanceof Sort) {
                instance = (Sort)object;
                if ((bits & 4L) == 0L) {
                    this.input(((SingleInputRel)instance).getInput());
                    bits |= 4L;
                }
                if ((bits & 1L) == 0L) {
                    extensionOptional = instance.getExtension();
                    if (extensionOptional.isPresent()) {
                        this.extension(extensionOptional);
                    }
                    bits |= 1L;
                }
                this.addAllSortFields(((Sort)instance).getSortFields());
                if ((bits & 2L) == 0L) {
                    commonExtensionOptional = instance.getCommonExtension();
                    if (commonExtensionOptional.isPresent()) {
                        this.commonExtension(commonExtensionOptional);
                    }
                    bits |= 2L;
                }
                if ((bits & 8L) == 0L) {
                    hintOptional = instance.getHint();
                    if (hintOptional.isPresent()) {
                        this.hint(hintOptional);
                    }
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    remapOptional = instance.getRemap();
                    if (remapOptional.isPresent()) {
                        this.remap(remapOptional);
                    }
                    bits |= 0x10L;
                }
            }
            if (object instanceof Rel) {
                instance = (Rel)object;
                if ((bits & 2L) == 0L) {
                    commonExtensionOptional = instance.getCommonExtension();
                    if (commonExtensionOptional.isPresent()) {
                        this.commonExtension(commonExtensionOptional);
                    }
                    bits |= 2L;
                }
                if ((bits & 8L) == 0L) {
                    hintOptional = instance.getHint();
                    if (hintOptional.isPresent()) {
                        this.hint(hintOptional);
                    }
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    remapOptional = instance.getRemap();
                    if (remapOptional.isPresent()) {
                        this.remap(remapOptional);
                    }
                    bits |= 0x10L;
                }
            }
            if (object instanceof AbstractRel) {
                instance = (AbstractRel)object;
                if ((bits & 2L) == 0L) {
                    commonExtensionOptional = instance.getCommonExtension();
                    if (commonExtensionOptional.isPresent()) {
                        this.commonExtension(commonExtensionOptional);
                    }
                    bits |= 2L;
                }
                if ((bits & 8L) == 0L) {
                    hintOptional = instance.getHint();
                    if (hintOptional.isPresent()) {
                        this.hint(hintOptional);
                    }
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    remapOptional = instance.getRemap();
                    if (remapOptional.isPresent()) {
                        this.remap(remapOptional);
                    }
                    bits |= 0x10L;
                }
            }
            if (object instanceof SingleInputRel) {
                instance = (SingleInputRel)object;
                if ((bits & 4L) == 0L) {
                    this.input(((SingleInputRel)instance).getInput());
                    bits |= 4L;
                }
                if ((bits & 2L) == 0L) {
                    commonExtensionOptional = instance.getCommonExtension();
                    if (commonExtensionOptional.isPresent()) {
                        this.commonExtension(commonExtensionOptional);
                    }
                    bits |= 2L;
                }
                if ((bits & 8L) == 0L) {
                    hintOptional = instance.getHint();
                    if (hintOptional.isPresent()) {
                        this.hint(hintOptional);
                    }
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    remapOptional = instance.getRemap();
                    if (remapOptional.isPresent()) {
                        this.remap(remapOptional);
                    }
                    bits |= 0x10L;
                }
            }
        }

        public final Builder extension(AdvancedExtension extension) {
            this.extension = Objects.requireNonNull(extension, "extension");
            return this;
        }

        public final Builder extension(Optional<? extends AdvancedExtension> extension) {
            this.extension = extension.orElse(null);
            return this;
        }

        public final Builder remap(Rel.Remap remap) {
            this.remap = Objects.requireNonNull(remap, "remap");
            return this;
        }

        public final Builder remap(Optional<? extends Rel.Remap> remap) {
            this.remap = remap.orElse(null);
            return this;
        }

        public final Builder commonExtension(AdvancedExtension commonExtension) {
            this.commonExtension = Objects.requireNonNull(commonExtension, "commonExtension");
            return this;
        }

        public final Builder commonExtension(Optional<? extends AdvancedExtension> commonExtension) {
            this.commonExtension = commonExtension.orElse(null);
            return this;
        }

        public final Builder hint(Hint hint) {
            this.hint = Objects.requireNonNull(hint, "hint");
            return this;
        }

        public final Builder hint(Optional<? extends Hint> hint) {
            this.hint = hint.orElse(null);
            return this;
        }

        public final Builder input(Rel input) {
            this.input = Objects.requireNonNull(input, "input");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addSortFields(Expression.SortField element) {
            this.sortFields.add(Objects.requireNonNull(element, "sortFields element"));
            return this;
        }

        public final Builder addSortFields(Expression.SortField ... elements) {
            for (Expression.SortField element : elements) {
                this.sortFields.add(Objects.requireNonNull(element, "sortFields element"));
            }
            return this;
        }

        public final Builder sortFields(Iterable<? extends Expression.SortField> elements) {
            this.sortFields.clear();
            return this.addAllSortFields(elements);
        }

        public final Builder addAllSortFields(Iterable<? extends Expression.SortField> elements) {
            for (Expression.SortField sortField : elements) {
                this.sortFields.add(Objects.requireNonNull(sortField, "sortFields element"));
            }
            return this;
        }

        public ImmutableSort build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSort(this.extension, this.remap, this.commonExtension, this.hint, this.input, ImmutableSort.createUnmodifiableList(true, this.sortFields));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("input");
            }
            return "Cannot build Sort, some of required attributes are not set " + attributes;
        }
    }
}

