/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.relation.physical;

import io.substrait.expression.Expression;
import io.substrait.expression.FieldReference;
import io.substrait.proto.HashJoinRel;
import io.substrait.relation.BiRel;
import io.substrait.relation.HasExtension;
import io.substrait.relation.RelVisitor;
import io.substrait.relation.physical.ImmutableHashJoin;
import io.substrait.type.Type;
import io.substrait.type.TypeCreator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.immutables.value.Value;

@Value.Immutable
public abstract class HashJoin
extends BiRel
implements HasExtension {
    public abstract List<FieldReference> getLeftKeys();

    public abstract List<FieldReference> getRightKeys();

    public abstract JoinType getJoinType();

    public abstract Optional<Expression> getPostJoinFilter();

    @Override
    protected Type.Struct deriveRecordType() {
        Stream<Object> stream;
        Stream<Object> stream2;
        switch (this.getJoinType()) {
            case RIGHT: 
            case OUTER: {
                stream2 = this.getLeft().getRecordType().fields().stream().map(TypeCreator::asNullable);
                break;
            }
            case RIGHT_ANTI: 
            case RIGHT_SEMI: {
                stream2 = Stream.empty();
                break;
            }
            default: {
                stream2 = this.getLeft().getRecordType().fields().stream();
            }
        }
        Stream leftTypes = stream2;
        switch (this.getJoinType()) {
            case OUTER: 
            case LEFT: {
                stream = this.getRight().getRecordType().fields().stream().map(TypeCreator::asNullable);
                break;
            }
            case LEFT_ANTI: 
            case LEFT_SEMI: {
                stream = Stream.empty();
                break;
            }
            default: {
                stream = this.getRight().getRecordType().fields().stream();
            }
        }
        Stream rightTypes = stream;
        return TypeCreator.REQUIRED.struct(Stream.concat(leftTypes, rightTypes));
    }

    @Override
    public <O, E extends Exception> O accept(RelVisitor<O, E> visitor) throws E {
        return visitor.visit(this);
    }

    public static ImmutableHashJoin.Builder builder() {
        return ImmutableHashJoin.builder();
    }

    public static enum JoinType {
        UNKNOWN(HashJoinRel.JoinType.JOIN_TYPE_UNSPECIFIED),
        INNER(HashJoinRel.JoinType.JOIN_TYPE_INNER),
        OUTER(HashJoinRel.JoinType.JOIN_TYPE_OUTER),
        LEFT(HashJoinRel.JoinType.JOIN_TYPE_LEFT),
        RIGHT(HashJoinRel.JoinType.JOIN_TYPE_RIGHT),
        LEFT_SEMI(HashJoinRel.JoinType.JOIN_TYPE_LEFT_SEMI),
        RIGHT_SEMI(HashJoinRel.JoinType.JOIN_TYPE_RIGHT_SEMI),
        LEFT_ANTI(HashJoinRel.JoinType.JOIN_TYPE_LEFT_ANTI),
        RIGHT_ANTI(HashJoinRel.JoinType.JOIN_TYPE_RIGHT_ANTI);

        private HashJoinRel.JoinType proto;

        private JoinType(HashJoinRel.JoinType proto) {
            this.proto = proto;
        }

        public static JoinType fromProto(HashJoinRel.JoinType proto) {
            for (JoinType v : JoinType.values()) {
                if (v.proto != proto) continue;
                return v;
            }
            throw new IllegalArgumentException("Unknown type: " + (Object)((Object)proto));
        }

        public HashJoinRel.JoinType toProto() {
            return this.proto;
        }
    }
}

