/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.relation.physical;

import io.substrait.expression.Expression;
import io.substrait.proto.NestedLoopJoinRel;
import io.substrait.relation.BiRel;
import io.substrait.relation.HasExtension;
import io.substrait.relation.RelVisitor;
import io.substrait.relation.physical.ImmutableNestedLoopJoin;
import io.substrait.type.Type;
import io.substrait.type.TypeCreator;
import java.util.stream.Stream;
import org.immutables.value.Value;

@Value.Immutable
public abstract class NestedLoopJoin
extends BiRel
implements HasExtension {
    public abstract Expression getCondition();

    public abstract JoinType getJoinType();

    @Override
    protected Type.Struct deriveRecordType() {
        Stream<Object> stream;
        Stream<Object> stream2;
        switch (this.getJoinType()) {
            case RIGHT: 
            case OUTER: {
                stream2 = this.getLeft().getRecordType().fields().stream().map(TypeCreator::asNullable);
                break;
            }
            case RIGHT_ANTI: 
            case RIGHT_SEMI: {
                stream2 = Stream.empty();
                break;
            }
            default: {
                stream2 = this.getLeft().getRecordType().fields().stream();
            }
        }
        Stream leftTypes = stream2;
        switch (this.getJoinType()) {
            case OUTER: 
            case LEFT: {
                stream = this.getRight().getRecordType().fields().stream().map(TypeCreator::asNullable);
                break;
            }
            case LEFT_ANTI: 
            case LEFT_SEMI: {
                stream = Stream.empty();
                break;
            }
            default: {
                stream = this.getRight().getRecordType().fields().stream();
            }
        }
        Stream rightTypes = stream;
        return TypeCreator.REQUIRED.struct(Stream.concat(leftTypes, rightTypes));
    }

    @Override
    public <O, E extends Exception> O accept(RelVisitor<O, E> visitor) throws E {
        return visitor.visit(this);
    }

    public static ImmutableNestedLoopJoin.Builder builder() {
        return ImmutableNestedLoopJoin.builder();
    }

    public static enum JoinType {
        UNKNOWN(NestedLoopJoinRel.JoinType.JOIN_TYPE_UNSPECIFIED),
        INNER(NestedLoopJoinRel.JoinType.JOIN_TYPE_INNER),
        OUTER(NestedLoopJoinRel.JoinType.JOIN_TYPE_OUTER),
        LEFT(NestedLoopJoinRel.JoinType.JOIN_TYPE_LEFT),
        RIGHT(NestedLoopJoinRel.JoinType.JOIN_TYPE_RIGHT),
        LEFT_SEMI(NestedLoopJoinRel.JoinType.JOIN_TYPE_LEFT_SEMI),
        RIGHT_SEMI(NestedLoopJoinRel.JoinType.JOIN_TYPE_RIGHT_SEMI),
        LEFT_ANTI(NestedLoopJoinRel.JoinType.JOIN_TYPE_LEFT_ANTI),
        RIGHT_ANTI(NestedLoopJoinRel.JoinType.JOIN_TYPE_RIGHT_ANTI);

        private NestedLoopJoinRel.JoinType proto;

        private JoinType(NestedLoopJoinRel.JoinType proto) {
            this.proto = proto;
        }

        public NestedLoopJoinRel.JoinType toProto() {
            return this.proto;
        }

        public static JoinType fromProto(NestedLoopJoinRel.JoinType proto) {
            for (JoinType v : JoinType.values()) {
                if (v.proto != proto) continue;
                return v;
            }
            throw new IllegalArgumentException("Unknown type: " + (Object)((Object)proto));
        }
    }
}

