/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.type.parser;

import io.substrait.function.ImmutableTypeExpression;
import io.substrait.function.ParameterizedType;
import io.substrait.function.ParameterizedTypeCreator;
import io.substrait.function.TypeExpression;
import io.substrait.function.TypeExpressionCreator;
import io.substrait.org.antlr.v4.runtime.tree.ErrorNode;
import io.substrait.org.antlr.v4.runtime.tree.ParseTree;
import io.substrait.org.antlr.v4.runtime.tree.RuleNode;
import io.substrait.org.antlr.v4.runtime.tree.TerminalNode;
import io.substrait.type.SubstraitTypeParser;
import io.substrait.type.SubstraitTypeVisitor;
import io.substrait.type.Type;
import io.substrait.type.TypeCreator;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.stream.Collectors;

public class ParseToPojo {
    public static Type type(String namespace, SubstraitTypeParser.StartContext ctx) {
        Visitor visitor = Visitor.simple(namespace);
        return (Type)ctx.accept(visitor);
    }

    public static ParameterizedType parameterizedType(String namespace, SubstraitTypeParser.StartContext ctx) {
        return (ParameterizedType)ctx.accept(Visitor.parameterized(namespace));
    }

    public static TypeExpression typeExpression(String namespace, SubstraitTypeParser.StartContext ctx) {
        return ctx.accept(Visitor.expression(namespace));
    }

    public static class Visitor
    implements SubstraitTypeVisitor<TypeExpression> {
        private final VisitorType expressionType;
        private final String namespace;

        public static Visitor simple(String namespace) {
            return new Visitor(VisitorType.SIMPLE, namespace);
        }

        public static Visitor parameterized(String namespace) {
            return new Visitor(VisitorType.PARAMETERIZED, namespace);
        }

        public static Visitor expression(String namespace) {
            return new Visitor(VisitorType.EXPRESSION, namespace);
        }

        private Visitor(VisitorType exprType, String namespace) {
            this.expressionType = exprType;
            this.namespace = namespace;
        }

        private void checkParameterizedOrExpression() {
            if (this.expressionType != VisitorType.EXPRESSION && this.expressionType != VisitorType.PARAMETERIZED) {
                throw new UnsupportedOperationException("This construct can only be used in Parameterized Types or Type Expressions.");
            }
        }

        private void checkExpression() {
            if (this.expressionType != VisitorType.EXPRESSION) {
                throw new UnsupportedOperationException("This construct can only be used in Type Expressions.");
            }
        }

        @Override
        public TypeExpression visitStart(SubstraitTypeParser.StartContext ctx) {
            return ctx.expr().accept(this);
        }

        @Override
        public Type visitBoolean(SubstraitTypeParser.BooleanContext ctx) {
            return this.withNull((SubstraitTypeParser.ScalarTypeContext)ctx).BOOLEAN;
        }

        @Override
        public Type visitI8(SubstraitTypeParser.I8Context ctx) {
            return this.withNull((SubstraitTypeParser.ScalarTypeContext)ctx).I8;
        }

        @Override
        public Type visitI16(SubstraitTypeParser.I16Context ctx) {
            return this.withNull((SubstraitTypeParser.ScalarTypeContext)ctx).I16;
        }

        @Override
        public Type visitI32(SubstraitTypeParser.I32Context ctx) {
            return this.withNull((SubstraitTypeParser.ScalarTypeContext)ctx).I32;
        }

        @Override
        public Type visitI64(SubstraitTypeParser.I64Context ctx) {
            return this.withNull((SubstraitTypeParser.ScalarTypeContext)ctx).I64;
        }

        @Override
        public TypeExpression visitTypeLiteral(SubstraitTypeParser.TypeLiteralContext ctx) {
            return ctx.type().accept(this);
        }

        @Override
        public Type visitFp32(SubstraitTypeParser.Fp32Context ctx) {
            return this.withNull((SubstraitTypeParser.ScalarTypeContext)ctx).FP32;
        }

        @Override
        public Type visitFp64(SubstraitTypeParser.Fp64Context ctx) {
            return this.withNull((SubstraitTypeParser.ScalarTypeContext)ctx).FP64;
        }

        @Override
        public Type visitString(SubstraitTypeParser.StringContext ctx) {
            return this.withNull((SubstraitTypeParser.ScalarTypeContext)ctx).STRING;
        }

        @Override
        public Type visitBinary(SubstraitTypeParser.BinaryContext ctx) {
            return this.withNull((SubstraitTypeParser.ScalarTypeContext)ctx).BINARY;
        }

        @Override
        public Type visitTimestamp(SubstraitTypeParser.TimestampContext ctx) {
            return this.withNull((SubstraitTypeParser.ScalarTypeContext)ctx).TIMESTAMP;
        }

        @Override
        public Type visitTimestampTz(SubstraitTypeParser.TimestampTzContext ctx) {
            return this.withNull((SubstraitTypeParser.ScalarTypeContext)ctx).TIMESTAMP_TZ;
        }

        @Override
        public Type visitDate(SubstraitTypeParser.DateContext ctx) {
            return this.withNull((SubstraitTypeParser.ScalarTypeContext)ctx).DATE;
        }

        @Override
        public Type visitTime(SubstraitTypeParser.TimeContext ctx) {
            return this.withNull((SubstraitTypeParser.ScalarTypeContext)ctx).TIME;
        }

        @Override
        public Type visitIntervalYear(SubstraitTypeParser.IntervalYearContext ctx) {
            return this.withNull((SubstraitTypeParser.ScalarTypeContext)ctx).INTERVAL_YEAR;
        }

        @Override
        public TypeExpression visitIntervalDay(SubstraitTypeParser.IntervalDayContext ctx) {
            boolean nullable = ctx.isnull != null;
            Object precision = this.i(ctx.precision);
            if (precision instanceof Integer) {
                Integer p = (Integer)precision;
                return this.withNull(nullable).intervalDay(p);
            }
            if (precision instanceof String) {
                String s = (String)precision;
                this.checkParameterizedOrExpression();
                return this.withNullP(nullable).intervalDayE(s);
            }
            this.checkExpression();
            return this.withNullE(nullable).intervalDayE(ctx.precision.accept(this));
        }

        @Override
        public TypeExpression visitIntervalCompound(SubstraitTypeParser.IntervalCompoundContext ctx) {
            boolean nullable = ctx.isnull != null;
            Object precision = this.i(ctx.precision);
            if (precision instanceof Integer) {
                Integer p = (Integer)precision;
                return this.withNull(nullable).intervalCompound(p);
            }
            if (precision instanceof String) {
                String s = (String)precision;
                this.checkParameterizedOrExpression();
                return this.withNullP(nullable).intervalCompoundE(s);
            }
            this.checkExpression();
            return this.withNullE(nullable).intervalCompoundE(ctx.precision.accept(this));
        }

        @Override
        public Type visitUuid(SubstraitTypeParser.UuidContext ctx) {
            return this.withNull((SubstraitTypeParser.ScalarTypeContext)ctx).UUID;
        }

        @Override
        public Type visitUserDefined(SubstraitTypeParser.UserDefinedContext ctx) {
            String name = ctx.Identifier().getSymbol().getText();
            return this.withNull(ctx).userDefined(this.namespace, name);
        }

        @Override
        public TypeExpression visitFixedChar(SubstraitTypeParser.FixedCharContext ctx) {
            boolean nullable = ctx.isnull != null;
            return this.of(ctx.len, this.withNull(nullable)::fixedChar, this.withNullP(nullable)::fixedCharE, this.withNullE(nullable)::fixedCharE);
        }

        private TypeExpression of(SubstraitTypeParser.NumericParameterContext ctx, IntFunction<TypeExpression> intFunc, Function<String, TypeExpression> strFunc, Function<TypeExpression, TypeExpression> exprFunc) {
            TypeExpression type = ctx.accept(this);
            if (type instanceof TypeExpression.IntegerLiteral) {
                return intFunc.apply(((TypeExpression.IntegerLiteral)type).value());
            }
            if (type instanceof ParameterizedType.StringLiteral) {
                this.checkParameterizedOrExpression();
                return strFunc.apply(((ParameterizedType.StringLiteral)type).value());
            }
            this.checkExpression();
            return exprFunc.apply(type);
        }

        @Override
        public TypeExpression visitVarChar(SubstraitTypeParser.VarCharContext ctx) {
            boolean nullable = ctx.isnull != null;
            return this.of(ctx.len, this.withNull(nullable)::varChar, this.withNullP(nullable)::varCharE, this.withNullE(nullable)::varCharE);
        }

        @Override
        public TypeExpression visitFixedBinary(SubstraitTypeParser.FixedBinaryContext ctx) {
            boolean nullable = ctx.isnull != null;
            return this.of(ctx.len, this.withNull(nullable)::fixedBinary, this.withNullP(nullable)::fixedBinaryE, this.withNullE(nullable)::fixedBinaryE);
        }

        @Override
        public TypeExpression visitDecimal(SubstraitTypeParser.DecimalContext ctx) {
            boolean nullable = ctx.isnull != null;
            Object precision = this.i(ctx.precision);
            Object scale = this.i(ctx.scale);
            if (precision instanceof Integer && scale instanceof Integer) {
                return this.withNull(nullable).decimal((Integer)precision, (Integer)scale);
            }
            if (precision instanceof String && scale instanceof String) {
                this.checkParameterizedOrExpression();
                return this.withNullP(nullable).decimalE((String)precision, (String)scale);
            }
            if (precision instanceof String && scale instanceof Integer) {
                this.checkParameterizedOrExpression();
                return this.withNullP(nullable).decimalE((String)precision, String.valueOf(scale));
            }
            if (precision instanceof Integer && scale instanceof String) {
                this.checkParameterizedOrExpression();
                return this.withNullP(nullable).decimalE(String.valueOf(precision), (String)scale);
            }
            this.checkExpression();
            return this.withNullE(nullable).decimalE(ctx.precision.accept(this), ctx.scale.accept(this));
        }

        @Override
        public TypeExpression visitPrecisionTimestamp(SubstraitTypeParser.PrecisionTimestampContext ctx) {
            boolean nullable = ctx.isnull != null;
            Object precision = this.i(ctx.precision);
            if (precision instanceof Integer) {
                Integer p = (Integer)precision;
                return this.withNull(nullable).precisionTimestamp(p);
            }
            if (precision instanceof String) {
                String s = (String)precision;
                this.checkParameterizedOrExpression();
                return this.withNullP(nullable).precisionTimestampE(s);
            }
            this.checkExpression();
            return this.withNullE(nullable).precisionTimestampE(ctx.precision.accept(this));
        }

        @Override
        public TypeExpression visitPrecisionTimestampTZ(SubstraitTypeParser.PrecisionTimestampTZContext ctx) {
            boolean nullable = ctx.isnull != null;
            Object precision = this.i(ctx.precision);
            if (precision instanceof Integer) {
                Integer p = (Integer)precision;
                return this.withNull(nullable).precisionTimestampTZ(p);
            }
            if (precision instanceof String) {
                String s = (String)precision;
                this.checkParameterizedOrExpression();
                return this.withNullP(nullable).precisionTimestampTZE(s);
            }
            this.checkExpression();
            return this.withNullE(nullable).precisionTimestampTZE(ctx.precision.accept(this));
        }

        private Object i(SubstraitTypeParser.NumericParameterContext ctx) {
            TypeExpression type = ctx.accept(this);
            if (type instanceof TypeExpression.IntegerLiteral) {
                return ((TypeExpression.IntegerLiteral)type).value();
            }
            if (type instanceof ParameterizedType.StringLiteral) {
                this.checkParameterizedOrExpression();
                return ((ParameterizedType.StringLiteral)type).value();
            }
            this.checkExpression();
            return type;
        }

        @Override
        public TypeExpression visitStruct(SubstraitTypeParser.StructContext ctx) {
            boolean nullable = ctx.isnull != null;
            List types = ctx.expr().stream().map(t -> t.accept(this)).collect(Collectors.toList());
            if (types.stream().allMatch(t -> t instanceof Type)) {
                return this.withNull(nullable).struct(types.stream().map(t -> (Type)t).collect(Collectors.toList()));
            }
            if (types.stream().allMatch(t -> t instanceof ParameterizedType)) {
                this.checkParameterizedOrExpression();
                return this.withNullP(nullable).structE((Iterable)types.stream().map(t -> (ParameterizedType)t).collect(Collectors.toList()));
            }
            this.checkExpression();
            return this.withNullE(nullable).structE((Iterable)types);
        }

        @Override
        public TypeExpression visitNStruct(SubstraitTypeParser.NStructContext ctx) {
            throw new UnsupportedOperationException();
        }

        @Override
        public TypeExpression visitList(SubstraitTypeParser.ListContext ctx) {
            boolean nullable = ctx.isnull != null;
            TypeExpression element = ctx.expr().accept(this);
            if (element instanceof Type) {
                return this.withNull(nullable).list((Type)element);
            }
            if (element instanceof ParameterizedType) {
                this.checkParameterizedOrExpression();
                return this.withNullP(nullable).listE((ParameterizedType)element);
            }
            this.checkExpression();
            return this.withNullE(nullable).listE(element);
        }

        @Override
        public TypeExpression visitMap(SubstraitTypeParser.MapContext ctx) {
            boolean nullable = ctx.isnull != null;
            TypeExpression key = ctx.key.accept(this);
            TypeExpression value = ctx.value.accept(this);
            if (key instanceof Type && value instanceof Type) {
                return this.withNull(nullable).map((Type)key, (Type)value);
            }
            if (key instanceof ParameterizedType && value instanceof ParameterizedType) {
                this.checkParameterizedOrExpression();
                return this.withNullP(nullable).mapE((ParameterizedType)key, (ParameterizedType)value);
            }
            this.checkExpression();
            return this.withNullE(nullable).mapE(key, value);
        }

        private TypeCreator withNull(SubstraitTypeParser.ScalarTypeContext required) {
            return Type.withNullability(((SubstraitTypeParser.TypeContext)required.parent).isnull != null);
        }

        private TypeCreator withNull(boolean nullable) {
            return Type.withNullability(nullable);
        }

        private TypeExpressionCreator withNullE(boolean nullable) {
            return TypeExpression.withNullability(nullable);
        }

        private ParameterizedTypeCreator withNullP(boolean nullable) {
            return ParameterizedType.withNullability(nullable);
        }

        @Override
        public TypeExpression visitType(SubstraitTypeParser.TypeContext ctx) {
            if (ctx.scalarType() != null) {
                return ctx.scalarType().accept(this);
            }
            if (ctx.parameterizedType() != null) {
                return ctx.parameterizedType().accept(this);
            }
            return ctx.anyType().accept(this);
        }

        @Override
        public TypeExpression visitTypeParam(SubstraitTypeParser.TypeParamContext ctx) {
            this.checkParameterizedOrExpression();
            boolean nullable = ctx.isnull != null;
            return ParameterizedType.StringLiteral.builder().nullable(nullable).value(ctx.getText()).build();
        }

        @Override
        public TypeExpression visitParenExpression(SubstraitTypeParser.ParenExpressionContext ctx) {
            return ctx.expr().accept(this);
        }

        @Override
        public TypeExpression visitIfExpr(SubstraitTypeParser.IfExprContext ctx) {
            this.checkExpression();
            return TypeExpression.IfOperation.builder().ifCondition(ctx.ifExpr.accept(this)).thenExpr(ctx.thenExpr.accept(this)).elseExpr(ctx.elseExpr.accept(this)).build();
        }

        @Override
        public TypeExpression visitTernary(SubstraitTypeParser.TernaryContext ctx) {
            this.checkExpression();
            return TypeExpression.IfOperation.builder().ifCondition(ctx.ifExpr.accept(this)).thenExpr(ctx.thenExpr.accept(this)).elseExpr(ctx.elseExpr.accept(this)).build();
        }

        @Override
        public TypeExpression visitMultilineDefinition(SubstraitTypeParser.MultilineDefinitionContext ctx) {
            this.checkExpression();
            List exprs = ctx.expr().stream().map(t -> t.accept(this)).collect(Collectors.toList());
            List identifiers = ctx.Identifier().stream().map(t -> t.getText()).collect(Collectors.toList());
            TypeExpression finalExpr = ctx.finalType.accept(this);
            ImmutableTypeExpression.ReturnProgram.Builder bldr = TypeExpression.ReturnProgram.builder();
            for (int i = 0; i < exprs.size(); ++i) {
                bldr.addAssignments((TypeExpression.ReturnProgram.Assignment)TypeExpression.ReturnProgram.Assignment.builder().expr((TypeExpression)exprs.get(i)).name((String)identifiers.get(i)).build());
            }
            bldr.finalExpression(finalExpr);
            return bldr.build();
        }

        @Override
        public TypeExpression visitBinaryExpr(SubstraitTypeParser.BinaryExprContext ctx) {
            TypeExpression.BinaryOperation.OpType opType;
            this.checkExpression();
            switch (ctx.op.getText().toUpperCase(Locale.ROOT)) {
                case "+": {
                    opType = TypeExpression.BinaryOperation.OpType.ADD;
                    break;
                }
                case "-": {
                    opType = TypeExpression.BinaryOperation.OpType.SUBTRACT;
                    break;
                }
                case "*": {
                    opType = TypeExpression.BinaryOperation.OpType.MULTIPLY;
                    break;
                }
                case "/": {
                    opType = TypeExpression.BinaryOperation.OpType.DIVIDE;
                    break;
                }
                case ">": {
                    opType = TypeExpression.BinaryOperation.OpType.GT;
                    break;
                }
                case "<": {
                    opType = TypeExpression.BinaryOperation.OpType.LT;
                    break;
                }
                case "AND": {
                    opType = TypeExpression.BinaryOperation.OpType.AND;
                    break;
                }
                case "OR": {
                    opType = TypeExpression.BinaryOperation.OpType.OR;
                    break;
                }
                case "=": {
                    opType = TypeExpression.BinaryOperation.OpType.EQ;
                    break;
                }
                case ":=": {
                    opType = TypeExpression.BinaryOperation.OpType.COVERS;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + ctx.op.getText());
                }
            }
            TypeExpression.BinaryOperation.OpType type = opType;
            return TypeExpression.BinaryOperation.builder().opType(type).left(ctx.left.accept(this)).right(ctx.right.accept(this)).build();
        }

        @Override
        public TypeExpression visitNumericLiteral(SubstraitTypeParser.NumericLiteralContext ctx) {
            return TypeExpression.IntegerLiteral.builder().value(Integer.parseInt(ctx.getText())).build();
        }

        @Override
        public TypeExpression visitNumericParameterName(SubstraitTypeParser.NumericParameterNameContext ctx) {
            this.checkParameterizedOrExpression();
            return ParameterizedType.StringLiteral.builder().nullable(false).value(ctx.getText()).build();
        }

        @Override
        public TypeExpression visitNumericExpression(SubstraitTypeParser.NumericExpressionContext ctx) {
            return ctx.expr().accept(this);
        }

        @Override
        public TypeExpression visitAnyType(SubstraitTypeParser.AnyTypeContext anyType) {
            boolean nullable = ((SubstraitTypeParser.TypeContext)anyType.parent).isnull != null;
            return this.withNullP(nullable).parameter("any");
        }

        @Override
        public TypeExpression visitFunctionCall(SubstraitTypeParser.FunctionCallContext ctx) {
            TypeExpression.BinaryOperation.OpType opType;
            String name;
            this.checkExpression();
            if (ctx.expr().size() != 2) {
                throw new IllegalStateException("Only two argument functions exist for type expressions.");
            }
            switch (name = ctx.Identifier().getSymbol().getText().toUpperCase(Locale.ROOT)) {
                case "MIN": {
                    opType = TypeExpression.BinaryOperation.OpType.MIN;
                    break;
                }
                case "MAX": {
                    opType = TypeExpression.BinaryOperation.OpType.MAX;
                    break;
                }
                default: {
                    throw new IllegalStateException("The following operation was unrecognized: " + name);
                }
            }
            TypeExpression.BinaryOperation.OpType type = opType;
            return TypeExpression.BinaryOperation.builder().opType(type).left(ctx.expr(0).accept(this)).right(ctx.expr(1).accept(this)).build();
        }

        @Override
        public TypeExpression visitNotExpr(SubstraitTypeParser.NotExprContext ctx) {
            return TypeExpression.NotOperation.builder().inner(ctx.expr().accept(this)).build();
        }

        @Override
        public TypeExpression visitLiteralNumber(SubstraitTypeParser.LiteralNumberContext ctx) {
            return this.i(Integer.parseInt(ctx.getText()));
        }

        protected TypeExpression i(int val) {
            return TypeExpression.IntegerLiteral.builder().value(val).build();
        }

        @Override
        public Type visit(ParseTree tree) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Type visitChildren(RuleNode node) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Type visitTerminal(TerminalNode node) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Type visitErrorNode(ErrorNode node) {
            throw new UnsupportedOperationException();
        }

        static enum VisitorType {
            SIMPLE,
            PARAMETERIZED,
            EXPRESSION;

        }
    }
}

