/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.type.proto;

import io.substrait.extension.ExtensionLookup;
import io.substrait.extension.SimpleExtension;
import io.substrait.proto.Type;
import io.substrait.type.Type;
import io.substrait.type.TypeCreator;
import java.util.stream.Collectors;

public class ProtoTypeConverter {
    private final ExtensionLookup lookup;
    private final SimpleExtension.ExtensionCollection extensions;

    public ProtoTypeConverter(ExtensionLookup lookup, SimpleExtension.ExtensionCollection extensions) {
        this.lookup = lookup;
        this.extensions = extensions;
    }

    public Type from(io.substrait.proto.Type type) {
        Type type2;
        switch (type.getKindCase()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case BOOL: {
                type2 = ProtoTypeConverter.n((Type.Nullability)type.getBool().getNullability()).BOOLEAN;
                break;
            }
            case I8: {
                type2 = ProtoTypeConverter.n((Type.Nullability)type.getI8().getNullability()).I8;
                break;
            }
            case I16: {
                type2 = ProtoTypeConverter.n((Type.Nullability)type.getI16().getNullability()).I16;
                break;
            }
            case I32: {
                type2 = ProtoTypeConverter.n((Type.Nullability)type.getI32().getNullability()).I32;
                break;
            }
            case I64: {
                type2 = ProtoTypeConverter.n((Type.Nullability)type.getI64().getNullability()).I64;
                break;
            }
            case FP32: {
                type2 = ProtoTypeConverter.n((Type.Nullability)type.getFp32().getNullability()).FP32;
                break;
            }
            case FP64: {
                type2 = ProtoTypeConverter.n((Type.Nullability)type.getFp64().getNullability()).FP64;
                break;
            }
            case STRING: {
                type2 = ProtoTypeConverter.n((Type.Nullability)type.getString().getNullability()).STRING;
                break;
            }
            case BINARY: {
                type2 = ProtoTypeConverter.n((Type.Nullability)type.getBinary().getNullability()).BINARY;
                break;
            }
            case TIMESTAMP: {
                type2 = ProtoTypeConverter.n((Type.Nullability)type.getTimestamp().getNullability()).TIMESTAMP;
                break;
            }
            case DATE: {
                type2 = ProtoTypeConverter.n((Type.Nullability)type.getDate().getNullability()).DATE;
                break;
            }
            case TIME: {
                type2 = ProtoTypeConverter.n((Type.Nullability)type.getTime().getNullability()).TIME;
                break;
            }
            case INTERVAL_YEAR: {
                type2 = ProtoTypeConverter.n((Type.Nullability)type.getIntervalYear().getNullability()).INTERVAL_YEAR;
                break;
            }
            case INTERVAL_DAY: {
                type2 = ProtoTypeConverter.n(type.getIntervalDay().getNullability()).intervalDay(type.getIntervalDay().hasPrecision() ? type.getIntervalDay().getPrecision() : 6);
                break;
            }
            case INTERVAL_COMPOUND: {
                type2 = ProtoTypeConverter.n(type.getIntervalCompound().getNullability()).intervalCompound(type.getIntervalCompound().getPrecision());
                break;
            }
            case TIMESTAMP_TZ: {
                type2 = ProtoTypeConverter.n((Type.Nullability)type.getTimestampTz().getNullability()).TIMESTAMP_TZ;
                break;
            }
            case UUID: {
                type2 = ProtoTypeConverter.n((Type.Nullability)type.getUuid().getNullability()).UUID;
                break;
            }
            case FIXED_CHAR: {
                type2 = ProtoTypeConverter.n(type.getFixedChar().getNullability()).fixedChar(type.getFixedChar().getLength());
                break;
            }
            case VARCHAR: {
                type2 = ProtoTypeConverter.n(type.getVarchar().getNullability()).varChar(type.getVarchar().getLength());
                break;
            }
            case FIXED_BINARY: {
                type2 = ProtoTypeConverter.n(type.getFixedBinary().getNullability()).fixedBinary(type.getFixedBinary().getLength());
                break;
            }
            case DECIMAL: {
                type2 = ProtoTypeConverter.n(type.getDecimal().getNullability()).decimal(type.getDecimal().getPrecision(), type.getDecimal().getScale());
                break;
            }
            case PRECISION_TIMESTAMP: {
                type2 = ProtoTypeConverter.n(type.getPrecisionTimestamp().getNullability()).precisionTimestamp(type.getPrecisionTimestamp().getPrecision());
                break;
            }
            case PRECISION_TIMESTAMP_TZ: {
                type2 = ProtoTypeConverter.n(type.getPrecisionTimestampTz().getNullability()).precisionTimestampTZ(type.getPrecisionTimestampTz().getPrecision());
                break;
            }
            case STRUCT: {
                type2 = ProtoTypeConverter.n(type.getStruct().getNullability()).struct(type.getStruct().getTypesList().stream().map(this::from).collect(Collectors.toList()));
                break;
            }
            case LIST: {
                type2 = this.fromList(type.getList());
                break;
            }
            case MAP: {
                type2 = this.fromMap(type.getMap());
                break;
            }
            case USER_DEFINED: {
                Type.UserDefined userDefined = type.getUserDefined();
                SimpleExtension.Type t = this.lookup.getType(userDefined.getTypeReference(), this.extensions);
                type2 = ProtoTypeConverter.n(userDefined.getNullability()).userDefined(t.uri(), t.name());
                break;
            }
            case USER_DEFINED_TYPE_REFERENCE: {
                throw new UnsupportedOperationException("Unsupported user defined reference: " + type);
            }
            case KIND_NOT_SET: {
                throw new UnsupportedOperationException("Type is not set: " + type);
            }
        }
        return type2;
    }

    public Type.ListType fromList(Type.List list) {
        return ProtoTypeConverter.n(list.getNullability()).list(this.from(list.getType()));
    }

    public Type.Map fromMap(Type.Map map) {
        return ProtoTypeConverter.n(map.getNullability()).map(this.from(map.getKey()), this.from(map.getValue()));
    }

    public static boolean isNullable(Type.Nullability nullability) {
        return Type.Nullability.NULLABILITY_NULLABLE == nullability;
    }

    private static TypeCreator n(Type.Nullability n) {
        return n == Type.Nullability.NULLABILITY_NULLABLE ? TypeCreator.NULLABLE : TypeCreator.REQUIRED;
    }
}

